/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.definitions;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KLinkType;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KLinkTypeSchemaObject
implements SchemaObject {
    private NameManager.ObjectName name;
    private final List<ColumnSchema> columns;
    private String comment;

    public KLinkTypeSchemaObject(NameManager.ObjectName name, List<ColumnSchema> columns, String comment) {
        this.name = name;
        this.columns = columns;
        this.comment = comment;
    }

    @Override
    public int getObjectType() {
        return 44;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("KLINK").append(' ');
        sb.append(name);
        if (this.columns.size() > 0) {
            sb.append(" (");
            sb.append(this.columns.stream().map(p -> NameManager.quoteNameIfNeeded(p.getObjectName().getStatementName()) + " " + p.dataType.getDefinition()).collect(Collectors.joining(", ")));
            sb.append(") ");
        }
        if (this.comment != null) {
            sb.append(" COMMENT '").append(this.comment).append("'");
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getComment() {
        return this.comment;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public KLinkType toKLinkType() {
        Map facets = this.columns.stream().collect(HashMap::new, (m, c) -> m.put(c.getObjectName().name, c.getDefaultValue(null)), Map::putAll);
        return new KLinkType(this.name.name, facets, this.comment);
    }
}

