/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.definitions;

import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KAssertionTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphType;
import com.streamscape.ds.schema.collection.cspace.definitions.KLinkType;
import com.streamscape.ds.schema.collection.cspace.definitions.KLinkTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeType;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeTypeSchemaObject;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FacetsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KGraphTypeSchemaObject
implements SchemaObject {
    private NameManager.ObjectName name;
    private final List<ColumnSchema> columns;
    private final List<KNodeTypeSchemaObject> knodes;
    private final List<KLinkTypeSchemaObject> klinks;
    private Map<String, Facets> klinksFacets;
    private final List<KAssertionTypeSchemaObject> assertions;
    private String comment;

    public KGraphTypeSchemaObject(NameManager.ObjectName name, List<ColumnSchema> columns, List<KNodeTypeSchemaObject> knodes, List<KLinkTypeSchemaObject> klinks, Map<String, Facets> klinksFacets, List<KAssertionTypeSchemaObject> assertions, String comment) {
        this.name = name;
        this.columns = columns;
        this.knodes = knodes;
        this.klinks = klinks;
        this.klinksFacets = klinksFacets;
        this.assertions = assertions;
        this.comment = comment;
    }

    @Override
    public int getObjectType() {
        return 44;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        this.knodes.stream().map(KNodeTypeSchemaObject::getReferences).forEach(set::addAll);
        this.klinks.stream().map(KLinkTypeSchemaObject::getReferences).forEach(set::addAll);
        this.knodes.stream().map(KNodeTypeSchemaObject::getObjectName).forEach(set::add);
        this.klinks.stream().map(KLinkTypeSchemaObject::getObjectName).forEach(set::add);
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("DEFINE").append(' ').append("KGRAPH").append(' ');
        sb.append(name);
        if (this.columns.size() > 0) {
            sb.append("(");
            sb.append(this.columns.stream().map(p -> NameManager.quoteNameIfNeeded(p.getObjectName().getStatementName()) + " " + p.dataType.getDefinition()).collect(Collectors.joining(", ")));
            sb.append(") ");
        }
        sb.append(" knodes(").append(this.knodes.stream().map(p -> NameManager.quoteNameIfNeeded(p.getObjectName().getStatementName())).collect(Collectors.joining(", "))).append(")");
        sb.append(" klinks(").append(this.klinks.stream().map(p -> {
            Facets facets = this.klinksFacets != null ? this.klinksFacets.get(p.getObjectName().name) : null;
            return NameManager.quoteNameIfNeeded(p.getObjectName().getStatementName()) + (String)(facets != null ? " (" + FacetsUtils.facetsToString(facets) + ")" : "");
        }).collect(Collectors.joining(", "))).append(")");
        sb.append(" assertions(").append(this.assertions.stream().map(p -> NameManager.quoteNameIfNeeded(p.getSubjectType().getObjectName().getStatementName()) + " -> :" + NameManager.quoteNameIfNeeded(p.getLinkType().getObjectName().getStatementName()) + " -> " + NameManager.quoteNameIfNeeded(p.getObjectType().getObjectName().getStatementName()) + " " + p.getOccurrency().toString()).collect(Collectors.joining(", "))).append(")");
        if (this.comment != null) {
            sb.append(" COMMENT '").append(this.comment).append("'");
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getComment() {
        return this.comment;
    }

    public List<KNodeTypeSchemaObject> getKnodes() {
        return this.knodes;
    }

    public List<KLinkTypeSchemaObject> getKlinks() {
        return this.klinks;
    }

    public List<KAssertionTypeSchemaObject> getAssertions() {
        return this.assertions;
    }

    public Map<String, Facets> getKlinksFacets() {
        return this.klinksFacets;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public KGraphTypeSchemaObject setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public KNodeTypeSchemaObject getKNodeTypeSchemaObject(String typeName) {
        return this.knodes.stream().filter(knode -> knode.getObjectName().name.equals(typeName)).findFirst().orElse(null);
    }

    public KLinkTypeSchemaObject getKLinkTypeSchemaObject(String typeName) {
        return this.klinks.stream().filter(klink -> klink.getObjectName().name.equals(typeName)).findFirst().orElse(null);
    }

    public KAssertionTypeSchemaObject getAssertion(String subjectType, String linkType, String objectType) {
        return this.assertions.stream().filter(a -> a.getSubjectType().getObjectName().name.equals(subjectType) && a.getLinkType().getObjectName().name.equals(linkType) && a.getObjectType().getObjectName().name.equals(objectType)).findAny().orElse(null);
    }

    public KGraphType toKGraphType() {
        Map facets = this.columns.stream().collect(HashMap::new, (m, c) -> m.put(c.getObjectName().name, c.getDefaultValue(null)), Map::putAll);
        return new KGraphType(this.name.name, facets, this.comment, new ArrayList<KNodeType>(this.knodes.stream().map(KNodeTypeSchemaObject::toKNodeType).collect(Collectors.toList())), new ArrayList<KLinkType>(this.klinks.stream().map(KLinkTypeSchemaObject::toKLinkType).map(d -> {
            if (this.klinksFacets != null && this.klinksFacets.get(d.getName()) != null) {
                d.getFacets().putAll(this.klinksFacets.get(d.getName()));
            }
            return d;
        }).collect(Collectors.toList())), this.assertions.stream().map(KAssertionTypeSchemaObject::toKAssertionType).collect(Collectors.toList()));
    }
}

