/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.definitions;

import com.streamscape.ds.stable.rplmethod.RPLMethod;

public class KGraphTypeOccurrency {
    private int minOccurs;
    private int maxOccurs;
    public static final int MAX = Integer.MAX_VALUE;

    public KGraphTypeOccurrency(int minOccurs, int maxOccurs) {
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @RPLMethod(description="Creates occurency which defines exactly one association.")
    public static KGraphTypeOccurrency exact(int n) {
        return new KGraphTypeOccurrency(n, n);
    }

    @RPLMethod(description="Creates occurency which defines min and max number of associations.")
    public static KGraphTypeOccurrency fromTo(int minOccurs, int maxOccurs) {
        return new KGraphTypeOccurrency(minOccurs, maxOccurs);
    }

    @RPLMethod(description="Creates occurency which defines min number of associations.")
    public static KGraphTypeOccurrency from(int minOccurs) {
        return new KGraphTypeOccurrency(minOccurs, Integer.MAX_VALUE);
    }

    @RPLMethod(description="Creates occurency which defines max number of associations.")
    public static KGraphTypeOccurrency upTo(int maxOccurs) {
        return new KGraphTypeOccurrency(0, maxOccurs);
    }

    public String toString() {
        return "(" + this.minOccurs + ": " + String.valueOf(this.maxOccurs != Integer.MAX_VALUE ? Integer.valueOf(this.maxOccurs) : "N") + ")";
    }
}

