/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.definitions;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.cspace.CSpace;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.instances.KAssertion;
import com.streamscape.ds.schema.collection.cspace.instances.KGraph;
import com.streamscape.ds.schema.collection.cspace.instances.KLink;
import com.streamscape.ds.schema.collection.cspace.instances.KNode;
import com.streamscape.ds.schema.collection.cspace.tables.CSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.cspace.tables.KAssertionTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.KGraphTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.KNodeTableManager;
import com.streamscape.ds.session.Session;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KGraphInstanceSchemaObject
implements SchemaObject {
    private NameManager.ObjectName name;
    private final KGraphTypeSchemaObject kgraphType;
    private String comment;

    public KGraphInstanceSchemaObject(NameManager.ObjectName name, KGraphTypeSchemaObject kgraphType, String comment) {
        this.name = name;
        this.kgraphType = kgraphType;
        this.comment = comment;
    }

    @Override
    public int getObjectType() {
        return 44;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.kgraphType.getReferences());
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("KGRAPH").append(' ');
        sb.append(name);
        sb.append(' ').append("CONSTRAINED").append(' ').append("BY").append(' ').append(this.kgraphType.getObjectName().getSchemaQualifiedStatementName());
        if (this.comment != null) {
            sb.append(" COMMENT '").append(this.comment).append("'");
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getComment() {
        return this.comment;
    }

    public KGraphTypeSchemaObject getKgraphType() {
        return this.kgraphType;
    }

    public KGraph toKGraph(Session session) {
        CSpaceSysTablesManager tablesManager = ((CSpace)session.dataspaceStore.schemaManager.findSchema(this.name.schema.name)).getCSpaceSysTablesManager();
        KGraphTableManager.KGraphRow kGraphRow = tablesManager.getKGraphTableManager().getKGraph(session, this.name.name);
        List<KAssertionTableManager.KAssertionRow> kAssertionsByGraphId = tablesManager.getKAssertionTableManager().getKAssertionsByGraphId(session, tablesManager.getKGraphTableManager().getKGraph(session, this.name.name).getKGraphId());
        Map kNodesByGraphId = tablesManager.getKNodeTableManager().getKNodesByGraphId(session, tablesManager.getKGraphTableManager().getKGraph(session, this.name.name).getKGraphId()).stream().collect(Collectors.toMap(KNodeTableManager.KNodeRow::getKNodeId, Function.identity()));
        List<KNode> nodes = kNodesByGraphId.values().stream().map(n -> {
            KNodeTypeSchemaObject objectKNodeType = (KNodeTypeSchemaObject)session.dataspaceStore.schemaManager.getSchemaObject(n.getTypeName(), "SDS", 43);
            return new KNode(objectKNodeType.getObjectName().name, objectKNodeType.getSubjectKey(), n.getFacets());
        }).collect(Collectors.toList());
        List<KAssertion> assertions = kAssertionsByGraphId.stream().map(a -> {
            HashMap<String, Object> facets = this.kgraphType.getKlinksFacets().get(a.getTypeName());
            facets = facets != null ? new HashMap<String, Object>(facets) : new HashMap();
            facets.putAll(a.getFacets());
            KLink kLink = new KLink(a.getTypeName(), facets);
            return new KAssertion(((KNodeTableManager.KNodeRow)kNodesByGraphId.get(a.getSubjectKNodeId())).getCompositeKey(), kLink, ((KNodeTableManager.KNodeRow)kNodesByGraphId.get(a.getObjectKNodeId())).getCompositeKey());
        }).collect(Collectors.toList());
        return new KGraph(kGraphRow.getkGraphTypeName(), kGraphRow.getkGraphName(), kGraphRow.getComment(), new HashMap<String, Object>(), nodes, assertions);
    }
}

