/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.instances.KNode;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import java.util.HashMap;
import java.util.Map;

public class NewKNodeExpression
extends Expression {
    private final KNodeTypeSchemaObject knodeSchemaObject;
    private final Expression knodeFacetsExpression;

    public NewKNodeExpression(KNodeTypeSchemaObject knodeSchemaObject, Expression knodeFacetsExpression) {
        super(1);
        this.knodeSchemaObject = knodeSchemaObject;
        this.knodeFacetsExpression = knodeFacetsExpression;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        return this.knodeFacetsExpression != null ? this.knodeFacetsExpression.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences) : unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        if (this.knodeFacetsExpression != null) {
            this.knodeFacetsExpression.resolveTypes(session, parent);
        }
        this.dataType = new OtherType(KNode.class.getSimpleName(), KNode.class);
    }

    @Override
    public Object getValue(Session session) {
        if (this.knodeSchemaObject == null) {
            return new KNode();
        }
        String subjectKeyAlias = this.knodeSchemaObject.getSubjectKey();
        HashMap knodeFacetsValue = this.knodeFacetsExpression != null ? OtherTypeWrapper.unwrap(this.knodeFacetsExpression.getValue(session)) : new HashMap();
        HashMap<String, Object> knodeFacets = new HashMap<String, Object>();
        if (knodeFacetsValue instanceof String) {
            knodeFacets.put(subjectKeyAlias, knodeFacetsValue);
        } else if (knodeFacetsValue instanceof Map) {
            knodeFacets.putAll(knodeFacetsValue);
        } else {
            throw new DataspaceException("Invalid value for KNode, should be String or Facets, but passed: " + (knodeFacetsValue != null ? knodeFacetsValue.getClass().getSimpleName() : "null"));
        }
        this.knodeSchemaObject.getColumns().stream().forEach(column -> knodeFacets.putIfAbsent(column.getNameString(), null));
        return new KNode(this.knodeSchemaObject.getObjectName().name, subjectKeyAlias, knodeFacets);
    }

    @Override
    public String getSQL() {
        if (this.knodeSchemaObject != null) {
            return "new knode(" + this.knodeSchemaObject.getObjectName().getSchemaQualifiedStatementName() + (String)(this.knodeFacetsExpression != null ? " : " + this.knodeFacetsExpression.getSQL() : "") + ")";
        }
        return "new knode()";
    }
}

