/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace;

import com.streamscape.ds.schema.collection.cspace.definitions.KAssertionTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KLinkTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.instances.KAssertion;
import com.streamscape.ds.schema.collection.cspace.instances.KGraph;
import com.streamscape.ds.schema.collection.cspace.instances.KGraphException;
import com.streamscape.ds.schema.collection.cspace.instances.KLink;
import com.streamscape.ds.schema.collection.cspace.instances.KNode;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KGraphValidator {
    @RPLMethod(description="Validates specified kgraph against validator schema and throws exception with errors list.")
    public void validate(Session session, KGraph kGraph) {
        List<String> errors = this.validateAndReturnErrors(session, kGraph);
        if (errors.size() > 0) {
            throw new KGraphException(errors.stream().collect(Collectors.joining("\n")));
        }
    }

    @RPLMethod(description="Validates specified kgraph against validator schema and returns errors list.")
    public List<String> validateAndReturnErrors(Session session, KGraph kGraph) {
        ArrayList<String> errors = new ArrayList<String>();
        KGraphTypeSchemaObject kGraphType = (KGraphTypeSchemaObject)session.dataspaceStore.schemaManager.findSchemaObject(kGraph.getTypeName(), session.currentDataspace.name, 45);
        if (kGraphType == null) {
            errors.add("KGraph type '" + kGraph.getTypeName() + "' not found in dataspace '" + session.currentDataspace.name + "'.");
            return errors;
        }
        this.validateNodes(kGraphType, kGraph, errors);
        this.validateLinks(kGraphType, kGraph, errors);
        this.validateAssertions(kGraphType, kGraph, errors);
        return errors;
    }

    private void validateNodes(KGraphTypeSchemaObject kGraphType, KGraph kGraph, ArrayList<String> errors) {
        for (KNode kNode : kGraph.getNodes()) {
            this.validateNode(kGraphType, kNode, errors);
        }
    }

    private void validateLinks(KGraphTypeSchemaObject kGraphType, KGraph kGraph, ArrayList<String> errors) {
        List kLinks = kGraph.getAssertions().stream().map(a -> a.getLink()).collect(Collectors.toMap(KLink::getTypeName, Function.identity(), (existing, replacement) -> existing, LinkedHashMap::new)).values().stream().collect(Collectors.toList());
        for (KLink kLink : kLinks) {
            this.validateLink(kGraphType, kLink, errors);
        }
    }

    private void validateAssertions(KGraphTypeSchemaObject kGraphType, KGraph kGraph, ArrayList<String> errors) {
        for (KAssertion assertion : kGraph.getAssertions()) {
            KAssertionTypeSchemaObject assertionType;
            KNode subjectNode = kGraph.getNode(assertion.getSubjectCompositeKey());
            KNode objectNode = kGraph.getNode(assertion.getObjectCompositeKey());
            if (subjectNode == null) {
                errors.add("Assertion " + assertion.toString() + ": subject node doesn't exist");
            }
            if (objectNode == null) {
                errors.add("Association " + String.valueOf(assertion) + ": object node doesn't exist");
            }
            if (subjectNode == null || objectNode == null || (assertionType = kGraphType.getAssertion(subjectNode.getTypeName(), assertion.getLink().getTypeName(), objectNode.getTypeName())) != null) continue;
            errors.add("Assertion " + String.valueOf(assertion) + ": assertion type doesn't exist.");
        }
    }

    private void validateNode(KGraphTypeSchemaObject kGraphType, KNode kNode, ArrayList<String> errors) {
        if (kNode.getTypeName() != null && kNode.getTypeName().length() != 0) {
            KNodeTypeSchemaObject kNodeType = kGraphType.getKNodeTypeSchemaObject(kNode.getTypeName());
            if (kNodeType != null) {
                if (kNode.getSubjectKey() == null) {
                    errors.add("Node " + kNode.getCompositeKey() + " has no subject key alias set.");
                }
                if (kNode.getSubjectKey() == null) {
                    errors.add("Node " + kNode.getCompositeKey() + " has null subject key.");
                }
                kNodeType.getColumns().stream().forEach(column -> {
                    if (!kNode.getFacets().containsKey(column.getNameString())) {
                        errors.add("Node " + kNode.getCompositeKey() + " missing facet '" + column.getNameString() + "'.");
                    }
                });
            } else {
                errors.add("Node " + kNode.getCompositeKey() + " type '" + kNode.getTypeName() + "' not exists in KGraph type.");
            }
        } else {
            errors.add("Node " + kNode.getCompositeKey() + " has no type name set.");
        }
    }

    private void validateLink(KGraphTypeSchemaObject kGraphType, KLink kLink, ArrayList<String> errors) {
        if (kLink.getTypeName() != null && kLink.getTypeName().length() != 0) {
            KLinkTypeSchemaObject kLinkType = kGraphType.getKLinkTypeSchemaObject(kLink.getTypeName());
            if (kLinkType != null) {
                kLinkType.getColumns().stream().forEach(column -> {
                    if (!kLink.getFacets().containsKey(column.getNameString())) {
                        errors.add("Link " + kLink.getTypeName() + " missing facet '" + column.getNameString() + "'.");
                    }
                });
            } else {
                errors.add("Link " + kLink.getTypeName() + ": schema " + kLink.getTypeName() + " not exists in KGraph.");
            }
        } else {
            errors.add("Link has no schema.");
        }
    }
}

