/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection;

import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.types.AspectsType;
import com.streamscape.ds.types.FacetsType;
import com.streamscape.ds.types.Type;

public class Tuple {
    private Table table;
    private int columnIndex;
    private ColumnBase columnBase;

    Tuple(Table table, int columnIndex) {
        this.table = table;
        this.columnIndex = columnIndex;
        this.columnBase = table.getColumn(columnIndex);
    }

    public String getName() {
        return this.columnBase.getNameString();
    }

    public static String getTypeName(Type type) {
        if (type.isDomainType() || type.isDistinctType()) {
            return type.getObjectName().getNameString();
        }
        return type.getFullNameString();
    }

    public static String getTypeName(ColumnBase column) {
        return Tuple.getTypeName(column.getDataType());
    }

    public String getTypeName() {
        return Tuple.getTypeName(this.columnBase.getDataType());
    }

    public int getPrecision() {
        return this.columnBase.getDataType().getJDBCPrecision();
    }

    public int getScale() {
        return this.columnBase.getDataType().getJDBCScale();
    }

    public Type getDataspaceType() {
        return this.columnBase.getDataType();
    }

    public boolean isNullable() {
        return this.columnBase.isNullable();
    }

    public boolean isSearchable() {
        return this.columnBase.isSearchable();
    }

    public boolean isPrimaryKey() {
        if (this.table == null) {
            return false;
        }
        Constraint primaryConstraint = this.table.getPrimaryConstraint();
        if (primaryConstraint == null) {
            return false;
        }
        return this.contains(primaryConstraint.getMainColumns(), this.columnIndex);
    }

    public boolean isIndex() {
        Index[] indexes;
        if (this.table == null) {
            return false;
        }
        for (Index index : indexes = this.table.getIndexList()) {
            boolean isIndex = this.contains(index.getColumns(), this.columnIndex);
            if (!isIndex) continue;
            return true;
        }
        if (this.columnBase != null && this.columnBase.dataType != null && this.columnBase.dataType instanceof FacetsType && ((FacetsType)this.columnBase.dataType).getFacetsSchemaObject() != null && ((FacetsType)this.columnBase.dataType).getFacetsSchemaObject().isIndexed()) {
            return true;
        }
        return this.columnBase != null && this.columnBase.dataType != null && this.columnBase.dataType instanceof AspectsType && ((AspectsType)this.columnBase.dataType).getAspectsSchemaObject() != null && ((AspectsType)this.columnBase.dataType).getAspectsSchemaObject().isIndexed();
    }

    public boolean isIdentity() {
        return this.columnBase.isIdentity();
    }

    private boolean contains(int[] array, int value) {
        for (int a : array) {
            if (a != value) continue;
            return true;
        }
        return false;
    }

    public ColumnBase getColumnBase() {
        return this.columnBase;
    }

    public String getComment() {
        if (this.columnBase instanceof ColumnSchema) {
            return ((ColumnSchema)this.columnBase).getObjectName().comment;
        }
        return null;
    }
}

