/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.fspace.table.SemagraphTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.service.ServiceDescriptor;

public class SemagraphCollection
extends AbstractCollection {
    private String serviceName;

    public SemagraphCollection(DataspaceStore store, NameManager.ObjectName name, String serviceName) {
        super(store, name, CollectionType.SEMAGRAPTH_TABLE, MemoryModel.MEMORY);
        this.serviceName = serviceName;
        NameManager.ObjectName tableName = store.nameManager.newObjectName(name.name, name.isNameQuoted, 3);
        tableName.schema = name.schema;
        this.table = new SemagraphTable(store, tableName, this);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        this.addColumn(this.table, "term", Type.STRING, false);
        this.addColumn(this.table, "score", Type.SQL_DECIMAL, true);
        this.addColumn(this.table, "cluster", Type.SQL_NUMERIC, true);
        this.addColumn(this.table, "set", Type.SQL_ARRAY_ALL_TYPES, true);
        this.table.setColumnStructures();
        this.table.setDataReadOnly(true);
        super.compile(session, parentObject);
    }

    @Override
    public void open(Session session) {
        if (session.isProcessingRecoveryLog || session.isProcessingRecoveryLog()) {
            return;
        }
        super.open(session);
        if (DataspaceStoreManager.getRuntimeContext().getServiceManager() == null) {
            return;
        }
        this.initService(session);
    }

    private void initService(Session session) {
    }

    public void checkService(Session session) {
        ServiceDescriptor descriptor = DataspaceStoreManager.getRuntimeContext().getServiceManager().getService("TXSemagraph." + this.serviceName);
        if (descriptor == null) {
            throw new DataspaceException("Service TXSemagraph." + this.serviceName + " doesn't exist.");
        }
    }

    @Override
    public String getSQL() {
        return "export semagraph for " + this.serviceName + " as [" + this.table.getObjectName().name + "]";
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Service Name", this.serviceName});
        return result;
    }
}

