/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.sef.dispatcher.AbstractOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    private static Map<DataspaceType, List<CollectionType>> collectionCompatibilityMap = new HashMap<DataspaceType, List<CollectionType>>();

    public static void checkCollectionCompatibility(AbstractCollection collection) {
        CollectionType collectionType = collection.getCollectionType();
        AbstractDataspace dataspace = collection.getDataspace();
        if (dataspace == null || AbstractOperation.isSystemDataspace(dataspace.getName())) {
            return;
        }
        List<CollectionType> collectionTypes = collectionCompatibilityMap.get((Object)dataspace.getDataspaceType());
        if (collectionTypes != null && !collectionTypes.contains((Object)collectionType)) {
            throw new DataspaceException("Collection '" + collection.getCollectionName() + "', type '" + collectionType.name() + "' is not compatible with dataspace '" + dataspace.getFullName() + "', type '" + dataspace.getDataspaceType().name() + "'");
        }
    }

    static {
        collectionCompatibilityMap.put(DataspaceType.FSPACE, Arrays.asList(CollectionType.FILE_TABLE, CollectionType.JOURNAL_FILE_TABLE, CollectionType.LOG_FILE_TABLE, CollectionType.DIRECTORY_TABLE, CollectionType.SEMAGRAPTH_TABLE));
        collectionCompatibilityMap.put(DataspaceType.TSPACE, Arrays.asList(CollectionType.TABLE, CollectionType.VTABLE, CollectionType.VIEW, CollectionType.EVENT_TABLE, CollectionType.FUNCTION_TABLE, CollectionType.MAP, CollectionType.SNAPSHOT_TABLE, CollectionType.SEMAGRAPTH_TABLE));
        collectionCompatibilityMap.put(DataspaceType.QSPACE, Arrays.asList(CollectionType.QUEUE, CollectionType.EVENT_QUEUE, CollectionType.PROCESS_QUEUE, CollectionType.AUDIT_QUEUE, CollectionType.BLOCKING_QUEUE));
        collectionCompatibilityMap.put(DataspaceType.CSPACE, Arrays.asList(CollectionType.TABLE, CollectionType.VTABLE, CollectionType.VIEW, CollectionType.EVENT_TABLE, CollectionType.FUNCTION_TABLE, CollectionType.MAP, CollectionType.SNAPSHOT_TABLE, CollectionType.SEMAGRAPTH_TABLE));
    }
}

