/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.CollectionMetaData;
import com.streamscape.ds.schema.collection.Tuple;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.sdo.rowset.RowSet;
import java.util.ArrayList;
import java.util.List;

public class CollectionMetaDataImpl
implements CollectionMetaData {
    private Collection collection;
    private RowSet collectionProperties;

    public CollectionMetaDataImpl(Collection collection) {
        this(collection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionMetaDataImpl(Collection collection, Session session) {
        this.collection = collection;
        if (session != null) {
            try {
                List<RowSet> results;
                Result result = collection.getCollectionProperties(session);
                if (result != null && (results = ((RowSetFactoryForDSResult)new RowSetFactoryForDSResult().setWithBlobs(false)).createRowSets(session, result)).size() > 0) {
                    this.collectionProperties = results.get(results.size() - 1);
                }
            }
            finally {
                session.close();
            }
        }
    }

    @Override
    public String getCollectionName() {
        return this.collection.getBaseTable().getObjectName().getNameString();
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collection.getCollectionType();
    }

    @Override
    public MemoryModel getMemoryModel() {
        return this.collection.getMemoryModel();
    }

    @Override
    public List<Tuple> getTuples() {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i = 0; i < this.collection.getBaseTable().getColumnCount(); ++i) {
            tuples.add(new Tuple(this.collection.getBaseTable(), i));
        }
        return tuples;
    }

    @Override
    public List<String> listTuples() {
        ArrayList<String> tuples = new ArrayList<String>();
        for (int i = 0; i < this.collection.getBaseTable().getColumnCount(); ++i) {
            tuples.add(this.collection.getBaseTable().getColumn(i).getNameString());
        }
        return tuples;
    }

    @Override
    public Tuple lookupTuple(String name) {
        for (int i = 0; i < this.collection.getBaseTable().getColumnCount(); ++i) {
            if (!name.equals(this.collection.getBaseTable().getColumn(i).getNameString())) continue;
            return new Tuple(this.collection.getBaseTable(), i);
        }
        return null;
    }

    @Override
    public RowSet getCollectionProperties() {
        return this.collectionProperties;
    }
}

