/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection;

import com.streamscape.cli.ds.CollectionFactory;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObject;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCollectionFactoryImpl
implements CollectionFactory,
AccessibleObject {
    public static final String MEMORY_MODEL_PROPERTY = "MemoryModel";
    protected CollectionType collectionType = null;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected AbstractDataspace dataspace;

    protected AbstractCollectionFactoryImpl(CollectionType type) {
        this.collectionType = type;
        this.properties.put(MEMORY_MODEL_PROPERTY, MemoryModel.MEMORY.name());
    }

    public void init(AbstractDataspace dataspace) {
        this.dataspace = dataspace;
    }

    public MemoryModel getMemoryModel(Session session) {
        return MemoryModel.valueOf(this.properties.get(MEMORY_MODEL_PROPERTY));
    }

    public void setMemoryModel(Session session, MemoryModel model) {
        this.properties.put(MEMORY_MODEL_PROPERTY, model.name());
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public CollectionType getCollectionType(Session session) {
        return this.collectionType;
    }

    public void setFactoryParameter(Session session, String name, String value) {
        this.properties.put(name, value);
    }

    public String getFactoryParameter(Session session, String name) {
        return this.properties.get(name);
    }

    @Override
    public void setFactoryParameter(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public String getFactoryParameter(String name) {
        return this.properties.get(name);
    }

    public DataCollection createCollection(Session session, String name) {
        Result result = session.executeDirectStatement(this.getCreateSql(session, name));
        AbstractCollection.checkResultNotError(result);
        return this.dataspace.lookupCollection(name);
    }

    public abstract String getCreateSql(Session var1, String var2);
}

