/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.persist.LobValidator;
import com.streamscape.ds.persist.TableTypesValidator;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.state.StateHolder;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.AspectsType;
import com.streamscape.ds.types.FacetsType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.RowChangeEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.service.osf.config.ActiveEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public abstract class AbstractCollection
implements Collection,
DataCollection {
    protected NameManager.ObjectName name = null;
    protected AbstractDataspace dataspace = null;
    protected DataspaceStore store = null;
    protected RuntimeContext runtimeCtx = null;
    protected CollectionType type = CollectionType.TABLE;
    protected Table table = null;
    protected MemoryModel memoryModel = MemoryModel.MEMORY;
    protected long changeTimestamp = 0L;
    protected DataspaceStateHolder stateHolder = new DataspaceStateHolder();
    private static HashSet<CollectionType> alterNotAllowedTypes = new HashSet<CollectionType>(Arrays.asList(CollectionType.AUDIT_QUEUE, CollectionType.BLOCKING_QUEUE, CollectionType.EVENT_QUEUE, CollectionType.EVENT_TABLE, CollectionType.MESSAGE_QUEUE, CollectionType.PROCESS_QUEUE, CollectionType.QUEUE));

    protected AbstractCollection(DataspaceStore store, NameManager.ObjectName name, CollectionType collectionType, MemoryModel memoryModel) {
        this.store = store;
        this.name = name;
        this.type = collectionType;
        this.memoryModel = memoryModel;
        this.runtimeCtx = DataspaceStoreManager.getRuntimeContext();
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(name.schema.name);
        this.stateHolder.setState(DataspaceStoreState.ONLINE);
    }

    @Override
    public int getObjectType() {
        return 4;
    }

    @Override
    public MemoryModel getMemoryModel() {
        return this.memoryModel;
    }

    public MemoryModel getMemoryModel(Session session) {
        return this.memoryModel;
    }

    @Override
    public Table getBaseTable() {
        return this.table;
    }

    public void updateBaseTable(Table table) {
        this.table = table;
    }

    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public void resetBaseTable(Table table) {
        if (table.getTableType() != this.table.getTableType()) {
            switch (table.getTableType()) {
                case 4: {
                    this.memoryModel = MemoryModel.MEMORY;
                    break;
                }
                case 5: {
                    this.memoryModel = MemoryModel.LOGGED;
                    break;
                }
                case 6: {
                    this.memoryModel = MemoryModel.PERSISTENT;
                }
            }
        }
        this.table = table;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.store.getCatalogName();
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.table.colTypes != null) {
            for (int i = 0; i < this.table.colTypes.length; ++i) {
                Type colType;
                ColumnSchema column = this.table.getColumn(i);
                OrderedHashSet refs = column.getReferences();
                if (!refs.isEmpty()) {
                    set.add(column.getObjectName());
                }
                if ((colType = this.table.colTypes[i]) instanceof OtherType) {
                    NameManager.ObjectName typeName = SemanticTypeAndPrototypeSchemaObjectsCache.getSemanticTypeObjectName(colType.getNameString());
                    if (typeName == null) continue;
                    set.add(typeName);
                    continue;
                }
                if (!(colType instanceof FacetsType) && !(colType instanceof AspectsType) || colType.userTypeModifier == null) continue;
                set.add(colType.getObjectName());
            }
        }
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet set = new OrderedHashSet();
        OrderedHashSet temp = this.getCollectionComponents();
        if (temp != null) {
            set.addAll(temp);
        }
        return set;
    }

    public OrderedHashSet getCollectionComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public void compileInternalStatements(Session session) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName(), false);
    }

    @Override
    public String getSQL(String name) {
        return this.getSQL(name, false);
    }

    public String getSQL(String name, boolean forReplication) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ');
        builder.append(this.memoryModel.name()).append(' ');
        builder.append(AbstractCollection.getCollectionTypeName(this.getCollectionType()));
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(this.getCollectionSQL(forReplication));
        return builder.toString();
    }

    @Override
    public String getSQLForReplication(String replicaName) {
        return this.getSQL(replicaName, true);
    }

    @Override
    public String[] getSQL(OrderedHashSet resolved, OrderedHashSet unresolved) {
        return this.table.getSQLForCollection(this, resolved, unresolved);
    }

    protected String getCollectionSQL(boolean forReplication) {
        return "";
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public static String getCollectionTypeName(CollectionType type) {
        switch (type) {
            case TABLE: {
                return "TABLE";
            }
            case EVENT_TABLE: {
                return "EVENT TABLE";
            }
            case MAP: {
                return "MAP";
            }
            case VIEW: {
                return "VIEW";
            }
            case QUEUE: {
                return "QUEUE";
            }
            case BLOCKING_QUEUE: {
                return "QUEUE";
            }
            case EVENT_QUEUE: {
                return "EVENT QUEUE";
            }
            case MESSAGE_QUEUE: {
                return "MESSAGE QUEUE";
            }
            case PROCESS_QUEUE: {
                return "PROCESS QUEUE";
            }
            case AUDIT_QUEUE: {
                return "AUDIT QUEUE";
            }
            case FILE_TABLE: {
                return "FILE TABLE";
            }
            case SOURCE_STREAM: {
                return "SOURCE STREAM";
            }
            case VTABLE: {
                return "VIRTUAL TABLE";
            }
            case DIRECTORY_TABLE: {
                return "DIRECTORY TABLE";
            }
            case FUNCTION_TABLE: {
                return "FUNCTION TABLE";
            }
            case JOURNAL_FILE_TABLE: {
                return "JOURNAL FILE TABLE";
            }
            case SNAPSHOT_TABLE: {
                return "SNAPSHOT TABLE";
            }
            case LOG_FILE_TABLE: {
                return "LOG FILE TABLE";
            }
            case SEMAGRAPTH_TABLE: {
                return "SEMAGRAPH TABLE";
            }
        }
        return "UNKNOWN";
    }

    public static String getCollectionTypeNameCamelCase(CollectionType type) {
        StringBuilder name = new StringBuilder();
        int prev = 0;
        for (int n : AbstractCollection.getCollectionTypeName(type).toCharArray()) {
            if (prev == 0 || prev == 32) {
                name.append(Character.toUpperCase((char)n));
            } else {
                name.append(Character.toLowerCase((char)n));
            }
            prev = n;
        }
        return name.toString();
    }

    protected final void addColumn(Table t, String name, Type type) {
        this.addColumn(t, name, type, true);
    }

    protected final void addColumn(Table t, String name, Type type, boolean nullable) {
        this.addColumn(t, name, type, nullable, null);
    }

    protected final void addColumn(Table t, String name, Type type, boolean nullable, Expression defaultExpression) {
        NameManager.ObjectName cn = NameManager.newInfoSchemaColumnName(name, t.getObjectName());
        ColumnSchema c = new ColumnSchema(cn, type, nullable, false, defaultExpression);
        t.addColumn(c);
    }

    protected final void addIdentityColumn(Table t, String name, Type type) {
        NameManager.ObjectName cn = NameManager.newInfoSchemaColumnName(name, t.getObjectName());
        ColumnSchema c = new ColumnSchema(cn, type, true, false, null);
        NumberSequence sequence = new NumberSequence(null, 0L, 1L, type);
        c.setIdentity(sequence);
        t.addColumn(c);
    }

    protected int getInternalTableType(MemoryModel model) {
        switch (model) {
            case LOGGED: {
                return 5;
            }
            case PERSISTENT: {
                return 6;
            }
        }
        return 4;
    }

    @Override
    public Result getCollectionProperties(Session session) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result result = Result.newDataResult(metaData);
        result.setNavigator(navigator);
        navigator.add(new Object[]{"Name", this.name.name});
        navigator.add(new Object[]{"Type", AbstractCollection.getCollectionTypeName(this.type)});
        navigator.add(new Object[]{"MemoryModel", this.memoryModel != null ? this.memoryModel.name() : (this.table.getTableType() == 3 ? "TRANSIENT" : "n/a")});
        navigator.add(new Object[]{"Data Scope", this.table.getDataScopeString()});
        this.exposeCollectionState(navigator, false);
        navigator.add(new Object[]{"Source Links", this.getReferenceLinksNames(true).toString()});
        navigator.add(new Object[]{"Target Links", this.getReferenceLinksNames(false).toString()});
        navigator.add(new Object[]{"Replicated", this.isReplicated()});
        navigator.add(new Object[]{"Sample Element Count", this.table != null ? this.table.getSampleCountAsString(session) : "n/a"});
        navigator.add(new Object[]{"Read Only", this.table != null ? Boolean.valueOf(this.table.isReadOnly()) : "n/a"});
        String comment = this.table.getObjectName().comment;
        navigator.add(new Object[]{"Comment", comment != null ? comment : ""});
        if (this.table.hasIdentityColumn()) {
            try {
                ColumnSchema identity = this.table.getColumn(this.table.getIdentityColumnIndex());
                NumberSequence sequence = identity.getIdentitySequence();
                navigator.add(new Object[]{"Identity Column Name", identity.getObjectName().name});
                navigator.add(new Object[]{"Identity SQL", sequence.getSQLColumnDefinition()});
                navigator.add(new Object[]{"Identity Start With", sequence.getStartValue()});
                navigator.add(new Object[]{"Identity Increment By", sequence.getIncrement()});
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        result.navigator.add(new Object[]{"Triggers", this.table != null && this.table.triggerList != null ? Arrays.asList(this.table.triggerList).stream().map(t -> t.getObjectName().name).collect(Collectors.joining(",")) : ""});
        return result;
    }

    private List<String> getReferenceLinksNames(boolean withSource) {
        return this.getReferenceLinks(withSource).stream().map(l -> l.getObjectName().getSchemaQualifiedStatementName()).collect(Collectors.toList());
    }

    private List<ReferenceLink> getReferenceLinks(boolean withSource) {
        ArrayList<ReferenceLink> links = new ArrayList<ReferenceLink>();
        Iterator iterator = this.dataspace.getStore().schemaManager.databaseObjectIterator(37);
        while (iterator.hasNext()) {
            ReferenceLink link = (ReferenceLink)iterator.next();
            if ((!withSource || !this.isReferenceToThisTable(link.getObjectName(), link.getSourceColumnObjectName())) && (withSource || !this.isReferenceToThisTable(link.getObjectName(), link.getTargetColumnObjectName()))) continue;
            links.add(link);
        }
        return links;
    }

    private boolean isReferenceToThisTable(NameManager.ObjectName linkObjectName, NameManager.ObjectName columnObjectName) {
        try {
            if (columnObjectName.schema == null ? !linkObjectName.schema.name.equals(this.getObjectName().schema.name) : !columnObjectName.schema.name.equals(this.getObjectName().schema.name)) {
                return false;
            }
            if (columnObjectName.parent.name.equals(this.getObjectName().name)) {
                return true;
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        return false;
    }

    @Override
    public void open(Session session) {
        this.table.updateTriggersOrderAndRemoveNulls();
    }

    @Override
    public void close() {
    }

    @Override
    public void destroy(Session session) {
        ReplicationSource source = this.getReplicationSource();
        if (source != null) {
            source.destroy(session);
        }
    }

    public List<String> listTriggers(Session session) {
        return this.listTriggers();
    }

    public String getCollectionName(Session session) {
        return this.getCollectionName();
    }

    @Override
    public String getCollectionName() {
        return this.name.getNameString();
    }

    public CollectionType getCollectionType(Session session) {
        return this.getCollectionType();
    }

    @Override
    public CollectionType getCollectionType() {
        return this.type;
    }

    @Override
    public List<String> listTriggers() {
        ArrayList<String> triggers = new ArrayList<String>();
        if (this.table != null) {
            for (TriggerDef trigger : this.table.getTriggers()) {
                triggers.add(trigger.getObjectName().name);
            }
        }
        return triggers;
    }

    @Override
    public boolean isTriggerEventAutogenerated() {
        return true;
    }

    @Override
    public String getTriggerEventId(int whenType, int operationType) {
        String operation;
        String when = TriggerDef.getTimingString(whenType);
        String eventId = "event." + this.name.schema.name + "." + this.name.name + "." + when + (operation = TriggerDef.getEventTypeString(operationType));
        if (PrototypeFactory.existsPrototype(eventId)) {
            if (operationType == 82 && this instanceof JournalFileTableCollection) {
                Prototype prototype = this.runtimeCtx.getDatagramPrototypeCache().lookupPrototype(eventId);
                if (prototype != null) {
                    if ("RowChangeEvent".equals(prototype.getModelName())) {
                        return eventId;
                    }
                    try {
                        PrototypeFactory.removeEventPrototype(eventId);
                    }
                    catch (DatagramFactoryException datagramFactoryException) {}
                }
            } else {
                return eventId;
            }
        }
        try {
            if (operationType == 50 || operationType == 19 || operationType == 3001 || operationType == 3032) {
                RowEvent rowEvent = (RowEvent)this.runtimeCtx.getEventDatagramFactory().newEventInstance("RowEvent");
                RowMetaData descriptor = new RowMetaData();
                for (int i = 0; i < this.table.getColumnCount(); ++i) {
                    ColumnSchema column = this.table.getColumn(i);
                    descriptor.addColumn(column.getObjectName().getStatementName());
                }
                rowEvent.init(descriptor);
                this.runtimeCtx.getDatagramPrototypeFactory().addEventPrototype(eventId, rowEvent);
            } else if (operationType == 82) {
                RowChangeEvent rowChangeEvent = (RowChangeEvent)this.runtimeCtx.getEventDatagramFactory().newEventInstance("RowChangeEvent");
                RowMetaData descriptor = new RowMetaData();
                for (int i = 0; i < this.table.getColumnCount(); ++i) {
                    ColumnSchema column = this.table.getColumn(i);
                    descriptor.addColumn(column.getObjectName().getStatementName());
                }
                Row beforeRow = new Row(descriptor);
                rowChangeEvent.setBeforeImage(beforeRow);
                Row afterRow = new Row(descriptor);
                rowChangeEvent.setAfterImage(afterRow);
                this.runtimeCtx.getDatagramPrototypeFactory().addEventPrototype(eventId, rowChangeEvent);
            } else if (operationType == 1206) {
                DataEvent dataEvent = (DataEvent)this.runtimeCtx.getEventDatagramFactory().newEventInstance("DataEvent");
                dataEvent.setData(new String());
                this.runtimeCtx.getDatagramPrototypeFactory().addDataEventPrototype(eventId, dataEvent);
            }
            return eventId;
        }
        catch (Exception error) {
            Trace.logError(TableCollection.class, error.getMessage());
            return null;
        }
    }

    @Override
    public ImmutableEventDatagram getEventForTrigger(Session session, Object[] oldData, Object[] newData, int when, int triggerType) {
        try {
            Object[] data;
            EventDatagram temp = EventDatagramFactory.getInstance().createEvent(this.getTriggerEventId(when, triggerType));
            if (triggerType == 1206) {
                if (!(temp instanceof DataEvent)) {
                    throw new DataspaceException("Invalid event prototype in the event trigger. Should be DataEvent with string payload for malformed data.");
                }
                ((DataEvent)temp).setData(oldData[0]);
                return temp;
            }
            if (oldData != null && newData != null) {
                if (!(temp instanceof RowChangeEvent)) {
                    throw new DataspaceException("Invalid event prototype in the event trigger.");
                }
                RowChangeEvent event = (RowChangeEvent)temp;
                Row row = event.getBeforeImage();
                row.setRawData(oldData);
                row = event.getAfterImage();
                row.setRawData(newData);
                return event;
            }
            Object[] objectArray = data = oldData != null ? oldData : newData;
            if (!(temp instanceof RowEvent)) {
                throw new DataspaceException("Invalid event prototype in the event trigger.");
            }
            RowEvent event = (RowEvent)temp;
            event.getRow().setRawData(data);
            return event;
        }
        catch (Exception error) {
            throw new DataspaceException(error.getMessage());
        }
    }

    public static void checkResultNotError(Result result) throws DataspaceException {
        if (result.isError()) {
            throw new DataspaceException(result);
        }
    }

    public static void checkUpdateCountIs(Result result, int updateCount) throws DataspaceException {
        if (!result.isUpdateCount() || result.getUpdateCount() != updateCount) {
            throw new DataspaceException("Operation failed. UpdateCount is invalid, expected " + updateCount + ", actually " + result.getUpdateCount());
        }
    }

    public static void checkResultIsData(Result result) {
        if (!result.isData()) {
            throw new DataspaceException("Operation failed. Result doesn't contain data.");
        }
    }

    @Override
    public Object wrapEvent(Session session, ImmutableEventDatagram event) {
        return event;
    }

    @Override
    public ImmutableEventDatagram unwrapEvent(Session session, Object data) {
        if (data instanceof ImmutableEventDatagram) {
            return (ImmutableEventDatagram)data;
        }
        return null;
    }

    @Override
    public List<ActiveEvent> getEvents() {
        return new ArrayList<ActiveEvent>();
    }

    @Override
    public ReplicationSource getReplicationSource() {
        if (this.table != null) {
            return this.table.getReplicationSource();
        }
        return null;
    }

    @Override
    public void dropReplicationSource() {
        if (this.table != null) {
            this.table.dropReplicationSource();
        }
    }

    @Override
    public boolean isReplicated() {
        if (this.table != null) {
            return this.table.isReplicated();
        }
        return false;
    }

    @Override
    public void setReplicationSource(ReplicationSource replicationSource) {
        if (this.table != null) {
            this.table.setReplicationSource(replicationSource);
        }
    }

    protected String makeDfetchSql(String columns, String selector, String updater, String orderBy, long timeout, TimeUnit unit) {
        String dfetchSql = "dfetch " + columns + " from " + this.name.getSchemaQualifiedStatementName();
        if (selector != null && selector.length() > 0) {
            dfetchSql = dfetchSql + " where " + selector;
        }
        if (orderBy != null) {
            dfetchSql = dfetchSql + " " + orderBy;
        }
        if (updater != null) {
            dfetchSql = dfetchSql + " (" + updater + ")";
        }
        if (timeout != -1L) {
            dfetchSql = dfetchSql + " wait " + this.convertTimeoutForDfetch(timeout, unit) + " " + this.convertTimeunitForDfetch(unit);
        }
        return dfetchSql;
    }

    protected long convertTimeoutForDfetch(long timeout, TimeUnit unit) {
        if (unit == TimeUnit.MICROSECONDS || unit == TimeUnit.NANOSECONDS) {
            timeout = 1L;
        }
        return timeout;
    }

    protected String convertTimeunitForDfetch(TimeUnit unit) {
        if (unit == TimeUnit.MICROSECONDS || unit == TimeUnit.NANOSECONDS) {
            unit = TimeUnit.MILLISECONDS;
        }
        switch (unit) {
            case MICROSECONDS: 
            case MILLISECONDS: 
            case NANOSECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "sec";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hr";
            }
            case DAYS: {
                return "day";
            }
        }
        return null;
    }

    protected Type resolveType(Session session, Object value) {
        if (value instanceof BigDecimal) {
            return Type.getType(3, null, null, ((BigDecimal)value).precision(), ((BigDecimal)value).scale());
        }
        return Types.getParameterSQLType(session, value.getClass());
    }

    protected <T, TT> T executeWithRemoteCollection(String nodeName, String componentType, String componentName, String collectionName, CollectionDelegate<T, TT> delegate, Class<? extends TT> collectionClazz) {
        if (nodeName != null && nodeName.length() == 0) {
            nodeName = null;
        }
        DataspaceType dataspaceType = DataspaceType.valueOf(componentType);
        try (FabricComponentAccessor accessor = null;){
            T e3;
            try {
                accessor = this.dataspace.createDataspaceAccessor(nodeName, dataspaceType, componentName);
            }
            catch (Exception e2) {
                throw new DataspaceException("Failed to open accessor to " + ModeratorUtils.makeComponentFullName(nodeName, componentType, componentName) + ". Cause: " + e2.getMessage());
            }
            if (accessor == null || !accessor.isAvailable()) {
                throw new DataspaceException("Failed to open accessor to " + ModeratorUtils.makeComponentFullName(nodeName, componentType, componentName));
            }
            DataCollection dataCollection = null;
            try {
                dataCollection = accessor.lookupCollection(collectionName);
            }
            catch (Exception e3) {
                throw new DataspaceException("Collection " + collectionName + " not found. Cause: " + e3.getMessage());
            }
            if (dataCollection == null) {
                throw new DataspaceException("Collection '" + collectionName + "' not found in " + ModeratorUtils.makeComponentFullName(nodeName, componentType, componentName));
            }
            if (!collectionClazz.isAssignableFrom(dataCollection.getClass())) {
                throw new DataspaceException("Collection '" + collectionName + "' is not instance of Collection.");
            }
            try {
                e3 = delegate.delegate(dataCollection, (DataspaceAccessor)accessor);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to execute delegate. Cause: " + exception.getMessage());
                throw new DataspaceException(exception.getMessage());
            }
            return e3;
        }
    }

    @Override
    public Long count(Session session) {
        Object count;
        Result result = session.compileStatement("select count(*) from " + this.getObjectName().getSchemaQualifiedStatementName()).execute(session);
        AbstractCollection.checkResultNotError(result);
        AbstractCollection.checkResultIsData(result);
        if (result.navigator.next() && (count = result.navigator.getCurrent()[0]) instanceof Number) {
            return ((Number)count).longValue();
        }
        return -1L;
    }

    public final void validate(boolean withLobs, int topN) {
        DataspaceStateHolder holder = new DataspaceStateHolder();
        if (withLobs) {
            this.onValidateLobs(holder);
        }
        this.onValidateTypes(holder, topN, TableTypesValidator.NormalizeScope.NONE);
        this.stateHolder = holder;
    }

    private void onValidateLobs(DataspaceStateHolder holder) {
        LobValidator lobValidator = this.store.lobManager.getValidator();
        LobValidator flobValidator = this.store.flobManager.getValidator(false);
        LobValidator.InvalidTable invalidTable = lobValidator.checkTableLobs(this.getBaseTable(), null, null, true);
        if (invalidTable != null && invalidTable.getInvalidLobsCount() > 0L) {
            ArrayList<String> l = new ArrayList<String>();
            for (LobValidator.InvalidRow r : invalidTable.getInvalidRows()) {
                for (LobValidator.InvalidColumn c : r.getInvalidColumns()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(invalidTable.getColumnNames().get(c.getColumnId()));
                    builder.append(" - references to broken LOB ID(").append(c.getLobId()).append(")");
                    l.add(builder.toString());
                }
            }
            if (l.size() > 0) {
                holder.setSuspectState(DataspaceStateHolder.lob, ((Object)l).toString());
            }
        }
        if ((invalidTable = flobValidator.checkTableLobs(this.getBaseTable(), null, null, false)) != null && (invalidTable.getInvalidLobsCount() > 0L || invalidTable.getInvalidLocations().size() > 0)) {
            if (invalidTable.getInvalidLocations().size() > 0) {
                Trace.logError(this, "WARNING: Non-existent FLOB locations for collection: {}. Make collection SUSPECT.", invalidTable.getObjectName().getSchemaQualifiedStatementName());
            }
            if (invalidTable.getInvalidLobsCount() > 0L) {
                Trace.logError(this, "WARNING: {} Invalid FLOB(s) detected in collection: {}.", invalidTable.getInvalidLobsCount(), invalidTable.getObjectName().getSchemaQualifiedStatementName());
            }
            if (invalidTable.getBrokenLobsCount() > 0L) {
                Trace.logError(this, "WARNING: {} Broken FLOB(s) detected in collection: {}. Collection is ONLINE.", invalidTable.getBrokenLobsCount(), invalidTable.getObjectName().getSchemaQualifiedStatementName());
            }
            StringBuilder builder = new StringBuilder();
            if (invalidTable.getInvalidLobsCount() > 0L) {
                builder.append("Column(s) ").append(invalidTable.getInvalidColumnNames().stream().collect(Collectors.joining(","))).append(" ");
                builder.append("references to ").append(invalidTable.getInvalidLobsCount()).append(" invalid/broken FLOB(s) in ").append(invalidTable.getInvalidRowsCount()).append(" row(s)");
            }
            if (invalidTable.getInvalidLocations().size() > 0) {
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append("Invalid location(s): ").append(invalidTable.getInvalidLocations().stream().collect(Collectors.joining(", ")));
            }
            if (invalidTable.getInvalidLocations().size() > 0) {
                holder.setSuspectState(DataspaceStateHolder.flob, builder.toString());
            }
        }
    }

    public TableTypesValidator.InvalidTypes validateTypes(int topN, TableTypesValidator.NormalizeScope normalizeScope) {
        return this.onValidateTypes(this.stateHolder, topN, normalizeScope);
    }

    private TableTypesValidator.InvalidTypes onValidateTypes(DataspaceStateHolder holder, int topN, TableTypesValidator.NormalizeScope normalizeScope) {
        if (this.table instanceof View) {
            return null;
        }
        TableTypesValidator.InvalidTypes invalidTypes = new TableTypesValidator(this.store, topN, normalizeScope).validateTableTypes(this.table);
        if (invalidTypes != null && invalidTypes.getInvalidTypes().size() > 0) {
            String error = invalidTypes.getInvalidTypes().values().stream().map(t -> ((TableTypesValidator.InvalidTable)t.get(0)).getInvalidColumns().stream().map(c -> c.getColumnName() + " - " + c.getError() + " ").collect(Collectors.joining())).collect(Collectors.joining());
            if (error.length() > 0 && error.charAt(error.length() - 1) == ' ') {
                error = error.substring(0, error.length() - 1);
            }
            holder.setSuspectState(DataspaceStateHolder.outOfSync, error);
        } else {
            holder.resetSuspectState(DataspaceStateHolder.outOfSync);
        }
        return invalidTypes;
    }

    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = (DataspaceStateHolder)this.getStateHolder().clone();
        try {
            if (this.dataspace != null) {
                DataspaceStateHolder.aggregateState(state, this.getReferences(), this.dataspace.getStore().schemaManager);
            } else {
                state.setRecoveryFailedState();
            }
            this.onAggregateOthers(state);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            state.setSuspectState(DataspaceStateHolder.object(this.getObjectName()), "Failed to aggregate state. Cause: " + exception.getMessage());
        }
        return state;
    }

    protected void onAggregateOthers(DataspaceStateHolder holder) {
    }

    public void exposeCollectionState(RowSetNavigatorClient navigator, boolean withValid) {
        ArrayList classes = new ArrayList(Arrays.asList(DataspaceStateHolder.lob.getClass(), DataspaceStateHolder.flob.getClass(), DataspaceStateHolder.DomainSuspectStateOriginator.class, DataspaceStateHolder.TypeSuspectStateOriginator.class, DataspaceStateHolder.PrototypeSuspectStateOriginator.class, DataspaceStateHolder.OutOfSyncSuspectStateOriginator.class, DataspaceStateHolder.ServerConnectionDataspaceSuspectStateOriginator.class, DataspaceStateHolder.IndexSuspectStateOriginator.class));
        classes.addAll(this.getExposeCollectionClassesOthers());
        this.aggregateStateHolder().exposeState(navigator, withValid, false, "Collection State", null, classes);
    }

    protected List<Class<? extends StateHolder.SuspectStateOriginator>> getExposeCollectionClassesOthers() {
        return Collections.emptyList();
    }

    public AbstractDataspace getDataspace() {
        return this.dataspace;
    }

    public List<TriggerDef> getWindowTriggers() {
        TriggerDef[] trigVec = this.table.triggerLists[Trigger.Type.WINDOW_CHANGE.ordinal()];
        return Arrays.asList(trigVec).stream().filter(t -> t != null).collect(Collectors.toList());
    }

    public static void checkAlterAllowed(AbstractCollection collection, String operationName, List<CollectionType> allowedTypes) {
        HashSet<CollectionType> notAllowedTypes = new HashSet<CollectionType>(alterNotAllowedTypes);
        if (allowedTypes != null) {
            notAllowedTypes.removeAll(allowedTypes);
        }
        if (notAllowedTypes.contains((Object)collection.getCollectionType())) {
            Trace.logError(AbstractCollection.class, "WARNING: Operation '" + operationName + "' is not allowed for this type of collection " + collection.getCollectionType().name() + ", collection: " + collection.getObjectName().getSchemaQualifiedStatementName() + ".");
            throw new DataspaceException("Operation '" + operationName + "' is not allowed for this type of collection " + collection.getCollectionType().name() + ", collection: " + collection.getObjectName().getSchemaQualifiedStatementName() + ".");
        }
    }

    protected static interface CollectionDelegate<T, TT> {
        public T delegate(TT var1, DataspaceAccessor var2) throws Exception;
    }
}

