/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.TableDuplicatesResolver;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.utils.Utils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SyntaxStore {
    static DataspaceStore store = null;
    static Statement saveObjectDefinition = null;
    static Statement updateObjectDefinition = null;
    static Statement loadObjectDefinition = null;
    static Statement loadObjectTimestamps = null;
    static Statement deleteObjectDefinition = null;
    static Statement deleteObjectDefinitions = null;
    static Statement deleteObjectDefinitionsForSchema = null;
    static Statement listEntityNamesDefinition = null;

    public static void setDataspaceStore(DataspaceStore dataspaceStore) {
        store = dataspaceStore;
    }

    public static void unload() {
        store = null;
        saveObjectDefinition = null;
        updateObjectDefinition = null;
        loadObjectDefinition = null;
        loadObjectTimestamps = null;
        deleteObjectDefinition = null;
        deleteObjectDefinitions = null;
        deleteObjectDefinitionsForSchema = null;
        listEntityNamesDefinition = null;
    }

    static synchronized void saveSyntax(Session session, FabricComponent component, String type, String name, String def) {
        Result result;
        if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
            return;
        }
        if (saveObjectDefinition == null) {
            if (session.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 4) == null) {
                return;
            }
            String sql = DataspaceStore.sysldefHasTimestamps ? "insert into SDS.SYSLDEF   values (?, ?, ?, ?, ?, now(), now())" : "insert into SDS.SYSLDEF (COMPONENT_TYPE,COMPONENT_NAME,ENTITY_TYPE,ENTITY_NAME,DEFINITION)  values (?, ?, ?, ?, ?)";
            saveObjectDefinition = session.compileStatement(sql);
        }
        def = def.replaceAll("'", "''");
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(new Object[]{component.getType(), component.getName(), type, name, def});
            result = saveObjectDefinition.execute(session);
        } else {
            result = session.executeCompiledStatement(saveObjectDefinition, new Object[]{component.getType(), component.getName(), type, name, def});
        }
        SyntaxStore.checkSysldefDuplicates(session, "saveSyntax");
        if (result.isError() || result.getUpdateCount() != 1) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to store definition for '" + type + "." + name + "' object. " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
    }

    static synchronized void updateCreatedAt(Session session, FabricComponent component, String type, String name, Timestamp created) {
        Result result;
        if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
            return;
        }
        if (session.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 4) == null) {
            return;
        }
        String sql = "update SDS.SYSLDEF  set CREATED=? where COMPONENT_TYPE = ? and COMPONENT_NAME = ? and ENTITY_TYPE = ? and ENTITY_NAME = ?";
        Statement updateCreatedAtDefinition = session.compileStatement(sql);
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(new Object[]{created, component.getType(), component.getName(), type, name});
            result = updateCreatedAtDefinition.execute(session);
        } else {
            result = session.executeCompiledStatement(updateCreatedAtDefinition, new Object[]{created, component.getType(), component.getName(), type, name});
        }
        SyntaxStore.checkSysldefDuplicates(session, "updateCreatedAt");
        if (result.isError() || result.getUpdateCount() != 1) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to update CREATED timestamp for  '" + type + "." + name + "' object. " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
    }

    public static void saveSyntax(FabricComponent component, String type, String name, String def) {
        try (Session sysSession = SyntaxStore.createSession(component);){
            SyntaxStore.saveSyntax(sysSession, component, type, name, def);
        }
    }

    static synchronized void updateSyntax(Session session, FabricComponent component, String type, String name, String def) {
        Result result;
        if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
            return;
        }
        if (updateObjectDefinition == null) {
            if (session.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 4) == null) {
                return;
            }
            String sql = DataspaceStore.sysldefHasTimestamps ? "update SDS.SYSLDEF   set DEFINITION = ?, MODIFIED=now() where COMPONENT_TYPE = ? and COMPONENT_NAME = ?    and ENTITY_TYPE = ? and ENTITY_NAME = ?" : "update SDS.SYSLDEF   set DEFINITION = ? where COMPONENT_TYPE = ? and COMPONENT_NAME = ?    and ENTITY_TYPE = ? and ENTITY_NAME = ?";
            updateObjectDefinition = session.compileStatement(sql);
        }
        def = def.replaceAll("'", "''");
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(new Object[]{def, component.getType(), component.getName(), type, name});
            result = updateObjectDefinition.execute(session);
        } else {
            result = session.executeCompiledStatement(updateObjectDefinition, new Object[]{def, component.getType(), component.getName(), type, name});
        }
        SyntaxStore.checkSysldefDuplicates(session, "update");
        if (result.isError() || result.getUpdateCount() != 1) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to update definition for '" + type + "." + name + "' object. " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
    }

    private static void checkSysldefDuplicates(Session session, String operation) {
        try {
            TableDuplicatesResolver resolver = new TableDuplicatesResolver(session.dataspaceStore, ((TableCollection)session.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 4)).getBaseTable());
            TableDuplicatesResolver.TableDuplicates tableDuplicates = resolver.findDuplicates(new TableDuplicatesResolver.OrderBy("MODIFIED", true));
            if (tableDuplicates.indexDuplicates.size() > 0) {
                Integer duplicatesKeysCount = tableDuplicates.indexDuplicates.stream().map(d -> d.duplicateValues.keySet().size()).reduce((i1, i2) -> i1 + i1).get();
                Integer duplicatesCount = tableDuplicates.indexDuplicates.stream().map(d -> d.duplicateValues.values().stream().map(v -> v.size()).reduce((i1, i2) -> i1 + i1).get()).reduce((i1, i2) -> i1 + i1).get();
                String duplicatesValues = tableDuplicates.indexDuplicates.stream().map(d -> d.duplicateValues.keySet().stream().collect(Collectors.joining(","))).collect(Collectors.joining(";"));
                Trace.logError(SyntaxStore.class, "WARNING: Duplicates in SYSLDEF table after {}. currentStatementCounter: {}, duplicatesKeysCount: {}, duplicatesCount: {}, duplicatesValues: {}, currentStatement: {}", operation, session.getCurrentStatementCounter(), duplicatesKeysCount, duplicatesCount, duplicatesValues, session.sessionContext != null && session.sessionContext.currentStatement != null ? session.sessionContext.currentStatement.sql : null);
            }
        }
        catch (Error error) {
            Trace.logError(SyntaxStore.class, "WARNING: failed to check SYSLDEF duplicates");
            Trace.logException(SyntaxStore.class, error, true);
        }
    }

    public static void updateSyntax(FabricComponent component, String type, String name, String def) {
        try (Session sysSession = SyntaxStore.createSession(component);){
            SyntaxStore.updateSyntax(sysSession, component, type, name, def);
        }
    }

    static synchronized String loadSyntax(Session session, FabricComponent component, String type, String name) {
        Result result;
        if (loadObjectDefinition == null) {
            if (session.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 4) == null) {
                return null;
            }
            loadObjectDefinition = session.compileStatement("select DEFINITION from SDS.SYSLDEF   where COMPONENT_TYPE = ? and COMPONENT_NAME = ?    and ENTITY_TYPE = ? and ENTITY_NAME = ? order by MODIFIED desc");
        }
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(new Object[]{component.getType(), component.getName(), type, name});
            result = loadObjectDefinition.execute(session);
        } else {
            result = session.executeCompiledStatement(loadObjectDefinition, new Object[]{component.getType(), component.getName(), type, name});
        }
        if (result.isError()) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to load definition for '" + type + "." + name + "' object. " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
        if (!result.isData() || !result.getNavigator().first()) {
            return null;
        }
        result.getNavigator().first();
        String def = result.getNavigator().getCurrent(0).toString();
        if (def != null) {
            def = def.replaceAll("''", "'");
        }
        return def;
    }

    public static String loadSyntax(FabricComponent component, String type, String name) {
        try (Session sysSession = SyntaxStore.createSession(component);){
            String string = SyntaxStore.loadSyntax(sysSession, component, type, name);
            return string;
        }
    }

    static synchronized Pair<Timestamp, Timestamp> loadObjectTimestamps(Session session, FabricComponent component, String type, String name) {
        Timestamp modifiedTimestamp;
        long modifiedMillis;
        Result result;
        if (loadObjectTimestamps == null) {
            if (session.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 4) == null) {
                return null;
            }
            if (!DataspaceStore.sysldefHasTimestamps) {
                return new Pair<Object, Object>(null, null);
            }
            loadObjectTimestamps = session.compileStatement("select CREATED, MODIFIED from SDS.SYSLDEF   where COMPONENT_TYPE = ? and COMPONENT_NAME = ?    and ENTITY_TYPE = ? and ENTITY_NAME = ? order by MODIFIED desc");
        }
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(new Object[]{component.getType(), component.getName(), type, name});
            result = loadObjectTimestamps.execute(session);
        } else {
            result = session.executeCompiledStatement(loadObjectTimestamps, new Object[]{component.getType(), component.getName(), type, name});
        }
        if (result.isError()) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to load definition for '" + type + "." + name + "' object. " + cause;
            Trace.logError(SyntaxStore.class, error);
            return new Pair<Object, Object>(null, null);
        }
        if (!result.isData() || !result.getNavigator().first()) {
            return new Pair<Object, Object>(null, null);
        }
        result.getNavigator().first();
        TimestampData created = (TimestampData)result.getNavigator().getCurrent(0);
        TimestampData modified = (TimestampData)result.getNavigator().getCurrent(1);
        long createdMillis = created != null ? created.getMilliseconds() : 0L;
        long l = modifiedMillis = modified != null ? modified.getMilliseconds() : 0L;
        if (session.getCalendar() != null) {
            if (createdMillis != 0L) {
                createdMillis = DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), createdMillis);
            }
            if (modifiedMillis != 0L) {
                modifiedMillis = DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), modifiedMillis);
            }
        }
        Timestamp createdTimestamp = createdMillis != 0L ? new Timestamp(createdMillis) : null;
        Timestamp timestamp = modifiedTimestamp = modifiedMillis != 0L ? new Timestamp(modifiedMillis) : null;
        if (created != null) {
            createdTimestamp.setNanos(created.getNanos());
        }
        if (modified != null) {
            modifiedTimestamp.setNanos(modified.getNanos());
        }
        return new Pair<Timestamp, Timestamp>(createdTimestamp, modifiedTimestamp);
    }

    static synchronized void deleteSyntax(Session session, FabricComponent component, String type, String name) {
        Result result;
        if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
            return;
        }
        if (deleteObjectDefinition == null) {
            deleteObjectDefinition = session.compileStatement("delete from SDS.SYSLDEF   where COMPONENT_TYPE = ? and COMPONENT_NAME = ?   and ENTITY_TYPE = ? and ENTITY_NAME = ? ");
        }
        Object[] arguments = new Object[]{component.getType(), component.getName(), type, name};
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(arguments);
            result = deleteObjectDefinition.execute(session);
        } else {
            result = session.executeCompiledStatement(deleteObjectDefinition, arguments);
        }
        if (result.isError()) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to delete definition for '" + type + "." + name + "' object. " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
    }

    static synchronized void deleteSyntaxes(Session session, FabricComponent component, String type) {
        Result result;
        if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
            return;
        }
        if (deleteObjectDefinitions == null) {
            deleteObjectDefinitions = session.compileStatement("delete from SDS.SYSLDEF   where COMPONENT_TYPE = ? and COMPONENT_NAME = ?   and ENTITY_TYPE = ?");
        }
        Object[] arguments = new Object[]{component.getType(), component.getName(), type};
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(arguments);
            result = deleteObjectDefinitions.execute(session);
        } else {
            result = session.executeCompiledStatement(deleteObjectDefinitions, arguments);
        }
        if (result.isError()) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to delete definitions for " + component.getType() + "." + component.getName() + "." + type + ". " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
    }

    static synchronized void deleteSyntaxes(Session session, FabricComponent component) {
        Result result;
        if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
            return;
        }
        deleteObjectDefinitionsForSchema = SyntaxStore.compileAsAdmin(session, component, deleteObjectDefinitionsForSchema, "delete from SDS.SYSLDEF   where COMPONENT_TYPE = ? and COMPONENT_NAME = ?");
        Object[] arguments = new Object[]{component.getType(), component.getName()};
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(arguments);
            result = deleteObjectDefinitionsForSchema.execute(session);
        } else {
            result = session.executeCompiledStatement(deleteObjectDefinitionsForSchema, arguments);
        }
        SyntaxStore.checkSysldefDuplicates(session, "delete");
        if (result.isError()) {
            String cause = result.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(result.getException()) : "";
            String error = "Unable to delete definitions for schema " + component.getType() + "." + component.getName() + ". " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
    }

    public static void deleteSyntax(FabricComponent component, String type, String name) {
        try (Session sysSession = SyntaxStore.createSession(component);){
            if (name != null) {
                SyntaxStore.deleteSyntax(sysSession, component, type, name);
            } else if (type != null) {
                SyntaxStore.deleteSyntaxes(sysSession, component, type);
            } else {
                SyntaxStore.deleteSyntaxes(sysSession, component);
            }
        }
    }

    static synchronized List<String> listEntityNames(Session session, FabricComponent component, String type) {
        Result result;
        if (listEntityNamesDefinition == null) {
            listEntityNamesDefinition = session.compileStatement("select ENTITY_NAME from SDS.SYSLDEF   where COMPONENT_TYPE = ? and COMPONENT_NAME = ?   and ENTITY_TYPE = ?");
        }
        if (session.getCurrentStatementCounter() > 0) {
            session.sessionContext.setDynamicArguments(new Object[]{component.getType(), component.getName(), type});
            result = listEntityNamesDefinition.execute(session);
        } else {
            result = session.executeCompiledStatement(listEntityNamesDefinition, new Object[]{component.getType(), component.getName(), type});
        }
        if (result.isError()) {
            String cause = result.getException() != null ? result.getException().getMessage() : "";
            String error = "Unable to get entity names definition for " + component.getType() + "." + component.getName() + "." + type + " object. " + cause;
            Trace.logError(SyntaxStore.class, error);
            throw new DataspaceException(error);
        }
        ArrayList<String> names = new ArrayList<String>();
        while (result.navigator.next()) {
            names.add((String)result.navigator.getCurrent()[0]);
        }
        return names;
    }

    public static List<String> listEntityNames(FabricComponent component, String type) {
        try (Session sysSession = SyntaxStore.createSession(component);){
            List<String> list = SyntaxStore.listEntityNames(sysSession, component, type);
            return list;
        }
    }

    private static Session createSession(FabricComponent component) {
        AbstractDataspace dataspace = (AbstractDataspace)SyntaxStore.store.schemaManager.findSchema("SYS");
        if (dataspace != null) {
            return dataspace.createSession();
        }
        throw new DataspaceException("Dataspace 'SYS' not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Statement compileAsAdmin(Session session, FabricComponent component, Statement statement, String sql) {
        if (statement == null) {
            Session compileSession = session;
            if (!session.isAdmin()) {
                compileSession = SyntaxStore.createSession(component);
            }
            try {
                statement = compileSession.compileStatement(sql);
            }
            finally {
                if (compileSession != session) {
                    compileSession.close();
                }
            }
        }
        return statement;
    }
}

