/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema;

import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.repository.types.SemanticType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SemanticTypeAndPrototypeSchemaObjectsCache {
    private static Map<String, NameManager.ObjectName> semanticTypeObjectNames = new ConcurrentHashMap<String, NameManager.ObjectName>();
    private static Map<String, NameManager.ObjectName> eventPrototypeObjectNames = new ConcurrentHashMap<String, NameManager.ObjectName>();
    private static Map<String, NameManager.ObjectName> fileDescriptorObjectNames = new ConcurrentHashMap<String, NameManager.ObjectName>();
    private static Map<String, NameManager.ObjectName> connectionFactoryObjectNames = new ConcurrentHashMap<String, NameManager.ObjectName>();

    public static NameManager.ObjectName createOrGetSemanticTypeObjectName(String semanticTypeName) {
        NameManager.ObjectName objectName = semanticTypeObjectNames.get(semanticTypeName);
        if (objectName == null) {
            NameManager.ObjectName newObjectName = NameManager.newSystemObjectName(semanticTypeName, 35);
            newObjectName.schema = SqlInvariants.SYS_SCHEMA_NAME;
            if (semanticTypeObjectNames.putIfAbsent(semanticTypeName, newObjectName) == null) {
                objectName = newObjectName;
            }
        }
        return objectName;
    }

    public static NameManager.ObjectName getSemanticTypeObjectName(String semanticTypeName) {
        return semanticTypeObjectNames.get(semanticTypeName);
    }

    public static NameManager.ObjectName createOrGetEventPrototypeObjectName(String eventId) {
        NameManager.ObjectName newObjectName;
        NameManager.ObjectName objectName = eventPrototypeObjectNames.get(eventId);
        if (objectName == null && eventPrototypeObjectNames.putIfAbsent(eventId, newObjectName = NameManager.newSystemObjectName(eventId, 36)) == null) {
            objectName = newObjectName;
        }
        return objectName;
    }

    public static NameManager.ObjectName createOrGetFileDescriptorObjectName(String fileDescriptorName) {
        NameManager.ObjectName objectName = fileDescriptorObjectNames.get(fileDescriptorName);
        if (objectName == null) {
            NameManager.ObjectName newObjectName = NameManager.newSystemObjectName(fileDescriptorName, 39);
            newObjectName.schema = SqlInvariants.SYS_SCHEMA_NAME;
            if (fileDescriptorObjectNames.putIfAbsent(fileDescriptorName, newObjectName) == null) {
                objectName = newObjectName;
            }
        }
        return objectName;
    }

    public static NameManager.ObjectName createOrGetConnectionFactoryObjectName(String connectionFactoryName) {
        NameManager.ObjectName objectName = connectionFactoryObjectNames.get(connectionFactoryName);
        if (objectName == null) {
            NameManager.ObjectName newObjectName = NameManager.newSystemObjectName(connectionFactoryName, 40);
            newObjectName.schema = SqlInvariants.SYS_SCHEMA_NAME;
            if (connectionFactoryObjectNames.putIfAbsent(connectionFactoryName, newObjectName) == null) {
                objectName = newObjectName;
            }
        }
        return objectName;
    }

    public static NameManager.ObjectName mapTypeToSemanticType(NameManager.ObjectName name) {
        NameManager.ObjectName semanticTypeName;
        if (name.type == 13 && (semanticTypeName = SemanticTypeAndPrototypeSchemaObjectsCache.getSemanticTypeObjectName(name.name)) != null) {
            name = semanticTypeName;
        }
        return name;
    }

    public static Boolean isSystem(NameManager.ObjectName name) {
        SemanticType semanticType;
        if (name.type == 35 && (semanticType = DataspaceStoreManager.getRuntimeContext().getSemanticTypeCache().lookupSemanticType(name.name)) != null && semanticType.isSystem()) {
            return true;
        }
        return false;
    }
}

