/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.NotLoggable;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.View;
import java.util.List;

public class SchemaObjectSet {
    public HashMap map;
    int type;

    SchemaObjectSet(int type) {
        this.type = type;
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                this.map = new HashMappedList();
                break;
            }
            case 6: 
            case 10: 
            case 21: {
                this.map = new HashMap();
            }
        }
    }

    NameManager.ObjectName getName(String name) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                SchemaObject object = (SchemaObject)this.map.get(name);
                return object == null ? null : object.getObjectName();
            }
            case 6: 
            case 10: 
            case 21: {
                return (NameManager.ObjectName)this.map.get(name);
            }
        }
        return (NameManager.ObjectName)this.map.get(name);
    }

    public SchemaObject getObject(String name) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return (SchemaObject)this.map.get(name);
            }
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    void checkAdd(NameManager.ObjectName name) {
        if (this.map.containsKey(name.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, name.name);
        }
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    void checkExists(String name) {
        if (!this.map.containsKey(name)) {
            int code = SchemaObjectSet.getGetErrorCode(this.type);
            throw Error.error(code, name);
        }
    }

    public void add(SchemaObject object) {
        NameManager.ObjectName name = object.getObjectName();
        if (this.type == 25) {
            name = ((RplScript)object).getSpecificName();
        }
        if (this.map.containsKey(name.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, name.name);
        }
        Object value = object;
        switch (name.type) {
            case 6: 
            case 21: {
                value = name;
            }
        }
        this.map.put(name.name, value);
    }

    void remove(String name) {
        this.map.remove(name);
    }

    void removeParent(NameManager.ObjectName parent) {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            if (this.type == 9 || this.type == 25) {
                SchemaObject object = (SchemaObject)it.next();
                if (object.getObjectName().parent != parent) continue;
                it.remove();
                continue;
            }
            NameManager.ObjectName name = (NameManager.ObjectName)it.next();
            if (name.parent != parent) continue;
            it.remove();
        }
    }

    void rename(NameManager.ObjectName name, NameManager.ObjectName newName) {
        if (this.map.containsKey(newName.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, newName.name);
        }
        switch (newName.type) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int i = ((HashMappedList)this.map).getIndex(name.name);
                if (i == -1) {
                    int code = SchemaObjectSet.getGetErrorCode(name.type);
                    throw Error.error(code, name.name);
                }
                SchemaObject object = (SchemaObject)((HashMappedList)this.map).get(i);
                object.getObjectName().rename(newName);
                ((HashMappedList)this.map).setKey(i, name.name);
                break;
            }
            case 6: 
            case 10: 
            case 21: {
                this.map.remove(name.name);
                name.rename(newName);
                this.map.put(name.name, name);
            }
        }
    }

    static int getAddErrorCode(int type) {
        return switch (type) {
            case 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 18, 21, 25, 27, 29, 30, 31, 32, 37, 38, 41, 42, 43, 44, 45, 46 -> 5504;
            default -> throw Error.runtimeError(201, "SchemaObjectSet");
        };
    }

    public static int getGetErrorCode(int type) {
        return switch (type) {
            case 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 18, 19, 21, 25, 27, 29, 30, 31, 32, 37, 38, 41, 42, 43, 44, 45, 46 -> 5501;
            default -> throw Error.runtimeError(201, "SchemaObjectSet");
        };
    }

    public static String getName(int type) {
        switch (type) {
            case 5: {
                return "VIEW";
            }
            case 10: {
                return "COLUMN";
            }
            case 3: {
                return "TABLE";
            }
            case 4: {
                return "COLLECTION";
            }
            case 29: {
                return "REPLICA";
            }
            case 32: {
                return "EVENT HANDLER";
            }
            case 37: {
                return "REFERENCE LINK";
            }
            case 30: {
                return "TIMER";
            }
            case 31: {
                return "JOB";
            }
            case 27: {
                return "SERVER";
            }
            case 8: {
                return "SEQUENCE";
            }
            case 15: {
                return "CHARACTER SET";
            }
            case 41: {
                return "FACETS";
            }
            case 42: {
                return "ASPECTS";
            }
            case 43: {
                return "KNODE";
            }
            case 44: {
                return "KLINK";
            }
            case 45: {
                return "KGRAPH DEFINITION";
            }
            case 46: {
                return "KGRAPH";
            }
            case 14: {
                return "DOMAIN";
            }
            case 13: {
                return "TYPE";
            }
            case 6: {
                return "CONSTRAINT";
            }
            case 16: {
                return "COLLATION";
            }
            case 18: {
                return "PROCEDURE";
            }
            case 17: {
                return "FUNCTION";
            }
            case 7: {
                return "ASSERTION";
            }
            case 21: {
                return "INDEX";
            }
            case 9: {
                return "TRIGGER";
            }
            case 25: {
                return "SPECIFIC ROUTINE";
            }
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    void getSQL(List<String> list, OrderedHashSet resolved, OrderedHashSet unresolved, DataspaceStore store) {
        if (!(this.map instanceof HashMappedList)) {
            return;
        }
        if (this.map.isEmpty()) {
            return;
        }
        Iterator it = this.map.values().iterator();
        if (this.type == 17 || this.type == 18) {
            OrderedHashSet set = new OrderedHashSet();
            while (it.hasNext()) {
                RoutineSchema routineSchema = (RoutineSchema)it.next();
                for (int i = 0; i < routineSchema.routines.length; ++i) {
                    RplScript routine = routineSchema.routines[i];
                    set.add(routine);
                }
            }
            it = set.iterator();
        }
        SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, null, store, true);
    }

    static void addAllSQL(OrderedHashSet resolved, OrderedHashSet unresolved, List<String> list, Iterator it, OrderedHashSet newResolved, DataspaceStore store, boolean dataspaceSet) {
        block10: while (it.hasNext()) {
            DataspaceStore.DDLRecordNode node;
            SchemaObject object = (SchemaObject)it.next();
            if (object instanceof NotLoggable) continue;
            OrderedHashSet references = object.getReferences();
            boolean isResolved = true;
            block11: for (int j = 0; j < references.size(); ++j) {
                NameManager.ObjectName name = (NameManager.ObjectName)references.get(j);
                if (SqlInvariants.isSchemaNameSystem(name)) continue;
                switch (name.type) {
                    case 3: {
                        if (resolved.contains(name)) continue block11;
                        isResolved = false;
                        continue block11;
                    }
                    case 10: {
                        Table baseTable;
                        if (object.getObjectType() == 4 && !((baseTable = ((Collection)object).getBaseTable()) instanceof View) && baseTable != null) {
                            int index = baseTable.findColumn(name.name);
                            ColumnSchema column = baseTable.getColumn(index);
                            if (SchemaObjectSet.isChildObjectResolved(column, resolved)) continue block11;
                            isResolved = false;
                            continue block11;
                        }
                        if (resolved.contains(name.parent)) continue block11;
                        isResolved = false;
                        continue block11;
                    }
                    case 6: {
                        Constraint constraint;
                        if (name.parent != object.getObjectName() || (constraint = ((Table)object).getConstraint(name.name)).getConstraintType() != 3 || SchemaObjectSet.isChildObjectResolved(constraint, resolved)) continue block11;
                        isResolved = false;
                        continue block11;
                    }
                    case 15: {
                        if (name.schema == null) continue block11;
                    }
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 25: {
                        if (resolved.contains(name)) continue block11;
                        isResolved = false;
                    }
                }
            }
            if (!isResolved) {
                unresolved.add(object);
                continue;
            }
            NameManager.ObjectName name = object.getObjectType() == 17 || object.getObjectType() == 18 ? ((RplScript)object).getSpecificName() : object.getObjectName();
            resolved.add(name);
            if (newResolved != null) {
                newResolved.add(object);
            }
            if (object.getObjectType() == 4) {
                if (!dataspaceSet) {
                    DataspaceSchema.addSetSchemaSQLAndIndex(list, object.getSchemaName(), store);
                }
                String[] temp = ((Collection)object).getSQL(resolved, unresolved);
                if (!store.generateLogIndex || temp.length <= 0) continue;
                list.add(temp[0]);
                DataspaceStore.DDLRecordNode node2 = new DataspaceStore.DDLRecordNode();
                node2.objectName = ((Collection)object).getObjectName().getSchemaQualifiedStatementName();
                node2.dataspaceId = ((Collection)object).getObjectName().schema.getId();
                node2.objectId = ((Collection)object).getObjectName().getId();
                node2.type = LogRecordType.CREATE;
                store.logIndexBuilder.put(list.size() - 1, node2);
                for (int i = 1; i < temp.length; ++i) {
                    list.add(temp[i]);
                    node2 = new DataspaceStore.DDLRecordNode();
                    node2.objectName = ((Collection)object).getObjectName().getSchemaQualifiedStatementName();
                    node2.dataspaceId = ((Collection)object).getObjectName().schema.getId();
                    node2.objectId = ((Collection)object).getObjectName().getId();
                    node2.type = LogRecordType.OTHER;
                    store.logIndexBuilder.put(list.size() - 1, node2);
                }
                continue;
            }
            switch (object.getObjectType()) {
                case 17: 
                case 18: {
                    if (!dataspaceSet) {
                        DataspaceSchema.addSetSchemaSQLAndIndex(list, object.getSchemaName(), store);
                    }
                    if (!((RplScript)object).isRecursive) break;
                    list.add(((RplScript)object).getSQLDeclaration());
                    node = new DataspaceStore.DDLRecordNode();
                    node.objectName = ((RplScript)object).getObjectName().getSchemaQualifiedStatementName();
                    node.dataspaceId = ((RplScript)object).getObjectName().schema.getId();
                    node.objectId = ((RplScript)object).getObjectName().getId();
                    node.type = LogRecordType.CREATE;
                    store.logIndexBuilder.put(list.size() - 1, node);
                    list.add(((RplScript)object).getSQLAlter());
                    node = new DataspaceStore.DDLRecordNode();
                    node.objectName = ((RplScript)object).getObjectName().getSchemaQualifiedStatementName();
                    node.dataspaceId = ((RplScript)object).getObjectName().schema.getId();
                    node.objectId = ((RplScript)object).getObjectName().getId();
                    node.type = LogRecordType.OTHER;
                    store.logIndexBuilder.put(list.size() - 1, node);
                    continue block10;
                }
            }
            list.add(object.getSQL());
            node = new DataspaceStore.DDLRecordNode();
            node.objectName = object.getObjectName().getSchemaQualifiedStatementName();
            node.dataspaceId = object.getObjectName().schema.getId();
            node.objectId = object.getObjectName().getId();
            node.type = LogRecordType.CREATE;
            store.logIndexBuilder.put(list.size() - 1, node);
        }
    }

    static boolean isChildObjectResolved(SchemaObject object, OrderedHashSet resolved) {
        OrderedHashSet refs = object.getReferences();
        for (int i = 0; i < refs.size(); ++i) {
            NameManager.ObjectName name = (NameManager.ObjectName)refs.get(i);
            if (SqlInvariants.isSchemaNameSystem(name) || resolved.contains(name)) continue;
            return false;
        }
        return true;
    }
}

