/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.collection.tspace.view.ViewCollection;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.RecompiledTrigger;

public interface SchemaObject {
    public static final int CATALOG = 1;
    public static final int SCHEMA = 2;
    public static final int TABLE = 3;
    public static final int COLLECTION = 4;
    public static final int VIEW = 5;
    public static final int CONSTRAINT = 6;
    public static final int ASSERTION = 7;
    public static final int SEQUENCE = 8;
    public static final int TRIGGER = 9;
    public static final int COLUMN = 10;
    public static final int TRANSITION = 11;
    public static final int GRANTEE = 12;
    public static final int TYPE = 13;
    public static final int DOMAIN = 14;
    public static final int CHARSET = 15;
    public static final int COLLATION = 16;
    public static final int FUNCTION = 17;
    public static final int PROCEDURE = 18;
    public static final int ROUTINE = 19;
    public static final int CURSOR = 20;
    public static final int INDEX = 21;
    public static final int LABEL = 22;
    public static final int VARIABLE = 23;
    public static final int PARAMETER = 24;
    public static final int SPECIFIC_ROUTINE = 25;
    public static final int WRAPPER = 26;
    public static final int SERVER = 27;
    public static final int SUBQUERY = 28;
    public static final int REPLICA = 29;
    public static final int TIMER = 30;
    public static final int JOB = 31;
    public static final int ACTOR = 32;
    public static final int TRANSIENT_VAR = 33;
    public static final int REPLICATION_SOURCE = 34;
    public static final int SEMANTIC_TYPE = 35;
    public static final int EVENT_PROTOTYPE = 36;
    public static final int REFERENCE_LINK = 37;
    public static final int FULL_TEXT_INDEX = 38;
    public static final int FILE_DESCRIPTOR = 39;
    public static final int CONNECTION_FACTORY = 40;
    public static final int FACETS = 41;
    public static final int ASPECTS = 42;
    public static final int KNODE_TYPE = 43;
    public static final int KLINK_TYPE = 44;
    public static final int KGRAPH_TYPE = 45;
    public static final int KGRAPH_INSTANCE = 46;
    public static final SchemaObject[] emptyArray = new SchemaObject[0];

    public int getObjectType();

    public NameManager.ObjectName getObjectName();

    public NameManager.ObjectName getSchemaName();

    public NameManager.ObjectName getCatalogName();

    public Grantee getOwner();

    public OrderedHashSet getReferences();

    public OrderedHashSet getComponents();

    public void compile(Session var1, SchemaObject var2);

    public String getSQL();

    public String getSQL(String var1);

    default public String getSQLInSchema(String schemaName) {
        throw new DataspaceException("getSQLInSchema not implemented in object of class " + String.valueOf(this.getClass()));
    }

    public long getChangeTimestamp();

    default public boolean recompileObject(Session session) {
        if (this instanceof RplScript && ((RplScript)this).routineSchema != null) {
            ((RplScript)this).routineSchema.recompileFunction(session);
        } else if (this instanceof RoutineSchema) {
            ((RoutineSchema)this).recompileFunction(session);
        } else if (this instanceof Actor) {
            ((Actor)this).recompileActor(session);
        } else if (this instanceof RecompiledTrigger) {
            ((RecompiledTrigger)((Object)this)).recompileTrigger(session);
        } else if (this instanceof ReferenceLink) {
            ((ReferenceLink)this).recompileReferenceLink(session);
        } else if (this instanceof View) {
            ((View)this).recompileView(session);
        } else if (this instanceof ViewCollection) {
            ((ViewCollection)this).recompileView(session);
        } else {
            return false;
        }
        return true;
    }

    default public DataspaceStateHolder aggregateObjectStateHolder() {
        if (this instanceof RplScript && ((RplScript)this).routineSchema != null) {
            return ((RplScript)this).aggregateStateHolder();
        }
        if (this instanceof RoutineSchema) {
            return ((RoutineSchema)this).routines[0].aggregateStateHolder();
        }
        if (this instanceof Actor) {
            return ((Actor)this).aggregateStateHolder();
        }
        if (this instanceof EventTriggerDefSQL) {
            return ((EventTriggerDefSQL)this).aggregateStateHolder();
        }
        if (this instanceof ReferenceLink) {
            return ((ReferenceLink)this).aggregateStateHolder();
        }
        if (this instanceof View) {
            return ((View)this).aggregateStateHolder();
        }
        if (this instanceof ViewCollection) {
            return ((ViewCollection)this).aggregateStateHolder();
        }
        return new DataspaceStateHolder();
    }

    public static interface Nullability {
        public static final byte NO_NULLS = 0;
        public static final byte NULLABLE = 1;
        public static final byte NULLABLE_UNKNOWN = 2;
    }

    public static interface ParameterModes {
        public static final byte PARAM_UNKNOWN = 0;
        public static final byte PARAM_IN = 1;
        public static final byte PARAM_OUT = 4;
        public static final byte PARAM_INOUT = 2;
        public static final byte PARAM_FUNCTION_RESULT = 5;
        public static final byte PARAM_FUNCTION_RESULT_COLUMN = 3;
    }

    public static interface ViewCheckModes {
        public static final int CHECK_NONE = 0;
        public static final int CHECK_LOCAL = 1;
        public static final int CHECK_CASCADE = 2;
    }

    public static interface Deferable {
        public static final int NOT_DEFERRABLE = 0;
        public static final int INIT_DEFERRED = 1;
        public static final int INIT_IMMEDIATE = 2;
    }

    public static interface ReferentialAction {
        public static final int CASCADE = 0;
        public static final int RESTRICT = 1;
        public static final int SET_NULL = 2;
        public static final int NO_ACTION = 3;
        public static final int SET_DEFAULT = 4;
    }

    public static interface ConstraintTypes {
        public static final int FOREIGN_KEY = 0;
        public static final int MAIN = 1;
        public static final int UNIQUE = 2;
        public static final int CHECK = 3;
        public static final int PRIMARY_KEY = 4;
        public static final int TEMP = 5;
    }
}

