/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.ds.DataspaceLoggerImpl;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.TypeInvariants;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.MultiValueHashMap;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.WrapperIterator;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SchemaObjectSet;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.SyntaxStore;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.cspace.CSpace;
import com.streamscape.ds.schema.collection.fspace.FSpace;
import com.streamscape.ds.schema.collection.fspace.table.LogFileTable;
import com.streamscape.ds.schema.collection.qspace.QSpace;
import com.streamscape.ds.schema.collection.tspace.TSpace;
import com.streamscape.ds.schema.collection.tspace.vtable.VirtualTableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.state.StateHolder;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.ReplicationEventTrigger;
import com.streamscape.ds.trigger.ReplicationModifyTrigger;
import com.streamscape.ds.trigger.ReplicationValidateTrigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.Charset;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.UserTypeModifier;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.numalloc.IntNumberAllocator;
import com.streamscape.lib.numalloc.NumberAllocatorException;
import com.streamscape.lib.reflection.creator.ObjectCreator;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.utils.Utils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SchemaManager {
    public static final int NON_EXISTING_DATASPACE_ID = -1;
    public static final int SYS_SCHEMA_DATASPACE_ID = 0;
    public static final int SDS_SCHEMA_DATASPACE_ID = 1;
    public static final int RDS_SCHEMA_DATASPACE_ID = 2;
    public static final int SYSTEM_SCHEMA_DATASPACE_ID = 3;
    public static final int LOBS_SCHEMA_DATASPACE_ID = 4;
    public static final int FLOBS_SCHEMA_DATASPACE_ID = 5;
    public static final int SCH_SCHEMA_DATASPACE_ID = 6;
    public static final int SYSTEM_DATASPACE_ID_MAX = 8;
    DataspaceStore store;
    NameManager.ObjectName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();
    MultiValueHashMap referenceMap = new MultiValueHashMap();
    MemoryModel defaultMemoryModel = MemoryModel.MEMORY;
    public long schemaChangeTimestamp;
    public NameManager.ObjectName[] catalogNameArray;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    Table dualTable;
    public Table dataChangeTable;
    IntNumberAllocator dataspaceIdAllocator = new IntNumberAllocator(8L);
    long[][] tempIndexRoots;

    public SchemaManager(DataspaceStore store) {
        DataspaceLogger logger;
        this.store = store;
        this.defaultSchemaHsqlName = SqlInvariants.SYS_SCHEMA_NAME;
        this.catalogNameArray = new NameManager.ObjectName[]{store.getCatalogName()};
        SyntaxStore.setDataspaceStore(store);
        TSpace schema = null;
        try {
            schema = new TSpace(SqlInvariants.SYS_SCHEMA_NAME, EventScope.OBSERVABLE, SqlInvariants.SYS_SCHEMA_NAME.owner, store);
        }
        catch (FabricNamingException exception) {
            Trace.logException(this, exception, true);
        }
        this.schemaMap.put(schema.getObjectName().name, schema);
        try {
            schema.getTypeLookup().add(SqlInvariants.CARDINAL_NUMBER);
            schema.getTypeLookup().add(SqlInvariants.YES_OR_NO);
            schema.getTypeLookup().add(SqlInvariants.CHARACTER_DATA);
            schema.getTypeLookup().add(SqlInvariants.SQL_IDENTIFIER);
            schema.getTypeLookup().add(SqlInvariants.TIME_STAMP);
            SemanticTypeCache cache = DataspaceStoreManager.getRuntimeContext().getSemanticTypeCache();
            for (String typeName : cache.listSemanticTypes()) {
                SemanticType semType = cache.lookupSemanticType(typeName);
                this.registerSemanticTypeAsType(semType, schema);
            }
            schema.getCharsetLookup().add(SqlInvariants.SQL_TEXT);
            schema.getCharsetLookup().add(SqlInvariants.SQL_IDENTIFIER_CHARSET);
            schema.getCharsetLookup().add(SqlInvariants.SQL_CHARACTER);
        }
        catch (DataspaceException exception) {
            Trace.logException(this, exception, true);
        }
        TSpace systemDataspace = null;
        try {
            systemDataspace = new TSpace(SqlInvariants.SDS_SCHEMA_NAME, EventScope.OBSERVABLE, SqlInvariants.SDS_SCHEMA_NAME.owner, store);
            logger = store.getDefaultLogger();
            if (logger == null) {
                logger = new DataspaceLoggerImpl(DataspaceType.TSPACE.name() + ".SDS", Trace.Level.DEBUG, store.getTimeZone());
            }
            systemDataspace.setLogger(logger);
        }
        catch (FabricNamingException exception) {
            Trace.logException(this, exception, true);
        }
        this.schemaMap.put(systemDataspace.getObjectName().name, systemDataspace);
        TSpace rdsDataspace = null;
        try {
            rdsDataspace = new TSpace(SqlInvariants.RDS_SCHEMA_NAME, EventScope.OBSERVABLE, SqlInvariants.RDS_SCHEMA_NAME.owner, store);
            logger = store.getDefaultLogger();
            if (logger == null) {
                logger = new DataspaceLoggerImpl(DataspaceType.TSPACE.name() + ".RDS", Trace.Level.DEBUG, store.getTimeZone());
            }
            rdsDataspace.setLogger(logger);
        }
        catch (FabricNamingException exception) {
            Trace.logException(this, exception, true);
        }
        this.schemaMap.put(rdsDataspace.getObjectName().name, rdsDataspace);
        TSpace schedulerDataspace = null;
        try {
            schedulerDataspace = new TSpace(SqlInvariants.SCH_SCHEMA_NAME, EventScope.GLOBAL, SqlInvariants.SCH_SCHEMA_NAME.owner, store);
            logger = store.getDefaultLogger();
            if (logger == null) {
                logger = new DataspaceLoggerImpl(DataspaceType.TSPACE.name() + ".SCH", Trace.Level.DEBUG, store.getTimeZone());
            }
            schedulerDataspace.setLogger(logger);
        }
        catch (FabricNamingException exception) {
            Trace.logException(this, exception, true);
        }
        this.schemaMap.put(schedulerDataspace.getObjectName().name, schedulerDataspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSystemSchemas() {
        Session tempSession = null;
        try {
            tempSession = this.store.getSessionManager().newSysSession();
            TSpace schema = (TSpace)this.schemaMap.get("SYS");
            schema.init(tempSession);
            TSpace systemDataspace = (TSpace)this.schemaMap.get("SDS");
            systemDataspace.init(tempSession);
            TSpace schedulerDataspace = (TSpace)this.schemaMap.get("SCH");
            schedulerDataspace.init(tempSession);
            TSpace replicationDataspace = (TSpace)this.schemaMap.get("RDS");
            replicationDataspace.init(tempSession);
        }
        finally {
            if (tempSession != null) {
                tempSession.commit(false);
                tempSession.close();
                tempSession = null;
            }
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.store.txManager.getGlobalChangeTimestamp();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataspaceSchema createSchema(Session session, NameManager.ObjectName name, DataspaceType type, EventScope scope, Trace.Level logLevel, Grantee owner) {
        this.writeLock.lock();
        try {
            AbstractDataspace schema;
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            try {
                switch (type) {
                    case TSPACE: {
                        schema = new TSpace(name, scope, owner, this.store);
                        break;
                    }
                    case QSPACE: {
                        schema = new QSpace(name, scope, owner, this.store);
                        break;
                    }
                    case FSPACE: {
                        schema = new FSpace(name, scope, owner, this.store);
                        break;
                    }
                    case CSPACE: {
                        schema = new CSpace(name, scope, owner, this.store);
                        break;
                    }
                    default: {
                        throw new DataspaceException("Unsupported dataspace type.");
                    }
                }
            }
            catch (FabricNamingException exception) {
                throw new DataspaceException(exception.getMessage());
            }
            DataspaceLogger logger = this.store.getDefaultLogger();
            if (logger == null) {
                logger = new DataspaceLoggerImpl(String.valueOf((Object)type) + "." + name.name, logLevel, this.store.getTimeZone());
            }
            schema.setLogger(logger);
            this.schemaMap.add(name.name, schema);
            try {
                schema.getObjectName().setId(this.dataspaceIdAllocator.getNumber());
                schema.init(session);
            }
            catch (NumberAllocatorException error) {
                throw Error.error(458, "Unable to create dataspace component.");
            }
            AbstractDataspace abstractDataspace = schema;
            return abstractDataspace;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(Session session, String name, boolean cascade, boolean force) {
        this.writeLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(5501, name);
            }
            if (SqlInvariants.isLobsSchemaName(name)) {
                throw Error.error(5503, name);
            }
            OrderedHashSet externalReferencesToSchema = new OrderedHashSet();
            session.dataspaceStore.schemaManager.getCascadingReferencesToSchema(schema.getObjectName(), externalReferencesToSchema);
            if (externalReferencesToSchema.size() > 0) {
                if (cascade) {
                    this.getCascadingReferencesToSchema(schema.getObjectName(), externalReferencesToSchema);
                    this.removeSchemaObjects(externalReferencesToSchema);
                } else if (!force) {
                    throw new DataspaceException("Current dataspace's objects have references from other dataspaces. Specify FORCE flag to ignore these references.");
                }
            }
            com.streamscape.ds.lib.Iterator tableIterator = schema.schemaObjectIterator(3);
            while (tableIterator.hasNext()) {
                Table table = (Table)tableIterator.next();
                Constraint[] list = table.getFKConstraints();
                for (int i = 0; i < list.length; ++i) {
                    Constraint constraint = list[i];
                    if (constraint.getMain().getSchemaName() == schema.getObjectName()) continue;
                    constraint.getMain().removeConstraint(constraint.getMainName().name);
                    this.removeReferencesFrom(constraint);
                }
                if (table.getReplicationSource() != null) {
                    if (table.getReplicationSource().getReplicationQueue() != null) {
                        if (table.getReplicationSource().getReplicationQueue().getReplicationQueueStorage() != null) {
                            this.dropTableOrView(session, table.getReplicationSource().getReplicationQueue().getReplicationQueueStorage(), cascade, false);
                        }
                        table.getReplicationSource().getReplicationQueue().destroy();
                    }
                    table.getReplicationSource().destroy(session);
                }
                this.removeTable(session, table);
            }
            com.streamscape.ds.lib.Iterator iterator = schema.schemaObjectIterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof SchemaObject) {
                    this.removeReferencesFrom((SchemaObject)next);
                    this.removeReferencesTo(((SchemaObject)next).getObjectName());
                    continue;
                }
                if (!(next instanceof NameManager.ObjectName)) continue;
                this.removeReferencesFrom((NameManager.ObjectName)next);
                this.removeReferencesTo((NameManager.ObjectName)next);
            }
            com.streamscape.ds.lib.Iterator textIndexIterator = schema.schemaObjectIterator(38);
            while (textIndexIterator.hasNext()) {
                this.store.getFullTextManager().dropIndex((FullTextIndex)textIndexIterator.next());
            }
            com.streamscape.ds.lib.Iterator sequenceIterator = schema.schemaObjectIterator(8);
            while (sequenceIterator.hasNext()) {
                NumberSequence sequence = (NumberSequence)sequenceIterator.next();
                this.store.getGranteeManager().removeDbObject(sequence.getObjectName());
            }
            schema.clearStructures();
            this.schemaMap.remove(name);
            if (this.defaultSchemaHsqlName.name.equals(name)) {
                NameManager.ObjectName hsqlName = this.store.nameManager.newObjectName(name, false, 2);
                try {
                    schema = new TSpace(hsqlName, EventScope.OBSERVABLE, this.store.getGranteeManager().getAdminsGroup(), this.store);
                }
                catch (FabricNamingException exception) {
                    Trace.logException(this, exception, true);
                }
                this.defaultSchemaHsqlName = schema.getObjectName();
                this.schemaMap.put(schema.getObjectName().name, schema);
            }
            this.store.getUserManager().removeSchemaReference(name);
            this.store.getSessionManager().removeSchemaReference(schema);
            SyntaxStore.deleteSyntaxes(session, schema);
            if (!cascade) {
                for (int i = 0; i < externalReferencesToSchema.size(); ++i) {
                    NameManager.ObjectName referenceName = (NameManager.ObjectName)externalReferencesToSchema.get(i);
                    SchemaObject referenceObject = session.dataspaceStore.schemaManager.getSchemaObject(referenceName);
                    referenceObject.recompileObject(session);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        Result result = session.executeDirectStatement("delete from RDS.REPLICATION_SOURCES where DATASPACE_NAME = '" + name + "'");
        if (result.isError() && result.getException() != null) {
            Trace.logError(this, "Unable to clean up replication sources metadata. " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
        }
        if ((result = session.executeDirectStatement("delete from RDS.REPLICAS where DATASPACE_NAME = '" + name + "'")).isError() && result.getException() != null) {
            Trace.logError(this, "Unable to clean up replicas metadata. " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
        }
        if ((result = session.executeDirectStatement("delete from RDS.SOURCE_REPLICAS where SOURCE_DATASPACE_NAME = '" + name + "'")).isError() && result.getException() != null) {
            Trace.logError(this, "Unable to clean up source replicas metadata. " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchema(NameManager.ObjectName name, NameManager.ObjectName newName) {
        this.writeLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name.name);
            DataspaceSchema exists = (DataspaceSchema)this.schemaMap.get(newName.name);
            if (schema == null) {
                throw Error.error(5501, name.name);
            }
            if (exists != null) {
                throw Error.error(5504, newName.name);
            }
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            SqlInvariants.checkSchemaNameNotSystem(newName.name);
            int index = this.schemaMap.getIndex(name.name);
            schema.getObjectName().rename(newName);
            this.schemaMap.set(index, newName.name, schema);
            schema.onRename();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearStructures() {
        this.writeLock.lock();
        try {
            com.streamscape.ds.lib.Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                DataspaceSchema schema = (DataspaceSchema)it.next();
                schema.clearStructures();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        SyntaxStore.unload();
    }

    public String[] getSchemaNamesArray() {
        this.readLock.lock();
        try {
            Object[] array = new String[this.schemaMap.size()];
            this.schemaMap.toKeysArray(array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public DataspaceSchema[] getAllSchemas() {
        this.readLock.lock();
        try {
            Object[] objects = new DataspaceSchema[this.schemaMap.size()];
            this.schemaMap.toValuesArray(objects);
            Object[] objectArray = objects;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameManager.ObjectName getUserSchemaHsqlName(String name) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(4850, name);
            }
            if (schema.getObjectName() == SqlInvariants.SYS_SCHEMA_NAME) {
                throw Error.error(4850, name);
            }
            NameManager.ObjectName objectName = schema.getObjectName();
            return objectName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grantee toSchemaOwner(String name) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name);
            Grantee grantee = schema == null ? null : schema.getOwner();
            return grantee;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public NameManager.ObjectName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(NameManager.ObjectName name) {
        this.defaultSchemaHsqlName = name;
    }

    public boolean schemaExists(String name) {
        this.readLock.lock();
        try {
            boolean bl = this.schemaMap.containsKey(name);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameManager.ObjectName findSchemaHsqlName(String name) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name);
            if (schema == null) {
                NameManager.ObjectName objectName = null;
                return objectName;
            }
            NameManager.ObjectName objectName = schema.getObjectName();
            return objectName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public NameManager.ObjectName getSchemaHsqlName(String name) {
        return this.getSchemaHsqlName(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameManager.ObjectName getSchemaHsqlName(String name, DataspaceType type) {
        if (name == null) {
            return this.defaultSchemaHsqlName;
        }
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(4850, name);
            }
            if (type != null && schema.getDataspaceType() != type) {
                throw Error.error(4851, type.name());
            }
            NameManager.ObjectName objectName = schema.getObjectName();
            return objectName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getSchemaName(String name) {
        return this.getSchemaHsqlName((String)name).name;
    }

    public DataspaceSchema findSchema(String name) {
        this.readLock.lock();
        try {
            DataspaceSchema dataspaceSchema = (DataspaceSchema)this.schemaMap.get(name);
            return dataspaceSchema;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchemas(Session session, Grantee grantee, boolean cascade, boolean force) {
        this.writeLock.lock();
        try {
            HsqlArrayList list = this.getSchemas(grantee);
            com.streamscape.ds.lib.Iterator it = list.iterator();
            while (it.hasNext()) {
                DataspaceSchema schema = (DataspaceSchema)it.next();
                schema.close(session);
                schema.destroy(session);
                this.dropSchema(session, schema.getObjectName().name, cascade, force);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            HsqlArrayList list = new HsqlArrayList();
            com.streamscape.ds.lib.Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                DataspaceSchema schema = (DataspaceSchema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                list.add(schema);
            }
            HsqlArrayList hsqlArrayList = list;
            return hsqlArrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            com.streamscape.ds.lib.Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                DataspaceSchema schema = (DataspaceSchema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getAllTables(boolean withLobTables) {
        this.readLock.lock();
        try {
            HsqlArrayList alltables = new HsqlArrayList();
            String[] schemas = this.getSchemaNamesArray();
            for (int i = 0; i < schemas.length; ++i) {
                String name = schemas[i];
                if (!withLobTables && SqlInvariants.isLobsSchemaName(name) || SqlInvariants.isSystemSchemaName(name)) continue;
                HashMappedList current = this.getTables(name);
                alltables.addAll(current.values());
            }
            HsqlArrayList hsqlArrayList = alltables;
            return hsqlArrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMappedList getTables(String schema) {
        this.readLock.lock();
        try {
            DataspaceSchema temp = (DataspaceSchema)this.schemaMap.get(schema);
            HashMappedList hashMappedList = temp.tableList;
            return hashMappedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public NameManager.ObjectName[] getCatalogNameArray() {
        return this.catalogNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameManager.ObjectName[] getCatalogAndBaseTableNames() {
        this.readLock.lock();
        try {
            OrderedHashSet names = new OrderedHashSet();
            HsqlArrayList tables = this.getAllTables(false);
            for (int i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                if (table.isTemp()) continue;
                names.add(table.getObjectName());
            }
            names.add(this.store.getCatalogName());
            Object[] array = new NameManager.ObjectName[names.size()];
            names.toArray(array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameManager.ObjectName[] getCatalogAndBaseTableNames(NameManager.ObjectName name) {
        this.readLock.lock();
        if (name == null) {
            return this.catalogNameArray;
        }
        try {
            SchemaObject parentObject;
            switch (name.type) {
                case 2: {
                    if (this.findSchemaHsqlName(name.name) == null) {
                        NameManager.ObjectName[] objectNameArray = this.catalogNameArray;
                        return objectNameArray;
                    }
                    OrderedHashSet names = new OrderedHashSet();
                    names.add(this.store.getCatalogName());
                    HashMappedList list = this.getTables(name.name);
                    for (int i = 0; i < list.size(); ++i) {
                        names.add(((SchemaObject)list.get(i)).getObjectName());
                    }
                    Object[] array = new NameManager.ObjectName[names.size()];
                    names.toArray(array);
                    Object[] objectArray = array;
                    return objectArray;
                }
                case 12: {
                    NameManager.ObjectName[] names = this.catalogNameArray;
                    return names;
                }
                case 6: 
                case 21: {
                    this.findSchemaObject(name.name, name.schema.name, name.type);
                }
            }
            SchemaObject object = this.findSchemaObject(name.name, name.schema.name, name.type);
            if (object == null) {
                NameManager.ObjectName[] list = this.catalogNameArray;
                return list;
            }
            NameManager.ObjectName parent = object.getObjectName().parent;
            OrderedHashSet references = this.getReferencesTo(object.getObjectName());
            OrderedHashSet names = new OrderedHashSet();
            names.add(this.store.getCatalogName());
            if (parent != null && (parentObject = this.findSchemaObject(parent.name, parent.schema.name, parent.type)) != null && parentObject.getObjectName().type == 3) {
                names.add(parentObject.getObjectName());
            }
            if (object.getObjectName().type == 3) {
                names.add(object.getObjectName());
            }
            for (int i = 0; i < references.size(); ++i) {
                Table table;
                NameManager.ObjectName reference = (NameManager.ObjectName)references.get(i);
                if (reference.type != 3 || (table = this.findUserTable(null, reference.name, reference.schema.name)) == null || table.isTemp()) continue;
                names.add(reference);
            }
            Object[] array = new NameManager.ObjectName[names.size()];
            names.toArray(array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObjectSet getSchemaObjectSet(DataspaceSchema schema, int type) {
        this.readLock.lock();
        try {
            SchemaObjectSet set = null;
            switch (type) {
                case 8: {
                    set = schema.sequenceLookup;
                    break;
                }
                case 3: 
                case 5: {
                    set = schema.tableLookup;
                    break;
                }
                case 15: {
                    set = schema.charsetLookup;
                    break;
                }
                case 41: {
                    set = schema.facetsLookup;
                    break;
                }
                case 42: {
                    set = schema.aspectsLookup;
                    break;
                }
                case 43: {
                    set = schema.kNodesLookup;
                    break;
                }
                case 44: {
                    set = schema.kLinksLookup;
                    break;
                }
                case 45: {
                    set = schema.kGraphsLookup;
                    break;
                }
                case 46: {
                    set = schema.kGraphInstancesLookup;
                    break;
                }
                case 16: {
                    set = schema.collationLookup;
                    break;
                }
                case 18: {
                    set = schema.procedureLookup;
                    break;
                }
                case 17: {
                    set = schema.functionLookup;
                    break;
                }
                case 13: 
                case 14: {
                    set = schema.typeLookup;
                    break;
                }
                case 21: {
                    set = schema.indexLookup;
                    break;
                }
                case 38: {
                    set = schema.fullTextIndexLookup;
                    break;
                }
                case 6: {
                    set = schema.constraintLookup;
                    break;
                }
                case 9: {
                    set = schema.triggerLookup;
                    break;
                }
                case 25: {
                    set = schema.specificRoutineLookup;
                    break;
                }
                case 4: {
                    set = schema.collectionLookup;
                    break;
                }
                case 29: {
                    set = schema.replicaLookup;
                    break;
                }
                case 32: {
                    set = schema.actorLookup;
                    break;
                }
                case 37: {
                    set = schema.referenceLinkLookup;
                    break;
                }
                case 30: {
                    set = schema.timerLookup;
                    break;
                }
                case 31: {
                    set = schema.jobLookup;
                    break;
                }
                case 27: {
                    set = schema.serverLookup;
                }
            }
            SchemaObjectSet schemaObjectSet = set;
            return schemaObjectSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchemaObjectNotExists(NameManager.ObjectName name) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.checkAdd(name);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Table findTransientTable(Session session, String name) {
        Table table = this.findUserTable(session, name, "SDS");
        return table != null && table.getTableType() == 3 ? table : null;
    }

    public List<Collection> listTransientCollections() {
        DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get("SDS");
        com.streamscape.ds.lib.Iterator iterator = schema.schemaObjectIterator(4);
        ArrayList<Collection> collections = new ArrayList<Collection>();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            if (collection.getBaseTable().getTableType() != 3) continue;
            collections.add(collection);
        }
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(Session session, String name, String schema) {
        this.readLock.lock();
        try {
            Table table;
            Table t = null;
            Collection c = null;
            if ("MODULE".equals(schema)) {
                c = this.findSessionCollection(session, name);
                if (c == null) {
                    throw Error.error(5501, name);
                }
                Table table2 = c.getBaseTable();
                return table2;
            }
            if (schema == null) {
                c = this.findSessionCollection(session, name);
            }
            if (schema == null && c == null && t == null) {
                t = this.findTransientTable(session, name);
            }
            if (c == null && t == null) {
                schema = session.getSchemaName(schema);
                SchemaObject collection = this.findSchemaObjectInTransaction(session, name);
                if (collection instanceof Table) {
                    t = (Table)collection;
                } else if (collection instanceof Collection) {
                    t = ((Collection)collection).getBaseTable();
                }
            }
            if (c == null && t == null) {
                schema = session.getSchemaName(schema);
                t = this.findUserTable(session, name, schema);
            }
            if (c == null && t == null && "SYS".equals(schema) && this.store.dsInfo != null) {
                t = this.store.dsInfo.getSystemTable(session, name);
            }
            if (c != null) {
                table = c.getBaseTable();
                return table;
            }
            if (t == null) {
                throw Error.error(5501, name);
            }
            table = t;
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection getCollection(Session session, String name, String schema) {
        Collection c = null;
        c = this.findSessionCollection(session, name);
        if (c == null) {
            schema = session.getSchemaName(schema);
            c = this.findUserCollection(session, name, schema);
        }
        if (c == null) {
            throw Error.error(5501, name);
        }
        return c;
    }

    public Table getUserTable(Session session, NameManager.ObjectName name) {
        return this.getUserTable(session, name.name, name.schema.name);
    }

    public Table getUserTable(Session session, String name, String schema) {
        Table t = this.findUserTable(session, name, schema);
        if (t == null) {
            String longName = schema == null ? name : schema + "." + name;
            throw Error.error(5501, longName);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findUserTable(Session session, String name, String schemaName) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            if (schema == null) {
                Table table = null;
                return table;
            }
            int i = schema.tableList.getIndex(name);
            if (i == -1) {
                Table table = null;
                return table;
            }
            Table table = (Table)schema.tableList.get(i);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findUserCollection(Session session, String name, String schemaName) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            if (schema == null) {
                Collection collection = null;
                return collection;
            }
            SchemaObject temp = schema.collectionLookup.getObject(name);
            if (temp != null) {
                Collection collection = (Collection)temp;
                return collection;
            }
            Collection collection = null;
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection findSessionCollection(Session session, String name) {
        return session.sessionContext.findSessionCollection(name);
    }

    public SchemaObject findSchemaObjectInTransaction(Session session, String name) {
        return session.sessionContext.findSchemaObjectInTransaction(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableOrView(Session session, Table table, boolean cascade, boolean force) {
        this.writeLock.lock();
        try {
            if (table.isView()) {
                this.dropView(table, cascade);
            } else {
                this.dropTable(session, table, cascade, force);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void dropView(Table table, boolean cascade) {
        DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(table.getSchemaName().name);
        this.removeSchemaObject(table.getObjectName(), cascade ? DropScope.CASCADE : DropScope.NONE);
        schema.triggerLookup.removeParent(table.getObjectName());
    }

    private void dropTable(Session session, Table table, boolean cascade, boolean force) {
        DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(table.getSchemaName().name);
        int dropIndex = schema.tableList.getIndex(table.getObjectName().name);
        OrderedHashSet externalConstraints = table.getDependentExternalConstraints();
        OrderedHashSet externalReferences = new OrderedHashSet();
        this.getCascadingReferencesTo(table.getObjectName(), externalReferences);
        if (!cascade) {
            int i;
            for (i = 0; i < externalConstraints.size(); ++i) {
                Constraint c = (Constraint)externalConstraints.get(i);
                NameManager.ObjectName refname = c.getRefName();
                if (c.getConstraintType() != 1) continue;
                throw Error.error(5533, refname.getSchemaQualifiedStatementName());
            }
            if (!externalReferences.isEmpty() && !force) {
                for (i = 0; i < externalReferences.size(); ++i) {
                    NameManager.ObjectName name = (NameManager.ObjectName)externalReferences.get(i);
                    if (name.parent == table.getObjectName()) continue;
                    throw Error.error(5502, name.getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet tableSet = new OrderedHashSet();
        OrderedHashSet constraintNameSet = new OrderedHashSet();
        OrderedHashSet indexNameSet = new OrderedHashSet();
        for (int i = 0; i < externalConstraints.size(); ++i) {
            Constraint c = (Constraint)externalConstraints.get(i);
            Table t = c.getMain();
            if (t != table) {
                tableSet.add(t);
            }
            if ((t = c.getRef()) != table) {
                tableSet.add(t);
            }
            constraintNameSet.add(c.getMainName());
            constraintNameSet.add(c.getRefName());
            indexNameSet.add(c.getRefIndex().getObjectName());
        }
        OrderedHashSet uniqueConstraintNames = table.getUniquePKConstraintNames();
        TableWorks tw = new TableWorks(session, table);
        tableSet = tw.makeNewTables(tableSet, constraintNameSet, indexNameSet);
        tw.setNewTablesInSchema(tableSet);
        tw.updateConstraints(tableSet, constraintNameSet);
        if (cascade) {
            this.removeSchemaObjects(externalReferences);
        }
        this.removeTableDependentReferences(table);
        this.removeReferencesTo(uniqueConstraintNames);
        this.removeReferencesTo(table.getObjectName());
        this.removeReferencesFrom(table);
        if (dropIndex != -1) {
            schema.tableList.remove(dropIndex);
        }
        schema.indexLookup.removeParent(table.getObjectName());
        schema.constraintLookup.removeParent(table.getObjectName());
        schema.triggerLookup.removeParent(table.getObjectName());
        this.removeTable(session, table);
        this.recompileDependentObjects(tableSet);
        if (force) {
            this.recompileDependentObjectsWithNames(externalReferences, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropCollection(Session session, Collection collection, boolean cascade, boolean force) {
        collection.close();
        this.dropTableOrView(session, collection.getBaseTable(), cascade, force);
        collection.destroy(session);
        this.writeLock.lock();
        try {
            this.removeSchemaObject(collection.getObjectName());
        }
        finally {
            this.writeLock.unlock();
        }
        DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(collection.getObjectName().schema.name);
        schema.objectIdAllocator.releaseNumber(collection.getObjectName().getId());
    }

    public void dropReplicationTarget(Session session, ReplicationTarget target, boolean cascade) {
        this.removeSchemaObject(target.getObjectName());
        target.detachFromSourceAndDestroy(session);
    }

    private void removeTable(Session session, Table table) {
        this.removeTableDependentReferences(table);
        this.removeReferencesTo(table.getObjectName());
        this.removeReferencesFrom(table);
        this.store.getGranteeManager().removeDbObject(table.getObjectName());
        table.releaseTriggers();
        if (table.hasLobColumn()) {
            RowIterator it = table.rowIterator(session);
            while (it.hasNext()) {
                Row row = it.getNextRow();
                Object[] data = row.getData();
                session.sessionData.adjustLobUsageCount(table, data, -1, EnumSet.of(SessionData.LobType.LOB, SessionData.LobType.FLOB));
            }
        }
        this.store.persistentStoreCollection.releaseStore(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(int index, Table table) {
        this.writeLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(table.getSchemaName().name);
            schema.tableList.set(index, table.getObjectName().name, table);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableIndex(Table table) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(table.getSchemaName().name);
            if (schema == null) {
                int n = -1;
                return n;
            }
            NameManager.ObjectName name = table.getObjectName();
            int n = schema.tableList.getIndex(name.name);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(OrderedHashSet tableSet) {
        this.writeLock.lock();
        Session session = this.store.collectionSessionManager.newSysSession();
        try {
            int i;
            OrderedHashSet set = new OrderedHashSet();
            for (i = 0; i < tableSet.size(); ++i) {
                Table table = (Table)tableSet.get(i);
                set.addAll(this.getReferencesTo(table.getObjectName()));
            }
            for (i = 0; i < set.size(); ++i) {
                NameManager.ObjectName name = (NameManager.ObjectName)set.get(i);
                switch (name.type) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 25: {
                        SchemaObject object = this.getSchemaObject(name);
                        object.compile(session, null);
                    }
                }
            }
            if (Error.TRACE) {
                HsqlArrayList list = this.getAllTables(false);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Table t = (Table)list.get(i2);
                    t.verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            session.close();
            this.writeLock.unlock();
        }
    }

    public void recompileDependentObjects(Table table) {
        this.recompileDependentObjects(table, false);
    }

    public void recompileDependentObjects(Table table, boolean throwErrorIfFailed) {
        OrderedHashSet set = new OrderedHashSet();
        this.getCascadingReferencesTo(table.getObjectName(), set);
        this.recompileDependentObjectsWithNames(set, throwErrorIfFailed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjectsWithNames(OrderedHashSet namesSet, boolean throwErrorIfFailed) {
        this.writeLock.lock();
        Session session = this.store.collectionSessionManager.newSysSession();
        try {
            ArrayList<NameManager.ObjectName> failedObjectsToRecompile = new ArrayList<NameManager.ObjectName>();
            Exception lastRecompileError = null;
            block13: for (int i = 0; i < namesSet.size(); ++i) {
                NameManager.ObjectName name = (NameManager.ObjectName)namesSet.get(i);
                switch (name.type) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 25: 
                    case 32: {
                        SchemaObject object = this.getSchemaObject(name);
                        if (object instanceof RplScript && ((RplScript)object).routineSchema != null) {
                            try {
                                ((RplScript)object).routineSchema.recompileFunction(session);
                            }
                            catch (Exception error) {
                                failedObjectsToRecompile.add(name);
                                Trace.logError(this, "Recompilation of dependent object failed, name: {}", name.getSchemaQualifiedStatementName());
                                Trace.logException(this, error, true);
                                lastRecompileError = error;
                            }
                            continue block13;
                        }
                        if (object.getObjectName() != null && object.getObjectName().schema != null) {
                            session.setCurrentDataspaceName(object.getObjectName().schema);
                        }
                        try {
                            object.compile(session, null);
                            continue block13;
                        }
                        catch (Exception error) {
                            failedObjectsToRecompile.add(name);
                            Trace.logError(this, "Recompilation of dependent object failed, name: {}", name.getSchemaQualifiedStatementName());
                            Trace.logException(this, error, true);
                            lastRecompileError = error;
                            continue block13;
                        }
                        finally {
                            session.setCurrentDataspaceName(session.dataspaceStore.schemaManager.getDefaultSchemaHsqlName());
                        }
                    }
                }
            }
            if (failedObjectsToRecompile.size() > 0) {
                Trace.logError(this, "Recompilation of dependent objects failed: {}", failedObjectsToRecompile.stream().map(n -> n.getSchemaQualifiedStatementName()).collect(Collectors.joining(",")));
                if (throwErrorIfFailed) {
                    throw lastRecompileError instanceof RuntimeException ? (RuntimeException)lastRecompileError : new DataspaceException(lastRecompileError);
                }
            }
            if (Error.TRACE) {
                HsqlArrayList list = this.getAllTables(false);
                for (int i = 0; i < list.size(); ++i) {
                    Table t = (Table)list.get(i);
                    t.verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            session.close();
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberSequence getSequence(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            NumberSequence object;
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            if (schema != null && (object = (NumberSequence)schema.sequenceList.get(name)) != null) {
                NumberSequence numberSequence = object;
                return numberSequence;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            NumberSequence numberSequence = null;
            return numberSequence;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getUserDefinedType(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomainOrUDT(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Type getDomain(String name, String schemaName, boolean raise) {
        return this.getDomainOrDistinctType(name, schemaName, raise, 14);
    }

    public Type getType(String name, String schemaName, boolean raise) {
        return this.getDomainOrDistinctType(name, schemaName, raise, 13);
    }

    public Type getDomainOrDistinctType(String name, String schemaName, boolean raise) {
        Type type = this.getDomainOrDistinctType(name, schemaName, false, 14);
        if (type == null) {
            type = this.getDomainOrDistinctType(name, schemaName, raise, 13);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type getDomainOrDistinctType(String name, String schemaName, boolean raise, int type) {
        this.readLock.lock();
        try {
            SchemaObject object;
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null && (((Type)object).isDomainType() && type == 14 || ((Type)object).isDistinctType() && type == 13)) {
                Type type2 = (Type)object;
                return type2;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type3 = null;
            return type3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(String name, String schemaName, int type) {
        this.readLock.lock();
        try {
            SchemaObject object = this.findSchemaObject(name, schemaName, type);
            if (object == null) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(type), name);
            }
            SchemaObject schemaObject = object;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SchemaObject findSchemaObject(NameManager.ObjectName objectName) {
        return this.findSchemaObject(objectName.name, objectName.schema.name, objectName.type);
    }

    public SchemaObject findSchemaObject(String name, String schemaName, int type) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            SchemaObjectSet set = null;
            switch (type) {
                case 8: {
                    SchemaObject schemaObject = schema.sequenceLookup.getObject(name);
                    return schemaObject;
                }
                case 4: {
                    SchemaObject schemaObject = schema.collectionLookup.getObject(name);
                    return schemaObject;
                }
                case 29: {
                    SchemaObject schemaObject = schema.replicaLookup.getObject(name);
                    return schemaObject;
                }
                case 30: {
                    SchemaObject schemaObject = schema.timerLookup.getObject(name);
                    return schemaObject;
                }
                case 31: {
                    SchemaObject schemaObject = schema.jobLookup.getObject(name);
                    return schemaObject;
                }
                case 27: {
                    SchemaObject schemaObject = schema.serverLookup.getObject(name);
                    return schemaObject;
                }
                case 32: {
                    SchemaObject schemaObject = schema.actorLookup.getObject(name);
                    return schemaObject;
                }
                case 37: {
                    SchemaObject schemaObject = schema.referenceLinkLookup.getObject(name);
                    return schemaObject;
                }
                case 3: 
                case 5: {
                    SchemaObject schemaObject = schema.tableLookup.getObject(name);
                    return schemaObject;
                }
                case 15: {
                    if (name.equals("SQL_IDENTIFIER")) {
                        Charset charset = TypeInvariants.SQL_IDENTIFIER_CHARSET;
                        return charset;
                    }
                    if (name.equals("SQL_TEXT")) {
                        Charset charset = TypeInvariants.SQL_TEXT;
                        return charset;
                    }
                    if (name.equals("LATIN1")) {
                        Charset charset = TypeInvariants.LATIN1;
                        return charset;
                    }
                    if (name.equals("ASCII_GRAPHIC")) {
                        Charset charset = TypeInvariants.ASCII_GRAPHIC;
                        return charset;
                    }
                    SchemaObject schemaObject = schema.charsetLookup.getObject(name);
                    return schemaObject;
                }
                case 41: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).facetsLookup.getObject(name);
                    return schemaObject;
                }
                case 42: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).aspectsLookup.getObject(name);
                    return schemaObject;
                }
                case 43: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).kNodesLookup.getObject(name);
                    return schemaObject;
                }
                case 44: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).kLinksLookup.getObject(name);
                    return schemaObject;
                }
                case 45: {
                    SchemaObject schemaObject = schema.kGraphsLookup.getObject(name);
                    return schemaObject;
                }
                case 46: {
                    SchemaObject schemaObject = schema.kGraphInstancesLookup.getObject(name);
                    return schemaObject;
                }
                case 16: {
                    SchemaObject schemaObject = schema.collationLookup.getObject(name);
                    return schemaObject;
                }
                case 18: {
                    SchemaObject schemaObject = schema.procedureLookup.getObject(name);
                    return schemaObject;
                }
                case 17: {
                    SchemaObject schemaObject = schema.functionLookup.getObject(name);
                    return schemaObject;
                }
                case 19: {
                    SchemaObject object = schema.procedureLookup.getObject(name);
                    if (object == null) {
                        object = schema.functionLookup.getObject(name);
                    }
                    SchemaObject schemaObject = object;
                    return schemaObject;
                }
                case 25: {
                    SchemaObject schemaObject = schema.specificRoutineLookup.getObject(name);
                    return schemaObject;
                }
                case 13: 
                case 14: {
                    SchemaObject schemaObject = schema.typeLookup.getObject(name);
                    return schemaObject;
                }
                case 21: {
                    set = schema.indexLookup;
                    NameManager.ObjectName objectName = set.getName(name);
                    if (objectName == null) {
                        SchemaObject schemaObject = null;
                        return schemaObject;
                    }
                    Table table = (Table)schema.tableList.get(objectName.parent.name);
                    Index index = table.getIndex(name);
                    return index;
                }
                case 38: {
                    SchemaObject schemaObject = schema.fullTextIndexLookup.getObject(name);
                    return schemaObject;
                }
                case 6: {
                    set = schema.constraintLookup;
                    NameManager.ObjectName objectName = set.getName(name);
                    if (objectName == null) {
                        SchemaObject schemaObject = null;
                        return schemaObject;
                    }
                    Table table = (Table)schema.tableList.get(objectName.parent.name);
                    if (table == null) {
                        SchemaObject schemaObject = null;
                        return schemaObject;
                    }
                    Constraint constraint = table.getConstraint(name);
                    return constraint;
                }
                case 9: {
                    set = schema.triggerLookup;
                    NameManager.ObjectName objectName = set.getName(name);
                    if (objectName == null) {
                        SchemaObject schemaObject = null;
                        return schemaObject;
                    }
                    if (objectName.parent != null) {
                        Table table = (Table)schema.tableList.get(objectName.parent.name);
                        TriggerDef triggerDef = table.getTrigger(name);
                        return triggerDef;
                    }
                    SchemaObject schemaObject = schema.triggerLookup.getObject(name);
                    return schemaObject;
                }
            }
            throw Error.runtimeError(201, "SchemaManager");
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table findUserTableForIndex(Session session, String name, String schemaName) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            NameManager.ObjectName indexName = schema.indexLookup.getName(name);
            if (indexName == null) {
                Table table = null;
                return table;
            }
            Table table = this.findUserTable(session, indexName.parent.name, schemaName);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Session session, NameManager.ObjectName name) {
        this.writeLock.lock();
        try {
            Table t = this.getTable(session, name.parent.name, name.parent.schema.name);
            TableWorks tw = new TableWorks(session, t);
            tw.dropIndex(name.name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConstraint(Session session, NameManager.ObjectName name, boolean cascade) {
        this.writeLock.lock();
        try {
            Table t = this.getTable(session, name.parent.name, name.parent.schema.name);
            TableWorks tw = new TableWorks(session, t);
            tw.dropConstraint(name.name, cascade);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeDependentObjects(NameManager.ObjectName name) {
        this.writeLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name.schema.name);
            schema.indexLookup.removeParent(name);
            schema.constraintLookup.removeParent(name);
            schema.triggerLookup.removeParent(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExportedKeys(Table toDrop) {
        this.writeLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(toDrop.getSchemaName().name);
            for (int i = 0; i < schema.tableList.size(); ++i) {
                Table table = (Table)schema.tableList.get(i);
                Constraint[] constraints = table.getConstraints();
                for (int j = constraints.length - 1; j >= 0; --j) {
                    Table refTable = constraints[j].getRef();
                    if (toDrop != refTable) continue;
                    table.removeConstraint(j);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.streamscape.ds.lib.Iterator dataspaceObjectIterator(String schemaName, int type) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            com.streamscape.ds.lib.Iterator iterator = schema.schemaObjectIterator(type);
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.streamscape.ds.lib.Iterator dataspaceObjectIterator(String schemaName) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName);
            com.streamscape.ds.lib.Iterator iterator = schema.schemaObjectIterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.streamscape.ds.lib.Iterator databaseObjectIterator(int type) {
        this.readLock.lock();
        try {
            com.streamscape.ds.lib.Iterator it = this.schemaMap.values().iterator();
            WrapperIterator objects = new WrapperIterator();
            while (it.hasNext()) {
                Object[] values;
                int targetType = type;
                if (type == 19) {
                    targetType = 17;
                }
                DataspaceSchema temp = (DataspaceSchema)it.next();
                SchemaObjectSet set = temp.getObjectSet(targetType);
                if (set.map.size() != 0) {
                    values = new Object[set.map.size()];
                    set.map.valuesToArray(values);
                    objects = new WrapperIterator(objects, new WrapperIterator(values));
                }
                if (type != 19) continue;
                set = temp.getObjectSet(18);
                if (set.map.size() == 0) continue;
                values = new Object[set.map.size()];
                set.map.valuesToArray(values);
                objects = new WrapperIterator(objects, new WrapperIterator(values));
            }
            WrapperIterator wrapperIterator = objects;
            return wrapperIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addReferencesFrom(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        if (set == null) {
            return;
        }
        NameManager.ObjectName name = object instanceof RplScript && ((RplScript)object).getSpecificName() != null ? ((RplScript)object).getSpecificName() : object.getObjectName();
        for (int i = 0; i < set.size(); ++i) {
            this.referenceMap.put(set.get(i), name);
        }
    }

    private void removeReferencesTo(OrderedHashSet set) {
        for (int i = 0; i < set.size(); ++i) {
            this.referenceMap.remove(set.get(i));
        }
    }

    private void removeReferencesTo(NameManager.ObjectName referenced) {
        this.referenceMap.remove(referenced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalReferencesToSchema(NameManager.ObjectName schemaName) {
        this.writeLock.lock();
        try {
            com.streamscape.ds.lib.Iterator iterator = this.referenceMap.keySet().iterator();
            while (iterator.hasNext()) {
                NameManager.ObjectName keyName = (NameManager.ObjectName)iterator.next();
                if (keyName.schema != schemaName && keyName != schemaName) continue;
                com.streamscape.ds.lib.Iterator valueIterator = this.referenceMap.get(keyName);
                while (valueIterator.hasNext()) {
                    NameManager.ObjectName valueName = (NameManager.ObjectName)valueIterator.next();
                    if (valueName == schemaName || valueName.schema == schemaName) continue;
                    this.referenceMap.remove(keyName, valueName);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeReferencesFrom(NameManager.ObjectName objectName) {
        SchemaObject schemaObject = this.getSchemaObject(objectName);
        if (schemaObject != null) {
            this.removeReferencesFrom(schemaObject);
        }
    }

    private void removeReferencesFrom(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        if (set == null) {
            return;
        }
        NameManager.ObjectName name = object instanceof RplScript && ((RplScript)object).getSpecificName() != null ? ((RplScript)object).getSpecificName() : object.getObjectName();
        for (int i = 0; i < set.size(); ++i) {
            this.referenceMap.remove(set.get(i), name);
        }
    }

    public void removeReferenceFromTo(NameManager.ObjectName from, NameManager.ObjectName to) {
        this.writeLock.lock();
        try {
            this.referenceMap.remove(to, from);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addReferenceFromTo(NameManager.ObjectName from, NameManager.ObjectName to) {
        this.writeLock.lock();
        try {
            this.referenceMap.put(to, from);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeTableDependentReferences(Table table) {
        OrderedHashSet mainSet = table.getReferencesForDependents();
        if (mainSet == null) {
            return;
        }
        for (int i = 0; i < mainSet.size(); ++i) {
            NameManager.ObjectName name = (NameManager.ObjectName)mainSet.get(i);
            SchemaObject object = null;
            switch (name.type) {
                case 6: {
                    object = table.getConstraint(name.name);
                    break;
                }
                case 9: {
                    object = table.getTrigger(name.name);
                    break;
                }
                case 10: {
                    object = table.getColumn(table.getColumnIndex(name.name));
                }
            }
            this.removeReferencesFrom(object);
        }
    }

    public OrderedHashSet getReferencesTo(NameManager.ObjectName object) {
        OrderedHashSet set = new OrderedHashSet();
        this.getReferencesTo(object, set, true, true, object.schema);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getReferencesTo(NameManager.ObjectName object, OrderedHashSet set, boolean withLocal, boolean withExternal, NameManager.ObjectName schemaName) {
        this.readLock.lock();
        try {
            com.streamscape.ds.lib.Iterator it = this.referenceMap.get(object);
            while (it.hasNext()) {
                NameManager.ObjectName name = (NameManager.ObjectName)it.next();
                if (schemaName != null && !withLocal && name.schema == schemaName || schemaName != null && !withExternal && name.schema != schemaName) continue;
                set.add(name);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencesTo(NameManager.ObjectName table, NameManager.ObjectName column) {
        this.readLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            com.streamscape.ds.lib.Iterator it = this.referenceMap.get(table);
            while (it.hasNext()) {
                NameManager.ObjectName name = (NameManager.ObjectName)it.next();
                SchemaObject object = this.getSchemaObject(name);
                OrderedHashSet references = object.getReferences();
                if (!references.contains(column)) continue;
                set.add(name);
            }
            OrderedHashSet orderedHashSet = set;
            return orderedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void getCascadingReferencesTo(NameManager.ObjectName object, OrderedHashSet set) {
        this.getCascadingReferencesTo(object, set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencesTo(NameManager.ObjectName object, OrderedHashSet set, boolean withLocal) {
        this.readLock.lock();
        try {
            OrderedHashSet newSet = new OrderedHashSet();
            com.streamscape.ds.lib.Iterator it = this.referenceMap.get(object);
            while (it.hasNext()) {
                NameManager.ObjectName collectionName;
                NameManager.ObjectName name = (NameManager.ObjectName)it.next();
                if (name.schema == object.schema && !withLocal) continue;
                boolean added = set.add(name);
                if (added) {
                    newSet.add(name);
                }
                if (name.type != 3 && name.type != 5 || (collectionName = this.getSchemaObjectName(name.schema, name.name, 4, false)) == null || !(added = set.add(collectionName))) continue;
                newSet.add(collectionName);
            }
            for (int i = 0; i < newSet.size(); ++i) {
                this.getCascadingReferencesTo((NameManager.ObjectName)newSet.get(i), set);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencesToSchema(NameManager.ObjectName schema, OrderedHashSet set) {
        this.readLock.lock();
        try {
            com.streamscape.ds.lib.Iterator mainIterator = this.referenceMap.keySet().iterator();
            while (mainIterator.hasNext()) {
                NameManager.ObjectName name = (NameManager.ObjectName)mainIterator.next();
                if (name.schema == schema) {
                    this.getCascadingReferencesTo(name, set);
                    continue;
                }
                if (name != schema) continue;
                this.getCascadingReferencesTo(name, set);
            }
            for (int i = 0; i < set.size(); ++i) {
                NameManager.ObjectName name = (NameManager.ObjectName)set.get(i);
                if (name.schema != schema) continue;
                set.remove(i);
                --i;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencesToSchemaByReferenceLinks(NameManager.ObjectName schema, OrderedHashSet set, boolean withLocal, boolean withExternal) {
        this.readLock.lock();
        try {
            com.streamscape.ds.lib.Iterator iterator = this.databaseObjectIterator(37);
            while (iterator.hasNext()) {
                ReferenceLink link = (ReferenceLink)iterator.next();
                if (!Objects.equals(link.getTargetColumnSchemaName().name, schema.name) || (Objects.equals(link.getObjectName().schema.name, schema.name) || Objects.equals(link.getSourceColumnSchemaName().name, schema.name)) && !withLocal || !Objects.equals(link.getObjectName().schema.name, schema.name) && !Objects.equals(link.getSourceColumnSchemaName().name, schema.name) && !withExternal) continue;
                set.add(link.getObjectName());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencesToObjectByReferenceLinks(NameManager.ObjectName object, OrderedHashSet set, boolean withLocal, boolean withExternal) {
        this.readLock.lock();
        try {
            com.streamscape.ds.lib.Iterator iterator = this.databaseObjectIterator(37);
            while (iterator.hasNext()) {
                ReferenceLink link = (ReferenceLink)iterator.next();
                if (!Objects.equals(link.getTargetColumnObjectName().parent.name, object.name) || !Objects.equals(link.getTargetColumnObjectName().parent.schema.name, object.schema.name) || Objects.equals(link.getTargetColumnSchemaName().name, object.schema.name) && !withLocal || !Objects.equals(link.getTargetColumnSchemaName().name, object.schema.name) && !withExternal) continue;
                set.add(link.getObjectName());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> getCascadingReferencesToSchema(NameManager.ObjectName schema, boolean withLocal, boolean withExternal, int depth) {
        this.readLock.lock();
        try {
            LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>> next = new LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>>();
            com.streamscape.ds.lib.Iterator mainIterator = this.referenceMap.keySet().iterator();
            while (mainIterator.hasNext()) {
                NameManager.ObjectName name = (NameManager.ObjectName)mainIterator.next();
                if (name.schema != schema) continue;
                next.put(name, new ArrayList());
            }
            next.put(schema, null);
            LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> linkedHashMap = this.getCascadingReferencesToObjects(next, schema, withLocal, withExternal, depth);
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<NameManager.ObjectName, List<NameManager.ObjectName>> getCascadingReferencesToObject(NameManager.ObjectName objectName, boolean withLocal, boolean withExternal, int depth) {
        LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>> next = new LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>>();
        next.put(objectName, new ArrayList());
        next.put(objectName.schema, null);
        LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> references = this.getCascadingReferencesToObjects(next, objectName.schema, withLocal, withExternal, depth);
        return references.getOrDefault(objectName, new LinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> getCascadingReferencesToObjects(LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>> next, NameManager.ObjectName schema, boolean withLocal, boolean withExternal, int depth) {
        this.readLock.lock();
        try {
            HashSet<NameManager.ObjectName> handled = new HashSet<NameManager.ObjectName>();
            LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> result = new LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>>();
            if (depth == 0) {
                depth = 1;
            }
            int level = 0;
            while (next.size() > 0) {
                Map<NameManager.ObjectName, List<NameManager.ObjectName>> rootNodeMap;
                Iterator<Map.Entry<NameManager.ObjectName, List<NameManager.ObjectName>>> iterator = next.entrySet().iterator();
                Map.Entry<NameManager.ObjectName, List<NameManager.ObjectName>> entry = iterator.next();
                iterator.remove();
                if (entry.getValue() == null) {
                    if (next.size() == 0) continue;
                    next.put(schema, null);
                    if (--depth == 0) break;
                    ++level;
                    continue;
                }
                if (handled.contains(entry.getKey())) continue;
                OrderedHashSet set = new OrderedHashSet();
                this.getReferencesTo(entry.getKey(), set, withLocal, withExternal, level == 0 ? schema : null);
                this.getCascadingReferencesToObjectByReferenceLinks(entry.getKey(), set, withLocal, withExternal);
                handled.add(entry.getKey());
                if (set.size() <= 0) continue;
                NameManager.ObjectName rootNode = entry.getKey();
                if (entry.getValue().size() > 0) {
                    rootNode = entry.getValue().get(0);
                }
                if ((rootNodeMap = result.get(rootNode)) == null) {
                    rootNodeMap = new LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>>();
                    result.put(rootNode, rootNodeMap);
                }
                for (int i = 0; i < set.size(); ++i) {
                    NameManager.ObjectName nextNode = (NameManager.ObjectName)set.get(i);
                    if (rootNodeMap.containsKey(nextNode)) continue;
                    ArrayList<NameManager.ObjectName> newPath = new ArrayList<NameManager.ObjectName>((java.util.Collection)entry.getValue());
                    newPath.add(entry.getKey());
                    rootNodeMap.put(nextNode, new ArrayList(newPath));
                    next.put(nextNode, newPath);
                }
            }
            LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> getCascadingReferencesFromSchema(NameManager.ObjectName schema, boolean withLocal, boolean withExternal, int depth) {
        this.readLock.lock();
        try {
            LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> result = new LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>>();
            com.streamscape.ds.lib.Iterator iterator = this.dataspaceObjectIterator(schema.name);
            while (iterator.hasNext()) {
                Object object = iterator.next();
                SchemaObject schemaObject = object instanceof SchemaObject ? (SchemaObject)object : this.getSchemaObject((NameManager.ObjectName)object);
                Map<NameManager.ObjectName, List<NameManager.ObjectName>> references = this.getCascadingReferencesFromObject(schemaObject, withLocal, withExternal, depth, schema);
                if (references == null || references.size() <= 0) continue;
                result.put(schemaObject.getObjectName(), references);
            }
            LinkedHashMap<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NameManager.ObjectName, List<NameManager.ObjectName>> getCascadingReferencesFromObject(SchemaObject object, boolean withLocal, boolean withExternal, int depth, NameManager.ObjectName schemaName) {
        this.readLock.lock();
        try {
            LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>> result = new LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>>();
            this.getCascadingReferencesFromObject(object, withLocal, withExternal, depth, result, new ArrayList<NameManager.ObjectName>(), schemaName);
            LinkedHashMap<NameManager.ObjectName, List<NameManager.ObjectName>> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void getCascadingReferencesFromObject(SchemaObject object, boolean withLocal, boolean withExternal, int depth, Map<NameManager.ObjectName, List<NameManager.ObjectName>> result, List<NameManager.ObjectName> path, NameManager.ObjectName schemaName) {
        if (object == null) {
            return;
        }
        OrderedHashSet references = object.getReferences();
        for (int i = 0; i < references.size(); ++i) {
            NameManager.ObjectName referenceTo = (NameManager.ObjectName)references.get(i);
            if (result.containsKey(referenceTo) || referenceTo.schema == schemaName && !withLocal || referenceTo.schema != schemaName && !withExternal) continue;
            result.put(referenceTo, path);
            if (depth <= 0) continue;
            ArrayList<NameManager.ObjectName> newPath = new ArrayList<NameManager.ObjectName>(path);
            newPath.add(referenceTo);
            this.getCascadingReferencesFromObject(this.getSchemaObject(referenceTo), withLocal, withExternal, depth - 1, result, newPath, schemaName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameManager.ObjectName getSchemaObjectName(NameManager.ObjectName schemaName, String name, int type, boolean raise) {
        this.readLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(schemaName.name);
            SchemaObjectSet set = null;
            if (schema == null) {
                if (raise) {
                    throw Error.error(SchemaObjectSet.getGetErrorCode(type));
                }
                NameManager.ObjectName objectName = null;
                return objectName;
            }
            if (type == 19) {
                set = schema.functionLookup;
                SchemaObject object = schema.functionLookup.getObject(name);
                if (object == null) {
                    set = schema.procedureLookup;
                    object = schema.procedureLookup.getObject(name);
                }
            } else {
                set = this.getSchemaObjectSet(schema, type);
            }
            if (raise) {
                set.checkExists(name);
            }
            NameManager.ObjectName objectName = set.getName(name);
            return objectName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(NameManager.ObjectName name) {
        this.readLock.lock();
        try {
            if (name.schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name.schema.name);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            switch (name.type) {
                case 8: {
                    SchemaObject schemaObject = (SchemaObject)schema.sequenceList.get(name.name);
                    return schemaObject;
                }
                case 3: 
                case 5: {
                    SchemaObject schemaObject = (SchemaObject)schema.tableList.get(name.name);
                    return schemaObject;
                }
                case 4: {
                    SchemaObject schemaObject = schema.collectionLookup.getObject(name.name);
                    return schemaObject;
                }
                case 29: {
                    SchemaObject schemaObject = schema.replicaLookup.getObject(name.name);
                    return schemaObject;
                }
                case 32: {
                    SchemaObject schemaObject = schema.actorLookup.getObject(name.name);
                    return schemaObject;
                }
                case 37: {
                    SchemaObject schemaObject = schema.referenceLinkLookup.getObject(name.name);
                    return schemaObject;
                }
                case 30: {
                    SchemaObject schemaObject = schema.timerLookup.getObject(name.name);
                    return schemaObject;
                }
                case 31: {
                    SchemaObject schemaObject = schema.jobLookup.getObject(name.name);
                    return schemaObject;
                }
                case 27: {
                    SchemaObject schemaObject = schema.serverLookup.getObject(name.name);
                    return schemaObject;
                }
                case 15: {
                    SchemaObject schemaObject = schema.charsetLookup.getObject(name.name);
                    return schemaObject;
                }
                case 41: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).facetsLookup.getObject(name.name);
                    return schemaObject;
                }
                case 42: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).aspectsLookup.getObject(name.name);
                    return schemaObject;
                }
                case 43: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).kNodesLookup.getObject(name.name);
                    return schemaObject;
                }
                case 44: {
                    SchemaObject schemaObject = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).kLinksLookup.getObject(name.name);
                    return schemaObject;
                }
                case 45: {
                    SchemaObject schemaObject = schema.kGraphsLookup.getObject(name.name);
                    return schemaObject;
                }
                case 46: {
                    SchemaObject schemaObject = schema.kGraphInstancesLookup.getObject(name.name);
                    return schemaObject;
                }
                case 16: {
                    SchemaObject schemaObject = schema.collationLookup.getObject(name.name);
                    return schemaObject;
                }
                case 18: {
                    SchemaObject schemaObject = schema.procedureLookup.getObject(name.name);
                    return schemaObject;
                }
                case 17: {
                    SchemaObject schemaObject = schema.functionLookup.getObject(name.name);
                    return schemaObject;
                }
                case 25: {
                    SchemaObject schemaObject = schema.specificRoutineLookup.getObject(name.name);
                    return schemaObject;
                }
                case 19: {
                    SchemaObject object = schema.functionLookup.getObject(name.name);
                    if (object == null) {
                        object = schema.procedureLookup.getObject(name.name);
                    }
                    SchemaObject schemaObject = object;
                    return schemaObject;
                }
                case 13: 
                case 14: {
                    SchemaObject schemaObject = schema.typeLookup.getObject(name.name);
                    return schemaObject;
                }
                case 9: {
                    name = schema.triggerLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject schemaObject = null;
                        return schemaObject;
                    }
                    NameManager.ObjectName tableName = name.parent;
                    if (tableName != null) {
                        Table table = (Table)schema.tableList.get(tableName.name);
                        TriggerDef triggerDef = table.getTrigger(name.name);
                        return triggerDef;
                    }
                    SchemaObject table = schema.triggerLookup.getObject(name.name);
                    return table;
                }
                case 6: {
                    name = schema.constraintLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject tableName = null;
                        return tableName;
                    }
                    NameManager.ObjectName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    if (table != null) {
                        Constraint constraint = table.getConstraint(name.name);
                        return constraint;
                    }
                    SchemaObject schemaObject = null;
                    return schemaObject;
                }
                case 7: {
                    SchemaObject tableName = null;
                    return tableName;
                }
                case 21: {
                    name = schema.indexLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject tableName = null;
                        return tableName;
                    }
                    NameManager.ObjectName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    Index index = table.getIndex(name.name);
                    return index;
                }
                case 38: {
                    SchemaObject schemaObject = schema.fullTextIndexLookup.getObject(name.name);
                    return schemaObject;
                }
            }
            SchemaObject schemaObject = null;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void checkColumnIsReferenced(NameManager.ObjectName tableName, NameManager.ObjectName name) {
        OrderedHashSet set = this.getReferencesTo(tableName, name);
        if (!set.isEmpty()) {
            NameManager.ObjectName objectName = (NameManager.ObjectName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
    }

    public void checkObjectIsReferenced(NameManager.ObjectName name) {
        OrderedHashSet set = this.getReferencesTo(name);
        NameManager.ObjectName refName = null;
        for (int i = 0; i < set.size(); ++i) {
            refName = (NameManager.ObjectName)set.get(i);
            if (refName.parent != name && (refName.type != 9 || !refName.parent.name.equals(name.name))) break;
            refName = null;
        }
        if (refName == null) {
            return;
        }
        int errorCode = 5502;
        if (refName.type == 0) {
            errorCode = 5533;
        }
        throw Error.error(errorCode, refName.getSchemaQualifiedStatementName());
    }

    public void checkSchemaNameCanChange(NameManager.ObjectName name) {
        this.readLock.lock();
        try {
            com.streamscape.ds.lib.Iterator it = this.referenceMap.values().iterator();
            NameManager.ObjectName refName = null;
            block7: while (it.hasNext()) {
                refName = (NameManager.ObjectName)it.next();
                switch (refName.type) {
                    case 5: 
                    case 9: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 25: 
                    case 32: {
                        if (refName.schema == name) break block7;
                    }
                    default: {
                        refName = null;
                        continue block7;
                    }
                }
            }
            if (refName == null) {
                return;
            }
            throw Error.error(5502, refName.getSchemaQualifiedStatementName());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemaObject(SchemaObject object) {
        this.writeLock.lock();
        try {
            NameManager.ObjectName name = object.getObjectName();
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            try {
                int id = schema.objectIdAllocator.getNumber();
                name.setId(id);
            }
            catch (NumberAllocatorException error) {
                throw new DataspaceException(error.getMessage());
            }
            switch (name.type) {
                case 17: 
                case 18: {
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    if (routine == null) {
                        routine = new RoutineSchema(name.type, name);
                        routine.addSpecificRoutine(this.store, (RplScript)object);
                        set.checkAdd(name);
                        SchemaObjectSet specificSet = this.getSchemaObjectSet(schema, 25);
                        specificSet.checkAdd(((RplScript)object).getSpecificName());
                        set.add(routine);
                        specificSet.add(object);
                    } else {
                        SchemaObjectSet specificSet = this.getSchemaObjectSet(schema, 25);
                        NameManager.ObjectName specificName = ((RplScript)object).getSpecificName();
                        if (specificName != null) {
                            specificSet.checkAdd(specificName);
                        }
                        routine.addSpecificRoutine(this.store, (RplScript)object);
                        specificSet.add(object);
                    }
                    this.addReferencesFrom(object);
                    return;
                }
                case 3: {
                    OrderedHashSet refs = ((Table)object).getReferencesForDependents();
                    block16: for (int i = 0; i < refs.size(); ++i) {
                        NameManager.ObjectName ref = (NameManager.ObjectName)refs.get(i);
                        switch (ref.type) {
                            case 10: {
                                int index = ((Table)object).findColumn(ref.name);
                                ColumnSchema column = ((Table)object).getColumn(index);
                                this.addSchemaObject(column);
                                continue block16;
                            }
                        }
                    }
                    break;
                }
                case 10: {
                    if (!object.getReferences().isEmpty()) break;
                    return;
                }
                case 4: {
                    this.addSchemaObject(((Collection)object).getBaseTable());
                    int extraId = ((Collection)object).getObjectName().getId();
                    ((Collection)object).getObjectName().setId(((Collection)object).getBaseTable().getObjectName().getId());
                    schema.objectIdAllocator.releaseNumber(extraId);
                }
            }
            if (set != null) {
                set.add(object);
            }
            this.addReferencesFrom(object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceVTable(Session session, VirtualTableCollection object) {
        this.writeLock.lock();
        try {
            int realId = object.getBaseTable().getObjectName().getId();
            this.dropTableOrView(session, object.getBaseTable(), true, false);
            this.addSchemaObject(object.getBaseTable());
            int extraId = object.getBaseTable().getObjectName().getId();
            object.getBaseTable().getObjectName().setId(realId);
            object.getObjectName().setId(realId);
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(object.getObjectName().schema.name);
            schema.objectIdAllocator.releaseNumber(extraId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void releaseObjectId(SchemaObject object) {
        this.writeLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(object.getObjectName().schema.name);
            schema.objectIdAllocator.releaseNumber(object.getObjectName().getId());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(NameManager.ObjectName name, DropScope dropScope) {
        this.writeLock.lock();
        try {
            OrderedHashSet objectSet = new OrderedHashSet();
            switch (name.type) {
                case 17: 
                case 18: 
                case 19: {
                    RoutineSchema routine = (RoutineSchema)this.getSchemaObject(name);
                    if (routine == null) break;
                    RplScript[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.getCascadingReferencesTo(specifics[i].getSpecificName(), objectSet);
                    }
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 13: 
                case 15: 
                case 16: 
                case 25: {
                    this.getCascadingReferencesTo(name, objectSet);
                    break;
                }
                case 14: {
                    objectSet = this.getReferencesTo(name);
                }
            }
            if (objectSet.isEmpty()) {
                this.removeSchemaObject(name);
                return;
            }
            if (dropScope == DropScope.NONE) {
                NameManager.ObjectName objectName = (NameManager.ObjectName)objectSet.get(0);
                throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
            }
            if (dropScope == DropScope.CASCADE) {
                objectSet.add(name);
                this.removeSchemaObjects(objectSet);
            } else if (dropScope == DropScope.FORCE) {
                this.removeSchemaObject(name);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObjects(OrderedHashSet set) {
        this.writeLock.lock();
        try {
            for (int i = 0; i < set.size(); ++i) {
                NameManager.ObjectName name = (NameManager.ObjectName)set.get(i);
                this.removeSchemaObject(name);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(NameManager.ObjectName name) {
        this.writeLock.lock();
        try {
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name.schema.name);
            if (schema == null) {
                Trace.logError(this, "WARNING: Trying to remove object {} of non existent schema.", name.getSchemaQualifiedStatementName());
                return;
            }
            SchemaObject object = null;
            SchemaObjectSet set = null;
            switch (name.type) {
                case 8: {
                    set = schema.sequenceLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 3: 
                case 5: {
                    set = schema.tableLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 4: {
                    set = schema.collectionLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 30: {
                    set = schema.timerLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 31: {
                    set = schema.jobLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 32: {
                    set = schema.actorLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 37: {
                    set = schema.referenceLinkLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 27: {
                    set = schema.serverLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 10: {
                    Table table = (Table)this.getSchemaObject(name.parent);
                    if (table == null) break;
                    object = table.getColumn(table.getColumnIndex(name.name));
                    break;
                }
                case 15: {
                    set = schema.charsetLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 41: {
                    set = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).facetsLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 43: {
                    set = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).kNodesLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 44: {
                    set = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).kLinksLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 45: {
                    set = schema.kGraphsLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 46: {
                    set = schema.kGraphInstancesLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 42: {
                    set = ((DataspaceSchema)this.schemaMap.get((Object)"SDS")).aspectsLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 16: {
                    set = schema.collationLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 18: {
                    set = schema.procedureLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    RplScript[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 17: {
                    set = schema.functionLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    RplScript[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 25: {
                    set = schema.specificRoutineLookup;
                    RplScript routine = (RplScript)set.getObject(name.name);
                    object = routine;
                    if (routine == null) break;
                    routine.routineSchema.removeSpecificRoutine(routine);
                    if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                    this.removeSchemaObject(routine.getObjectName());
                    break;
                }
                case 13: 
                case 14: {
                    set = schema.typeLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 21: {
                    set = schema.indexLookup;
                    break;
                }
                case 38: {
                    set = schema.fullTextIndexLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 29: {
                    set = schema.replicaLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 6: {
                    set = schema.constraintLookup;
                    if (name.parent.type == 3) {
                        Table table = (Table)schema.tableList.get(name.parent.name);
                        object = table.getConstraint(name.name);
                        table.removeConstraint(name.name);
                        break;
                    }
                    if (name.parent.type != 14) break;
                    Type type = (Type)schema.typeLookup.getObject(name.parent.name);
                    object = type.userTypeModifier.getConstraint(name.name);
                    OrderedHashSet references = type.getReferences();
                    type.userTypeModifier.removeConstraint(name.name);
                    OrderedHashSet updatedReferences = type.getReferences();
                    if (references == null) break;
                    for (int i = 0; i < references.size(); ++i) {
                        if (updatedReferences.contains(references.get(i))) continue;
                        this.referenceMap.remove(references.get(i), type.getObjectName());
                    }
                    break;
                }
                case 9: {
                    set = schema.triggerLookup;
                    if (name.parent != null) {
                        Table table = (Table)schema.tableList.get(name.parent.name);
                        object = table.getTrigger(name.name);
                        if (object != null) {
                            table.removeTrigger((TriggerDef)object);
                        }
                    } else {
                        object = schema.triggerLookup.getObject(name.name);
                    }
                    if (object == null) break;
                    if (object instanceof ReplicationEventTrigger) {
                        ReplicationEventTrigger repTrigger = (ReplicationEventTrigger)object;
                        repTrigger.getReplicationEntity().removeTrigger(repTrigger);
                        repTrigger.destroy();
                        break;
                    }
                    if (object instanceof ReplicationValidateTrigger) {
                        ReplicationValidateTrigger validationTrigger = (ReplicationValidateTrigger)object;
                        validationTrigger.getReplicationTarget().removeValidationTrigger(validationTrigger);
                        validationTrigger.destroy();
                        break;
                    }
                    if (object instanceof ReplicationModifyTrigger) {
                        ReplicationModifyTrigger replicationModifyTrigger = (ReplicationModifyTrigger)object;
                        replicationModifyTrigger.getReplicationTarget().removeReplicationModifyTrigger();
                        replicationModifyTrigger.destroy();
                        if (replicationModifyTrigger.getReplicationTarget() == null) break;
                        replicationModifyTrigger.getReplicationTarget().enqueueReattachAction();
                        break;
                    }
                    if (!(object instanceof EventTriggerDefSQL)) break;
                    ((EventTriggerDefSQL)object).destroy();
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "SchemaManager");
                }
            }
            if (object != null) {
                this.store.getGranteeManager().removeDbObject(name);
                this.removeReferencesFrom(object);
            }
            if (set != null) {
                set.remove(name.name);
            }
            this.removeReferencesTo(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchemaObject(NameManager.ObjectName name, NameManager.ObjectName newName) {
        this.writeLock.lock();
        try {
            if (name.schema != newName.schema) {
                throw Error.error(5505, newName.schema.name);
            }
            this.checkObjectIsReferenced(name);
            DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.rename(name, newName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void replaceReferences(SchemaObject oldObject, SchemaObject newObject) {
        this.writeLock.lock();
        try {
            if (oldObject != null) {
                this.removeReferencesFrom(oldObject);
            }
            if (newObject != null) {
                this.addReferencesFrom(newObject);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSQLArray(List<String> list) {
        this.readLock.lock();
        try {
            DataspaceSchema schema;
            DataspaceStore.DDLRecordNode node;
            SchemaObject object;
            OrderedHashSet newResolved;
            com.streamscape.ds.lib.Iterator it;
            DataspaceSchema schema2;
            OrderedHashSet resolved = new OrderedHashSet();
            OrderedHashSet unresolved = new OrderedHashSet();
            com.streamscape.ds.lib.Iterator schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema2 = (DataspaceSchema)schemas.next();
                if (SqlInvariants.isSystemSchemaName(schema2.getObjectName().name) || SqlInvariants.isLobsSchemaName(schema2.getObjectName().name) || "SDS".equals(schema2.getObjectName().name) || "SCH".equals(schema2.getObjectName().name) || "RDS".equals(schema2.getObjectName().name)) continue;
                list.add(schema2.getSQL());
                DataspaceStore.DDLRecordNode node2 = new DataspaceStore.DDLRecordNode();
                node2.objectName = schema2.getObjectName().getSchemaQualifiedStatementName();
                node2.dataspaceId = schema2.getObjectName().getId();
                node2.objectId = -1;
                node2.type = LogRecordType.CREATE;
                this.store.logIndexBuilder.put(list.size() - 1, node2);
                schema2.addSimpleObjects(unresolved);
            }
            while ((it = unresolved.iterator()).hasNext()) {
                newResolved = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, newResolved, this.store, false);
                unresolved.removeAll(newResolved);
                if (newResolved.size() != 0) continue;
                break;
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema2 = (DataspaceSchema)schemas.next();
                if (SqlInvariants.isLobsSchemaName(schema2.getObjectName().name) || SqlInvariants.isSystemSchemaName(schema2.getObjectName().name)) continue;
                schema2.getSQLArray(list, resolved, unresolved, this.store);
            }
            while ((it = unresolved.iterator()).hasNext()) {
                newResolved = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, newResolved, this.store, false);
                unresolved.removeAll(newResolved);
                if (newResolved.size() != 0) continue;
                break;
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (!(object instanceof RplScript)) continue;
                DataspaceSchema.addSetSchemaSQLAndIndex(list, object.getSchemaName(), this.store);
                list.add(((RplScript)object).getSQLDeclaration());
                node = new DataspaceStore.DDLRecordNode();
                node.objectName = object.getObjectName().getSchemaQualifiedStatementName();
                node.dataspaceId = object.getObjectName().schema.getId();
                node.objectId = object.getObjectName().getId();
                node.type = LogRecordType.CREATE;
                this.store.logIndexBuilder.put(list.size() - 1, node);
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                DataspaceSchema.addSetSchemaSQLAndIndex(list, object.getSchemaName(), this.store);
                if (object instanceof RplScript) {
                    list.add(((RplScript)object).getSQLAlter());
                    node = new DataspaceStore.DDLRecordNode();
                    node.objectName = object.getObjectName().getSchemaQualifiedStatementName();
                    node.dataspaceId = object.getObjectName().schema.getId();
                    node.objectId = object.getObjectName().getId();
                    node.type = LogRecordType.CREATE;
                    this.store.logIndexBuilder.put(list.size() - 1, node);
                    continue;
                }
                if (object instanceof Collection) {
                    String[] temp = ((Collection)object).getSQL(resolved, unresolved);
                    if (!this.store.generateLogIndex || temp.length <= 0) continue;
                    list.add(temp[0]);
                    DataspaceStore.DDLRecordNode node3 = new DataspaceStore.DDLRecordNode();
                    node3.objectName = ((Collection)object).getObjectName().getSchemaQualifiedStatementName();
                    node3.dataspaceId = ((Collection)object).getObjectName().schema.getId();
                    node3.objectId = ((Collection)object).getObjectName().getId();
                    node3.type = LogRecordType.CREATE;
                    this.store.logIndexBuilder.put(list.size() - 1, node3);
                    for (int i = 1; i < temp.length; ++i) {
                        list.add(temp[i]);
                        node3 = new DataspaceStore.DDLRecordNode();
                        node3.objectName = ((Collection)object).getObjectName().getSchemaQualifiedStatementName();
                        node3.dataspaceId = ((Collection)object).getObjectName().schema.getId();
                        node3.objectId = ((Collection)object).getObjectName().getId();
                        node3.type = LogRecordType.OTHER;
                        this.store.logIndexBuilder.put(list.size() - 1, node3);
                    }
                    continue;
                }
                list.add(object.getSQL());
                node = new DataspaceStore.DDLRecordNode();
                node.objectName = object.getObjectName().getSchemaQualifiedStatementName();
                node.dataspaceId = object.getObjectName().schema.getId();
                node.objectId = object.getObjectName().getId();
                node.type = LogRecordType.CREATE;
                this.store.logIndexBuilder.put(list.size() - 1, node);
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema = (DataspaceSchema)schemas.next();
                if (SqlInvariants.isLobsSchemaName(schema.getObjectName().name) || SqlInvariants.isSystemSchemaName(schema.getObjectName().name)) continue;
                DataspaceSchema.addSetSchemaSQLAndIndex(list, schema.getObjectName(), this.store);
                schema.addTriggerSQL(list, this.store);
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema = (DataspaceSchema)schemas.next();
                schema.getSequenceRestartSQL(list, this.store);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTablePropsSQL(boolean withHeader, int loggedStatements) {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(false);
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < tableList.size(); ++i) {
                Object ddl;
                Table t = (Table)tableList.get(i);
                if (t.isText() && !t.getObjectName().name.equals("RECOVERY_LOG")) {
                    ddl = t.getSQLForTextSource(withHeader);
                    list.addAll((Object[])ddl);
                    for (int j = 0; j < ((Object[])ddl).length; ++j) {
                        node = new DataspaceStore.DDLRecordNode();
                        node.objectName = t.getObjectName().getSchemaQualifiedStatementName();
                        node.dataspaceId = t.getObjectName().schema.getId();
                        node.objectId = t.getObjectName().getId();
                        node.type = LogRecordType.OTHER;
                        if (ddl[j] != null && ((String)ddl[j]).trim().toUpperCase().startsWith("LINK")) {
                            node.type = LogRecordType.LINK;
                        }
                        this.store.logIndexBuilder.put(loggedStatements + list.size() - ((Object[])ddl).length + j, node);
                    }
                } else if (t instanceof LogFileTable) {
                    ddl = ((LogFileTable)t).getParent().getSQLForLogDDL();
                    list.addAll((Object[])ddl);
                    for (int j = 0; j < ((Object[])ddl).length; ++j) {
                        node = new DataspaceStore.DDLRecordNode();
                        node.objectName = t.getObjectName().getSchemaQualifiedStatementName();
                        node.dataspaceId = t.getObjectName().schema.getId();
                        node.objectId = t.getObjectName().getId();
                        node.type = LogRecordType.OTHER;
                        if (ddl[j] != null && ((String)ddl[j]).trim().toUpperCase().startsWith("START")) {
                            node.type = LogRecordType.LINK;
                        }
                        this.store.logIndexBuilder.put(loggedStatements + list.size() - ((Object[])ddl).length + j, node);
                    }
                } else {
                    ddl = t.getSQLForReadOnly();
                    if (ddl != null) {
                        list.add(ddl);
                        DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
                        node.objectName = t.getObjectName().getSchemaQualifiedStatementName();
                        node.dataspaceId = t.getObjectName().schema.getId();
                        node.objectId = t.getObjectName().getId();
                        node.type = LogRecordType.OTHER;
                        this.store.logIndexBuilder.put(loggedStatements + list.size() - 1, node);
                    }
                }
                if (!t.isCached() || (ddl = t.getSQLForClustered()) == null) continue;
                list.add(ddl);
                DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
                node.objectName = t.getObjectName().getSchemaQualifiedStatementName();
                node.dataspaceId = t.getObjectName().schema.getId();
                node.objectId = t.getObjectName().getId();
                node.type = LogRecordType.OTHER;
                this.store.logIndexBuilder.put(loggedStatements + list.size() - 1, node);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexRootsSQL(int loggedStatements) {
        this.readLock.lock();
        try {
            long[][] rootsArray = this.getIndexRoots();
            HsqlArrayList tableList = this.getAllTables(true);
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < rootsArray.length; ++i) {
                Table t = (Table)tableList.get(i);
                if (rootsArray[i] == null || rootsArray[i].length <= 0 || rootsArray[i][0] == -1L) continue;
                String ddl = t.getIndexRootsSQL(rootsArray[i]);
                list.add(ddl);
                DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
                node.objectName = t.getObjectName().getSchemaQualifiedStatementName();
                node.dataspaceId = t.getObjectName().schema.getId();
                node.objectId = t.getObjectName().getId();
                node.type = LogRecordType.OTHER;
                this.store.logIndexBuilder.put(loggedStatements + list.size() - 1, node);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCommentsArray() {
        this.readLock.lock();
        try {
            HsqlArrayList list = new HsqlArrayList();
            StringBuffer sb = new StringBuffer();
            com.streamscape.ds.lib.Iterator collectionIt = this.databaseObjectIterator(4);
            while (collectionIt.hasNext()) {
                Collection collection = (Collection)collectionIt.next();
                Table table = collection.getBaseTable();
                if (table.getTableType() == 1) continue;
                list.addAll(table.getCommentsSQL());
            }
            com.streamscape.ds.lib.Iterator routineIt = this.databaseObjectIterator(19);
            com.streamscape.ds.lib.Iterator actorIt = this.databaseObjectIterator(32);
            WrapperIterator wholeIt = new WrapperIterator(routineIt, actorIt);
            while (wholeIt.hasNext()) {
                SchemaObject object = (SchemaObject)wholeIt.next();
                if (object.getObjectName().comment == null) continue;
                sb.setLength(0);
                sb.append("COMMENT").append(' ').append("ON");
                sb.append(' ').append("RPL").append(' ');
                sb.append(object.getObjectName().getSchemaQualifiedStatementName());
                sb.append(' ').append("IS").append(' ');
                sb.append(StringConverter.toQuotedString(object.getObjectName().comment, '\'', true));
                list.add(sb.toString());
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setTempIndexRoots(long[][] roots) {
        this.tempIndexRoots = roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[][] getIndexRoots() {
        this.readLock.lock();
        try {
            if (this.tempIndexRoots != null) {
                long[][] roots = this.tempIndexRoots;
                this.tempIndexRoots = null;
                long[][] lArray = roots;
                return lArray;
            }
            HsqlArrayList allTables = this.getAllTables(true);
            HsqlArrayList list = new HsqlArrayList();
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 6) {
                    long[] roots = t.getIndexRootsArray();
                    list.add(roots);
                    continue;
                }
                list.add(null);
            }
            long[][] array = new long[list.size()][];
            list.toArray(array);
            long[][] lArrayArray = array;
            return lArrayArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexRoots(long[][] roots) {
        this.readLock.lock();
        try {
            HsqlArrayList allTables = this.store.schemaManager.getAllTables(true);
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() != 6) continue;
                long[] rootsArray = roots[i];
                if (roots == null) continue;
                t.setIndexRoots(rootsArray);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setDefaultMemoryModel(MemoryModel model) {
        this.defaultMemoryModel = model;
    }

    public MemoryModel getDefaultMemoryModel() {
        return this.defaultMemoryModel;
    }

    public HashSet<NameManager.ObjectName> getSemanticTypeReferences(SemanticType semanticType) {
        HashSet<NameManager.ObjectName> result = new HashSet<NameManager.ObjectName>();
        com.streamscape.ds.lib.Iterator tables = this.databaseObjectIterator(3);
        block0: while (tables.hasNext()) {
            Table table = (Table)tables.next();
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = column.getDataType();
                if (!type.isDistinctType() || !type.getNameString().equals(semanticType.getTypeName())) continue;
                result.add(table.getObjectName());
                continue block0;
            }
        }
        WrapperIterator routines = new WrapperIterator(this.databaseObjectIterator(25), this.databaseObjectIterator(32));
        routines = new WrapperIterator(routines, this.databaseObjectIterator(9));
        block2: while (routines.hasNext()) {
            SchemaObject routine = (SchemaObject)routines.next();
            OrderedHashSet set = routine.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                NameManager.ObjectName refName = (NameManager.ObjectName)set.get(i);
                if (!refName.name.equals(semanticType.getTypeName()) || refName.type != 13) continue;
                result.add(routine.getObjectName());
                continue block2;
            }
        }
        return result;
    }

    public List<String> getSemanticTypeReferencesTo(NameManager.ObjectName name) {
        SchemaObject schemaObject = this.findSchemaObject(name);
        ArrayList<String> semanticTypes = new ArrayList<String>();
        switch (schemaObject.getObjectType()) {
            case 4: {
                Table table = ((Collection)schemaObject).getBaseTable();
                int columnCount = table.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    ColumnSchema column = table.getColumn(i);
                    if (!column.getDataType().isDistinctType()) continue;
                    semanticTypes.add(column.getDataType().getObjectName().name);
                }
                break;
            }
            case 9: 
            case 17: 
            case 32: {
                SchemaObject routine = schemaObject;
                if (schemaObject instanceof RoutineSchema) {
                    routine = ((RoutineSchema)schemaObject).getSpecificRoutines()[0];
                }
                OrderedHashSet set = routine.getReferences();
                for (int i = 0; i < set.size(); ++i) {
                    NameManager.ObjectName refName = (NameManager.ObjectName)set.get(i);
                    if (refName.type != 13) continue;
                    semanticTypes.add(refName.name);
                }
                break;
            }
        }
        return semanticTypes;
    }

    public void registerSemanticTypeAsType(SemanticType semanticType, TSpace schema) {
        if (schema == null && (schema = (TSpace)this.schemaMap.get(SqlInvariants.SYS_SCHEMA_NAME.name)) == null) {
            Trace.logError(this, "Unable to register semantic type [" + semanticType.getTypeName() + "] as Dataspace domain type. Cause: SYS schema is not accessible.");
            return;
        }
        try {
            Class semanticTypeClass = ClassUtils.loadClass(semanticType.getClassName(), DataspaceStoreManager.getRuntimeContext().getSystemClassLoaderChain());
            Type typeObject = (Type)this.findSchemaObject(semanticType.getTypeName(), SqlInvariants.SYS_SCHEMA_NAME.name, 13);
            boolean typeCreated = false;
            if (typeObject == null) {
                NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(semanticType.getTypeName(), true, 13);
                typeObject = ImmutableEventDatagram.class.isAssignableFrom(semanticTypeClass) ? new EventType(semanticType.getTypeName(), semanticTypeClass) : new OtherType(semanticType.getTypeName(), ObjectCreator.isPrimitive(semanticTypeClass) ? semanticTypeClass : null);
                typeObject.userTypeModifier = new UserTypeModifier(name, 13, typeObject);
                schema.getTypeLookup().add(typeObject);
                this.addReferencesFrom(typeObject);
                typeCreated = true;
            } else {
                ((OtherType)typeObject).setInternalClass(null, null);
            }
        }
        catch (Throwable exception) {
            if (exception instanceof ClassNotFoundException) {
                Trace.logError(this, "Unable to register semantic type [" + semanticType.getTypeName() + "] as Dataspace domain type. Cause: Type is invalid.");
            }
            Trace.logException(this, exception, false);
            Trace.logError(this, "Unable to register semantic type [" + semanticType.getTypeName() + "] as Dataspace domain type.");
        }
    }

    public void unregisterSemanticTypeAsType(String semanticTypeName) {
        DataspaceSchema schema = (DataspaceSchema)this.schemaMap.get(SqlInvariants.SYS_SCHEMA_NAME.name);
        if (schema == null) {
            Trace.logError(this, "Unable to unregister semantic type [" + semanticTypeName + "] as Dataspace domain type. Cause: SYS schema in not accessible.");
            return;
        }
        NameManager.ObjectName semanticTypeObjectName = SemanticTypeAndPrototypeSchemaObjectsCache.getSemanticTypeObjectName(semanticTypeName);
        if (semanticTypeObjectName == null) {
            return;
        }
        OrderedHashSet references = this.getReferencesTo(semanticTypeObjectName);
        com.streamscape.ds.lib.Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            NameManager.ObjectName reference = (NameManager.ObjectName)iterator.next();
            SchemaObject schemaObject = this.findSchemaObject(reference);
            if (!(schemaObject instanceof OtherType) || !((OtherType)schemaObject).isDistinctType()) continue;
            if (this.getReferencesTo(reference).isEmpty()) {
                this.removeSchemaObject(reference);
                continue;
            }
            ((OtherType)schemaObject).setInternalClass(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSemanticTypes(List<SemanticType> types, boolean validate) {
        try (Session session = validate ? this.store.getSessionManager().newSysSession() : null;){
            for (SemanticType semanticType : types) {
                NameManager.ObjectName semanticTypeObjectName = SemanticTypeAndPrototypeSchemaObjectsCache.getSemanticTypeObjectName(semanticType.getTypeName());
                if (semanticTypeObjectName != null) {
                    this.getReferencesToSemanticType(semanticType.getTypeName(), null, t -> t.setInternalClass(null, null), (collection, type) -> collection.getStateHolder().setSuspectState(DataspaceStateHolder.outOfSync, "Type '" + type.getObjectName().name + "' " + (validate ? "reloaded" : "unloaded") + ". Check of types/collection and normalization of collection is needed."), null, session);
                    continue;
                }
                if (!validate || !semanticType.isValid()) continue;
                this.registerSemanticTypeAsType(semanticType, null);
            }
        }
    }

    private void getReferencesToSemanticType(String semanticTypeName, SchemaObject exceptType, Consumer<OtherType> typeConsumer, BiConsumer<AbstractCollection, OtherType> collectionConsumer, BiConsumer<RplScript, OtherType> rplScriptConsumer, Session recompileSession) {
        OrderedHashSet references = this.getReferencesTo(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetSemanticTypeObjectName(semanticTypeName));
        com.streamscape.ds.lib.Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            NameManager.ObjectName reference = (NameManager.ObjectName)iterator.next();
            SchemaObject schemaObject = this.findSchemaObject(reference);
            if (schemaObject == exceptType || !(schemaObject instanceof OtherType) || ((OtherType)schemaObject).userTypeModifier == null) continue;
            if (typeConsumer != null) {
                typeConsumer.accept((OtherType)schemaObject);
            }
            OrderedHashSet referencesToReferences = this.getReferencesTo(reference);
            com.streamscape.ds.lib.Iterator refToRefIterator = referencesToReferences.iterator();
            while (refToRefIterator.hasNext()) {
                SchemaObject referenceSchemaObject;
                NameManager.ObjectName referenceToReference = (NameManager.ObjectName)refToRefIterator.next();
                if (recompileSession != null && referenceToReference.type != 10 && (referenceSchemaObject = this.findSchemaObject(referenceToReference)) != null) {
                    referenceSchemaObject.recompileObject(recompileSession);
                }
                if (referenceToReference.type == 10 && collectionConsumer != null) {
                    referenceSchemaObject = this.findSchemaObject(referenceToReference.parent);
                    if (referenceSchemaObject instanceof Table) {
                        referenceSchemaObject = this.findSchemaObject(referenceToReference.parent.name, referenceToReference.parent.schema.name, 4);
                    }
                    if (!(referenceSchemaObject instanceof AbstractCollection)) continue;
                    collectionConsumer.accept((AbstractCollection)referenceSchemaObject, (OtherType)schemaObject);
                    continue;
                }
                if (rplScriptConsumer == null || (referenceSchemaObject = this.findSchemaObject(referenceToReference)) == null || !(referenceSchemaObject instanceof RplScript)) continue;
                rplScriptConsumer.accept((RplScript)referenceSchemaObject, (OtherType)schemaObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveObjectDefinition(Session session, SchemaObject object, String dsql) {
        String type = SqlUtils.getSchemaObjectType(object.getObjectType());
        String name = object.getObjectName().name;
        boolean isInteractive = session.isInteractive();
        boolean isSDSRuntimeSession = session.isSDSRuntimeSession();
        try {
            session.setInteractive(false);
            session.setSDSRuntimeSession(false);
            DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(object.getObjectName().schema.name);
            String oldDef = SyntaxStore.loadSyntax(session, schema, type, name);
            if (oldDef != null) {
                this.updateObjectDefinition(session, object, dsql);
            } else {
                SyntaxStore.saveSyntax(session, schema, type, name, dsql);
            }
        }
        finally {
            session.setInteractive(isInteractive);
            session.setSDSRuntimeSession(isSDSRuntimeSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectDefinition(Session session, SchemaObject object, String dsql) {
        block7: {
            String type = SqlUtils.getSchemaObjectType(object.getObjectType());
            String name = object.getObjectName().name;
            boolean isInteractive = session.isInteractive();
            boolean isSDSRuntimeSession = session.isSDSRuntimeSession();
            try {
                session.setInteractive(false);
                session.setSDSRuntimeSession(false);
                DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(object.getObjectName().schema.name);
                try {
                    SyntaxStore.updateSyntax(session, schema, type, name, dsql);
                }
                catch (Exception exception) {
                    if (!exception.getMessage().contains("unique constraint or index violation")) break block7;
                    Trace.logError(this, "Failed to update SYSLDEF, removing entity rows and then insert the new one.");
                    Pair<Timestamp, Timestamp> pair = SyntaxStore.loadObjectTimestamps(session, schema, type, name);
                    SyntaxStore.deleteSyntax(session, schema, type, name);
                    SyntaxStore.saveSyntax(session, schema, type, name, dsql);
                    try {
                        SyntaxStore.updateCreatedAt(session, schema, type, name, (Timestamp)pair.first);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            finally {
                session.setInteractive(isInteractive);
                session.setSDSRuntimeSession(isSDSRuntimeSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadObjectDefinition(Session session, SchemaObject object) {
        String type = SqlUtils.getSchemaObjectType(object.getObjectType());
        String name = object.getObjectName().name;
        boolean isInteractive = session.isInteractive();
        try {
            DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(object.getObjectName().schema.name);
            String string = SyntaxStore.loadSyntax(session, schema, type, name);
            return string;
        }
        finally {
            session.setInteractive(isInteractive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Timestamp, Timestamp> loadObjectTimestamps(Session session, SchemaObject object) {
        String type = SqlUtils.getSchemaObjectType(object.getObjectType());
        String name = object.getObjectName().name;
        boolean isInteractive = session.isInteractive();
        try {
            DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(object.getObjectName().schema.name);
            Pair<Timestamp, Timestamp> pair = SyntaxStore.loadObjectTimestamps(session, schema, type, name);
            return pair;
        }
        finally {
            session.setInteractive(isInteractive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectDefinition(Session session, NameManager.ObjectName name) {
        String type = SqlUtils.getSchemaObjectType(name.type);
        boolean isInteractive = session.isInteractive();
        boolean isSDSRuntimeSession = session.isSDSRuntimeSession();
        try {
            session.setInteractive(false);
            session.setSDSRuntimeSession(false);
            DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(name.schema.name);
            SyntaxStore.deleteSyntax(session, schema, type, name.name);
        }
        finally {
            session.setInteractive(isInteractive);
            session.setSDSRuntimeSession(isSDSRuntimeSession);
        }
    }

    private static /* synthetic */ void lambda$unregisterSemanticTypeAsType$6(RplScript rplScript, OtherType type) {
        rplScript.getStateHolder().setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.type(type.getObjectName()), "Type or domain references missing semantic type.");
    }

    private static /* synthetic */ void lambda$unregisterSemanticTypeAsType$5(AbstractCollection collection, OtherType type) {
        collection.getStateHolder().setSuspectState((StateHolder.SuspectStateOriginator)DataspaceStateHolder.type(type.getObjectName()), "Type or domain references missing semantic type.");
    }

    private static /* synthetic */ void lambda$unregisterSemanticTypeAsType$4(String semanticTypeName, OtherType type) {
        type.userTypeModifier.getStateHolder().setSuspectState(DataspaceStateHolder.semanticType(semanticTypeName), "Semantic type is missing.");
    }

    private static /* synthetic */ void lambda$registerSemanticTypeAsType$3(RplScript rplScript, OtherType type) {
        rplScript.getStateHolder().resetSuspectState(DataspaceStateHolder.type(type.getObjectName()));
    }

    private static /* synthetic */ void lambda$registerSemanticTypeAsType$2(AbstractCollection collection, OtherType type) {
        collection.getStateHolder().resetSuspectState(DataspaceStateHolder.type(type.getObjectName()));
    }

    private static /* synthetic */ void lambda$registerSemanticTypeAsType$1(SemanticType semanticType, OtherType type) {
        type.userTypeModifier.getStateHolder().resetSuspectState(DataspaceStateHolder.semanticType(semanticType.getTypeName()));
    }

    public static enum DropScope {
        NONE,
        CASCADE,
        FORCE;

    }
}

