/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.WrapperIterator;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SchemaObjectSet;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.ds.trigger.SystemEventTrigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.MetasetTypeWrapper;
import com.streamscape.lib.numalloc.IntNumberAllocator;
import com.streamscape.omf.java.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.IllegalComponentStateException;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dispatcher.AbstractDataspaceComponent;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.SchedulerException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DataspaceSchema
extends AbstractDataspaceComponent
implements SchemaObject {
    protected NameManager.ObjectName name;
    protected SchemaObjectSet triggerLookup;
    protected SchemaObjectSet constraintLookup;
    protected SchemaObjectSet indexLookup;
    protected SchemaObjectSet tableLookup;
    protected SchemaObjectSet collectionLookup;
    protected SchemaObjectSet sequenceLookup;
    protected SchemaObjectSet typeLookup;
    protected SchemaObjectSet charsetLookup;
    protected SchemaObjectSet collationLookup;
    protected SchemaObjectSet procedureLookup;
    protected SchemaObjectSet functionLookup;
    protected SchemaObjectSet specificRoutineLookup;
    protected SchemaObjectSet assertionLookup;
    protected SchemaObjectSet replicaLookup;
    protected SchemaObjectSet timerLookup;
    protected SchemaObjectSet jobLookup;
    protected SchemaObjectSet serverLookup;
    protected SchemaObjectSet actorLookup;
    protected SchemaObjectSet referenceLinkLookup;
    protected SchemaObjectSet fullTextIndexLookup;
    protected SchemaObjectSet facetsLookup;
    protected SchemaObjectSet aspectsLookup;
    protected SchemaObjectSet kNodesLookup;
    protected SchemaObjectSet kLinksLookup;
    protected SchemaObjectSet kGraphsLookup;
    protected SchemaObjectSet kGraphInstancesLookup;
    protected HashMappedList tableList;
    protected HashMappedList sequenceList;
    protected long changeTimestamp;
    protected IntNumberAllocator objectIdAllocator = new IntNumberAllocator();
    protected static Set<String> systemSchemas = new HashSet<String>();
    protected boolean started = true;
    protected boolean online = true;
    protected String metasetName;
    protected Metaset metaset;
    protected final Object metasetMutex = new Object();
    protected long createdAt;
    private Map<String, Object> metasetDynamicValues;
    private Map<String, Object> metasetPredefinedValues;

    public DataspaceSchema(NameManager.ObjectName name, DataspaceType type, Grantee owner) throws FabricNamingException {
        super(type, name.getNameString());
        this.name = name;
        this.triggerLookup = new SchemaObjectSet(9);
        this.indexLookup = new SchemaObjectSet(21);
        this.constraintLookup = new SchemaObjectSet(6);
        this.tableLookup = new SchemaObjectSet(3);
        this.collectionLookup = new SchemaObjectSet(4);
        this.sequenceLookup = new SchemaObjectSet(8);
        this.typeLookup = new SchemaObjectSet(13);
        this.charsetLookup = new SchemaObjectSet(15);
        this.collationLookup = new SchemaObjectSet(16);
        this.procedureLookup = new SchemaObjectSet(18);
        this.functionLookup = new SchemaObjectSet(17);
        this.specificRoutineLookup = new SchemaObjectSet(25);
        this.assertionLookup = new SchemaObjectSet(7);
        this.replicaLookup = new SchemaObjectSet(29);
        this.timerLookup = new SchemaObjectSet(30);
        this.jobLookup = new SchemaObjectSet(31);
        this.serverLookup = new SchemaObjectSet(27);
        this.actorLookup = new SchemaObjectSet(32);
        this.referenceLinkLookup = new SchemaObjectSet(37);
        this.fullTextIndexLookup = new SchemaObjectSet(38);
        this.facetsLookup = new SchemaObjectSet(41);
        this.aspectsLookup = new SchemaObjectSet(42);
        this.kNodesLookup = new SchemaObjectSet(43);
        this.kLinksLookup = new SchemaObjectSet(44);
        this.kGraphsLookup = new SchemaObjectSet(45);
        this.kGraphInstancesLookup = new SchemaObjectSet(46);
        this.tableList = (HashMappedList)this.tableLookup.map;
        this.sequenceList = (HashMappedList)this.sequenceLookup.map;
        name.owner = owner;
        this.context = DataspaceStoreManager.getRuntimeContext();
    }

    public HashMappedList getTables() {
        return this.tableList;
    }

    public final void init(Session session) {
        if (this.state == ComponentState.INITIALIZED || this.state == ComponentState.STARTED || this.state == ComponentState.STOPPED) {
            return;
        }
        if (this.state != ComponentState.DESTROYED) {
            throw new DataspaceException("Invalid dataspace state for starting: " + String.valueOf((Object)this.state));
        }
        SLOperationLogger.logDebug(this, "\nStarting dataspace...\n");
        this.setState(ComponentState.INITIALIZING);
        try {
            try {
                super.init();
            }
            catch (IllegalComponentStateException error) {
                throw new DataspaceException(error);
            }
            this.doInit(session);
            this.setState(ComponentState.INITIALIZED);
            SLOperationLogger.logInfo(this, "Dataspace started.\n");
        }
        catch (Exception exception) {
            SLOperationLogger.logInfo(this, "Start dataspace failed. " + Utils.formatExceptionWithUnrepeatedCauses(exception) + "\n");
            try {
                this.destroy(session);
            }
            catch (Exception exception1) {
                SLOperationLogger.logError(this, "Failed to stop dataspace. " + Utils.formatExceptionWithUnrepeatedCauses(exception1) + "\n");
                Trace.logException(this, exception1, true);
            }
            throw exception;
        }
    }

    protected void doInit(Session session) {
    }

    public final void destroy(Session session) {
        if (this.state == ComponentState.STARTED || this.state == ComponentState.STARTING) {
            this.close(session);
        }
        if (this.state != ComponentState.INITIALIZED && this.state != ComponentState.STOPPED) {
            throw new DataspaceException("Invalid dataspace state for stopping: " + String.valueOf((Object)this.state));
        }
        SLOperationLogger.logDebug(this, "\nStopping dataspace...\n");
        this.setState(ComponentState.DESTROYING);
        try {
            super.destroy();
            this.doDestroy(session);
            SLOperationLogger.logInfo(this, "Dataspace stopped.\n");
        }
        catch (Exception exception) {
            SLOperationLogger.logError(this, "Failed to stop dataspace.\n");
            Trace.logException(this, exception, true);
        }
        finally {
            this.setState(ComponentState.DESTROYED);
        }
    }

    protected void doDestroy(Session session) {
    }

    public final void open(Session session) {
        if (this.state == ComponentState.DESTROYED || this.state == ComponentState.NOT_INITIALIZED) {
            this.init(session);
        }
        if (this.state == ComponentState.STARTED) {
            return;
        }
        if (this.state != ComponentState.INITIALIZED && this.state != ComponentState.STOPPED) {
            throw new DataspaceException("Invalid dataspace state for onlining: " + String.valueOf((Object)this.state));
        }
        SLOperationLogger.logDebug(this, "\nMoving dataspace to ONLINE...\n");
        this.setState(ComponentState.STARTING);
        try {
            this.doOpen(session);
            this.setState(ComponentState.STARTED);
            SLOperationLogger.logInfo(this, "Dataspace is ONLINE.\n");
        }
        catch (Exception exception) {
            SLOperationLogger.logInfo(this, "Failed to move dataspace to ONLINE. " + Utils.formatExceptionWithUnrepeatedCauses(exception) + "\n");
            try {
                this.close(session);
                this.setState(ComponentState.STOPPED);
            }
            catch (Exception exception1) {
                SLOperationLogger.logError(this, "Failed to offline dataspace.\n");
                Trace.logException(this, exception1, true);
            }
            throw exception;
        }
    }

    protected void doOpen(Session session) {
    }

    public final void close(Session session) {
        if (this.state == ComponentState.STOPPED || this.state == ComponentState.INITIALIZED) {
            return;
        }
        if (this.state != ComponentState.STARTED) {
            throw new DataspaceException("Invalid dataspace state for offlining: " + String.valueOf((Object)this.state));
        }
        SLOperationLogger.logDebug(this, "\nMoving dataspace to OFFLINE...\n");
        this.setState(ComponentState.STOPPING);
        try {
            this.doClose(session);
            this.setState(ComponentState.STOPPED);
            SLOperationLogger.logInfo(this, "Dataspace is OFFLINE.\n");
        }
        catch (Exception exception) {
            SLOperationLogger.logError(this, "Failed to offline dataspace.\n");
            Trace.logException(this, exception, true);
            throw exception;
        }
    }

    protected void doClose(Session session) {
    }

    public void persist(Session session) {
    }

    @Override
    public int getObjectType() {
        return 2;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return null;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return this.name.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().statementName);
    }

    @Override
    public String getSQL(String name) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("CREATE").append(' ');
        sb.append("DATASPACE").append(' ');
        sb.append(name).append(' ');
        sb.append("TYPE").append(' ');
        sb.append(this.getDataspaceType().name()).append(' ');
        sb.append("EVENT").append(' ').append("SCOPE").append(' ');
        sb.append(this.eventScope.name()).append(' ');
        if (this.logger != null) {
            sb.append("LOG").append(' ').append("LEVEL").append(' ');
            sb.append(this.getLogger().getLogLevel().name()).append(' ');
        }
        sb.append("AUTHORIZATION").append(' ');
        sb.append(this.getOwner().getObjectName().getStatementName());
        sb.append(' ').append(this.started ? "START" : "STOP");
        sb.append(' ').append(this.online ? "ONLINE" : "OFFLINE");
        this.appendMetaset(sb);
        sb.append(" CREATED TIMESTAMP ").append(this.createdAt);
        return sb.toString();
    }

    public void appendMetaset(StringBuilder sb) {
        if (this.metasetName != null) {
            Map<String, Object> metasetPredefinedValues;
            sb.append(" METASET ").append(this.metasetName);
            Map<String, Object> metasetDynamicValues = this.getMetasetDynamicValues();
            if (metasetDynamicValues != null) {
                sb.append(" WITH DYNAMIC VALUES '").append(MetasetTypeWrapper.serializeMetasetValues(metasetDynamicValues)).append("'");
            }
            if ((metasetPredefinedValues = this.getMetasetPredefinedValues()) != null) {
                sb.append(" WITH PREDEFINED VALUES '").append(MetasetTypeWrapper.serializeMetasetValues(metasetPredefinedValues)).append("'");
            }
        }
    }

    static String getSetSchemaSQL(NameManager.ObjectName schemaName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ');
        sb.append("DATASPACE").append(' ');
        sb.append(schemaName.statementName);
        return sb.toString();
    }

    static void addSetSchemaSQLAndIndex(List<String> list, NameManager.ObjectName name, DataspaceStore store) {
        String setSchema = DataspaceSchema.getSetSchemaSQL(name);
        list.add(setSchema);
        DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
        node.objectName = name.getSchemaQualifiedStatementName();
        node.dataspaceId = name.getId();
        node.objectId = -1;
        node.type = LogRecordType.OTHER;
        store.logIndexBuilder.put(list.size() - 1, node);
    }

    public void getSQLArray(List<String> list, OrderedHashSet resolved, OrderedHashSet unresolved, DataspaceStore store) {
        DataspaceSchema.addSetSchemaSQLAndIndex(list, this.name, store);
        this.sequenceLookup.getSQL(list, resolved, unresolved, store);
        this.serverLookup.getSQL(list, resolved, unresolved, store);
        this.facetsLookup.getSQL(list, resolved, unresolved, store);
        this.aspectsLookup.getSQL(list, resolved, unresolved, store);
        this.kNodesLookup.getSQL(list, resolved, unresolved, store);
        this.kLinksLookup.getSQL(list, resolved, unresolved, store);
        this.kGraphsLookup.getSQL(list, resolved, unresolved, store);
        this.kGraphInstancesLookup.getSQL(list, resolved, unresolved, store);
        this.collectionLookup.getSQL(list, resolved, unresolved, store);
        this.fullTextIndexLookup.getSQL(list, resolved, unresolved, store);
        this.timerLookup.getSQL(list, resolved, unresolved, store);
        this.jobLookup.getSQL(list, resolved, unresolved, store);
        this.replicaLookup.getSQL(list, resolved, unresolved, store);
        this.functionLookup.getSQL(list, resolved, unresolved, store);
        this.procedureLookup.getSQL(list, resolved, unresolved, store);
        this.actorLookup.getSQL(list, resolved, unresolved, store);
        this.assertionLookup.getSQL(list, resolved, unresolved, store);
        this.referenceLinkLookup.getSQL(list, resolved, unresolved, store);
    }

    public void getSequenceRestartSQL(List<String> list, DataspaceStore store) {
        com.streamscape.ds.lib.Iterator it = this.sequenceLookup.map.values().iterator();
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            String ddl = sequence.getRestartSQL();
            list.add(ddl);
            DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
            node.objectName = sequence.getObjectName().getSchemaQualifiedStatementName();
            node.dataspaceId = sequence.getObjectName().schema.getId();
            node.objectId = sequence.getObjectName().getId();
            node.type = LogRecordType.OTHER;
            store.logIndexBuilder.put(list.size() - 1, node);
        }
    }

    public void addTriggerSQL(List<String> list, DataspaceStore store) {
        com.streamscape.ds.lib.Iterator it = this.tableLookup.map.values().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            table.addTriggerSQL(list, store);
        }
        it = this.triggerLookup.map.values().iterator();
        while (it.hasNext()) {
            DataspaceStore.DDLRecordNode node;
            TriggerDef trigger = (TriggerDef)it.next();
            if (trigger instanceof SystemEventTrigger) {
                list.add(trigger.getSQL());
                node = new DataspaceStore.DDLRecordNode();
                node.objectName = trigger.getObjectName().getSchemaQualifiedStatementName();
                node.dataspaceId = trigger.getObjectName().schema.getId();
                node.objectId = trigger.getObjectName().getId();
                node.type = LogRecordType.CREATE;
                store.logIndexBuilder.put(list.size() - 1, node);
                continue;
            }
            if (!(trigger instanceof AbstractReplicationEventTrigger)) continue;
            list.add(trigger.getSQL());
            node = new DataspaceStore.DDLRecordNode();
            node.objectName = trigger.getObjectName().getSchemaQualifiedStatementName();
            node.dataspaceId = trigger.getObjectName().schema.getId();
            node.objectId = trigger.getObjectName().getId();
            node.type = LogRecordType.CREATE;
            store.logIndexBuilder.put(list.size() - 1, node);
        }
    }

    public void addSimpleObjects(OrderedHashSet unresolved) {
        unresolved.addAll(this.typeLookup.map.values());
        unresolved.addAll(this.charsetLookup.map.values());
        unresolved.addAll(this.collationLookup.map.values());
    }

    boolean isEmpty() {
        return this.sequenceLookup.isEmpty() && this.tableLookup.isEmpty() && this.typeLookup.isEmpty() && this.charsetLookup.isEmpty() && this.collationLookup.isEmpty() && this.specificRoutineLookup.isEmpty();
    }

    public SchemaObjectSet getObjectSet(int type) {
        switch (type) {
            case 8: {
                return this.sequenceLookup;
            }
            case 3: 
            case 5: {
                return this.tableLookup;
            }
            case 15: {
                return this.charsetLookup;
            }
            case 41: {
                return this.facetsLookup;
            }
            case 42: {
                return this.aspectsLookup;
            }
            case 43: {
                return this.kNodesLookup;
            }
            case 44: {
                return this.kLinksLookup;
            }
            case 45: {
                return this.kGraphsLookup;
            }
            case 46: {
                return this.kGraphInstancesLookup;
            }
            case 16: {
                return this.collationLookup;
            }
            case 18: {
                return this.procedureLookup;
            }
            case 17: {
                return this.functionLookup;
            }
            case 19: {
                return this.functionLookup;
            }
            case 25: {
                return this.specificRoutineLookup;
            }
            case 13: 
            case 14: {
                return this.typeLookup;
            }
            case 7: {
                return this.assertionLookup;
            }
            case 9: {
                return this.triggerLookup;
            }
            case 21: {
                return this.indexLookup;
            }
            case 6: {
                return this.constraintLookup;
            }
            case 4: {
                return this.collectionLookup;
            }
            case 29: {
                return this.replicaLookup;
            }
            case 30: {
                return this.timerLookup;
            }
            case 27: {
                return this.serverLookup;
            }
            case 31: {
                return this.jobLookup;
            }
            case 32: {
                return this.actorLookup;
            }
            case 37: {
                return this.referenceLinkLookup;
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    com.streamscape.ds.lib.Iterator schemaObjectIterator() {
        com.streamscape.ds.lib.Iterator iterator = this.sequenceLookup.map.values().iterator();
        iterator = new WrapperIterator(iterator, this.tableLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.collectionLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.replicaLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.timerLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.jobLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.serverLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.charsetLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.collationLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.procedureLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.functionLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.functionLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.procedureLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.specificRoutineLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.typeLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.assertionLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.triggerLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.indexLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.constraintLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.actorLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.referenceLinkLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.fullTextIndexLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.facetsLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.aspectsLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.kNodesLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.kLinksLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.kGraphsLookup.map.values().iterator());
        iterator = new WrapperIterator(iterator, this.kGraphInstancesLookup.map.values().iterator());
        return iterator;
    }

    com.streamscape.ds.lib.Iterator schemaObjectIterator(int type) {
        switch (type) {
            case 8: {
                return this.sequenceLookup.map.values().iterator();
            }
            case 3: 
            case 5: {
                return this.tableLookup.map.values().iterator();
            }
            case 4: {
                return this.collectionLookup.map.values().iterator();
            }
            case 29: {
                return this.replicaLookup.map.values().iterator();
            }
            case 30: {
                return this.timerLookup.map.values().iterator();
            }
            case 31: {
                return this.jobLookup.map.values().iterator();
            }
            case 27: {
                return this.serverLookup.map.values().iterator();
            }
            case 15: {
                return this.charsetLookup.map.values().iterator();
            }
            case 41: {
                return this.facetsLookup.map.values().iterator();
            }
            case 42: {
                return this.aspectsLookup.map.values().iterator();
            }
            case 43: {
                return this.kNodesLookup.map.values().iterator();
            }
            case 44: {
                return this.kLinksLookup.map.values().iterator();
            }
            case 45: {
                return this.kGraphsLookup.map.values().iterator();
            }
            case 46: {
                return this.kGraphInstancesLookup.map.values().iterator();
            }
            case 16: {
                return this.collationLookup.map.values().iterator();
            }
            case 18: {
                return this.procedureLookup.map.values().iterator();
            }
            case 17: {
                return this.functionLookup.map.values().iterator();
            }
            case 19: {
                com.streamscape.ds.lib.Iterator functions = this.functionLookup.map.values().iterator();
                return new WrapperIterator(functions, this.procedureLookup.map.values().iterator());
            }
            case 25: {
                return this.specificRoutineLookup.map.values().iterator();
            }
            case 13: 
            case 14: {
                return this.typeLookup.map.values().iterator();
            }
            case 7: {
                return this.assertionLookup.map.values().iterator();
            }
            case 9: {
                return this.triggerLookup.map.values().iterator();
            }
            case 21: {
                return this.indexLookup.map.values().iterator();
            }
            case 6: {
                return this.constraintLookup.map.values().iterator();
            }
            case 32: {
                return this.actorLookup.map.values().iterator();
            }
            case 37: {
                return this.referenceLinkLookup.map.values().iterator();
            }
            case 38: {
                return this.fullTextIndexLookup.map.values().iterator();
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    void clearStructures() {
        this.tableList.clear();
        this.sequenceList.clear();
        this.triggerLookup = null;
        this.indexLookup = null;
        this.constraintLookup = null;
        this.collectionLookup = null;
        this.replicaLookup = null;
        this.procedureLookup = null;
        this.functionLookup = null;
        this.sequenceLookup = null;
        this.tableLookup = null;
        this.typeLookup = null;
        this.charsetLookup = null;
        this.specificRoutineLookup = null;
        this.assertionLookup = null;
        this.timerLookup = null;
        this.jobLookup = null;
        this.serverLookup = null;
        this.actorLookup = null;
        this.referenceLinkLookup = null;
        this.facetsLookup = null;
        this.aspectsLookup = null;
        this.kNodesLookup = null;
        this.kLinksLookup = null;
        this.kGraphsLookup = null;
        this.kGraphInstancesLookup = null;
    }

    @Override
    public void setLogger(Logger logger) {
        if (logger != null && !(logger instanceof DataspaceLogger)) {
            throw new DataspaceException("Logger should be of type DataspaceLogger.");
        }
        super.setLogger(logger);
    }

    @Override
    public void onRename() {
        super.onRename();
        ((AbstractDataspaceComponent)this).name = this.name.name;
    }

    @Override
    public DataspaceLogger getLogger() {
        return (DataspaceLogger)this.logger;
    }

    public abstract void logDebug(String var1);

    public abstract void logDebug(String var1, String var2);

    public abstract void logError(String var1);

    public abstract void logError(String var1, String var2);

    public abstract void logInfo(String var1);

    public abstract void logInfo(String var1, String var2);

    public void setOnline(boolean online) {
        this.online = online;
        if (online) {
            this.started = true;
        }
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
        if (!started) {
            this.online = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMetasetName(String metasetName) {
        Object object = this.metasetMutex;
        synchronized (object) {
            this.metasetName = metasetName;
            this.metaset = null;
            this.metasetDynamicValues = null;
            this.metasetPredefinedValues = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetasetName(String metasetName) {
        Object object = this.metasetMutex;
        synchronized (object) {
            if (metasetName != null && !DataspaceManager.getContext().getScheduler().existsMetaset(metasetName)) {
                throw new DataspaceException("Metaset not found.");
            }
            if (this.metasetName != null && metasetName != null && this.metasetName.equals(metasetName)) {
                throw new DataspaceException("Specified metaset already attached.");
            }
            this.metasetName = metasetName;
            this.metaset = null;
            this.metasetDynamicValues = null;
            this.metasetPredefinedValues = null;
        }
    }

    public String getMetasetName() {
        return this.metasetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metaset getMetaset() {
        if (this.metaset == null) {
            Iterator<Map.Entry<String, Object>> iterator = this.metasetMutex;
            synchronized (iterator) {
                if (this.metaset == null && this.metasetName != null) {
                    this.metaset = DataspaceManager.getContext().getScheduler().getMetaset(this.metasetName);
                }
            }
        }
        if (this.metaset != null && this.metasetDynamicValues != null) {
            for (Map.Entry<String, Object> entry : this.metasetDynamicValues.entrySet()) {
                try {
                    this.metaset.set(entry.getKey(), entry.getValue());
                }
                catch (SchedulerException exception) {
                    this.logError(exception.getErrorMessage());
                }
                this.metasetDynamicValues = null;
            }
        }
        if (this.metaset != null && this.metasetPredefinedValues != null) {
            for (Map.Entry<String, Object> entry : this.metasetPredefinedValues.entrySet()) {
                try {
                    this.metaset.set(entry.getKey(), entry.getValue());
                }
                catch (SchedulerException exception) {
                    this.logError(exception.getErrorMessage());
                }
                this.metasetPredefinedValues = null;
            }
        }
        return this.metaset;
    }

    public void setMetasetDynamicValues(Map<String, Object> metasetDynamicValues) {
        this.metasetDynamicValues = metasetDynamicValues;
    }

    public Map<String, Object> getMetasetDynamicValues() {
        if (RuntimeContext.isInitialized()) {
            return this.getMetaset().getDynamicProperties();
        }
        return this.metasetDynamicValues;
    }

    public void setMetasetPredefinedValues(Map<String, Object> metasetPredefinedValues) {
        this.metasetPredefinedValues = metasetPredefinedValues;
    }

    public Map<String, Object> getMetasetPredefinedValues() {
        if (RuntimeContext.isInitialized()) {
            return this.getMetaset().getPredefinedProperties();
        }
        return this.metasetPredefinedValues;
    }

    public boolean matchesDomain(String domainName, Object value) {
        return this.getSelectorDataSource().getInValues().matchesDomain(domainName, value);
    }

    public boolean matchesRange(String rangeName, Object value) {
        return this.getSelectorDataSource().getInValues().matchesRange(rangeName, value);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    static {
        systemSchemas.add("SYS_LOBS");
        systemSchemas.add("SYS_FLOBS");
    }
}

