/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.rights;

import com.streamscape.Trace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.rights.GranteeManager;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.security.User;

public class UserWrapper
extends Grantee {
    private transient NameManager.ObjectName initialSchema = null;

    UserWrapper(NameManager.ObjectName name, GranteeManager manager) {
        super(name, manager);
        if (manager != null) {
            this.updateAllRights();
        }
    }

    @Override
    public boolean isSudoCapable() {
        if (this.getObjectName().name.equals("sysadmin")) {
            return true;
        }
        try {
            User user = DataspaceManager.getContext().getSecurityManager().lookupUser(this.getObjectName().name);
            if (user != null) {
                return user.isSudoCapable();
            }
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to check user 'sudo' capable flag.");
        }
        return false;
    }

    @Override
    public String getSQL() {
        return "";
    }

    public NameManager.ObjectName getInitialSchema() {
        return this.initialSchema;
    }

    public NameManager.ObjectName getInitialOrDefaultSchema() {
        if (this.initialSchema != null) {
            return this.initialSchema;
        }
        NameManager.ObjectName schema = this.granteeManager.store.schemaManager.findSchemaHsqlName(this.getObjectName().getNameString());
        if (schema == null) {
            return this.granteeManager.store.schemaManager.getDefaultSchemaHsqlName();
        }
        return schema;
    }

    public void setInitialSchema(NameManager.ObjectName schema) {
        this.initialSchema = schema;
    }

    public String getInitialSchemaSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.getObjectName().getStatementName()).append(' ');
        sb.append("SET").append(' ');
        sb.append("INITIAL").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.initialSchema.getStatementName());
        return sb.toString();
    }

    public String getConnectUserSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ');
        sb.append("SESSION").append(' ');
        sb.append("AUTHORIZATION").append(' ');
        sb.append(StringConverter.toQuotedString(this.getObjectName().getNameString(), '\'', true));
        return sb.toString();
    }
}

