/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.rights;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.rights.GranteeManager;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.CIString;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.List;

public final class UserManager {
    private HashMappedList userList;
    private GranteeManager granteeManager;
    private DataspaceStore store = null;

    public UserManager(DataspaceStore store) {
        this.store = store;
        this.granteeManager = store.getGranteeManager();
        this.userList = new HashMappedList();
        try {
            SecurityManager securityManager = DataspaceStoreManager.getRuntimeContext().getSecurityManager();
            List<User> runtimeUsers = securityManager.getUsers();
            for (User user : runtimeUsers) {
                if (user.getName().toString().equalsIgnoreCase("sysadmin")) continue;
                UserWrapper wrapper = this.getUser(user);
                AccessControlList acl = securityManager.getUserPermissions(user.getName().toString());
                if (acl == null || !acl.isAllowed(AccessControlOperation.DATASPACE_CREATE)) continue;
                this.granteeManager.grantCreateDataspace(wrapper, true);
            }
            List<Group> groups = securityManager.getGroups();
            for (Group group : groups) {
                for (String user : group.listUsers()) {
                    if (user.equalsIgnoreCase("sysadmin")) continue;
                    this.granteeManager.grant(user, group.getName().toString(), this.granteeManager.adminsGroup);
                }
            }
            this.userList.add(new CIString("sysadmin"), GranteeManager.systemAuthorisation);
        }
        catch (SecurityManagerException error) {
            throw new DataspaceException(error);
        }
    }

    public UserWrapper createUser(NameManager.ObjectName name) {
        UserWrapper user = this.granteeManager.addUser(name);
        try {
            User createdUser = DataspaceStoreManager.getRuntimeContext().getSecurityManager().lookupUser(name.name);
            for (String groupName : createdUser.listGroups()) {
                this.granteeManager.grant(name.name, groupName, this.granteeManager.adminsGroup);
            }
        }
        catch (Exception e) {
            throw Error.error(4003, name.statementName);
        }
        boolean success = this.userList.add(new CIString(name.name), user);
        if (!success) {
            throw Error.error(4003, name.statementName);
        }
        return user;
    }

    public void dropUser(String name) {
        boolean reservedUser = GranteeManager.isReserved(name);
        if (reservedUser) {
            throw Error.error(4002, name);
        }
        boolean result = this.granteeManager.removeGrantee(name);
        if (!result) {
            throw Error.error(4001, name);
        }
        UserWrapper user = (UserWrapper)this.userList.remove(new CIString(name));
        if (user == null) {
            throw Error.error(4001, name);
        }
    }

    public UserWrapper getUser(String name, String password) {
        if (name == null) {
            name = "";
        }
        if (password == null) {
            password = "";
        }
        UserWrapper user = this.get(name);
        try {
            this.store.schemaManager.findSchema("SYS").authenticateUser(name, password);
        }
        catch (SecurityManagerException error) {
            throw Error.error(4000);
        }
        return user;
    }

    public UserWrapper getUser(User user) {
        return this.get(user);
    }

    public HashMappedList getUsers() {
        return this.userList;
    }

    public boolean exists(String name) {
        return this.userList.get(new CIString(name)) != null;
    }

    public UserWrapper get(String name) {
        UserWrapper user = (UserWrapper)this.userList.get(new CIString(name));
        if (user == null) {
            throw Error.error(4001, name);
        }
        return user;
    }

    public UserWrapper get(User user) {
        UserWrapper userWrapper = (UserWrapper)this.userList.get(user.getName());
        if (userWrapper == null) {
            NameManager.ObjectName name = this.store.nameManager.newObjectName(user.getName().toString(), true, 12);
            userWrapper = this.createUser(name);
            if (user.isAdministrator()) {
                this.granteeManager.grant(name.name, "Admins", this.granteeManager.adminsGroup);
            }
        }
        return userWrapper;
    }

    public HsqlArrayList listVisibleUsers(Session session) {
        HsqlArrayList list = new HsqlArrayList();
        boolean isAdmin = session.isAdmin();
        String sessionName = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return list;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            UserWrapper user = (UserWrapper)this.userList.get(i);
            if (user == null) continue;
            String userName = user.getObjectName().getNameString();
            if (isAdmin) {
                list.add(user);
                continue;
            }
            if (!sessionName.equals(userName)) continue;
            list.add(user);
        }
        return list;
    }

    public UserWrapper getSysUser() {
        return GranteeManager.systemAuthorisation;
    }

    public synchronized void removeSchemaReference(String schemaName) {
        for (int i = 0; i < this.userList.size(); ++i) {
            UserWrapper user = (UserWrapper)this.userList.get(i);
            NameManager.ObjectName schema = user.getInitialSchema();
            if (schema == null || !schemaName.equals(schema.name)) continue;
            user.setInitialSchema(null);
        }
    }

    public String[] getInitialSchemaSQL() {
        HsqlArrayList list = new HsqlArrayList(this.userList.size());
        for (int i = 0; i < this.userList.size(); ++i) {
            NameManager.ObjectName name;
            UserWrapper user = (UserWrapper)this.userList.get(i);
            if (user.isSystem || (name = user.getInitialSchema()) == null) continue;
            list.add(user.getInitialSchemaSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }
}

