/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.rights;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.Collection;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.IntValueHashMap;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.rights.Right;
import com.streamscape.ds.rights.SchemaPermission;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.CIString;
import com.streamscape.sef.dispatcher.DataspaceGranteeManager;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityAdvisory;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import java.util.List;

public class GranteeManager
extends DataspaceGranteeManager {
    static UserWrapper systemAuthorisation;
    SecurityManager securityManager;
    private HashMappedList map = new HashMappedList();
    private HashMappedList groupMap = new HashMappedList();
    DataspaceStore store;
    Grantee usersGroup;
    Grantee adminsGroup;
    static final IntValueHashMap rightsStringLookup;

    public GranteeManager(DataspaceStore store) {
        super(DataspaceStoreManager.getRuntimeContext());
        this.store = store;
        try {
            SecurityManager securityManager = DataspaceStoreManager.getRuntimeContext().getSecurityManager();
            List<Group> groups = securityManager.getGroups();
            for (Group group : groups) {
                this.addGroup(store.nameManager.newObjectName(group.getName().toString(), true, 12));
            }
        }
        catch (SecurityManagerException error) {
            throw new DataspaceException(error);
        }
        this.usersGroup = this.getGroup("Users");
        this.usersGroup.isPublic = true;
        this.adminsGroup = this.getGroup("Admins");
        this.adminsGroup.setAdminDirect();
        GranteeManager.systemAuthorisation.granteeManager = this;
    }

    public void open() {
        try {
            this.securityManager = DataspaceStoreManager.getRuntimeContext().getSecurityManager();
        }
        catch (Exception ex) {
            Trace.logError(this, "Unable to resolve runtime security manager. " + ex.getMessage());
        }
    }

    public void close() {
    }

    @Override
    protected void onSecurityUpdate(SecurityAdvisory advisory) {
        switch (advisory.getType()) {
            case GROUP_CREATED: {
                this.addGroup(this.store.nameManager.newObjectName(advisory.getEntity(), true, 12));
                break;
            }
            case GROUP_DROPPED: {
                this.dropGroup(this.store.getSessionManager().getSysSession(), advisory.getEntity(), true);
                break;
            }
            case USER_CREATED: {
                this.store.userManager.createUser(this.store.nameManager.newObjectName(advisory.getEntity(), true, 12));
                try {
                    AccessControlList acl = this.securityManager.getUserPermissions(advisory.getEntity());
                    Grantee grantee = this.get(advisory.getEntity());
                    if (acl == null || grantee == null) break;
                    this.grantCreateDataspace(grantee, acl.isAllowed(AccessControlOperation.DATASPACE_CREATE));
                }
                catch (Exception error) {
                    Trace.logError(this, "Unable to update user/group ACL. " + error.getMessage());
                }
                break;
            }
            case USER_DROPPED: {
                this.dropUser(this.store.getSessionManager().getSysSession(), advisory.getEntity(), true);
                break;
            }
            case USER_ADDED_TO_GROUP: {
                this.grant(advisory.getEntity(), advisory.getInfo(), systemAuthorisation);
                break;
            }
            case USER_REMOVED_FROM_GROUP: {
                this.revoke(advisory.getEntity(), advisory.getInfo(), systemAuthorisation);
                break;
            }
            case USER_PERMISSIONS_CHANGED: 
            case GROUP_PERMISSIONS_CHANGED: {
                try {
                    AccessControlList acl = this.securityManager.getUserPermissions(advisory.getEntity());
                    Grantee grantee = this.get(advisory.getEntity());
                    if (acl == null || grantee == null) break;
                    this.grantCreateDataspace(grantee, acl.isAllowed(AccessControlOperation.DATASPACE_CREATE));
                    break;
                }
                catch (Exception error) {
                    Trace.logError(this, "Unable to update user/group ACL. " + error.getMessage());
                }
            }
        }
    }

    private synchronized void dropUser(Session session, String name, boolean cascade) {
        UserWrapper grantee = session.dataspaceStore.getUserManager().get(name);
        if (session.dataspaceStore.getSessionManager().isUserActive(name)) {
            throw Error.error(5539);
        }
        if (!cascade && session.dataspaceStore.schemaManager.hasSchemas(grantee)) {
            HsqlArrayList list = session.dataspaceStore.schemaManager.getSchemas(grantee);
            DataspaceSchema schema = (DataspaceSchema)list.get(0);
            throw Error.error(5502, schema.getObjectName().statementName);
        }
        session.dataspaceStore.schemaManager.dropSchemas(session, grantee, cascade, false);
        session.dataspaceStore.getUserManager().dropUser(name);
    }

    private synchronized void dropGroup(Session session, String name, boolean cascade) {
        Grantee role = session.dataspaceStore.getGranteeManager().getGroup(name);
        if (!cascade && session.dataspaceStore.schemaManager.hasSchemas(role)) {
            HsqlArrayList list = session.dataspaceStore.schemaManager.getSchemas(role);
            DataspaceSchema schema = (DataspaceSchema)list.get(0);
            throw Error.error(5502, schema.getObjectName().statementName);
        }
        session.dataspaceStore.schemaManager.dropSchemas(session, role, cascade, false);
        session.dataspaceStore.getGranteeManager().dropRole(name);
    }

    public Grantee getAdminsGroup() {
        return this.adminsGroup;
    }

    public static Grantee getSystemUser() {
        return systemAuthorisation;
    }

    public void grant(OrderedHashSet granteeList, SchemaObject dbObject, Right right, Grantee grantor, boolean withGrantOption) {
        if (dbObject instanceof RoutineSchema) {
            SchemaObject[] routines = ((RoutineSchema)dbObject).getSpecificRoutines();
            this.grant(granteeList, routines, right, grantor, withGrantOption);
            return;
        }
        NameManager.ObjectName name = dbObject.getObjectName();
        if (dbObject instanceof RplScript) {
            name = ((RplScript)dbObject).getSpecificName();
        }
        if (!grantor.isGrantable(dbObject, right)) {
            throw Error.error(2000, grantor.getObjectName().getNameString());
        }
        if (grantor.isAdmin()) {
            grantor = dbObject.getOwner();
        }
        this.checkGranteeList(granteeList);
        for (int i = 0; i < granteeList.size(); ++i) {
            Grantee grantee = this.get((String)granteeList.get(i));
            grantee.grant(name, right, grantor, withGrantOption);
            if (!grantee.isGroup) continue;
            this.updateAllRights(grantee);
        }
    }

    public void grant(OrderedHashSet granteeList, SchemaObject[] routines, Right right, Grantee grantor, boolean withGrantOption) {
        boolean granted = false;
        for (int i = 0; i < routines.length; ++i) {
            if (!grantor.isGrantable(routines[i], right)) continue;
            this.grant(granteeList, routines[i], right, grantor, withGrantOption);
            granted = true;
        }
        if (!granted && routines.length > 0) {
            throw Error.error(2000, grantor.getObjectName().getNameString());
        }
    }

    public void grant(OrderedHashSet granteeList, NameManager.ObjectName schemaName, Right right, Grantee grantor, boolean withGrantOption) {
        this.checkGranteeList(granteeList);
        for (int i = 0; i < granteeList.size(); ++i) {
            Grantee grantee = this.get((String)granteeList.get(i));
            grantee.grantForSchema(schemaName, right, grantor, withGrantOption);
            if (!grantee.isGroup) continue;
            this.updateAllRights(grantee);
        }
    }

    public void grant(OrderedHashSet granteeList, NameManager.ObjectName schemaName, SchemaPermission permission) {
        this.checkGranteeList(granteeList);
        for (int i = 0; i < granteeList.size(); ++i) {
            Grantee grantee = this.get((String)granteeList.get(i));
            grantee.grantForSchema(schemaName, permission);
            if (!grantee.isGroup) continue;
            this.updateAllRights(grantee);
        }
    }

    public void checkGranteeList(OrderedHashSet granteeList) {
        for (int i = 0; i < granteeList.size(); ++i) {
            String name = (String)granteeList.get(i);
            Grantee grantee = this.get(name);
            if (grantee == null) {
                throw Error.error(4001, name);
            }
            if (!GranteeManager.isImmutable(name)) continue;
            throw Error.error(4002, name);
        }
    }

    public void grantCreateDataspace(Grantee grantee, boolean value) {
        grantee.dataspaceCreationCapable = value;
    }

    public void grant(String granteeName, String roleName, Grantee grantor) {
        Grantee grantee = this.get(granteeName);
        if (grantee == null) {
            throw Error.error(4001, granteeName);
        }
        if (GranteeManager.isImmutable(granteeName)) {
            throw Error.error(4002, granteeName);
        }
        Grantee role = this.getGroup(roleName);
        if (role == null) {
            throw Error.error(2200, roleName);
        }
        if (role == grantee) {
            throw Error.error(2251, granteeName);
        }
        if (role.hasRole(grantee)) {
            throw Error.error(2251, roleName);
        }
        if (!grantor.isGrantable(role)) {
            throw Error.error(2000, grantor.getObjectName().getNameString());
        }
        grantee.grant(role);
        grantee.updateAllRights();
        if (grantee.isGroup) {
            this.updateAllRights(grantee);
        }
    }

    public void checkRoleList(String granteeName, OrderedHashSet groupList, Grantee grantor, boolean grant) {
        Grantee grantee = this.get(granteeName);
        for (int i = 0; i < groupList.size(); ++i) {
            String groupName = (String)groupList.get(i);
            Grantee group = this.getGroup(groupName);
            if (group == null) {
                throw Error.error(2200, groupName);
            }
            if (groupName.equals("sysadmin") || groupName.equals("Users")) {
                throw Error.error(4002, groupName);
            }
            if (grant) {
                if (grantee.getDirectRoles().contains(group)) {
                    throw Error.error(2200, granteeName);
                }
            } else if (!grantee.getDirectRoles().contains(group)) {
                throw Error.error(2200, groupName);
            }
            if (grantor.isAdmin()) continue;
            throw Error.error(2000, grantor.getObjectName().getNameString());
        }
    }

    public void grantSystemToPublic(SchemaObject object, Right right) {
        this.usersGroup.grant(object.getObjectName(), right, systemAuthorisation, true);
    }

    public void revoke(String granteeName, String roleName, Grantee grantor) {
        if (!grantor.isAdmin()) {
            throw Error.error(5507);
        }
        Grantee grantee = this.get(granteeName);
        if (grantee == null) {
            throw Error.error(4000, granteeName);
        }
        Grantee role = (Grantee)this.groupMap.get(new CIString(roleName));
        grantee.revoke(role);
        grantee.updateAllRights();
        if (grantee.isGroup) {
            this.updateAllRights(grantee);
        }
    }

    public void revoke(OrderedHashSet granteeList, SchemaObject dbObject, Right rights, Grantee grantor, boolean grantOption, boolean cascade) {
        Grantee g;
        String granteeName;
        int i;
        if (dbObject instanceof RoutineSchema) {
            SchemaObject[] routines = ((RoutineSchema)dbObject).getSpecificRoutines();
            this.revoke(granteeList, routines, rights, grantor, grantOption, cascade);
            return;
        }
        NameManager.ObjectName name = dbObject.getObjectName();
        if (dbObject instanceof RplScript) {
            name = ((RplScript)dbObject).getSpecificName();
        }
        if (!grantor.isFullyAccessibleByRole(name)) {
            throw Error.error(5501, dbObject.getObjectName().name);
        }
        if (grantor.isAdmin()) {
            grantor = dbObject.getOwner();
        }
        for (i = 0; i < granteeList.size(); ++i) {
            granteeName = (String)granteeList.get(i);
            g = this.get(granteeName);
            if (g == null) {
                throw Error.error(4001, granteeName);
            }
            if (!GranteeManager.isImmutable(granteeName)) continue;
            throw Error.error(4002, granteeName);
        }
        for (i = 0; i < granteeList.size(); ++i) {
            granteeName = (String)granteeList.get(i);
            g = this.get(granteeName);
            g.revoke(dbObject, rights, grantor, grantOption);
            g.updateAllRights();
            if (!g.isGroup) continue;
            this.updateAllRights(g);
        }
    }

    public void revoke(OrderedHashSet granteeList, SchemaObject[] routines, Right rights, Grantee grantor, boolean grantOption, boolean cascade) {
        for (int i = 0; i < routines.length; ++i) {
            this.revoke(granteeList, routines[i], rights, grantor, grantOption, cascade);
        }
    }

    public void revoke(OrderedHashSet granteeList, NameManager.ObjectName schemaName, Right rights, Grantee grantor, boolean grantOption, boolean cascade) {
        this.checkGranteeList(granteeList);
        for (int i = 0; i < granteeList.size(); ++i) {
            String granteeName = (String)granteeList.get(i);
            Grantee g = this.get(granteeName);
            g.revokeForSchema(schemaName, rights, grantor, grantOption);
            if (!g.isGroup) continue;
            this.updateAllRights(g);
        }
    }

    public void revoke(OrderedHashSet granteeList, NameManager.ObjectName schemaName, SchemaPermission permission) {
        this.checkGranteeList(granteeList);
        for (int i = 0; i < granteeList.size(); ++i) {
            String granteeName = (String)granteeList.get(i);
            Grantee g = this.get(granteeName);
            g.revokeForSchema(schemaName, permission);
            if (!g.isGroup) continue;
            this.updateAllRights(g);
        }
    }

    void removeEmptyRole(Grantee role) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee grantee = (Grantee)this.map.get(i);
            grantee.roles.remove(role);
        }
    }

    public void removeDbObject(NameManager.ObjectName name) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee g = (Grantee)this.map.get(i);
            g.revokeDbObject(name);
        }
    }

    public void removeDbObjects(OrderedHashSet nameSet) {
        Iterator it = nameSet.iterator();
        while (it.hasNext()) {
            NameManager.ObjectName name = (NameManager.ObjectName)it.next();
            for (int i = 0; i < this.map.size(); ++i) {
                Grantee g = (Grantee)this.map.get(i);
                g.revokeDbObject(name);
            }
        }
    }

    void updateAllRights(Grantee role) {
        Grantee grantee;
        int i;
        for (i = 0; i < this.map.size(); ++i) {
            grantee = (Grantee)this.map.get(i);
            if (!grantee.isGroup) continue;
            grantee.updateNestedRoles(role);
        }
        for (i = 0; i < this.map.size(); ++i) {
            grantee = (Grantee)this.map.get(i);
            if (grantee.isGroup) continue;
            grantee.updateAllRights();
        }
    }

    public boolean removeGrantee(String name) {
        if (GranteeManager.isReserved(name)) {
            return false;
        }
        Grantee g = (Grantee)this.map.remove(new CIString(name));
        if (g == null) {
            return false;
        }
        g.clearPrivileges();
        this.updateAllRights(g);
        if (g.isGroup) {
            this.groupMap.remove(new CIString(name));
            this.removeEmptyRole(g);
        }
        return true;
    }

    public Grantee addGroup(NameManager.ObjectName name) {
        if (this.map.containsKey(new CIString(name.name))) {
            throw Error.error(4003, name.name);
        }
        Grantee g = new Grantee(name, this);
        g.isGroup = true;
        this.map.put(new CIString(name.name), g);
        this.groupMap.add(new CIString(name.name), g);
        return g;
    }

    public UserWrapper addUser(NameManager.ObjectName name) {
        if (this.map.containsKey(new CIString(name.name))) {
            throw Error.error(4003, name.name);
        }
        UserWrapper g = new UserWrapper(name, this);
        this.map.put(new CIString(name.name), g);
        return g;
    }

    boolean isGrantee(String name) {
        return this.map.containsKey(new CIString(name));
    }

    public static int getCheckSingleRight(String right) {
        int r = GranteeManager.getRight(right);
        if (r != 0) {
            return r;
        }
        throw Error.error(5581, right);
    }

    public static int getRight(String right) {
        return rightsStringLookup.get((Object)right.toUpperCase(), 0);
    }

    public Grantee get(String name) {
        return (Grantee)this.map.get(new CIString(name));
    }

    public Collection getGrantees() {
        return this.map.values();
    }

    public static boolean validRightString(String rightString) {
        return GranteeManager.getRight(rightString) != 0;
    }

    public static boolean isImmutable(String name) {
        return name.equalsIgnoreCase("sysadmin");
    }

    public static boolean isReserved(String name) {
        return name.equalsIgnoreCase("sysadmin") || name.equalsIgnoreCase("Admins") || name.equalsIgnoreCase("Users");
    }

    public void dropRole(String name) {
        if (!this.isRole(name)) {
            throw Error.error(2200, name);
        }
        if (GranteeManager.isReserved(name)) {
            throw Error.error(5507);
        }
        this.removeGrantee(name);
    }

    public Set getRoleNames() {
        return this.groupMap.keySet();
    }

    public Collection getRoles() {
        return this.groupMap.values();
    }

    public Grantee getGroup(String name) {
        Grantee g = (Grantee)this.groupMap.get(new CIString(name));
        if (g == null) {
            throw Error.error(2200, name);
        }
        return g;
    }

    public boolean isRole(String name) {
        return this.groupMap.containsKey(new CIString(name));
    }

    public String[] getSQL() {
        HsqlArrayList list = new HsqlArrayList();
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getRightsSQL(int loggedStatements) {
        HsqlArrayList list = new HsqlArrayList();
        Iterator grantees = this.getGrantees().iterator();
        while (grantees.hasNext()) {
            Grantee grantee = (Grantee)grantees.next();
            String name = grantee.getObjectName().getNameString();
            if (GranteeManager.isImmutable(name)) continue;
            HsqlArrayList subList = grantee.getRightsSQL(loggedStatements + list.size());
            list.addAll(subList);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    static {
        NameManager.ObjectName name = NameManager.newSystemObjectName("sysadmin", 12);
        systemAuthorisation = new UserWrapper(name, null);
        GranteeManager.systemAuthorisation.isSystem = true;
        systemAuthorisation.setAdminDirect();
        systemAuthorisation.setInitialSchema(SqlInvariants.SYSTEM_SCHEMA_NAME);
        SqlInvariants.SYS_SCHEMA_NAME.owner = systemAuthorisation;
        SqlInvariants.SDS_SCHEMA_NAME.owner = systemAuthorisation;
        SqlInvariants.SCH_SCHEMA_NAME.owner = systemAuthorisation;
        SqlInvariants.SYSTEM_SCHEMA_NAME.owner = systemAuthorisation;
        SqlInvariants.LOBS_SCHEMA_NAME.owner = systemAuthorisation;
        SqlInvariants.FLOBS_SCHEMA_NAME.owner = systemAuthorisation;
        SqlInvariants.RDS_SCHEMA_NAME.owner = systemAuthorisation;
        rightsStringLookup = new IntValueHashMap(7);
        rightsStringLookup.put("ALL", 63);
        rightsStringLookup.put("SELECT", 1);
        rightsStringLookup.put("UPDATE", 8);
        rightsStringLookup.put("DELETE", 2);
        rightsStringLookup.put("INSERT", 4);
        rightsStringLookup.put("EXECUTE", 32);
        rightsStringLookup.put("USAGE", 16);
        rightsStringLookup.put("REFERENCES", 64);
        rightsStringLookup.put("TRIGGER", 128);
    }
}

