/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.rights;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.MultiValueHashMap;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.rights.GranteeManager;
import com.streamscape.ds.rights.Right;
import com.streamscape.ds.rights.SchemaPermission;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.function.Function;

public class Grantee
implements SchemaObject {
    boolean isGroup;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    boolean isSchemaCreator = false;
    boolean isPublic = false;
    boolean isSystem = false;
    boolean dataspaceCreationCapable = false;
    transient NameManager.ObjectName granteeName;
    private MultiValueHashMap directRightsMap;
    HashMap fullRightsMap;
    OrderedHashSet roles;
    private MultiValueHashMap grantedRightsMap;
    transient GranteeManager granteeManager;
    protected Right ownerRights;
    private MultiValueHashMap schemaRightsMap;
    private HashMap schemaPermissionMap;
    private final Object retrieveItMutex = new Object();

    Grantee(NameManager.ObjectName name, GranteeManager man) {
        this.fullRightsMap = new HashMap();
        this.directRightsMap = new MultiValueHashMap();
        this.grantedRightsMap = new MultiValueHashMap();
        this.schemaRightsMap = new MultiValueHashMap();
        this.schemaPermissionMap = new HashMap();
        this.granteeName = name;
        this.granteeManager = man;
        this.roles = new OrderedHashSet();
        this.ownerRights = new Right();
        this.ownerRights.isFull = true;
        this.ownerRights.grantor = GranteeManager.systemAuthorisation;
        this.ownerRights.grantee = this;
    }

    @Override
    public int getObjectType() {
        return 12;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.granteeName;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return null;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return null;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.granteeName.statementName);
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("ROLE");
        sb.append(' ').append(name);
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public boolean isRole() {
        return this.isGroup;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public OrderedHashSet getDirectRoles() {
        return this.roles;
    }

    public OrderedHashSet getAllRoles() {
        OrderedHashSet set = this.getGranteeAndAllRoles();
        set.remove(this);
        return set;
    }

    public OrderedHashSet getGranteeAndAllRoles() {
        OrderedHashSet set = new OrderedHashSet();
        this.addGranteeAndRoles(set);
        return set;
    }

    public OrderedHashSet getGranteeAndAllRolesWithPublic() {
        OrderedHashSet set = new OrderedHashSet();
        this.addGranteeAndRoles(set);
        set.add(this.granteeManager.usersGroup);
        return set;
    }

    public boolean isAccessible(NameManager.ObjectName name, int privilegeType) {
        if (this.isFullyAccessibleByRole(name)) {
            return true;
        }
        return this.checkFullRights(name, (Right right) -> right.canAccess(privilegeType));
    }

    public boolean isAccessible(SchemaObject object) {
        return this.isAccessible(object.getObjectName());
    }

    public boolean isAccessible(NameManager.ObjectName name) {
        if (this.isFullyAccessibleByRole(name)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        if (right != null && !right.isEmpty()) {
            return true;
        }
        Iterator iter = this.schemaRightsMap.get(name.schema);
        if (iter.hasNext()) {
            return true;
        }
        if (!this.isPublic) {
            return this.granteeManager.usersGroup.isAccessible(name);
        }
        return false;
    }

    private OrderedHashSet addGranteeAndRoles(OrderedHashSet set) {
        set.add(this);
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee candidateRole = (Grantee)this.roles.get(i);
            if (set.contains(candidateRole)) continue;
            candidateRole.addGranteeAndRoles(set);
        }
        return set;
    }

    private boolean hasRoleDirect(Grantee role) {
        return this.roles.contains(role);
    }

    public boolean hasRole(Grantee role) {
        return this.getAllRoles().contains(role);
    }

    void grant(NameManager.ObjectName name, Right right, Grantee grantor, boolean withGrant) {
        Right grantableRights = grantor.getAllGrantableRights(name);
        Right existingRight = null;
        if (right == Right.fullRights) {
            if (grantableRights.isEmpty()) {
                return;
            }
            right = grantableRights;
        } else if (!grantableRights.contains(right)) {
            throw Error.error(2000);
        }
        Iterator it = this.directRightsMap.get(name);
        while (it.hasNext()) {
            Right existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
            existingRight = existing;
            existingRight.add(right);
            break;
        }
        if (existingRight == null) {
            existingRight = right.duplicate();
            existingRight.grantor = grantor;
            existingRight.grantee = this;
            this.directRightsMap.put(name, existingRight);
        }
        if (withGrant) {
            if (existingRight.grantableRights == null) {
                existingRight.grantableRights = right.duplicate();
            } else {
                existingRight.grantableRights.add(right);
            }
        }
        if (!grantor.isSystem()) {
            grantor.grantedRightsMap.put(name, existingRight);
        }
        this.updateAllRights();
    }

    void grantForSchema(NameManager.ObjectName schemaName, Right right, Grantee grantor, boolean withGrant) {
        Right existingRight = null;
        Iterator it = this.schemaRightsMap.get(schemaName);
        while (it.hasNext()) {
            Right existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
            existingRight = existing;
            existingRight.add(right);
            break;
        }
        if (existingRight == null) {
            existingRight = right.duplicate();
            existingRight.grantor = grantor;
            existingRight.grantee = this;
            this.schemaRightsMap.put(schemaName, existingRight);
        }
        if (withGrant) {
            if (existingRight.grantableRights == null) {
                existingRight.grantableRights = right.duplicate();
            } else {
                existingRight.grantableRights.add(right);
            }
        }
    }

    void grantForSchema(NameManager.ObjectName schemaName, SchemaPermission permission) {
        if (permission == SchemaPermission.dataspaceUsePermission) {
            this.schemaPermissionMap.put(schemaName, permission);
        }
        this.updateAllRights();
    }

    void revokeForSchema(NameManager.ObjectName schemaName, SchemaPermission permission) {
        if (permission == SchemaPermission.dataspaceUsePermission) {
            this.schemaPermissionMap.put(schemaName, SchemaPermission.dataspaceNotUsePermission);
        }
        this.updateAllRights();
    }

    void revoke(SchemaObject object, Right right, Grantee grantor, boolean grantOption) {
        NameManager.ObjectName name = object.getObjectName();
        if (object instanceof RplScript) {
            name = ((RplScript)object).getSpecificName();
        }
        Iterator it = this.directRightsMap.get(name);
        Right existing = null;
        while (it.hasNext()) {
            existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
        }
        if (existing == null) {
            return;
        }
        if (existing.grantableRights != null) {
            existing.grantableRights.remove(object, right);
        }
        if (grantOption) {
            return;
        }
        if (right.isFull) {
            this.directRightsMap.remove(name, existing);
            grantor.grantedRightsMap.remove(name, existing);
            this.updateAllRights();
            return;
        }
        existing.remove(object, right);
        if (existing.isEmpty()) {
            this.directRightsMap.remove(name, existing);
            grantor.grantedRightsMap.remove(name, existing);
        }
        this.updateAllRights();
    }

    void revokeForSchema(NameManager.ObjectName schemaName, Right right, Grantee grantor, boolean grantOption) {
        Iterator it = this.schemaRightsMap.get(schemaName);
        Right existing = null;
        while (it.hasNext()) {
            existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
        }
        if (existing == null) {
            return;
        }
        if (grantOption) {
            return;
        }
        if (right.isFull) {
            this.schemaRightsMap.remove(schemaName, existing);
            this.updateAllRights();
            return;
        }
        if (existing.isEmpty()) {
            this.schemaRightsMap.remove(schemaName, existing);
        } else {
            if (right.isExec) {
                existing.isExec = false;
            }
            if (right.isFullSelect) {
                existing.isFullSelect = false;
            }
            if (right.isUsage) {
                existing.isUsage = false;
            }
            if (right.isFullDelete) {
                existing.isFullDelete = false;
            }
            if (right.isFullInsert) {
                existing.isFullInsert = false;
            }
            if (right.isFullReferences) {
                existing.isFullReferences = false;
            }
            if (right.isFullTrigger) {
                existing.isFullTrigger = false;
            }
            if (right.isFullUpdate) {
                existing.isFullUpdate = false;
            }
        }
        this.updateAllRights();
    }

    void revokeDbObject(NameManager.ObjectName name) {
        this.directRightsMap.remove(name);
        this.grantedRightsMap.remove(name);
        this.fullRightsMap.remove(name);
    }

    void clearPrivileges() {
        this.roles.clear();
        this.directRightsMap.clear();
        this.grantedRightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdmin = false;
    }

    public OrderedHashSet getColumnsForAllPrivileges(SchemaObject object) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return table.getColumnNameSet();
            }
            Right right = (Right)this.fullRightsMap.get(table.getObjectName());
            return right == null ? Right.emptySet : right.getColumnsForAllRights(table);
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllDirectPrivileges(SchemaObject object) {
        Iterator rights;
        if (object.getOwner() == this) {
            OrderedHashSet set = new OrderedHashSet();
            set.add(this.ownerRights);
            return set;
        }
        NameManager.ObjectName name = object.getObjectName();
        if (object instanceof RplScript) {
            name = ((RplScript)object).getSpecificName();
        }
        if ((rights = this.directRightsMap.get(name)).hasNext()) {
            OrderedHashSet set = new OrderedHashSet();
            while (rights.hasNext()) {
                set.add(rights.next());
            }
            return set;
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllGrantedPrivileges(SchemaObject object) {
        Iterator rights;
        NameManager.ObjectName name = object.getObjectName();
        if (object instanceof RplScript) {
            name = ((RplScript)object).getSpecificName();
        }
        if ((rights = this.grantedRightsMap.get(name)).hasNext()) {
            OrderedHashSet set = new OrderedHashSet();
            while (rights.hasNext()) {
                set.add(rights.next());
            }
            return set;
        }
        return Right.emptySet;
    }

    public void checkSelect(SchemaObject object, boolean[] checkList) {
        String objectName = object.getObjectName().name;
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return;
            }
            ArrayList errorFieldsOut = new ArrayList();
            if (this.checkFullRights(table.getObjectName(), (Right right) -> right != null && right.canSelect(table, checkList, errorFieldsOut))) {
                return;
            }
            if (!errorFieldsOut.isEmpty()) {
                objectName = (String)errorFieldsOut.get(0);
            }
        }
        throw Error.error(5501, objectName);
    }

    public OrderedHashSet getSelectColumnSet(SchemaObject object) {
        String objectName = object.getObjectName().name;
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return null;
            }
            Right right = (Right)this.fullRightsMap.get(table.getObjectName());
            if (right != null) {
                return right.selectColumnSet;
            }
        }
        throw Error.error(5501, objectName);
    }

    public OrderedHashSet getDisclosableFields(SchemaObject object) {
        String objectName = object.getObjectName().name;
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return null;
            }
            if (this.checkFullRights(table.getObjectName(), (Right right) -> right.canAccessFully(1) || right.canAccessFully(4) || right.canAccessFully(8))) {
                return null;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getObjectName());
            OrderedHashSet columns = new OrderedHashSet();
            if (right2 == null) {
                return columns;
            }
            if (right2.selectColumnSet != null) {
                columns.addAll(right2.selectColumnSet);
            }
            if (right2.updateColumnSet != null) {
                columns.addAll(right2.updateColumnSet);
            }
            if (right2.insertColumnSet != null) {
                columns.addAll(right2.updateColumnSet);
            }
            return columns;
        }
        throw Error.error(5501, objectName);
    }

    public boolean isDisclosableField(SchemaObject object, ColumnSchema column) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return true;
            }
            if (this.checkFullRights(table.getObjectName(), (Right right) -> right.canAccessFully(1) || right.canAccessFully(4) || right.canAccessFully(8))) {
                return true;
            }
            Right right2 = (Right)this.fullRightsMap.get(table.getObjectName());
            if (right2 == null) {
                return false;
            }
            NameManager.ObjectName columnName = column.getObjectName();
            if (right2.selectColumnSet != null && right2.selectColumnSet.contains(columnName)) {
                return true;
            }
            if (right2.updateColumnSet != null && right2.updateColumnSet.contains(columnName)) {
                return true;
            }
            return right2.insertColumnSet != null && right2.insertColumnSet.contains(columnName);
        }
        throw Error.error(5501, object.getObjectName().name);
    }

    public boolean isDisclosableSelectField(SchemaObject object, ColumnSchema column) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return true;
            }
            return this.checkFullRights(table, (Right right) -> right.canAccessFully(1) || right.selectColumnSet != null && right.selectColumnSet.contains(column.getObjectName()));
        }
        throw Error.error(5501, object.getObjectName().name);
    }

    public void checkInsert(SchemaObject object, boolean[] checkList) {
        String objectName = object.getObjectName().name;
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return;
            }
            ArrayList errorFieldsOut = new ArrayList();
            if (this.checkFullRights(table.getObjectName(), (Right right) -> right.canInsert(table, checkList, errorFieldsOut))) {
                return;
            }
            if (!errorFieldsOut.isEmpty()) {
                objectName = (String)errorFieldsOut.get(0);
            }
        }
        throw Error.error(5501, objectName);
    }

    public void checkUpdate(SchemaObject object, boolean[] checkList) {
        String objectName = object.getObjectName().name;
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return;
            }
            ArrayList errorFieldsOut = new ArrayList();
            if (this.checkFullRights(table.getObjectName(), (Right right) -> right.canUpdate(table, checkList, errorFieldsOut))) {
                return;
            }
            if (!errorFieldsOut.isEmpty()) {
                objectName = (String)errorFieldsOut.get(0);
            }
        }
        throw Error.error(5501, objectName);
    }

    public void checkReferences(SchemaObject object, boolean[] checkList) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return;
            }
            if (this.checkFullRights(table.getObjectName(), (Right right) -> right.canReference(table, checkList))) {
                return;
            }
        }
        throw Error.error(5501, object.getObjectName().name);
    }

    public void checkUsage(SchemaObject object) {
        if (this.isAdmin()) {
            return;
        }
        Right fullRight = (Right)this.fullRightsMap.get(object.getObjectName());
        if (fullRight != null && fullRight.isUsage) {
            return;
        }
        Iterator it = this.directRightsMap.get(object.getObjectName());
        while (it.hasNext()) {
            Right r = (Right)it.next();
            if (!r.isUsage) continue;
            return;
        }
        throw Error.error(5501, object.getObjectName().name);
    }

    public void checkTrigger(SchemaObject object, boolean[] checkList) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return;
            }
            Right right = (Right)this.fullRightsMap.get(table.getObjectName());
            if (right != null && right.canReference(table, checkList)) {
                return;
            }
        }
        throw Error.error(5501, object.getObjectName().name);
    }

    public void checkDelete(SchemaObject object) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return;
            }
            if (this.checkFullRights(table.getObjectName(), (Right right) -> right.canDelete())) {
                return;
            }
        }
        throw Error.error(5501, object.getObjectName().name);
    }

    public void checkAccess(SchemaObject object) {
        if (this.isFullyAccessibleByRole(object.getObjectName())) {
            return;
        }
        NameManager.ObjectName name = object.getObjectName();
        if (object instanceof RplScript) {
            name = ((RplScript)object).getSpecificName();
        }
        if (this.checkFullRights(name, (Right right) -> right.isExec || right.isFull)) {
            return;
        }
        throw Error.error(5501, object.getObjectName().name);
    }

    public boolean canAccessDataspace(SchemaObject schemaObject) {
        NameManager.ObjectName schemaObjectName = schemaObject.getObjectName();
        if (this.isFullyAccessibleByRole(schemaObjectName)) {
            return true;
        }
        if (schemaObjectName.equals(SqlInvariants.SYS_SCHEMA_NAME)) {
            return true;
        }
        if (schemaObjectName.equals(SqlInvariants.SDS_SCHEMA_NAME)) {
            return true;
        }
        if (schemaObjectName.equals(SqlInvariants.SCH_SCHEMA_NAME)) {
            return true;
        }
        if (schemaObjectName.equals(SqlInvariants.RDS_SCHEMA_NAME)) {
            return true;
        }
        SchemaPermission permission = (SchemaPermission)this.schemaPermissionMap.get(schemaObjectName);
        if (permission == null) {
            return true;
        }
        return permission.isDataspaceUse();
    }

    public void checkAccessDataspace(SchemaObject schemaObject) {
        if (!this.canAccessDataspace(schemaObject)) {
            throw Error.error(5501, schemaObject.getObjectName().name);
        }
    }

    public void checkSchemaUpdateOrGrantRights(String schemaName) {
        if (!this.hasSchemaUpdateOrGrantRights(schemaName)) {
            throw new DataspaceException("user lacks privilege or unsupported statement in dataspace: " + schemaName);
        }
    }

    public boolean hasSchemaUpdateOrGrantRights(String schemaName) {
        if (this.isAdmin() && this.isSudoCapable()) {
            return true;
        }
        Grantee schemaOwner = this.granteeManager.store.schemaManager.toSchemaOwner(schemaName);
        if (schemaOwner == this) {
            return true;
        }
        return this.hasRole(schemaOwner);
    }

    boolean isGrantable(SchemaObject object, Right right) {
        return this.isFullyAccessibleByRole(object.getObjectName());
    }

    boolean isGrantable(Grantee role) {
        return this.isAdmin;
    }

    public boolean isFullyAccessibleByRole(NameManager.ObjectName name) {
        Grantee owner;
        if (this.isAdmin) {
            if (this.isSudoCapable()) {
                return true;
            }
            NameManager.ObjectName schemaName = null;
            if (name.schema != null) {
                schemaName = name.schema;
            } else if (name.type == 2) {
                schemaName = name;
            }
            if (schemaName == SqlInvariants.SYS_SCHEMA_NAME) {
                return true;
            }
            if (schemaName == SqlInvariants.SDS_SCHEMA_NAME) {
                return true;
            }
            if (schemaName == SqlInvariants.SCH_SCHEMA_NAME) {
                return true;
            }
            if (schemaName == SqlInvariants.RDS_SCHEMA_NAME) {
                return true;
            }
        }
        if (name.type == 2) {
            owner = name.owner;
        } else {
            if (name.schema == null) {
                return false;
            }
            owner = name.schema.owner;
        }
        if (owner == this) {
            return true;
        }
        return this.hasRole(owner);
    }

    public void checkAdmin() {
        if (!this.isAdmin()) {
            throw Error.error(5507);
        }
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean canCreateDataspace() {
        return this.isAdmin || this.dataspaceCreationCapable;
    }

    public boolean canChangeAuthorisation() {
        return this.isAdmin || this.isSudoCapable();
    }

    public boolean isSudoCapable() {
        return false;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public OrderedHashSet visibleGrantees() {
        OrderedHashSet grantees = new OrderedHashSet();
        GranteeManager gm = this.granteeManager;
        if (this.isAdmin()) {
            grantees.addAll(gm.getGrantees());
        } else {
            grantees.add(this);
            Iterator it = this.getAllRoles().iterator();
            while (it.hasNext()) {
                grantees.add(it.next());
            }
        }
        return grantees;
    }

    public boolean hasNonSelectTableRight(SchemaObject table) {
        if (table != null) {
            if (this.isFullyAccessibleByRole(table.getObjectName())) {
                return true;
            }
            Right right = (Right)this.fullRightsMap.get(table.getObjectName());
            if (right == null) {
                return false;
            }
            return right.canAccessNonSelect();
        }
        return false;
    }

    public boolean hasColumnRights(SchemaObject table, int[] columnMap) {
        if (this.isFullyAccessibleByRole(table.getObjectName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(table.getObjectName());
        if (right == null) {
            return false;
        }
        return right.canAccess((Table)table, columnMap);
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(Grantee role) {
        boolean hasNested = false;
        if (role != this) {
            for (int i = 0; i < this.roles.size(); ++i) {
                Grantee currentRole = (Grantee)this.roles.get(i);
                hasNested |= currentRole.updateNestedRoles(role);
            }
        }
        if (hasNested) {
            this.updateAllRights();
        }
        return hasNested || role == this;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee currentRole = (Grantee)this.roles.get(i);
            this.addToFullRights(currentRole.fullRightsMap);
            this.addToSchemaPermissions(currentRole.schemaPermissionMap);
            this.isAdmin |= currentRole.isAdmin();
        }
        this.addToFullRights(this.directRightsMap);
        if (!(this.isGroup || this.isPublic || this.isSystem)) {
            this.addToFullRights(this.granteeManager.usersGroup.fullRightsMap);
        }
    }

    private void addToSchemaPermissions(HashMap newSchemaPermissionMap) {
        Iterator schemaName = newSchemaPermissionMap.keySet().iterator();
        while (schemaName.hasNext()) {
            NameManager.ObjectName currentSchemaName = (NameManager.ObjectName)schemaName.next();
            SchemaPermission permission = (SchemaPermission)newSchemaPermissionMap.get(currentSchemaName);
            this.schemaPermissionMap.put(currentSchemaName, permission);
        }
    }

    void addToFullRights(HashMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Right add = (Right)map.get(key);
            Right existing = (Right)this.fullRightsMap.get(key);
            if (existing == null) {
                existing = add.duplicate();
                this.fullRightsMap.put(key, existing);
            } else {
                existing.add(add);
            }
            if (add.grantableRights == null) continue;
            if (existing.grantableRights == null) {
                existing.grantableRights = add.grantableRights.duplicate();
                continue;
            }
            existing.grantableRights.add(add.grantableRights);
        }
    }

    private void addToFullRights(MultiValueHashMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Iterator values = map.get(key);
            Right existing = (Right)this.fullRightsMap.get(key);
            while (values.hasNext()) {
                Right add = (Right)values.next();
                if (existing == null) {
                    existing = add.duplicate();
                    this.fullRightsMap.put(key, existing);
                } else {
                    existing.add(add);
                }
                if (add.grantableRights == null) continue;
                if (existing.grantableRights == null) {
                    existing.grantableRights = add.grantableRights.duplicate();
                    continue;
                }
                existing.grantableRights.add(add.grantableRights);
            }
        }
    }

    Right getAllGrantableRights(NameManager.ObjectName name) {
        if (this.isAdmin) {
            return name.schema.owner.ownerRights;
        }
        if (name.schema.owner == this) {
            return this.ownerRights;
        }
        if (this.roles.contains(name.schema.owner)) {
            return name.schema.owner.ownerRights;
        }
        OrderedHashSet set = this.getAllRoles();
        for (int i = 0; i < set.size(); ++i) {
            Grantee role = (Grantee)set.get(i);
            if (name.schema.owner != role) continue;
            return role.ownerRights;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        return right == null || right.grantableRights == null ? Right.noRights : right.grantableRights;
    }

    private MultiValueHashMap getRights() {
        return this.directRightsMap;
    }

    void grant(Grantee role) {
        this.roles.add(role);
    }

    void revoke(Grantee role) {
        if (!this.hasRoleDirect(role)) {
            throw Error.error(2253, role.getObjectName().getNameString());
        }
        this.roles.remove(role);
    }

    HsqlArrayList getRightsSQL(int loggedStatements) {
        AbstractStringBuilder sb;
        HsqlArrayList list = new HsqlArrayList();
        MultiValueHashMap rightsMap = this.getRights();
        Iterator dbObjects = rightsMap.keySet().iterator();
        while (dbObjects.hasNext()) {
            Object nameObject = dbObjects.next();
            Iterator rights = rightsMap.get(nameObject);
            while (rights.hasNext()) {
                Right right = (Right)rights.next();
                StringBuffer sb2 = new StringBuffer(128);
                NameManager.ObjectName hsqlname = (NameManager.ObjectName)nameObject;
                NameManager.ObjectName objectName = null;
                switch (hsqlname.type) {
                    case 3: 
                    case 5: {
                        Table table = this.granteeManager.store.schemaManager.findUserTable(null, hsqlname.name, hsqlname.schema.name);
                        if (table == null) break;
                        sb2.append("GRANT").append(' ');
                        sb2.append(right.getTableRightsSQL(table));
                        sb2.append(' ').append("ON").append(' ');
                        sb2.append("TABLE").append(' ');
                        sb2.append(hsqlname.getSchemaQualifiedStatementName());
                        objectName = table.getObjectName();
                        break;
                    }
                    case 8: {
                        NumberSequence sequence = (NumberSequence)this.granteeManager.store.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 8);
                        if (sequence == null) break;
                        sb2.append("GRANT").append(' ');
                        sb2.append("USAGE");
                        sb2.append(' ').append("ON").append(' ');
                        sb2.append("SEQUENCE").append(' ');
                        sb2.append(hsqlname.getSchemaQualifiedStatementName());
                        objectName = sequence.getObjectName();
                        break;
                    }
                    case 14: {
                        Type domain = (Type)this.granteeManager.store.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 14);
                        if (domain == null || hsqlname.schema.name.equals("SYS")) break;
                        sb2.append("GRANT").append(' ');
                        sb2.append("USAGE");
                        sb2.append(' ').append("ON").append(' ');
                        sb2.append("DOMAIN").append(' ');
                        sb2.append(hsqlname.getSchemaQualifiedStatementName());
                        objectName = domain.getObjectName();
                        break;
                    }
                    case 13: {
                        Type type = (Type)this.granteeManager.store.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 13);
                        if (type == null || hsqlname.schema.name.equals("SYS")) break;
                        sb2.append("GRANT").append(' ');
                        sb2.append("USAGE");
                        sb2.append(' ').append("ON").append(' ');
                        sb2.append("TYPE").append(' ');
                        sb2.append(hsqlname.getSchemaQualifiedStatementName());
                        objectName = type.getObjectName();
                        break;
                    }
                    case 27: {
                        sb2.append("GRANT").append(' ');
                        sb2.append("USAGE");
                        sb2.append(' ').append("ON").append(' ');
                        sb2.append(hsqlname.getSchemaQualifiedStatementName());
                        ServerObject serverObject = (ServerObject)this.granteeManager.store.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 27);
                        if (serverObject == null) break;
                        objectName = serverObject.getObjectName();
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 25: {
                        SchemaObject routine = this.granteeManager.store.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, hsqlname.type);
                        if (routine == null) break;
                        sb2.append("GRANT").append(' ');
                        sb2.append(right.isFull ? "ALL" : "EXECUTE").append(' ');
                        sb2.append("ON").append(' ');
                        sb2.append("SPECIFIC").append(' ');
                        if (routine.getObjectType() == 18) {
                            sb2.append("PROCEDURE");
                        } else {
                            sb2.append("FUNCTION");
                        }
                        sb2.append(' ');
                        sb2.append(hsqlname.getSchemaQualifiedStatementName());
                        objectName = routine.getObjectName();
                    }
                }
                if (sb2.length() == 0) continue;
                sb2.append(' ').append("TO").append(' ');
                sb2.append(this.getObjectName().getStatementName());
                list.add(sb2.toString());
                if (objectName == null) continue;
                DataspaceStore.DDLRecordNode node = new DataspaceStore.DDLRecordNode();
                node.objectName = objectName.getSchemaQualifiedStatementName();
                node.dataspaceId = objectName.schema.getId();
                node.objectId = objectName.getId();
                node.type = LogRecordType.OTHER;
                this.granteeManager.store.logIndexBuilder.put(loggedStatements + list.size() - 1, node);
            }
        }
        rightsMap = this.schemaRightsMap;
        Iterator schemas = rightsMap.keySet().iterator();
        while (schemas.hasNext()) {
            Object nameObject = schemas.next();
            Iterator rights = rightsMap.get(nameObject);
            NameManager.ObjectName hsqlname = (NameManager.ObjectName)nameObject;
            list.add("SET DATASPACE " + hsqlname.getSchemaQualifiedStatementName());
            while (rights.hasNext()) {
                Right right = (Right)rights.next();
                sb = new StringBuilder();
                ((StringBuilder)sb).append("GRANT");
                if (right.isFull) {
                    ((StringBuilder)sb).append(' ').append("ALL").append(' ');
                } else {
                    StringBuilder sb1;
                    if (right.isExec) {
                        sb1 = new StringBuilder();
                        sb1.append("GRANT");
                        sb1.append(' ').append("EXECUTE").append(' ');
                        sb1.append("TO").append(' ');
                        sb1.append(this.getObjectName().getStatementName());
                        list.add(sb1.toString());
                    }
                    if (right.isUsage) {
                        sb1 = new StringBuilder();
                        sb1.append("GRANT");
                        sb1.append(' ').append("USAGE").append(' ');
                        sb1.append("TO").append(' ');
                        sb1.append(this.getObjectName().getStatementName());
                        list.add(sb1.toString());
                    }
                    if (right.isFullDelete) {
                        if (((StringBuilder)sb).charAt(((StringBuilder)sb).length() - 1) == ' ') {
                            ((StringBuilder)sb).setCharAt(((StringBuilder)sb).length() - 1, ',');
                        }
                        ((StringBuilder)sb).append(' ').append("DELETE").append(' ');
                    }
                    if (right.isFullInsert) {
                        if (((StringBuilder)sb).charAt(((StringBuilder)sb).length() - 1) == ' ') {
                            ((StringBuilder)sb).setCharAt(((StringBuilder)sb).length() - 1, ',');
                        }
                        ((StringBuilder)sb).append(' ').append("INSERT").append(' ');
                    }
                    if (right.isFullSelect) {
                        if (((StringBuilder)sb).charAt(((StringBuilder)sb).length() - 1) == ' ') {
                            ((StringBuilder)sb).setCharAt(((StringBuilder)sb).length() - 1, ',');
                        }
                        ((StringBuilder)sb).append(' ').append("SELECT").append(' ');
                    }
                    if (right.isFullUpdate) {
                        if (((StringBuilder)sb).charAt(((StringBuilder)sb).length() - 1) == ' ') {
                            ((StringBuilder)sb).setCharAt(((StringBuilder)sb).length() - 1, ',');
                        }
                        ((StringBuilder)sb).append(' ').append("UPDATE").append(' ');
                    }
                }
                if (((StringBuilder)sb).charAt(((StringBuilder)sb).length() - 1) != ' ') continue;
                ((StringBuilder)sb).append("TO").append(' ');
                ((StringBuilder)sb).append(this.getObjectName().getStatementName());
                list.add(((StringBuilder)sb).toString());
            }
        }
        Iterator schemaName = this.schemaPermissionMap.keySet().iterator();
        if (!this.isGroup) {
            while (schemaName.hasNext()) {
                SchemaPermission permission;
                NameManager.ObjectName currentSchemaName = (NameManager.ObjectName)schemaName.next();
                DataspaceSchema dbSchema = this.granteeManager.store.schemaManager.findSchema(currentSchemaName.name);
                if (dbSchema == null || (permission = (SchemaPermission)this.schemaPermissionMap.get(currentSchemaName)).isDataspaceUse()) continue;
                sb = new StringBuffer(128);
                list.add("SET DATASPACE " + currentSchemaName.getSchemaQualifiedStatementName());
                ((StringBuffer)sb).append("REVOKE").append(' ');
                ((StringBuffer)sb).append("USE").append(' ');
                ((StringBuffer)sb).append("FROM").append(' ');
                ((StringBuffer)sb).append(this.getObjectName().getStatementName());
                list.add(((StringBuffer)sb).toString());
            }
        }
        return list;
    }

    public OrderedHashSet getFullRights(SchemaObject schemaObject) {
        return this.getFullRights(schemaObject.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getFullRights(NameManager.ObjectName objectName) {
        OrderedHashSet set = new OrderedHashSet();
        set.add(this.fullRightsMap.get(objectName));
        NameManager.ObjectName schema = objectName.schema;
        if (schema != null) {
            Object object = this.retrieveItMutex;
            synchronized (object) {
                Iterator iter = this.schemaRightsMap.get(schema);
                while (iter.hasNext()) {
                    set.add(iter.next());
                }
            }
        }
        return set;
    }

    public OrderedHashSet getSchemaRights(NameManager.ObjectName name) {
        OrderedHashSet set = new OrderedHashSet();
        Iterator it = this.schemaRightsMap.get(name);
        while (it.hasNext()) {
            set.add(it.next());
        }
        return set;
    }

    private boolean checkFullRights(SchemaObject schemaObject, Function<Right, Boolean> func) {
        return this.checkFullRights(schemaObject.getObjectName(), func);
    }

    private boolean checkFullRights(NameManager.ObjectName objectName, Function<Right, Boolean> func) {
        OrderedHashSet rights = this.getFullRights(objectName);
        for (int i = 0; i < rights.size(); ++i) {
            if (!func.apply((Right)rights.get(i)).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

