/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.result;

import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultLobFactory;
import com.streamscape.ds.result.ResultLobFactoryImpl;
import com.streamscape.lib.utils.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ResultLobFactoryFactory {
    public static ResultLobFactory getLobResultFactory() {
        return ResultLobFactoryHolder.holder;
    }

    public static ResultLobFactory getFlobResultFactory() {
        return ResultFlobFactoryHolder.holder;
    }

    private static class ResultLobFactoryHolder {
        private static ResultLobFactory holder = new ResultLobFactoryImpl();

        private ResultLobFactoryHolder() {
        }
    }

    private static class ResultFlobFactoryHolder {
        private static ResultLobFactory holder = (ResultLobFactory)Proxy.newProxyInstance(ResultLobFactoryFactory.class.getClassLoader(), new Class[]{ResultLobFactory.class}, (InvocationHandler)new ResultFlobFactoryInvocationHandler(new ResultLobFactoryImpl()));

        private ResultFlobFactoryHolder() {
        }

        static class ResultFlobFactoryInvocationHandler
        implements InvocationHandler {
            private ResultLobFactory factory;

            ResultFlobFactoryInvocationHandler(ResultLobFactory factory) {
                this.factory = factory;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    ResultLob resultLob = (ResultLob)method.invoke((Object)this.factory, args);
                    resultLob.setIsFlob(true);
                    return resultLob;
                }
                catch (Throwable exception) {
                    throw Utils.unwrapInvokeException(exception);
                }
            }
        }
    }
}

