/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.result;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.DataOutputStream;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.SessionInterface;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class ResultLob
extends Result {
    long lobID;
    int subType;
    long blockOffset;
    long blockLength;
    byte[] byteBlock;
    char[] charBlock;
    Reader reader;
    public InputStream stream;
    private boolean isFlob = false;

    ResultLob() {
        super(18);
    }

    public void read(DataInput dataInput, boolean readTerminate) throws IOException {
        this.databaseID = dataInput.readInt();
        this.sessionID = dataInput.readLong();
        this.lobID = dataInput.readLong();
        this.subType = dataInput.readInt();
        this.isFlob = dataInput.readInt() != 0;
        switch (this.subType) {
            case 7: 
            case 8: {
                this.blockOffset = dataInput.readLong();
                this.blockLength = dataInput.readLong();
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 12: {
                this.blockOffset = dataInput.readLong();
                this.blockLength = dataInput.readLong();
                break;
            }
            case 2: 
            case 5: {
                this.blockOffset = dataInput.readLong();
                this.blockLength = dataInput.readLong();
                this.byteBlock = new byte[(int)this.blockLength];
                dataInput.readFully(this.byteBlock);
                break;
            }
            case 4: 
            case 6: {
                this.blockOffset = dataInput.readLong();
                this.blockLength = dataInput.readLong();
                this.charBlock = new char[(int)this.blockLength];
                for (int i = 0; i < this.charBlock.length; ++i) {
                    this.charBlock[i] = dataInput.readChar();
                }
                break;
            }
            case 9: 
            case 10: {
                this.blockOffset = dataInput.readLong();
                break;
            }
            case 21: {
                this.blockOffset = dataInput.readLong();
                this.blockLength = dataInput.readLong();
                this.byteBlock = new byte[(int)this.blockLength];
                dataInput.readFully(this.byteBlock);
                break;
            }
            case 23: {
                this.blockOffset = dataInput.readLong();
                this.blockLength = dataInput.readLong();
                this.charBlock = new char[(int)this.blockLength];
                for (int i = 0; i < this.charBlock.length; ++i) {
                    this.charBlock[i] = dataInput.readChar();
                }
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                this.blockLength = dataInput.readLong();
                break;
            }
            case 25: 
            case 26: {
                this.blockOffset = dataInput.readLong();
                break;
            }
            default: {
                throw Error.runtimeError(201, "ResultLob");
            }
        }
        if (readTerminate) {
            dataInput.readByte();
        }
    }

    @Override
    public void write(SessionInterface session, DataOutputStream dataOut, RowOutputInterface rowOut) throws IOException {
        this.writeBody(session, dataOut);
        dataOut.writeByte(0);
        dataOut.flush();
    }

    public void writeBody(SessionInterface session, DataOutputStream dataOut) throws IOException {
        switch (this.subType) {
            case 7: {
                if (this.blockLength >= 0L) {
                    this.writeCreate(session, dataOut);
                    return;
                }
                this.writeCreateByteSegments(session, dataOut);
                return;
            }
            case 8: {
                if (this.blockLength >= 0L) {
                    this.writeCreate(session, dataOut);
                    return;
                }
                this.writeCreateCharSegments(session, dataOut);
                return;
            }
        }
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        dataOut.writeInt(!this.isFlob ? 0 : 1);
        switch (this.subType) {
            case 2: 
            case 5: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.write(this.byteBlock);
                break;
            }
            case 4: 
            case 6: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.writeChars(this.charBlock);
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 12: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                break;
            }
            case 9: 
            case 10: {
                dataOut.writeLong(this.blockOffset);
                break;
            }
            case 21: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.write(this.byteBlock);
                break;
            }
            case 23: {
                dataOut.writeLong(this.blockOffset);
                dataOut.writeLong(this.blockLength);
                dataOut.writeChars(this.charBlock);
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                dataOut.writeLong(this.blockLength);
                break;
            }
            case 25: 
            case 26: {
                dataOut.writeLong(this.blockOffset);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ResultLob");
            }
        }
    }

    private void writeCreate(SessionInterface session, DataOutputStream dataOut) throws IOException {
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        dataOut.writeInt(!this.isFlob ? 0 : 1);
        dataOut.writeLong(this.blockOffset);
        dataOut.writeLong(this.blockLength);
        switch (this.subType) {
            case 7: {
                dataOut.write(this.stream, this.blockLength);
                break;
            }
            case 8: {
                dataOut.write(this.reader, this.blockLength);
            }
        }
    }

    private void writeCreateByteSegments(SessionInterface session, DataOutputStream dataOut) throws IOException {
        int bufferLength = session.getStreamBlockSize();
        long currentOffset = this.blockOffset;
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        HsqlByteArrayOutputStream byteArrayOS = new HsqlByteArrayOutputStream(bufferLength);
        byteArrayOS.reset();
        byteArrayOS.write(this.stream, bufferLength);
        dataOut.writeLong(currentOffset);
        dataOut.writeLong(byteArrayOS.size());
        dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
        currentOffset += (long)byteArrayOS.size();
        if (byteArrayOS.size() < bufferLength) {
            return;
        }
        do {
            byteArrayOS.reset();
            byteArrayOS.write(this.stream, bufferLength);
            if (byteArrayOS.size() == 0) break;
            dataOut.writeByte(this.mode);
            dataOut.writeInt(this.databaseID);
            dataOut.writeLong(this.sessionID);
            dataOut.writeLong(this.lobID);
            dataOut.writeInt(2);
            dataOut.writeLong(currentOffset);
            dataOut.writeLong(byteArrayOS.size());
            dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
            currentOffset += (long)byteArrayOS.size();
        } while (byteArrayOS.size() >= bufferLength);
    }

    private void writeCreateCharSegments(SessionInterface session, DataOutputStream dataOut) throws IOException {
        int bufferLength = session.getStreamBlockSize();
        long currentOffset = this.blockOffset;
        dataOut.writeByte(this.mode);
        dataOut.writeInt(this.databaseID);
        dataOut.writeLong(this.sessionID);
        dataOut.writeLong(this.lobID);
        dataOut.writeInt(this.subType);
        HsqlByteArrayOutputStream byteArrayOS = new HsqlByteArrayOutputStream(bufferLength);
        byteArrayOS.reset();
        byteArrayOS.write(this.reader, bufferLength / 2);
        dataOut.writeLong(currentOffset);
        dataOut.writeLong(byteArrayOS.size() / 2);
        dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
        currentOffset += (long)(byteArrayOS.size() / 2);
        if (byteArrayOS.size() < bufferLength) {
            return;
        }
        do {
            byteArrayOS.reset();
            byteArrayOS.write(this.reader, bufferLength / 2);
            if (byteArrayOS.size() == 0) break;
            dataOut.writeByte(this.mode);
            dataOut.writeInt(this.databaseID);
            dataOut.writeLong(this.sessionID);
            dataOut.writeLong(this.lobID);
            dataOut.writeInt(4);
            dataOut.writeLong(currentOffset);
            dataOut.writeLong(byteArrayOS.size() / 2);
            dataOut.write(byteArrayOS.getBuffer(), 0, byteArrayOS.size());
            currentOffset += (long)(byteArrayOS.size() / 2);
        } while (byteArrayOS.size() >= bufferLength);
    }

    public long getLobID() {
        return this.lobID;
    }

    public int getSubType() {
        return this.subType;
    }

    public long getOffset() {
        return this.blockOffset;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public byte[] getByteArray() {
        return this.byteBlock;
    }

    public char[] getCharArray() {
        return this.charBlock;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public boolean isFlob() {
        return this.isFlob;
    }

    public void setIsFlob(boolean isFlob) {
        this.isFlob = isFlob;
    }

    public static interface LobResultTypes {
        public static final int REQUEST_GET_BYTES = 1;
        public static final int REQUEST_SET_BYTES = 2;
        public static final int REQUEST_GET_CHARS = 3;
        public static final int REQUEST_SET_CHARS = 4;
        public static final int REQUEST_GET_BYTE_PATTERN_POSITION = 5;
        public static final int REQUEST_GET_CHAR_PATTERN_POSITION = 6;
        public static final int REQUEST_CREATE_BYTES = 7;
        public static final int REQUEST_CREATE_CHARS = 8;
        public static final int REQUEST_TRUNCATE = 9;
        public static final int REQUEST_GET_LENGTH = 10;
        public static final int REQUEST_GET_LOB = 11;
        public static final int REQUEST_DUPLICATE_LOB = 12;
        public static final int REQUEST_GET_TRUNCATE_LENGTH = 13;
        public static final int RESPONSE_GET_BYTES = 21;
        public static final int RESPONSE_SET = 22;
        public static final int RESPONSE_GET_CHARS = 23;
        public static final int RESPONSE_GET_BYTE_PATTERN_POSITION = 25;
        public static final int RESPONSE_GET_CHAR_PATTERN_POSITION = 26;
        public static final int RESPONSE_CREATE_BYTES = 27;
        public static final int RESPONSE_CREATE_CHARS = 28;
        public static final int RESPONSE_TRUNCATE = 29;
    }
}

