/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.ds.replication.ReplicationDeliveryMetrics;
import com.streamscape.lib.utils.Pair;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Function;

public class WindowMetricsQueue<T> {
    private int scale;
    private long scaleBoundary;
    private Function<T, Long> scaleValue;
    private Function<T, Long> timestampValue;
    private MetricsAggregator aggregatorTotal;
    private long timeWindow;
    private int countWindow;
    private Queue<T>[] queues;
    private Object[] totals;
    private T total;
    private int totalCount = 0;
    private int maxTimestampIndex = -1;
    private long maxTimestamp = 0L;
    private int minTimestampIndex = -1;
    private long minTimestamp = 0L;
    private long maxScaleValue;
    private long totalResetTime;
    private Map<String, Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>>> minMaxValues = new HashMap<String, Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>>>();

    public WindowMetricsQueue(int scale, long scaleBoundary, Function<T, Long> scaleValue, Function<T, Long> timestampValue, MetricsAggregator aggregatorTotal, long timeWindow, int countWindow) {
        this.scale = scale;
        this.scaleBoundary = scaleBoundary;
        this.scaleValue = scaleValue;
        this.timestampValue = timestampValue;
        this.aggregatorTotal = aggregatorTotal;
        this.timeWindow = timeWindow;
        this.countWindow = countWindow;
        this.queues = new Queue[scale];
        this.totals = new Object[scale];
        this.maxScaleValue = 0L;
    }

    public synchronized void reset() {
        for (Queue<T> queue : this.queues) {
            if (queue == null) continue;
            queue.clear();
        }
        for (Map.Entry entry : this.minMaxValues.entrySet()) {
            ((PriorityQueue)((Pair)((Pair)entry.getValue()).second).first).clear();
            ((PriorityQueue)((Pair)((Pair)entry.getValue()).second).second).clear();
        }
        for (int i = 0; i < this.totals.length; ++i) {
            this.totals[i] = null;
        }
        this.totalResetTime = System.currentTimeMillis();
        this.total = null;
        this.totalCount = 0;
        this.maxTimestampIndex = -1;
        this.maxTimestamp = 0L;
        this.minTimestampIndex = -1;
        this.minTimestamp = 0L;
        this.maxScaleValue = 0L;
    }

    public long getTimeWindow() {
        return this.timeWindow;
    }

    public int getCountWindow() {
        return this.countWindow;
    }

    public synchronized void setTimeWindow(long timeWindow) {
        this.timeWindow = timeWindow;
        this.arrangeQueue();
    }

    public synchronized void setCountWindow(int countWindow) {
        this.countWindow = countWindow;
        this.arrangeQueue();
    }

    public synchronized void addMinMaxComparator(String name, Comparator<T> comparator) {
        Pair<PriorityQueue<T>, PriorityQueue<T>> pair = new Pair<PriorityQueue<T>, PriorityQueue<T>>(new PriorityQueue<T>(comparator), new PriorityQueue<T>(comparator.reversed()));
        this.minMaxValues.put(name, new Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>>(comparator, pair));
    }

    public synchronized void removeMinMaxComparator(String name) {
        this.minMaxValues.remove(name);
    }

    public synchronized T getMinMetric(String name) {
        Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>> pair = this.minMaxValues.get(name);
        if (pair == null) {
            return null;
        }
        return (T)((PriorityQueue)((Pair)pair.second).first).peek();
    }

    public synchronized T getMaxMetric(String name) {
        Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>> pair = this.minMaxValues.get(name);
        if (pair == null) {
            return null;
        }
        return (T)((PriorityQueue)((Pair)pair.second).second).peek();
    }

    public synchronized Map<String, Pair<T, T>> getMinMaxMetricMap() {
        HashMap<String, Pair<T, T>> map = new HashMap<String, Pair<T, T>>();
        for (Map.Entry<String, Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>>> entry : this.minMaxValues.entrySet()) {
            map.put(entry.getKey(), new Pair(((PriorityQueue)((Pair)entry.getValue().second).first).peek(), ((PriorityQueue)((Pair)entry.getValue().second).second).peek()));
        }
        return map;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public long getTotalResetTime() {
        return this.totalResetTime;
    }

    public synchronized T getTotal() {
        return (T)(this.total != null ? this.total : ReplicationDeliveryMetrics.ReplicationDeliveryMetric.empty());
    }

    public synchronized void add(T metric) {
        long value = this.scaleValue.apply(metric);
        int scaleIndex = value >= this.scaleBoundary ? this.scale - 1 : (int)(value % (long)this.scale);
        this.maxScaleValue = Math.max(value, this.maxScaleValue);
        if (this.queues[scaleIndex] == null) {
            this.queues[scaleIndex] = new ArrayDeque<T>();
        }
        this.queues[scaleIndex].add(metric);
        this.maxTimestamp = this.timestampValue.apply(metric);
        this.maxTimestampIndex = scaleIndex;
        ++this.totalCount;
        this.totals[this.maxTimestampIndex] = this.aggregatorTotal.add(this.totals[this.maxTimestampIndex], metric, this.queues[this.maxTimestampIndex].size());
        this.total = this.totals.length > 1 ? this.aggregatorTotal.add(this.total, metric, this.totalCount) : this.totals[this.maxTimestampIndex];
        for (Map.Entry<String, Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>>> entry : this.minMaxValues.entrySet()) {
            ((PriorityQueue)((Pair)entry.getValue().second).first).add(metric);
            ((PriorityQueue)((Pair)entry.getValue().second).second).add(metric);
        }
        this.arrangeQueue();
    }

    public synchronized void arrangeQueue() {
        while (true) {
            if (this.minTimestampIndex == -1) {
                for (int i = 0; i < this.queues.length; ++i) {
                    Queue<T> queue = this.queues[i];
                    if (queue == null || queue.size() <= 0) continue;
                    queue.peek();
                    long timestamp = this.timestampValue.apply(queue.peek());
                    if (this.minTimestamp != 0L && timestamp >= this.minTimestamp) continue;
                    this.minTimestamp = timestamp;
                    this.minTimestampIndex = i;
                }
            }
            if (this.minTimestampIndex == -1) {
                this.maxTimestampIndex = -1;
                this.maxTimestamp = 0L;
                for (Map.Entry<String, Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>>> entry : this.minMaxValues.entrySet()) {
                    ((PriorityQueue)((Pair)entry.getValue().second).first).clear();
                    ((PriorityQueue)((Pair)entry.getValue().second).second).clear();
                }
            }
            if (this.minTimestampIndex == -1 || (this.countWindow <= 0 || this.totalCount <= this.countWindow) && (this.timeWindow <= 0L || System.currentTimeMillis() - this.minTimestamp <= this.timeWindow)) break;
            T removedMetric = this.queues[this.minTimestampIndex].remove();
            if (removedMetric != null) {
                --this.totalCount;
                this.totals[this.minTimestampIndex] = this.aggregatorTotal.remove(this.totals[this.minTimestampIndex], removedMetric, this.queues[this.minTimestampIndex].size());
                this.total = this.totals.length > 1 ? this.aggregatorTotal.remove(this.total, removedMetric, this.totalCount) : this.totals[this.minTimestampIndex];
                for (Map.Entry<String, Pair<Comparator<T>, Pair<PriorityQueue<T>, PriorityQueue<T>>>> entry : this.minMaxValues.entrySet()) {
                    ((PriorityQueue)((Pair)entry.getValue().second).first).remove(removedMetric);
                    ((PriorityQueue)((Pair)entry.getValue().second).second).remove(removedMetric);
                }
            }
            this.minTimestampIndex = -1;
            this.minTimestamp = 0L;
        }
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public static interface MetricsAggregator<TM, TMA> {
        public TMA add(TMA var1, TM var2, long var3);

        public TMA remove(TMA var1, TM var2, long var3);
    }
}

