/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.replication.ReplicationRequest;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.ReplicationEventTrigger;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ReplicationUtil {
    public static ReplicationResponse getSourceDefinition(Session session, ReplicationEntityName sourceEntityName, ReplicationEntityName replicaEntityName, boolean global, boolean withMetrics) {
        AbstractDataspace dataspace = ReplicationUtil.lookupDataspace(session, replicaEntityName != null ? replicaEntityName.getDataspaceName() : session.currentDataspace.name);
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.GET_SOURCE_DEFINITION);
        request.setSourceName(sourceEntityName.getSourceOrReplicaName());
        request.setReplicaEntityName(replicaEntityName);
        request.setWithMetrics(withMetrics);
        request.setSession(session);
        if (global && dataspace.getEventScope() != EventScope.GLOBAL && !DataspaceStoreManager.getRuntimeContext().getName().equals(sourceEntityName.getNodeName())) {
            return ReplicationManager.sendReplicationManagementRequestGlobal(request, sourceEntityName);
        }
        return dataspace.getReplicationManager().sendReplicationManagementRequest(request, sourceEntityName);
    }

    public static ReplicationResponse getReplicaInfo(Session session, ReplicationEntityName replicaEntityName, boolean withMetrics) {
        AbstractDataspace dataspace = ReplicationUtil.lookupDataspace(session, session.currentDataspace.name);
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.GET_REPLICA_INFO);
        request.setReplicaEntityName(replicaEntityName);
        request.setSession(session);
        request.setWithMetrics(withMetrics);
        if (dataspace.getEventScope() != EventScope.GLOBAL && !DataspaceStoreManager.getRuntimeContext().getName().equals(replicaEntityName.getNodeName())) {
            return ReplicationManager.sendReplicationManagementRequestGlobal(request, replicaEntityName);
        }
        return dataspace.getReplicationManager().sendReplicationManagementRequest(request, replicaEntityName);
    }

    public static ReplicationResponse sendSqlRequestTo(Session session, ReplicationEntityName toEntityName, String sql) {
        Trace.logDebug(ReplicationUtil.class, "Sending request to {}, sql: {}", toEntityName, sql);
        AbstractDataspace dataspace = ReplicationUtil.lookupDataspace(session, session.currentDataspace.name);
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.SQL_REQUEST);
        request.setSession(session);
        request.setSql(sql);
        long timeout = session.getRequestTimeout();
        timeout = timeout <= 0L ? 300000L : (timeout -= timeout / 10L);
        request.setRequestTimeout(timeout - timeout / 10L);
        if (dataspace.getEventScope() != EventScope.GLOBAL && !toEntityName.isLocalNode()) {
            return ReplicationManager.sendReplicationManagementRequestGlobal(request, toEntityName, timeout);
        }
        return dataspace.getReplicationManager().sendReplicationManagementRequest(request, toEntityName, timeout);
    }

    public static ReplicationResponse addReplicaToSource(Session session, ReplicationEntityName sourceEntityName, ReplicationEntityName targetEntityName) {
        AbstractDataspace dataspace = ReplicationUtil.lookupDataspace(session, targetEntityName.getDataspaceName());
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.ADD_REPLICA_TO_SOURCE);
        request.setSourceName(sourceEntityName.getSourceOrReplicaName());
        request.setReplicaEntityName(targetEntityName);
        request.setReplicaState(ReplicaState.INACTIVE);
        request.setSuspended(false);
        request.setSession(session);
        return dataspace.getReplicationManager().sendReplicationManagementRequest(request, sourceEntityName);
    }

    public static ReplicationResponse getSourceReplicationId(Session session, ReplicationEntityName sourceEntityName, ReplicationEntityName targetEntityName) {
        AbstractDataspace dataspace = ReplicationUtil.lookupDataspace(session, session.currentDataspace.name);
        return ReplicationUtil.getSourceReplicationId(session, dataspace, sourceEntityName, targetEntityName);
    }

    public static ReplicationResponse getSourceReplicationId(Session session, AbstractDataspace dataspace, ReplicationEntityName sourceEntityName, ReplicationEntityName targetEntityName) {
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.GET_SOURCE_REPLICATION_ID);
        request.setSourceName(sourceEntityName.getSourceOrReplicaName());
        request.setReplicaEntityName(targetEntityName);
        request.setSession(session);
        return dataspace.getReplicationManager().sendReplicationManagementRequest(request, sourceEntityName);
    }

    private static AbstractDataspace lookupDataspace(Session session, String dataspaceName) {
        AbstractDataspace dataspace = (AbstractDataspace)session.dataspaceStore.lookup(dataspaceName);
        if (dataspace == null) {
            throw new DataspaceException("Dataspace '" + dataspaceName + "' doesn't exist.");
        }
        return dataspace;
    }

    public static String formattedOutputReplicaList(List<ReplicaInfo> replicas, boolean withAllStates) {
        return "[" + replicas.stream().map(r -> r.getReplicaEntityName().getFullName() + "(" + (r.getState() != null ? (r.isSuspended() ? "SUSPENDED" : (withAllStates ? String.valueOf((Object)r.getState()) : "ATTACHED")) : "DETACHED") + ")").collect(Collectors.joining(",")) + "]";
    }

    public static String formattedOutputTriggerList(ReplicationEventTrigger[] triggers) {
        return "[" + Arrays.stream(triggers).map(t -> t.getEntityName()).collect(Collectors.joining(",")) + "]";
    }

    public static String replicationSourceReferenceToQueueFullName(ReplicationSourceReference sourceReference) {
        String pattern = "(.+://)(.+)\\.(.+):.+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(sourceReference.getName());
        if (!m.find()) {
            throw new DataspaceException("Wrong replication source name format");
        }
        String nodeName = m.group(1);
        String dsType = m.group(2);
        String dsName = m.group(3);
        return ReplicationQueue.getQueueFullName(nodeName.substring(0, nodeName.length() - 3), dsType, NameManager.unquoteString(dsName), sourceReference.getCollectionName());
    }
}

