/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.replication.AbstractReplicationEntity;
import com.streamscape.ds.replication.DurationTimer;
import com.streamscape.ds.replication.MessagesExpirationCache;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationDataBatch;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationDeliveryMetrics;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationErrorCode;
import com.streamscape.ds.replication.ReplicationException;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.replication.ReplicationMetaSchema;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.ReplicationRequest;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationSourceInfo;
import com.streamscape.ds.replication.ReplicationUtil;
import com.streamscape.ds.replication.SimpleColumnDescriptor;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.qspace.aqueue.AuditQueueCollection;
import com.streamscape.ds.schema.collection.tspace.vtable.VirtualTableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.ds.trigger.ReplicationModifyTrigger;
import com.streamscape.ds.trigger.ReplicationValidateTrigger;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.AbstractReplicationAdvisory;
import com.streamscape.sdo.advisory.ReplicaMetricAdvisory;
import com.streamscape.sdo.advisory.ReplicaStateChangeAdvisory;
import com.streamscape.sdo.advisory.ReplicationExceptionAdvisory;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractReplicationManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.Token;
import com.streamscape.tools.log.monitor.Utils;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReplicationTarget
extends AbstractReplicationEntity
implements FabricRequestListener,
SchemaObject,
SourceEventFlowData {
    public static final long SOURCE_CHECK_TIMEOUT_MS = 10000L;
    public static final long MESSAGE_EXPIRATION_TIMEOUT = 900000L;
    public static final long MESSAGE_EXPIRATION_CLEANUP_TIMEOUT = 1800000L;
    protected ReplicationEntityName sourceEntityName = null;
    protected ReplicationEntityName targetEntityName = null;
    protected String targetCollectionName = null;
    protected final SessionWrapperHolder sessionWrapperHolder = new SessionWrapperHolder();
    protected NameManager.ObjectName name = null;
    protected boolean withMaterialization = false;
    protected boolean renewCollection = false;
    protected ReplicaState state = ReplicaState.INACTIVE;
    protected String lastError = null;
    protected boolean isSuspended = false;
    protected int retryCount = -1;
    private volatile boolean upsert;
    private volatile boolean ignoreOnFailDelete;
    private volatile boolean ignoreOnFailUpdate;
    private volatile boolean ignoreOnFailInsert;
    private long publishTimeWindow;
    private TimeUnit publishTimeWindowUnit;
    private long publishBatchWindow;
    protected long identity;
    protected String[] columnNames = null;
    protected Statement insertStat = null;
    protected Statement deleteStat = null;
    protected Statement updateStat = null;
    protected List<Integer> deleteUpdateStatPrimaryKeyIndexes = null;
    protected List<String> primaryReplicationKey;
    protected List<Integer> primaryReplicationKeyIndexes;
    protected Statement truncateStat = null;
    protected Statement updateReplicationId = null;
    protected int numberOfColumns = 0;
    protected boolean containsIdentity = false;
    protected boolean sync = true;
    protected boolean rollbackOnFailure = false;
    protected boolean isSyncSet = false;
    protected int DEFAULT_FETCH_SIZE = 1000;
    protected ReplicationTargetReference reference;
    protected AtomicInteger version = new AtomicInteger();
    protected AtomicLong replicationId = new AtomicLong();
    protected long lastRequestFromSource = 0L;
    private boolean registered = false;
    private volatile boolean shouldBeAttachedToSource = false;
    private Session materializationSession;
    private long batchInterval = -1L;
    private boolean sourceEnabled = true;
    private long lastTimeStartedStopped = 0L;
    private long lastTimeResumedSuspended = 0L;
    private long lastTimeStateChanged = 0L;
    private long lastTimeStateChangedNotified = 0L;
    private ReplicationDataTransaction lastReplicationUnit = null;
    private long sourceTableSchemaChangeTimestamp = -1L;
    private long targetTableSchemaChangeTimestamp = -1L;
    private ReplicationDeliveryMetrics metrics;
    private ReplicationMetaSchema metaSchema = ReplicationMetaSchema.NONE;
    private Map<String, ReplicationValidateTrigger> validationTriggers = new LinkedHashMap<String, ReplicationValidateTrigger>();
    private ReplicationModifyTrigger replicationModifyTrigger;
    private MessagesExpirationCache messagesExpirationCache = new MessagesExpirationCache(900000L, 1800000L);
    private ReplicationSourceInfo replicationSourceInfo;
    private String needsReattach = null;

    public ReplicationTarget(DataspaceStore store, NameManager.ObjectName name, ReplicationEntityName sourceEntityName, String targetCollection, boolean withMaterialization, boolean newCollection, boolean stopped, boolean isSuspended, int retryCount, boolean upsert, boolean ignoreOnFailDelete, boolean ignoreOnFailUpdate, boolean ignoreOnFailInsert, long publishTimeWindow, TimeUnit publishTimeWindowUnit, long publishBatchWindow, List<String> primaryReplicationKey) {
        super(store, name.schema.name);
        this.name = name;
        this.sourceEntityName = sourceEntityName;
        this.withMaterialization = withMaterialization;
        this.renewCollection = newCollection;
        this.targetCollectionName = targetCollection;
        this.retryCount = retryCount;
        this.upsert = upsert;
        this.ignoreOnFailDelete = ignoreOnFailDelete;
        this.ignoreOnFailUpdate = ignoreOnFailUpdate;
        this.ignoreOnFailInsert = ignoreOnFailInsert;
        this.publishTimeWindow = publishTimeWindow;
        this.publishTimeWindowUnit = publishTimeWindowUnit;
        this.publishBatchWindow = publishBatchWindow;
        this.primaryReplicationKey = primaryReplicationKey;
        if (this.primaryReplicationKey != null && this.primaryReplicationKey.size() == 0) {
            this.primaryReplicationKey = null;
        }
        if (stopped) {
            this.state = ReplicaState.STOPPED;
        }
        this.isSuspended = isSuspended;
        this.targetEntityName = new ReplicationEntityName(DataspaceStoreManager.getRuntimeContext().getName(), this.dataspace.getType(), this.dataspace.getName(), name.name, targetCollection);
        this.metrics = new ReplicationDeliveryMetrics();
        this.metrics.addGlobalMinMaxComparator("DELIVERY_TIME", (o1, o2) -> Long.compare(o1.getDeliveryTime(), o2.getDeliveryTime()));
    }

    void initReference() {
        if (this.reference == null) {
            this.reference = this.replicationManager.addTargetReference(this);
        }
    }

    public long getIdentity() {
        return this.identity;
    }

    public void setIdentity(long identity) {
        this.identity = identity;
    }

    public ReplicaState getState() {
        return this.state;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public String getLastError() {
        return this.lastError;
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    public void open(Session session) {
        this.trace(Trace.Level.DEBUG, "Opening...", new Object[0]);
        this.replicationManager.addTarget(this);
        this.initReference();
        Result temp = session.executeDirectStatement("select VERSION, REPLICATION_ID from  RDS.REPLICAS  where DATASPACE_NAME = '" + this.name.schema.name + "' and NAME = '" + this.name.name + "'");
        if (temp == null || temp.isError() || !temp.isData() || temp.navigator == null) {
            throw new DataspaceException("Unable to retrieve information about replica from the registry. " + (temp != null && temp.getException() != null ? Utils.formatException(temp.getException()) : ""));
        }
        if (temp.navigator.next() && temp.navigator.getCurrent(0) instanceof Integer && temp.navigator.getCurrent(1) instanceof Long) {
            int version = (Integer)temp.navigator.getCurrent(0);
            long replicationId = (Long)temp.navigator.getCurrent(1);
            this.setInitVersion(version);
            this.setInitReplicationId(replicationId);
        } else {
            this.setInitVersion(1);
            this.setInitReplicationId(-1L);
            temp = session.executeDirectStatement("insert into RDS.REPLICAS  values ('" + this.dataspace.getType() + "','" + this.dataspace.getName() + "','" + this.name.name + "', " + this.getVersion() + ", " + this.getReplicationId() + ")");
            if (temp == null || temp.isError()) {
                throw new DataspaceException("Unable to add information about new replica to the registry. " + (temp != null && temp.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(temp.getException()) : ""));
            }
        }
        this.startPublisher();
        this.trace(Trace.Level.DEBUG, "Opened. ReplicationId: {}, version: {}, state: ", this.replicationId.get(), this.version.get());
    }

    public void stop(Session session) {
        this.trace(Trace.Level.DEBUG, "Stopping...", new Object[0]);
        if (this.state != ReplicaState.STOPPED) {
            this.lastTimeStartedStopped = System.currentTimeMillis();
        }
        if (session.isProcessingLog() || session.isProcessingRecoveryLog) {
            this.state = ReplicaState.STOPPED;
        } else if (this.state != ReplicaState.STOPPED) {
            this.detachFromSource(session, false);
            this.setState(ReplicaState.STOPPED, null);
            this.stopPublisher();
        }
        this.trace(Trace.Level.DEBUG, "Stopped.", new Object[0]);
    }

    public void start(Session session) {
        this.trace(Trace.Level.DEBUG, "Starting...", new Object[0]);
        if (this.state == ReplicaState.STOPPED || this.lastTimeStartedStopped == 0L) {
            this.lastTimeStartedStopped = System.currentTimeMillis();
        }
        if (session.isProcessingLog() || session.isProcessingRecoveryLog) {
            this.state = ReplicaState.INACTIVE;
        } else if (this.state == ReplicaState.STOPPED) {
            this.resetMetrics();
            this.startPublisher();
            this.setState(ReplicaState.INACTIVE, null);
            this.attachToSource(session);
        }
        this.trace(Trace.Level.DEBUG, "Started.", new Object[0]);
    }

    public void suspend(Session session) {
        this.trace(Trace.Level.DEBUG, "Suspending...", new Object[0]);
        if (!this.isSuspended) {
            this.lastTimeResumedSuspended = System.currentTimeMillis();
        }
        if (session.isProcessingLog() || session.isProcessingRecoveryLog) {
            this.isSuspended = true;
        } else if (!this.isSuspended) {
            this.isSuspended = true;
            try {
                this.sendReplicaStateChangedRequest(null);
            }
            catch (Exception exception) {
                this.sourceDisconnected("Unable to suspend replica on source. Replica is moved to INACTIVE state.");
            }
            if (this.state == ReplicaState.SYNCING) {
                this.state = ReplicaState.OUTSYNC;
            }
            if (this.isSuspended) {
                this.setSuspended(true, true);
            }
        }
        this.trace(Trace.Level.DEBUG, "Suspended.", new Object[0]);
    }

    public void resetMetrics() {
        this.metrics.resetAll();
    }

    public void alterPublishParameters(Long publishTimeWindow, TimeUnit publishTimeWindowUnit, Long publishBatchWindow) {
        this.publishTimeWindow = publishTimeWindow;
        this.publishTimeWindowUnit = publishTimeWindowUnit;
        this.publishBatchWindow = publishBatchWindow;
        this.startPublisher();
    }

    private void startPublisher() {
        try {
            this.metrics.setPublishMetricsParameters(this.getTargetEntityName().getFullName(), this.publishTimeWindowUnit.toMillis(this.publishTimeWindow), this.publishBatchWindow, (metricsAggregator, info) -> {
                block2: {
                    try {
                        ReplicationDeliveryMetrics.ReplicaMetricsReportFacet facet = (ReplicationDeliveryMetrics.ReplicaMetricsReportFacet)metricsAggregator.toReport();
                        facet.setEndTime(info.getEndTime());
                        ReplicationDeliveryMetrics.ReplicaMetricsWindowReport report = new ReplicationDeliveryMetrics.ReplicaMetricsWindowReport(facet, info);
                        ReplicaMetricAdvisory advisory = new ReplicaMetricAdvisory();
                        advisory.setSourceDataspaceType(this.getSourceEntityName().getDataspaceType());
                        advisory.setSourceDataspaceName(this.getSourceEntityName().getDataspaceName());
                        advisory.setSourceName(this.getSourceEntityName().getSourceOrReplicaName());
                        advisory.setTargetDataspaceType(this.getTargetEntityName().getDataspaceType());
                        advisory.setTargetDataspaceName(this.getTargetEntityName().getDataspaceName());
                        advisory.setReplicaName(this.getTargetEntityName().getSourceOrReplicaName());
                        advisory.setReport(report);
                        this.dataspace.raiseSystemAdvisory(advisory);
                    }
                    catch (Exception exception) {
                        if (!this.raiseReplicationException(exception, true)) break block2;
                        this.trace(Trace.Level.ERROR, "Failed to send replication metrics advisory", new Object[0]);
                        Trace.logException(this, exception, true);
                    }
                }
            });
        }
        catch (Exception exception) {
            this.raiseReplicationException(exception, false);
            this.trace(Trace.Level.ERROR, "Failed to start publisher.", new Object[0]);
            Trace.logException(this, exception, true);
        }
    }

    private void stopPublisher() {
        this.metrics.setPublishMetricsParameters(null, 0L, 0L, null);
    }

    public void resume(Session session) {
        this.trace(Trace.Level.DEBUG, "Resuming...", new Object[0]);
        if (this.isSuspended) {
            this.lastTimeResumedSuspended = System.currentTimeMillis();
        }
        if (session.isProcessingLog() || session.isProcessingRecoveryLog) {
            this.isSuspended = false;
        } else if (this.isSuspended) {
            this.isSuspended = false;
            try {
                this.sendReplicaStateChangedRequest(null);
            }
            catch (Exception exception) {
                this.sourceDisconnected("Unable to resume replica on source. Replica is moved to INACTIVE state.");
            }
            if (this.state != ReplicaState.INACTIVE && this.state != ReplicaState.FAILURE && this.state != ReplicaState.EVICTED) {
                try {
                    ReplicationResponse response = ReplicationUtil.getSourceReplicationId(session, this.dataspace, this.sourceEntityName, this.targetEntityName);
                    if (response.isOk()) {
                        if (response.getReplicationId() != this.replicationId.get()) {
                            this.setState(ReplicaState.OUTSYNC, null);
                        } else {
                            this.setState(ReplicaState.ACTIVE, null);
                        }
                        try {
                            this.sendReplicaStateChangedRequest(null);
                        }
                        catch (Exception exception) {}
                    } else {
                        this.sourceDisconnected(response.getErrorMessage());
                    }
                }
                catch (Exception exception) {
                    this.sourceDisconnected("Unable to send 'get source definition' replication request. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
            }
            if (!this.isSuspended) {
                this.setSuspended(false, true);
            }
        }
        this.trace(Trace.Level.DEBUG, "Resumed.", new Object[0]);
    }

    public void attachToSourceMonitor() {
        try (Session session = this.dataspace.createSession();){
            this.attachToSourceMonitor(session);
        }
    }

    public void attachToSourceMonitor(Session session) {
        session.lockReplicationManual(this.getObjectName());
        try {
            if (this.shouldBeAttachedToSource) {
                this.attachToSource(session);
            }
            if ((!this.shouldBeAttachedToSource || this.state != ReplicaState.INACTIVE && this.state != ReplicaState.FAILURE && this.state != ReplicaState.EVICTED) && System.currentTimeMillis() - this.lastRequestFromSource > (this.batchInterval > 0L && this.batchInterval >= 5000L ? 2L * this.batchInterval : 10000L)) {
                this.lastRequestFromSource = System.currentTimeMillis();
                this.checkReplicaIsPairedWithSource(session);
            }
        }
        finally {
            session.unlockReplicationManual(this.getObjectName());
        }
    }

    public void checkReplicaIsPairedWithSourceMonitor(Session session) {
        session.lockReplicationManual(this.getObjectName());
        try {
            if (!this.shouldBeAttachedToSource || this.state != ReplicaState.INACTIVE && this.state != ReplicaState.FAILURE && this.state != ReplicaState.EVICTED) {
                this.checkReplicaIsPairedWithSource(session);
            }
        }
        finally {
            session.unlockReplicationManual(this.getObjectName());
        }
    }

    public void sendReplicaStateChangedRequestMonitor(Session session, boolean withReplicationId) {
        session.lockReplicationManual(this.getObjectName());
        try {
            if (this.shouldBeAttachedToSource && this.state != ReplicaState.INACTIVE && this.state != ReplicaState.FAILURE && this.state != ReplicaState.STOPPED && this.state != ReplicaState.EVICTED) {
                this.sendReplicaStateChangedRequest(session, withReplicationId);
            }
        }
        finally {
            session.unlockReplicationManual(this.getObjectName());
        }
    }

    public void sendReplicaDetachedMonitor(Session session) {
        session.lockReplicationManual(this.getObjectName());
        try {
            if (!this.shouldBeAttachedToSource || this.state == ReplicaState.FAILURE || this.state == ReplicaState.STOPPED) {
                this.sendReplicaDetached(session);
            }
        }
        finally {
            session.unlockReplicationManual(this.getObjectName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToSource(Session parentSession) {
        if (this.state == ReplicaState.ACTIVE || this.state == ReplicaState.OUTSYNC || this.state == ReplicaState.SYNCING) {
            if (this.collection != null && this.targetTableSchemaChangeTimestamp != -1L && this.targetTableSchemaChangeTimestamp != this.collection.getBaseTable().tableSchemaChangeTimestamp) {
                this.setState(ReplicaState.INACTIVE, "Replica table schema has been changed. It can be caused by replica table alter operation. Reattach will be done automatically.");
            } else if (this.replicationModifyTrigger != null && this.replicationModifyTrigger.needsRecompile()) {
                this.setState(ReplicaState.INACTIVE, "Replication modify trigger has been changed. Reattach will be done automatically.");
            } else if (this.needsReattach != null) {
                this.setState(ReplicaState.INACTIVE, this.needsReattach);
            } else {
                for (ReplicationValidateTrigger trigger : this.validationTriggers.values()) {
                    if (!trigger.needsRecompile()) continue;
                    this.setState(ReplicaState.INACTIVE, "Validation trigger '" + trigger.getObjectName().name + "' has been changed. Reattach will be done automatically.");
                    break;
                }
            }
        }
        if (this.state != ReplicaState.INACTIVE && this.state != ReplicaState.FAILURE) {
            return;
        }
        this.trace(Trace.Level.DEBUG, "Attaching to source {}...", this.getSourceEntityName());
        parentSession.lockReplicationManual(this.getObjectName());
        try {
            if (this.state != ReplicaState.INACTIVE && this.state != ReplicaState.FAILURE) {
                return;
            }
            if (this.lastTimeStartedStopped == 0L) {
                this.lastTimeStartedStopped = System.currentTimeMillis();
            }
            if (this.lastTimeResumedSuspended == 0L) {
                this.lastTimeResumedSuspended = System.currentTimeMillis();
            }
            this.needsReattach = null;
            this.sessionWrapperHolder.openSession();
            this.sessionWrapperHolder.needToRecreateSession();
            if (!this.checkReplicaIsPairedWithSource(parentSession)) {
                this.trace(Trace.Level.DEBUG, "Attach failed. Replica is not paired with source or source is not reachable.", new Object[0]);
                return;
            }
            this.trace(Trace.Level.DEBUG, "Getting source definition...", new Object[0]);
            ReplicationResponse response = ReplicationUtil.getSourceDefinition(parentSession, this.sourceEntityName, this.targetEntityName, false, false);
            if (!response.isOk()) {
                this.sourceDisconnected(response);
                return;
            }
            try {
                this.replicationSourceInfo = response.getReplicationSourceInfo();
                this.sourceTableSchemaChangeTimestamp = response.getSourceTableSchemaChangeTimestamp();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                this.sourceDisconnected("Unable to send 'get source definition' replication request. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                return;
            }
            if (response.getReplicationSourceInfo().getSql() == null) {
                this.setState(ReplicaState.FAILURE, "Replication source responded with null SQL.");
                return;
            }
            try {
                this.checkAndCreateTargetCollection(parentSession, response);
                this.recompileTriggers(parentSession);
                this.checkPrimaryReplicationKey();
                this.checkPrimaryKeyMetaSchema(response);
            }
            catch (Exception exception) {
                this.trace(Trace.Level.ERROR, Utils.formatExceptionWithUnrepeatedCauses(exception), new Object[0]);
                this.setState(ReplicaState.FAILURE, Utils.formatExceptionWithUnrepeatedCauses(exception));
                this.shouldBeAttachedToSource = true;
                parentSession.unlockReplicationManual(this.getObjectName());
                return;
            }
            try (SessionWrapper wrapper = this.sessionWrapperHolder.getSessionWrapper(null);){
                this.recompileStatements(wrapper.getSession());
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                this.setState(ReplicaState.FAILURE, "Failed to compile replica statements. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                this.shouldBeAttachedToSource = true;
                parentSession.unlockReplicationManual(this.getObjectName());
                return;
            }
            this.sync = response.getReplicationSourceInfo().isSync();
            this.isSyncSet = true;
            this.rollbackOnFailure = response.getReplicationSourceInfo().isRollbackOnFailure();
            if (this.replicationId.get() == -1L && response.getReplicationId() == 0L) {
                this.replicationId.set(0L);
                this.executeInRequestOrTargetSession(parentSession, session -> this.updateReplicationId((Session)session, this.replicationId.get()));
            }
            this.registerTarget();
            if (this.replicationId.get() == -1L) {
                this.setState(ReplicaState.OUTSYNC, "Replication source was filled with some data when replica was being created. Execute 'reset replica' or 'materialize replica' to synchronize source and target.");
            } else if (response.getReplicationId() > this.replicationId.get()) {
                this.setState(ReplicaState.OUTSYNC, "Replication source replication ID(" + response.getReplicationId() + ") is greater than replica replication ID(" + this.replicationId.get() + ")." + (this.isSync() ? " Reset replica or materialization is needed." : " Should become synchronized automatically."));
            } else if (response.getReplicationId() < this.replicationId.get()) {
                this.setState(ReplicaState.OUTSYNC, "Replication source replication ID(" + response.getReplicationId() + ") is lower than replica replication ID(" + this.replicationId.get() + "). Is seems that something is wrong. Reset replica or materialization is needed.");
            } else {
                this.setState(ReplicaState.ACTIVE, null);
            }
            this.batchInterval = response.getReplicationSourceInfo().getReplicationQueueSettings().batchInterval;
            try {
                this.sendReplicaStateChangedRequest(parentSession);
            }
            catch (Exception exception) {
                this.unregisterTarget();
                Trace.logException(this, exception, false);
                this.setState(ReplicaState.FAILURE, "Unable to send replica state change request. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                this.shouldBeAttachedToSource = true;
                parentSession.unlockReplicationManual(this.getObjectName());
                return;
            }
            this.trace(Trace.Level.DEBUG, "Attached to source.", new Object[0]);
        }
        finally {
            this.shouldBeAttachedToSource = true;
            parentSession.unlockReplicationManual(this.getObjectName());
        }
    }

    private void checkAndCreateTargetCollection(Session parentSession, ReplicationResponse response) throws Exception {
        this.collection = (Collection)this.dataspace.lookupCollection(this.targetCollectionName);
        if (this.renewCollection && this.collection != null) {
            this.trace(Trace.Level.DEBUG, "Dropping target collection {}.", this.targetCollectionName);
            this.dataspace.getStore().schemaManager.replaceReferences(this, null);
            parentSession.executeDirectStatement("drop collection [" + this.targetCollectionName + "]");
            this.collection = null;
        }
        if (this.collection == null) {
            this.trace(Trace.Level.DEBUG, "Creating target collection {}.", this.targetCollectionName);
            if (response.getReplicationSourceInfo().getSql().equals("N/A")) {
                throw new Exception("Target collection for JFT source should exist.");
            }
            Result result = parentSession.executeDirectStatement(response.getReplicationSourceInfo().getSql());
            if (result.isError()) {
                throw new Exception("Unable to create target table. " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
            }
            this.collection = (Collection)this.dataspace.lookupCollection(this.targetCollectionName);
            if (this.collection == null) {
                throw new Exception("Unable to create target collection.");
            }
            this.dataspace.getStore().schemaManager.replaceReferences(this, this);
        } else if (this.replicationModifyTrigger == null) {
            this.trace(Trace.Level.DEBUG, "Checking target collection {} columns.", this.targetCollectionName);
            List<SimpleColumnDescriptor> columns = response.getReplicationSourceInfo().getColumnList();
            if (columns.size() != this.collection.getBaseTable().columnList.size()) {
                int replicaColumnSize = this.collection.getBaseTable().columnList.size();
                this.collection = null;
                throw new Exception("Replication Target Meta Data mismatch. Replica is expecting " + replicaColumnSize + " tuples but Source had " + columns.size() + ". Replication modify trigger may be needed.");
            }
            int counter = -1;
            com.streamscape.ds.lib.Iterator iter = this.collection.getBaseTable().columnList.values().iterator();
            while (iter.hasNext()) {
                ColumnSchema targetColumn = (ColumnSchema)iter.next();
                SimpleColumnDescriptor sourceColumn = columns.get(++counter);
                if (!targetColumn.getNameString().equals(sourceColumn.getColumnName())) {
                    this.collection = null;
                    throw new Exception("Replication Target Meta Data mismatch. Replica has '" + targetColumn.getNameString() + "' column instead of '" + sourceColumn.getColumnName() + "' on The source. Replication modify trigger may be needed.");
                }
                if (targetColumn.getDataType().getJDBCTypeCode() == sourceColumn.getJdbcType()) continue;
                this.collection = null;
                throw new Exception("Replication Target Meta Data mismatch. Replica column '" + targetColumn.getNameString() + "' data type '" + Type.getTypeName(targetColumn.getDataType().getJDBCTypeCode()) + "' does not match data type '" + Type.getTypeName(sourceColumn.getJdbcType()) + "' on the Source. Replication modify trigger may be needed.");
            }
        }
        this.targetTableSchemaChangeTimestamp = this.collection.getBaseTable().tableSchemaChangeTimestamp;
    }

    private void recompileTriggers(Session session) throws Exception {
        if (this.replicationModifyTrigger != null) {
            this.recompileTrigger(session, this.replicationModifyTrigger);
        }
        for (ReplicationValidateTrigger trigger : this.validationTriggers.values()) {
            this.recompileTrigger(session, trigger);
        }
    }

    private void recompileTrigger(Session session, AbstractReplicationEventTrigger trigger) throws Exception {
        try {
            trigger.updateRangeVariables(session, this.replicationSourceInfo);
            trigger.recompileTrigger(session);
            if (trigger.getStateHolder().isSuspectState()) {
                throw new Exception(trigger.getStateHolder().getLastOrSyntaxOrAllErrors());
            }
        }
        catch (Exception exception) {
            throw new Exception("Compilation of trigger '" + trigger.getObjectName().name + "' is failed. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    private void checkPrimaryReplicationKey() {
        if (this.primaryReplicationKey == null && this.collection instanceof AuditQueueCollection) {
            this.primaryReplicationKey = new ArrayList<String>();
            this.primaryReplicationKey.add("CorrelationId");
            this.primaryReplicationKey.add("EventGroupId");
            this.primaryReplicationKey.add("EventKey");
        }
        if (this.primaryReplicationKey != null) {
            this.checkPrimaryReplicationKey(this.primaryReplicationKey);
            this.buildPrimaryReplicationKeyIndexes();
        }
    }

    private void checkPrimaryKeyMetaSchema(ReplicationResponse response) {
        int[] targetPrimaryKey;
        int[] sourcePrimaryKey = response.getReplicationSourceInfo().getPrimaryKey();
        if (sourcePrimaryKey.length == (targetPrimaryKey = this.collection.getBaseTable().getPrimaryKey()).length) {
            if (sourcePrimaryKey.length == 0) {
                this.metaSchema = ReplicationMetaSchema.NPK_MATCH;
            } else {
                this.metaSchema = ReplicationMetaSchema.PK_MATCH;
                for (int i = 0; i < sourcePrimaryKey.length; ++i) {
                    if (sourcePrimaryKey[i] == targetPrimaryKey[i]) continue;
                    this.metaSchema = ReplicationMetaSchema.NON_MATCH;
                    break;
                }
            }
        } else {
            this.metaSchema = sourcePrimaryKey.length == 0 ? ReplicationMetaSchema.NPK_PK : (targetPrimaryKey.length == 0 ? ReplicationMetaSchema.PK_NPK : ReplicationMetaSchema.NON_MATCH);
        }
    }

    private void registerTarget() {
        if (!this.registered) {
            this.trace(Trace.Level.DEBUG, "Registering target.", new Object[0]);
            this.replicationManager.registerTarget(this);
            this.registered = true;
        }
    }

    private void unregisterTarget() {
        this.trace(Trace.Level.DEBUG, "Unregistering target.", new Object[0]);
        this.replicationManager.unregisterTarget(this);
        this.registered = false;
    }

    public synchronized void sourceDisconnected(String message) {
        this.trace(Trace.Level.DEBUG, "Source disconnected. Message: {}", message);
        this.setState(ReplicaState.INACTIVE, message);
    }

    public synchronized void sourceDisconnected(ReplicationResponse response) {
        this.trace(Trace.Level.DEBUG, "Source disconnected. Code: {}, message: {}.", new Object[]{response.getReplicationErrorCode(), response.getErrorMessage()});
        if (response.getReplicationErrorCode() == ReplicationErrorCode.SOURCE_AND_REPLICA_NOT_PAIRED) {
            this.setState(ReplicaState.EVICTED, response.getErrorMessage());
        } else {
            this.setState(ReplicaState.INACTIVE, response.getErrorMessage());
        }
    }

    public void detachFromSource(Session session, boolean withStateChange) {
        this.trace(Trace.Level.DEBUG, "Detaching from source...", new Object[0]);
        session.lockReplicationManual(this.getObjectName());
        try {
            this.shouldBeAttachedToSource = false;
            this.batchInterval = 0L;
            this.sendReplicaDetached(session);
            this.unregisterTarget();
            this.sessionWrapperHolder.closeSession();
            if (withStateChange) {
                this.setState(ReplicaState.INACTIVE, "Source detached.");
            }
            this.trace(Trace.Level.DEBUG, "Detached from source.", new Object[0]);
        }
        finally {
            session.unlockReplicationManual(this.getObjectName());
        }
    }

    public void destroy(Session session) {
        this.trace(Trace.Level.DEBUG, "Destroying...", new Object[0]);
        session.lockReplicationManual(this.getObjectName());
        try {
            this.shouldBeAttachedToSource = false;
            this.batchInterval = 0L;
            this.sendReplicaRemoved(session);
            this.replicationManager.removeTarget(this);
            this.reference = null;
            this.trace(Trace.Level.DEBUG, "Destroyed.", new Object[0]);
        }
        finally {
            session.unlockReplicationManual(this.getObjectName());
        }
        this.stopPublisher();
        try {
            this.dataspace.unbindProducerFor("advisory.replication.replica.Metrics", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataspace.unbindProducerFor("advisory.replica.StateChange", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataspace.unbindProducerFor("advisory.replication.Exception", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void detachFromSourceAndDestroy(Session session) {
        this.trace(Trace.Level.DEBUG, "Detaching from source and destroying...", new Object[0]);
        session.lockReplicationManual(this.getObjectName());
        try {
            this.shouldBeAttachedToSource = false;
            this.batchInterval = 0L;
            this.replicationManager.removeTarget(this);
            this.unregisterTarget();
            this.sessionWrapperHolder.closeSession();
            this.sendReplicaRemoved(session);
            this.trace(Trace.Level.DEBUG, "Detached from source and destroyed.", new Object[0]);
        }
        finally {
            session.unlockReplicationManual(this.getObjectName());
        }
    }

    public void reset(Session session) {
        this.trace(Trace.Level.DEBUG, "Resetting...", new Object[0]);
        if (this.state == ReplicaState.STOPPED || this.state == ReplicaState.FAILURE) {
            throw new DataspaceException("Replica should be started to reset.");
        }
        try {
            ReplicationResponse response = ReplicationUtil.getSourceReplicationId(session, this.dataspace, this.sourceEntityName, this.targetEntityName);
            if (!response.isOk()) {
                this.sourceDisconnected(response);
                throw new DataspaceException(response.getErrorMessage());
            }
            this.replicationId.set(response.getReplicationId());
        }
        catch (Exception error) {
            this.sourceDisconnected("Source is unavailable. " + Utils.formatExceptionWithUnrepeatedCauses(error));
            throw new DataspaceException("Unable to send 'get source replication id' replication request. " + Utils.formatExceptionWithUnrepeatedCauses(error));
        }
        this.executeInRequestOrTargetSession(session, s -> this.updateReplicationId((Session)s, this.replicationId.get()));
        if (this.state == ReplicaState.OUTSYNC || this.state == ReplicaState.SYNCING) {
            this.setState(ReplicaState.ACTIVE, null);
        }
        try {
            this.sendReplicaStateChangedRequest(null);
        }
        catch (Exception exception) {
            this.sourceDisconnected(exception.getMessage());
        }
        this.trace(Trace.Level.DEBUG, "Reset finished.", new Object[0]);
    }

    public void setReplicationId(Session session, long replicationId) {
        this.trace(Trace.Level.DEBUG, "Setting replication ID from {} to {}...", this.replicationId.get(), replicationId);
        this.executeInRequestOrTargetSession(session, s -> this.updateReplicationId((Session)s, replicationId));
        this.trace(Trace.Level.INFO, "WARNING: Replication ID {} has been changed from {} to {}.", this.replicationId.get(), replicationId);
        this.replicationId.set(replicationId);
        try {
            this.sendReplicaStateChangedRequest(null);
        }
        catch (Exception exception) {
            this.sourceDisconnected(exception.getMessage());
        }
        this.trace(Trace.Level.DEBUG, "Setting replication ID finished.", new Object[0]);
    }

    public void skipCurrentUnitOnReplica(Session session) {
        this.trace(Trace.Level.DEBUG, "Skipping current replication unit with ID {}...", this.replicationId.get());
        long replicationId = this.replicationId.get() + 1L;
        this.executeInRequestOrTargetSession(session, s -> this.updateReplicationId((Session)s, replicationId));
        this.replicationId.set(replicationId);
        this.trace(Trace.Level.INFO, "WARNING: Replication unit with ID {} has been skipped.", replicationId - 1L);
        try {
            this.sendReplicaStateChangedRequest(null);
        }
        catch (Exception exception) {
            this.sourceDisconnected(exception.getMessage());
        }
        this.trace(Trace.Level.DEBUG, "Skipping current replication unit finished.", new Object[0]);
    }

    public void materialize(Session session, boolean append) {
        this.trace(Trace.Level.DEBUG, "Materializing...", new Object[0]);
        if (this.state == ReplicaState.INACTIVE || this.state == ReplicaState.STOPPED || this.state == ReplicaState.FAILURE || this.state == ReplicaState.EVICTED) {
            throw new DataspaceException("Replica should be in ACTIVE or OUTSYNC state.");
        }
        if (this.replicationModifyTrigger != null) {
            throw new DataspaceException("Materialization is not allowed for non symetric replication with modify trigger.");
        }
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.MATERIALIZE_REQUEST);
        request.setFetchSize(session.getFetchSize());
        request.setRequestTimeout(session.getRequestTimeout());
        request.setSourceName(this.sourceEntityName.getSourceOrReplicaName());
        request.setReplicaEntityName(this.targetEntityName);
        request.setAppend(append);
        this.materializationSession = session;
        try {
            long timeout = session.getRequestTimeout();
            if (timeout > 0L) {
                timeout -= timeout / 10L;
            }
            request.setRequestTimeout(timeout - timeout / 10L);
            ReplicationResponse response = this.dataspace.getReplicationManager().sendReplicationManagementRequest(request, this.sourceEntityName, timeout);
            if (!response.isOk()) {
                throw new DataspaceException(response.getErrorMessage());
            }
        }
        catch (Exception error) {
            this.trace(Trace.Level.ERROR, "Unable to send materialize request to the source. " + Utils.formatExceptionWithUnrepeatedCauses(error), new Object[0]);
            throw error;
        }
        finally {
            this.materializationSession = null;
        }
        this.trace(Trace.Level.DEBUG, "Materialized.", new Object[0]);
    }

    public void doMaterialize(Session session, int fetchSize, long timeout, boolean append) {
        this.trace(Trace.Level.DEBUG, "Materializing internal... fetch size: {}, timeout: {}, append: {}.", fetchSize, timeout, append);
        FabricComponentAccessor accessor = null;
        RowSet rowSet = null;
        try {
            Result result;
            session.disableReplication(true);
            if (!append) {
                try (Session tempSession = this.dataspace.createSession();){
                    tempSession.disableReplication(true);
                    tempSession.setParentSessionId(this.materializationSession.getId());
                    result = tempSession.executeCompiledStatement(this.truncateStat, new Object[0]);
                    if (result.isError()) {
                        throw result.getException();
                    }
                }
            }
            accessor = this.dataspace.createDataspaceAccessor(this.sourceEntityName.getNodeName(), DataspaceType.valueOf(this.sourceEntityName.getDataspaceType()), this.sourceEntityName.getDataspaceName());
            accessor.setFetchSize(fetchSize);
            if (timeout >= 0L) {
                accessor.setRequestTimeout(timeout);
            }
            rowSet = accessor.executeQuery("select " + this.getColumnNamesAsOneString() + " from [" + this.sourceEntityName.getSourceOrReplicaName() + "]");
            while (rowSet.next()) {
                Object[] sourceData = rowSet.getCurrentRow().getRawData();
                result = session.executeCompiledStatement(this.insertStat, sourceData = SqlUtils.prepareDataForInsert(session, this.insertStat, sourceData));
                if (!result.isError()) continue;
                this.trace(Trace.Level.ERROR, "Unable to insert row from the source. ", new Object[0]);
                throw new DataspaceException(result);
            }
        }
        catch (Throwable error) {
            this.trace(Trace.Level.ERROR, "Materialization of replica failed. " + Utils.formatExceptionWithUnrepeatedCauses(error), new Object[0]);
            throw new ReplicationException(ReplicationErrorCode.MATERIALIZATION_FAILED, Utils.formatExceptionWithUnrepeatedCauses(error));
        }
        finally {
            session.disableReplication(false);
            if (rowSet != null) {
                rowSet.close();
            }
            if (accessor != null) {
                accessor.close();
            }
        }
        this.reset(session);
        this.trace(Trace.Level.DEBUG, "Materializing internal finished.", new Object[0]);
    }

    private boolean checkReplicaIsPairedWithSource(Session session) {
        this.trace(Trace.Level.DEBUG, "Check if replica is paired with source {}.", this.getSourceEntityName());
        try {
            ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.CHECK_REPLICA_IS_PAIRED_WITH_SOURCE);
            request.setSourceName(this.sourceEntityName.getSourceOrReplicaName());
            request.setReplicaEntityName(this.targetEntityName);
            request.setSession(session);
            ReplicationResponse response = this.dataspace.getReplicationManager().sendReplicationManagementRequest(request, this.sourceEntityName, 20000L);
            if (!response.isOk()) {
                this.sourceDisconnected(response);
                return false;
            }
            this.sourceEnabled = response.getReplicationSourceInfo().isEnabled();
            if (this.sourceTableSchemaChangeTimestamp != -1L && response.getSourceTableSchemaChangeTimestamp() != this.sourceTableSchemaChangeTimestamp) {
                this.setState(ReplicaState.INACTIVE, "Source table schema has been changed. It can be caused by source table alter operation. Reattach will be done automatically in 30 seconds maximum.");
                this.enqueueReattachAction();
                return true;
            }
        }
        catch (Exception exception) {
            this.setState(ReplicaState.INACTIVE, "Unable to send 'check replica is paired with source' replication request. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            return false;
        }
        return true;
    }

    private ReplicationResponse sendReplicaStateChangedRequest(Session session) {
        return this.sendReplicaStateChangedRequest(session, true);
    }

    private ReplicationResponse sendReplicaStateChangedRequest(Session session, boolean withReplicationId) {
        this.trace(Trace.Level.DEBUG, "Send replica state changed request.", new Object[0]);
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.REPLICA_STATE_CHANGED);
        request.setSourceName(this.sourceEntityName.getSourceOrReplicaName());
        request.setReplicaEntityName(this.targetEntityName);
        request.setReplicationId(withReplicationId ? this.replicationId.get() : -2L);
        request.setReplicaState(this.state);
        request.setSuspended(this.isSuspended);
        request.setSession(session);
        if (this.replicationModifyTrigger == null) {
            request.setPrimaryKey(this.primaryReplicationKeyIndexes != null ? this.primaryReplicationKeyIndexes : (this.collection != null ? ReplicationSource.intArrayToList(this.collection.getBaseTable().getPrimaryKey()) : null));
        }
        request.setRetryCount(this.retryCount);
        request.setSourceTableSchemaChangeTimestamp(this.sourceTableSchemaChangeTimestamp);
        ReplicationResponse response = this.dataspace.getReplicationManager().sendReplicationManagementRequest(request, this.sourceEntityName);
        if (!response.isOk()) {
            this.sourceDisconnected(response);
        }
        return response;
    }

    private void sendReplicaRemoved(Session session) {
        block3: {
            this.trace(Trace.Level.DEBUG, "Send replica removed request.", new Object[0]);
            ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.REPLICA_REMOVED);
            request.setSourceName(this.sourceEntityName.getSourceOrReplicaName());
            request.setReplicaEntityName(this.targetEntityName);
            request.setSession(session);
            try {
                ReplicationResponse response = this.dataspace.getReplicationManager().sendReplicationManagementRequest(request, this.sourceEntityName);
                if (!response.isOk()) {
                    throw new DataspaceException(response.getErrorMessage());
                }
            }
            catch (Exception exception) {
                if (exception instanceof ReplicationException && (((ReplicationException)exception).getCode() == ReplicationErrorCode.SOURCE_COLLECTION_NOT_FOUND || ((ReplicationException)exception).getCode() == ReplicationErrorCode.SOURCE_NOT_FOUND || ((ReplicationException)exception).getCode() == ReplicationErrorCode.REPLICATION_MANAGER_NOT_REACHABLE)) break block3;
                this.trace(Trace.Level.ERROR, Utils.formatExceptionWithUnrepeatedCauses(exception), new Object[0]);
                this.trace(Trace.Level.ERROR, "Unable to notify source '{}' about replica removal. Please manually unpair replica from source when it becomes available.", this.sourceEntityName.toString());
            }
        }
    }

    private void sendReplicaDetached(Session session) {
        block3: {
            this.trace(Trace.Level.DEBUG, "Send replica detached request.", new Object[0]);
            ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.REPLICA_DETACHED);
            request.setSourceName(this.sourceEntityName.getSourceOrReplicaName());
            request.setReplicaEntityName(this.targetEntityName);
            request.setReplicaState(this.state);
            request.setReplicationId(this.replicationId.get());
            request.setSession(session);
            try {
                ReplicationResponse response = this.dataspace.getReplicationManager().sendReplicationManagementRequest(request, this.sourceEntityName);
                if (!response.isOk()) {
                    throw new DataspaceException(response.getErrorMessage());
                }
            }
            catch (Exception exception) {
                if (exception instanceof ReplicationException && (((ReplicationException)exception).getCode() == ReplicationErrorCode.SOURCE_COLLECTION_NOT_FOUND || ((ReplicationException)exception).getCode() == ReplicationErrorCode.SOURCE_NOT_FOUND || ((ReplicationException)exception).getCode() == ReplicationErrorCode.REPLICATION_MANAGER_NOT_REACHABLE)) break block3;
                this.trace(Trace.Level.ERROR, Utils.formatExceptionWithUnrepeatedCauses(exception), new Object[0]);
                this.trace(Trace.Level.ERROR, "Unable to notify source '{}' about replica detaching. Please manually detach replica from source when it becomes available.", this.sourceEntityName.toString());
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateSyncAndRollbackOnFailure(boolean sync, boolean rollbackOnFailure) {
        boolean changed = this.isSyncSet && (this.sync != sync || sync && this.rollbackOnFailure != rollbackOnFailure);
        this.sync = sync;
        this.rollbackOnFailure = rollbackOnFailure;
        if (changed) {
            this.replicationManager.updateTargetState(this, this.state, this.isSuspended, this.isSyncSet ? Boolean.valueOf(sync) : null, this.metaSchema);
        }
    }

    private void initReplicationResponseReplicaInfo(ReplicationResponse response) {
        response.setReplicaInfo(new ReplicaInfo(this.targetEntityName, this.state, this.isSuspended, this.replicationId.get()));
    }

    private ReplicationResponse processReplicationDataSync(ReplicationDataBatch batch, Session session, ReplicationDeliveryMetrics.ReplicationDeliveryMetric.ReplicationDeliveryMetricBuilder metricBuilder) throws FabricRequestException {
        if (batch.getCurrentReplicationId() != this.replicationId.get() && this.state != ReplicaState.OUTSYNC) {
            if (this.rollbackOnFailure) {
                this.setState(ReplicaState.OUTSYNC, batch.getCurrentReplicationId() > this.replicationId.get() ? "Source replication ID(" + batch.getCurrentReplicationId() + ") is greater than target replication ID(" + this.replicationId.get() + "). Since replication is 'rollback on failure' fail replication." : "Source replication ID(" + batch.getCurrentReplicationId() + ") is lower than target replication ID(" + this.replicationId.get() + "). Since replication is 'rollback on failure' fail replication.");
                throw new FabricRequestException("Replica is out of sync.");
            }
            this.setState(ReplicaState.OUTSYNC, batch.getCurrentReplicationId() > this.replicationId.get() ? "Source replication ID(" + batch.getCurrentReplicationId() + ") is greater than target replication ID(" + this.replicationId.get() + "). Because replication is not 'rollback on failure', continue processing." : "Source replication ID(" + batch.getCurrentReplicationId() + ") is lower than target replication ID(" + this.replicationId.get() + "). Because replication is not 'rollback on failure', continue processing.");
        }
        try {
            this.processReplicationDataTransaction(batch.getTransactions().get(0), batch.getSession(), session, metricBuilder);
            ReplicationResponse response = new ReplicationResponse();
            response.setProcessedTransactionsCount(1);
            response.setReplicationId(this.replicationId.get());
            this.initReplicationResponseReplicaInfo(response);
            return response;
        }
        catch (Exception exception) {
            this.raiseReplicationException(exception, true);
            this.setState(ReplicaState.OUTSYNC, Utils.formatExceptionWithUnrepeatedCauses(exception));
            ReplicationResponse response = new ReplicationResponse();
            response.setIsOk(false);
            response.setReplicationId(this.replicationId.get());
            if (exception instanceof ReplicationException) {
                response.setErrorStateAndMessage(((ReplicationException)exception).getCode(), exception.getMessage());
            } else {
                response.setErrorMessage(exception.getMessage());
            }
            this.initReplicationResponseReplicaInfo(response);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationResponse processReplicationDataAsync(ReplicationDataBatch batch, Session session, ReplicationDeliveryMetrics.ReplicationDeliveryMetric.ReplicationDeliveryMetricBuilder metricBuilder) throws FabricRequestException {
        if (batch.getCurrentReplicationId() != this.replicationId.get()) {
            this.trace(Trace.Level.DEBUG, "Source replicationId {} != target replicationId {}. Set status OUTSYNC and replying with target replicationId.", batch.getCurrentReplicationId(), this.replicationId.get());
            this.setState(ReplicaState.OUTSYNC, batch.getCurrentReplicationId() > this.replicationId.get() ? "Source replication ID(" + batch.getCurrentReplicationId() + ") is greater than target replication ID(" + this.replicationId.get() + "). If not resolved automatically, needs to be fixed manually using commands 'reset replica' or 'materialize replica'." : "Source replication ID(" + batch.getCurrentReplicationId() + ") is lower than target replication ID(" + this.replicationId.get() + "). If not resolved automatically, needs to be fixed manually using commands 'reset replica' or 'materialize replica'.");
            try {
                this.sendReplicaStateChangedRequest(null, false);
            }
            catch (Exception exception) {
                this.sourceDisconnected(exception.getMessage());
            }
            ReplicationResponse response = new ReplicationResponse();
            response.setReplicationId(this.replicationId.get());
            this.initReplicationResponseReplicaInfo(response);
            return response;
        }
        if (this.state != ReplicaState.ACTIVE && this.state != ReplicaState.OUTSYNC && this.state != ReplicaState.SYNCING) {
            this.trace(Trace.Level.DEBUG, "Replica is not in ACTIVE or OUTSYNC or SYNCING state, rejecting request.", new Object[0]);
            ReplicationResponse response = new ReplicationResponse();
            response.setReplicationId(this.replicationId.get());
            this.initReplicationResponseReplicaInfo(response);
            return response;
        }
        int processedTransactionsCount = 0;
        ReplicationResponse response = null;
        try {
            for (ReplicationDataTransaction transaction : batch.getTransactions()) {
                this.processReplicationDataTransaction(transaction, batch.getSession(), session, metricBuilder);
                ++processedTransactionsCount;
            }
            if (batch.getCommittedReplicationId() == this.replicationId.get()) {
                this.setState(ReplicaState.ACTIVE, null);
            } else if (this.state == ReplicaState.OUTSYNC) {
                this.setState(ReplicaState.SYNCING, null);
            }
            response = new ReplicationResponse();
            response.setReplicationId(this.replicationId.get());
            this.initReplicationResponseReplicaInfo(response);
            ReplicationResponse replicationResponse = response;
            return replicationResponse;
        }
        catch (Exception exception) {
            this.raiseReplicationException(exception, true);
            if (exception instanceof DataspaceException && ((DataspaceException)exception).getErrorCode() == -4865) {
                this.trace(Trace.Level.ERROR, "RU Batch Timeout Exceeded. Rolling Back Delivery. Batch size: {}, batch replication ID: {}, processed RU count: {}.", batch.size(), batch.getCurrentReplicationId(), processedTransactionsCount);
                this.setState(ReplicaState.OUTSYNC, "RU Batch Timeout Exceeded. Rolling Back Delivery.");
            } else {
                this.setState(ReplicaState.OUTSYNC, Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
            response = new ReplicationResponse();
            response.setIsOk(false);
            response.setReplicationId(this.replicationId.get());
            if (exception instanceof ReplicationException) {
                response.setErrorStateAndMessage(((ReplicationException)exception).getCode(), exception.getMessage());
            } else {
                response.setErrorMessage(exception.getMessage());
            }
            this.initReplicationResponseReplicaInfo(response);
            ReplicationResponse replicationResponse = response;
            return replicationResponse;
        }
        finally {
            if (response != null) {
                response.setProcessedTransactionsCount(processedTransactionsCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplicationDataTransaction(ReplicationDataTransaction transaction, Session requestSession, Session session, ReplicationDeliveryMetrics.ReplicationDeliveryMetric.ReplicationDeliveryMetricBuilder metricBuilder) throws FabricRequestException {
        ArrayList<Pair<ReplicationData, Exception>> ignoredFailed = new ArrayList<Pair<ReplicationData, Exception>>();
        boolean isAutoCommit = session.isAutoCommit();
        int unitIndex = 0;
        try {
            DurationTimer transactionTimer = new DurationTimer();
            this.trace(Trace.Level.DEBUG, "Processing transaction of {} statements...", transaction.getSize());
            this.lastReplicationUnit = transaction;
            session.setAutoCommit(false);
            session.setAutoCommitVtables(false);
            for (ReplicationData data : transaction.getData()) {
                if (this.fireValidationTrigger(session, data)) {
                    metricBuilder.incrementDiscardedStatementTemp(data.getOperationType());
                    continue;
                }
                data = this.modifyData(session, data);
                this.processReplicationData(data, requestSession, session, ignoredFailed, metricBuilder);
                ++unitIndex;
            }
            session.commitVtables();
            session.commit(true);
            metricBuilder.commitStatementsTimeTemp();
            metricBuilder.commitDiscardedIgnoredStatementTemp();
            metricBuilder.addStatementTime(ReplicationOperationType.TRANSACTION, transactionTimer.getDuration());
            if (this.sync) {
                this.replicationId.incrementAndGet();
            } else {
                this.replicationId.set(transaction.getReplicationId());
            }
            session.setAutoCommit(true);
            this.executeInRequestSessionOrSession(requestSession, session, s -> this.updateReplicationId((Session)s, this.replicationId.get()));
            this.onReplicationSuccess(session, transaction);
        }
        catch (Throwable exception) {
            ignoredFailed.clear();
            metricBuilder.setFailedUnitsCount(1L);
            metricBuilder.setFailedStatementsMap(transaction.getStatementsMap());
            try {
                session.rollbackVtables();
            }
            catch (Exception exception1) {
                this.raiseReplicationException(exception1, true);
            }
            finally {
                try {
                    session.rollback(true);
                }
                catch (Exception exception1) {
                    this.raiseReplicationException(exception1, true);
                }
                this.onReplicationFail(session, transaction, exception);
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new DataspaceException(exception, true);
            }
        }
        finally {
            ignoredFailed.forEach(pair -> this.onReplicationFail(session, (ReplicationData)pair.first, (Throwable)pair.second));
            try {
                metricBuilder.resetStatementsTimeTemp();
                metricBuilder.resetDiscardedIgnoredStatementsMapTemp();
                session.setAutoCommitVtables(true);
                session.setAutoCommit(isAutoCommit);
            }
            catch (Exception exception) {
                this.raiseReplicationException(exception, true);
            }
        }
    }

    private ReplicationData modifyData(Session session, ReplicationData data) {
        if (this.replicationModifyTrigger != null) {
            data = this.replicationModifyTrigger.execute(session, data);
        }
        return data;
    }

    private boolean fireValidationTrigger(Session session, ReplicationData data) {
        for (Map.Entry<String, ReplicationValidateTrigger> entry : this.validationTriggers.entrySet()) {
            if (!entry.getValue().execute(session, data)) continue;
            return true;
        }
        return false;
    }

    private Result processReplicationData(ReplicationData data, Session requestSession, Session session, List<Pair<ReplicationData, Exception>> ignoredFailed, ReplicationDeliveryMetrics.ReplicationDeliveryMetric.ReplicationDeliveryMetricBuilder metricBuilder) throws FabricRequestException {
        Result result;
        DurationTimer timer = new DurationTimer();
        int ignoredFailedSize = ignoredFailed.size();
        switch (data.getOperationType()) {
            case TRUNCATE: {
                result = this.executeInRequestSessionOrSession(requestSession, session, sessionLocal -> sessionLocal.executeCompiledStatement(this.truncateStat, new Object[0]));
                int newVersion = this.version.incrementAndGet();
                Result tempResult = this.executeInRequestSessionOrSession(requestSession, session, sessionLocal -> sessionLocal.executeDirectStatement("update RDS.REPLICAS  set VERSION = " + newVersion + " where DATASPACE_NAME = '" + this.name.schema.name + "' and NAME = '" + this.name.name + "'"));
                if (!tempResult.isError()) break;
                this.raiseReplicationException(tempResult.getException() != null ? tempResult.getException() : new DataspaceException(tempResult), true);
                this.dataspace.logError("Unable to update replica version after truncate. " + (tempResult.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(tempResult.getException()) : ""));
                break;
            }
            case INSERT: {
                Object[] row = this.buildRowForInsertOrUpdate(session, data.getRow());
                this.traceStatement(Trace.Level.DEBUG, session, "insert", this.insertStat, row);
                result = session.executeCompiledStatement(this.insertStat, row);
                if (result == null) break;
                if (Trace.isDebugEnabled(this.getClass()) && result.isError()) {
                    this.trace(Trace.Level.DEBUG, (this.ignoreOnFailInsert ? "" : "WARNING: ") + "INSERT statement result is error.", new Object[0]);
                    Trace.logException(this, new DataspaceException(result), true);
                }
                if (!this.ignoreOnFailInsert || !result.isError()) break;
                ignoredFailed.add(new Pair<ReplicationData, DataspaceException>(data, result.getException() != null ? result.getException() : new DataspaceException(result)));
                result = Result.updateNoResult;
                break;
            }
            case DELETE: {
                Object[] rowForDelete = this.buildRowForDeleteUpdateWhere(session, data.getRow(), data.getPrimaryKey(), true);
                this.traceStatement(Trace.Level.DEBUG, session, "delete", this.deleteStat, rowForDelete);
                result = session.executeCompiledStatement(this.deleteStat, rowForDelete);
                if (result == null) break;
                if (Trace.isDebugEnabled(this.getClass())) {
                    if (!result.isUpdateCount()) {
                        this.trace(Trace.Level.DEBUG, "WARNING: DELETE statement result is not Update Count.", new Object[0]);
                    } else {
                        this.trace(Trace.Level.DEBUG, (!this.ignoreOnFailDelete && result.getUpdateCount() != 1 ? "WARNING: " : "") + "DELETE returned Update Count: {}", result.getUpdateCount());
                    }
                }
                if (!result.isUpdateCount()) {
                    throw new DataspaceException("DELETE statement did not return an Update Count.");
                }
                if (!this.ignoreOnFailDelete && result.getUpdateCount() != 1) {
                    this.traceStatement(Trace.Level.ERROR, session, "delete", this.deleteStat, rowForDelete);
                    this.trace(Trace.Level.ERROR, "WARNING: DELETE statement returned Update Count: {}", result.getUpdateCount());
                    if (result.getUpdateCount() == 0) {
                        throw new DataspaceException("DELETE statement returned zero Update Count.");
                    }
                    if (result.getUpdateCount() <= 0) break;
                    throw new DataspaceException("DELETE statement deleted more than one row.");
                }
                if (!this.ignoreOnFailDelete || result.getUpdateCount() == 1) break;
                ignoredFailed.add(new Pair<ReplicationData, DataspaceException>(data, new DataspaceException("DELETE statement returned Update Count(" + result.getUpdateCount() + ") is not equal to 1.")));
                break;
            }
            case UPDATE: {
                Object[] oldRow = (Object[])data.getRow()[0];
                Object[] newRow = (Object[])data.getRow()[1];
                newRow = this.buildRowForInsertOrUpdate(session, newRow);
                oldRow = this.buildRowForDeleteUpdateWhere(session, oldRow, data.getPrimaryKey(), true);
                if (this.upsert) {
                    this.traceStatement(Trace.Level.DEBUG, session, "upsert-delete", this.deleteStat, oldRow);
                    result = session.executeCompiledStatement(this.deleteStat, oldRow);
                    if (result == null || result.isError()) break;
                    if (Trace.isDebugEnabled(this.getClass())) {
                        if (!result.isUpdateCount()) {
                            this.trace(Trace.Level.DEBUG, "WARNING: UPSERT-DELETE statement result is not Update Count.", new Object[0]);
                        } else {
                            this.trace(Trace.Level.DEBUG, "UPSERT-DELETE statement returned Update Count: {}", result.getUpdateCount());
                        }
                    }
                    if (!result.isUpdateCount()) {
                        throw new DataspaceException("UPSERT-DELETE statement did not return an Update Count.");
                    }
                    this.traceStatement(Trace.Level.DEBUG, session, "upsert-insert", this.insertStat, newRow);
                    result = session.executeCompiledStatement(this.insertStat, newRow);
                    if (!this.ignoreOnFailUpdate || !result.isError()) break;
                    ignoredFailed.add(new Pair<ReplicationData, DataspaceException>(data, result.getException() != null ? result.getException() : new DataspaceException(result)));
                    result = Result.updateNoResult;
                    break;
                }
                newRow = Arrays.copyOf(newRow, newRow.length + oldRow.length);
                System.arraycopy(oldRow, 0, newRow, newRow.length - oldRow.length, oldRow.length);
                this.traceStatement(Trace.Level.DEBUG, session, "update", this.updateStat, newRow);
                result = session.executeCompiledStatement(this.updateStat, newRow);
                if (result == null) break;
                if (Trace.isDebugEnabled(this.getClass())) {
                    if (!result.isUpdateCount()) {
                        this.trace(Trace.Level.DEBUG, "WARNING: UPDATE statement result is not Update Count.", new Object[0]);
                    } else {
                        this.trace(Trace.Level.DEBUG, (!this.ignoreOnFailDelete && result.getUpdateCount() != 1 ? "WARNING: " : "") + "UPDATE returned Update Count: {}", result.getUpdateCount());
                    }
                }
                if (!result.isUpdateCount()) {
                    throw new DataspaceException("UPDATE statement did not return an Update Count.");
                }
                if (!this.ignoreOnFailUpdate && result.getUpdateCount() != 1) {
                    this.traceStatement(Trace.Level.ERROR, session, "update", this.updateStat, newRow);
                    this.trace(Trace.Level.ERROR, "WARNING: UPDATE statement returned Update Count: {}", result.getUpdateCount());
                    if (result.getUpdateCount() == 0) {
                        throw new DataspaceException("UPDATE statement returned zero Update Count.");
                    }
                    if (result.getUpdateCount() <= 0) break;
                    throw new DataspaceException("UPDATE statement updated more than one row.");
                }
                if (!this.ignoreOnFailUpdate || result.getUpdateCount() == 1) break;
                ignoredFailed.add(new Pair<ReplicationData, DataspaceException>(data, new DataspaceException("UPDATE statement returned Update Count(" + result.getUpdateCount() + ") is not equal to 1.")));
                break;
            }
            default: {
                throw new FabricRequestException("Unsupported replication operation type on data: " + String.valueOf((Object)data.getOperationType()));
            }
        }
        if (result == null) {
            throw new FabricRequestException("Null result!");
        }
        if (result.isError()) {
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, result.getException(), true);
            }
            throw new FabricRequestException(result.getException());
        }
        if (ignoredFailedSize != ignoredFailed.size()) {
            metricBuilder.incrementIgnoredStatementTemp(data.getOperationType());
        } else {
            metricBuilder.addStatementTimeTemp(data.getOperationType(), timer.getDuration());
        }
        return result;
    }

    private void traceStatement(Trace.Level level, Session session, String name, Statement statement, Object[] row) {
        if (Trace.isEnabled(this.getClass(), level)) {
            this.trace(level, "Executing {} statement\n{}\n{}", name, statement.sql, ReplicationTarget.printPreparedStatement(session, statement.sql, row));
        }
    }

    private Object[] buildRowForInsertOrUpdate(Session session, Object[] row) {
        if (this.containsIdentity) {
            int index = 0;
            Object[] resultRow = new Object[this.numberOfColumns];
            for (int i = 0; i < this.collection.getBaseTable().getColumnCount(); ++i) {
                ColumnSchema column = this.collection.getBaseTable().getColumn(i);
                if (column.isGenerated() || column.isIdentity()) continue;
                resultRow[index++] = this.updateBlobValueForInsertOrUpdate(session, column, row[i]);
            }
            row = resultRow;
        } else if (this.collection.getBaseTable().hasLobColumn()) {
            int index = 0;
            for (int i = 0; i < this.collection.getBaseTable().getColumnCount(); ++i) {
                ColumnSchema column = this.collection.getBaseTable().getColumn(i);
                row[index] = this.updateBlobValueForInsertOrUpdate(session, column, row[index]);
                ++index;
            }
        }
        return row;
    }

    private Object updateBlobValueForInsertOrUpdate(Session session, ColumnSchema column, Object value) {
        if (column.getDataType().isLobType()) {
            try {
                if (value instanceof byte[]) {
                    return SqlUtils.allocateBlob(session, (byte[])value);
                }
                if (value instanceof char[]) {
                    return SqlUtils.allocateClob(session, (char[])value);
                }
            }
            catch (SQLException error) {
                throw new DataspaceException("Unable to allocate replicated lob for the column '" + column.getNameString() + "'. " + Utils.formatExceptionWithUnrepeatedCauses(error));
            }
        }
        return value;
    }

    Object[] buildRowForDeleteUpdateWhere(Session session, Object[] row, List<Integer> primaryKey, boolean recompileIfMismatch) {
        ArrayList<Integer> columnIndexToSourceRowIndex = null;
        if (primaryKey != null && primaryKey.size() > 0) {
            columnIndexToSourceRowIndex = new ArrayList<Integer>(primaryKey.get(primaryKey.size() - 1) + 1);
            for (int i = 0; i < primaryKey.size(); ++i) {
                while (columnIndexToSourceRowIndex.size() <= primaryKey.get(i)) {
                    columnIndexToSourceRowIndex.add(null);
                }
                columnIndexToSourceRowIndex.set(primaryKey.get(i), i);
            }
        }
        if (recompileIfMismatch && this.deleteUpdateStatPrimaryKeyIndexes == null) {
            this.recompileStatements(session);
            return this.buildRowForDeleteUpdateWhere(session, row, primaryKey, false);
        }
        if (this.deleteUpdateStatPrimaryKeyIndexes == null) {
            throw new ReplicationException(ReplicationErrorCode.REPLICATION_DATA_AND_TARGET_PRIMARY_KEY_MISMATCH, "Failed to build target primary key indexes.");
        }
        Object[] rowForDelete = new Object[this.deleteUpdateStatPrimaryKeyIndexes.size()];
        for (int i = 0; i < this.deleteUpdateStatPrimaryKeyIndexes.size(); ++i) {
            int keyColumnIndex = this.deleteUpdateStatPrimaryKeyIndexes.get(i);
            if (columnIndexToSourceRowIndex != null && (columnIndexToSourceRowIndex.size() <= keyColumnIndex || columnIndexToSourceRowIndex.get(keyColumnIndex) == null) || columnIndexToSourceRowIndex == null && row.length <= keyColumnIndex) {
                if (recompileIfMismatch && !this.deleteKeysMatch()) {
                    this.recompileStatements(session);
                    return this.buildRowForDeleteUpdateWhere(session, row, primaryKey, false);
                }
                throw new ReplicationException(ReplicationErrorCode.REPLICATION_DATA_AND_TARGET_PRIMARY_KEY_MISMATCH, "Target executes delete on columns " + String.valueOf(this.deleteUpdateStatPrimaryKeyIndexes) + ". But replication data contains only columns " + String.valueOf(primaryKey) + ". Execute this transaction manually or create primary key on target table that corresponds to replication data.");
            }
            rowForDelete[i] = row[columnIndexToSourceRowIndex != null ? (Integer)columnIndexToSourceRowIndex.get(keyColumnIndex) : keyColumnIndex];
        }
        return rowForDelete;
    }

    private boolean deleteKeysMatch() {
        if (this.deleteUpdateStatPrimaryKeyIndexes == null) {
            return false;
        }
        if (this.primaryReplicationKey != null) {
            return true;
        }
        if (this.deleteUpdateStatPrimaryKeyIndexes.size() == this.collection.getBaseTable().getColumnCount() && this.collection.getBaseTable().getPrimaryKey().length != 0) {
            return true;
        }
        if (this.deleteUpdateStatPrimaryKeyIndexes.size() != this.collection.getBaseTable().getPrimaryKey().length) {
            return false;
        }
        for (int i = 0; i < this.deleteUpdateStatPrimaryKeyIndexes.size(); ++i) {
            if (this.deleteUpdateStatPrimaryKeyIndexes.get(i) == this.collection.getBaseTable().getPrimaryKey()[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isNew() {
        return this.renewCollection;
    }

    public boolean isWithMaterialization() {
        return this.withMaterialization;
    }

    public void setWithMaterialization(boolean withMaterialization) {
        this.withMaterialization = withMaterialization;
    }

    public ReplicationEntityName getSourceEntityName() {
        return this.sourceEntityName;
    }

    public ReplicationEntityName getTargetEntityName() {
        return this.targetEntityName;
    }

    public void setSourceEntityName(ReplicationEntityName sourceEntityName) {
        this.sourceEntityName = sourceEntityName;
    }

    private synchronized void setState(ReplicaState state, String lastError) {
        boolean changed = false;
        if (this.state != state) {
            this.state = state;
            this.lastTimeStateChanged = System.currentTimeMillis();
            changed = true;
        }
        this.lastError = lastError;
        MessagesExpirationCache.MessageInfo messageInfo = null;
        if (state == ReplicaState.FAILURE || state == ReplicaState.INACTIVE || state == ReplicaState.OUTSYNC) {
            messageInfo = this.messagesExpirationCache.addMessage(new StateMessage(state, lastError));
        }
        if (changed || messageInfo != null) {
            this.raiseReplicaStateChangeAdvisory(lastError, messageInfo);
        }
        if (changed || System.currentTimeMillis() - this.lastTimeStateChangedNotified >= 60000L) {
            this.lastTimeStateChangedNotified = System.currentTimeMillis();
            this.replicationManager.updateTargetState(this, state, this.isSuspended, this.isSyncSet ? Boolean.valueOf(this.sync) : null, this.metaSchema);
        }
    }

    private void setSuspended(boolean isSuspended, boolean sendAnyway) {
        boolean changed = this.isSuspended != isSuspended;
        this.isSuspended = isSuspended;
        if (sendAnyway || changed) {
            this.raiseReplicaStateChangeAdvisory(null, null);
            this.replicationManager.updateTargetState(this, this.state, isSuspended, this.isSyncSet ? Boolean.valueOf(this.sync) : null, this.metaSchema);
        }
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        try {
            this.dataspace.bindProducerForSystem("advisory.replication.replica.Metrics", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.replica.StateChange", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.replication.Exception", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
    }

    @Override
    public int getObjectType() {
        return 29;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    public String getTargetCollectionName() {
        return this.targetCollectionName;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.store.getCatalogName();
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet references = new OrderedHashSet();
        SchemaObject targetCollection = this.dataspace.getStore().schemaManager.findSchemaObject(this.targetCollectionName, this.getObjectName().schema.name, 4);
        if (targetCollection == null) {
            targetCollection = this.dataspace.getStore().schemaManager.findSchemaObject(this.targetCollectionName, this.getObjectName().schema.name, 3);
        }
        if (targetCollection != null) {
            references.add(targetCollection.getObjectName());
        }
        return references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return new OrderedHashSet();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ');
        builder.append("REPLICA").append(' ');
        builder.append(name).append(' ');
        builder.append("FOR").append(' ');
        builder.append('[').append(this.sourceEntityName.toString()).append(']').append(' ');
        builder.append("AT").append(' ');
        builder.append('[').append(this.targetCollectionName).append(']').append(' ');
        if (this.renewCollection) {
            builder.append(' ').append("RENEW");
        }
        if (this.withMaterialization) {
            builder.append(' ').append("WITH").append(' ').append("MATERIALIZATION");
        }
        if (this.state == ReplicaState.STOPPED) {
            builder.append(' ').append("STOP");
        }
        if (this.isSuspended) {
            builder.append(' ').append("SUSPEND");
        }
        builder.append(" retry count ").append(this.retryCount);
        if (!this.upsert) {
            builder.append(' ').append("ON").append(' ').append("UPDATE").append(' ').append("UPDATE");
        }
        if (this.ignoreOnFailDelete || this.ignoreOnFailUpdate || this.ignoreOnFailInsert) {
            builder.append(' ').append("IGNORE").append(' ').append("ON").append(' ').append("FAIL").append(" (");
            if (this.ignoreOnFailDelete) {
                builder.append("DELETE");
            }
            if (this.ignoreOnFailUpdate) {
                if (this.ignoreOnFailDelete) {
                    builder.append(",");
                }
                builder.append("UPDATE");
            }
            if (this.ignoreOnFailInsert) {
                if (this.ignoreOnFailUpdate || this.ignoreOnFailDelete) {
                    builder.append(",");
                }
                builder.append("INSERT");
            }
            builder.append(')');
        }
        if (this.publishTimeWindow != 0L || this.publishBatchWindow != 0L) {
            builder.append(' ').append("PUBLISH").append(' ').append("STATISTICS").append(' ').append("FOR").append(' ');
            if (this.publishTimeWindow != 0L) {
                builder.append(' ').append("TIME").append(' ').append("WINDOW").append(' ').append(this.publishTimeWindow).append(' ');
                SqlUtils.timeUnitToString(builder, this.publishTimeWindowUnit);
            }
            if (this.publishBatchWindow != 0L) {
                builder.append(' ').append("BATCH").append(' ').append("WINDOW").append(' ').append(this.publishBatchWindow);
            }
        }
        if (this.primaryReplicationKey != null) {
            builder.append(' ').append("PRIMARY").append(' ').append("KEY").append(' ').append("(").append(this.primaryReplicationKey.stream().map(k -> NameManager.quoteNameIfNeeded(k)).collect(Collectors.joining(","))).append(")");
        }
        return builder.toString();
    }

    public FabricAddress getComponentAddress() {
        return this.dataspace.getFabricAddress();
    }

    public EventScope getEventScope() {
        return this.dataspace.getEventScope();
    }

    private void setInitReplicationId(long replicationId) {
        this.replicationId.set(replicationId);
    }

    public long getReplicationId() {
        return this.replicationId.get();
    }

    public void setInitVersion(int version) {
        this.version.set(version);
    }

    public int getVersion() {
        return this.version.get();
    }

    public ReplicationTargetReference getReference() {
        return this.reference;
    }

    @Override
    public String getName() {
        return this.name.name;
    }

    public ReplicationMetaSchema getMetaSchema() {
        return this.metaSchema;
    }

    private void compileStatements(Session session) {
        this.compileInsertStat(session);
        this.compileDeleteStat(session);
        this.compileUpdateStat(session);
        StringBuilder buffer = new StringBuilder();
        buffer.append("TRUNCATE").append(' ').append("COLLECTION").append(' ');
        buffer.append(this.collection.getObjectName().getSchemaQualifiedStatementName());
        this.truncateStat = session.compileStatement(buffer.toString());
    }

    private void recompileStatements(Session session) {
        this.columnNames = null;
        this.numberOfColumns = 0;
        this.containsIdentity = false;
        this.deleteUpdateStatPrimaryKeyIndexes = null;
        this.compileStatements(session);
    }

    private void compileInsertStat(Session session) {
        this.buildColumnNames();
        String columnNames = this.getColumnNamesAsOneString();
        String columnParameters = this.getColumnParameters();
        String SQL = "insert into " + this.collection.getObjectName().getSchemaQualifiedStatementName() + "(" + columnNames + ")values (" + columnParameters + ")";
        this.insertStat = session.compileStatement(SQL);
    }

    private void compileUpdateStat(Session session) {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.collection.getObjectName().getSchemaQualifiedStatementName());
        builder.append(" SET ");
        this.buildColumnNames();
        boolean first = true;
        for (String columnName : this.columnNames) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(columnName).append("=").append("?");
            first = false;
        }
        builder.append(" WHERE ");
        builder.append(this.buildDeleteUpdateWhere());
        this.updateStat = session.compileStatement(builder.toString());
    }

    private void compileDeleteStat(Session session) {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.collection.getObjectName().getSchemaQualifiedStatementName());
        builder.append(" WHERE ");
        builder.append(this.buildDeleteUpdateWhere());
        this.deleteStat = session.compileStatement(builder.toString());
    }

    private void buildColumnNames() {
        if (this.columnNames == null) {
            this.numberOfColumns = 0;
            this.containsIdentity = false;
            ArrayList<String> temp = new ArrayList<String>();
            for (int i = 0; i < this.collection.getBaseTable().getColumnCount(); ++i) {
                ColumnSchema column = this.collection.getBaseTable().getColumn(i);
                if (!column.isGenerated() && !column.isIdentity()) {
                    ++this.numberOfColumns;
                    temp.add(column.getObjectName().getStatementName());
                    continue;
                }
                this.containsIdentity = true;
            }
            this.columnNames = temp.toArray(new String[temp.size()]);
        }
    }

    private String getColumnNamesAsOneString() {
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        for (String columnName : this.columnNames) {
            if (!first) {
                buffer.append(',');
            } else {
                first = false;
            }
            buffer.append(columnName);
        }
        return buffer.toString();
    }

    private String getColumnParameters() {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String columnName : this.columnNames) {
            if (!first) {
                buffer.append(',');
            } else {
                first = false;
            }
            buffer.append("?");
        }
        return buffer.toString();
    }

    private String buildDeleteUpdateWhere() {
        if (this.deleteUpdateStatPrimaryKeyIndexes == null) {
            if (this.primaryReplicationKey != null) {
                this.buildPrimaryReplicationKeyIndexes();
                this.deleteUpdateStatPrimaryKeyIndexes = new ArrayList<Integer>(this.primaryReplicationKeyIndexes);
            } else {
                this.deleteUpdateStatPrimaryKeyIndexes = ReplicationSource.intArrayToList(this.collection.getBaseTable().getPrimaryKey());
                if (this.deleteUpdateStatPrimaryKeyIndexes == null) {
                    this.deleteUpdateStatPrimaryKeyIndexes = new ArrayList<Integer>();
                }
                if (this.deleteUpdateStatPrimaryKeyIndexes.size() == 0) {
                    for (int i = 0; i < this.collection.getBaseTable().columnList.size(); ++i) {
                        this.deleteUpdateStatPrimaryKeyIndexes.add(i);
                    }
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        HashMappedList cols = this.collection.getBaseTable().columnList;
        Iterator<Integer> keysIterator = this.deleteUpdateStatPrimaryKeyIndexes.iterator();
        boolean first = true;
        while (keysIterator.hasNext()) {
            int j = keysIterator.next();
            if (cols == null) continue;
            ColumnSchema col = (ColumnSchema)cols.get(j);
            if (!(col.dataType instanceof BinaryType)) {
                if (!first) {
                    builder.append(" AND ");
                }
                builder.append(col.getObjectName().statementName).append(" = ? ");
                first = false;
                continue;
            }
            keysIterator.remove();
        }
        return builder.toString();
    }

    private Result updateReplicationId(Session session, long replicationId) {
        try {
            Result result;
            if (this.updateReplicationId == null) {
                String buffer = "UPDATE RDS.REPLICAS set REPLICATION_ID = ? where DATASPACE_NAME = ? and NAME = ?";
                this.updateReplicationId = session.compileStatement(buffer);
            }
            if ((result = session.executeCompiledStatement(this.updateReplicationId, new Object[]{replicationId, this.name.schema.name, this.name.name})).isError() && this.raiseReplicationException(result.getException() != null ? result.getException() : new DataspaceException(result), true)) {
                this.trace(Trace.Level.ERROR, "Failed to update replicationId to value " + replicationId + "." + (String)(result.getException() != null ? " Cause: " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()) : ""), new Object[0]);
            }
            return result;
        }
        catch (Exception exception) {
            if (this.raiseReplicationException(exception, true)) {
                Trace.logException(this, exception, true);
            }
            return null;
        }
    }

    public boolean isAttachedToSource() {
        return this.state != ReplicaState.INACTIVE && this.state != ReplicaState.STOPPED && this.state != ReplicaState.FAILURE && this.state != ReplicaState.EVICTED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean raiseReplicationException(Throwable exception, boolean withExpiration) {
        if (withExpiration) {
            MessagesExpirationCache.MessageInfo messageInfo = this.messagesExpirationCache.addMessage(new ExceptionMessage(exception));
            if (messageInfo == null) return false;
            this.raiseReplicationExceptionAdvisory(exception, messageInfo);
            return true;
        } else {
            this.raiseReplicationExceptionAdvisory(exception, null);
        }
        return true;
    }

    private void raiseReplicaStateChangeAdvisory(String comment, MessagesExpirationCache.MessageInfo messageInfo) {
        try {
            Object repeatedInfo;
            this.trace(Trace.Level.INFO, "Replica state changed: state: {}, isSuspended: {}, comment: '{}'. {}", new Object[]{this.state, this.isSuspended, comment != null ? comment : "n/a", messageInfo != null ? messageInfo.getRepeatedInfo() : ""});
            Object object = repeatedInfo = messageInfo != null ? messageInfo.getRepeatedInfo() : "";
            if (repeatedInfo != null && ((String)repeatedInfo).length() > 0 && comment != null && comment.length() > 0) {
                repeatedInfo = "(" + (String)repeatedInfo + ")";
            }
            ReplicaStateChangeAdvisory advisory = new ReplicaStateChangeAdvisory();
            this.fillReplicaAdvisory(advisory);
            advisory.setSuspended(this.isSuspended);
            advisory.setReplicaState(this.state);
            advisory.setComment((String)(comment != null ? comment + " " + (String)repeatedInfo : repeatedInfo));
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception exception) {
            this.trace(Trace.Level.ERROR, "Failed to send replica state change advisory.", new Object[0]);
            Trace.logException(this, exception, true);
        }
    }

    private void raiseReplicationExceptionAdvisory(Throwable exception, MessagesExpirationCache.MessageInfo messageInfo) {
        try {
            this.trace(Trace.Level.INFO, "Replication exception caught: {}. {}", Utils.formatExceptionWithUnrepeatedCauses(exception), messageInfo != null ? messageInfo.getRepeatedInfo() : "");
            ReplicationExceptionAdvisory advisory = new ReplicationExceptionAdvisory();
            advisory.fillFromException(exception, messageInfo);
            this.fillReplicaAdvisory(advisory);
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception exception1) {
            this.trace(Trace.Level.ERROR, "Failed to send replication exception advisory.", new Object[0]);
            Trace.logException(this, exception1, true);
        }
    }

    private void fillReplicaAdvisory(AbstractReplicationAdvisory advisory) {
        advisory.setOriginator("replica");
        advisory.setSourceNodeName(this.sourceEntityName.getNodeName());
        advisory.setSourceDataspaceType(this.sourceEntityName.getDataspaceType());
        advisory.setSourceDataspaceName(this.sourceEntityName.getDataspaceName());
        advisory.setSourceName(this.sourceEntityName.getSourceOrReplicaName());
        advisory.setReplicaNodeName(this.targetEntityName.getNodeName());
        advisory.setReplicaDataspaceType(this.targetEntityName.getDataspaceType());
        advisory.setReplicaDataspaceName(this.targetEntityName.getDataspaceName());
        advisory.setReplicaName(this.targetEntityName.getSourceOrReplicaName());
        advisory.setReplicationId(this.replicationId.get());
    }

    public <T> T executeInRequestOrTargetSession(Session requestSession, Function<Session, T> function) {
        try (SessionWrapper wrapper = this.sessionWrapperHolder.getSessionWrapper(null);){
            T t = this.executeInRequestSessionOrSession(requestSession, wrapper.getSession(), function);
            return t;
        }
    }

    public <T> T executeInRequestSessionOrSession(Session requestSession, Session session, Function<Session, T> function) {
        if (requestSession != null) {
            return AbstractReplicationManager.executeWithPush(requestSession, function);
        }
        return function.apply(session);
    }

    public boolean isSyncSet() {
        return this.isSyncSet;
    }

    public ReplicaInfo getReplicaInfo(boolean withMetrics) {
        VirtualServerObject server;
        ReplicaInfo replicaInfo = new ReplicaInfo(this.targetEntityName, this.state, this.isSuspended, this.replicationId.get());
        replicaInfo.setWithMaterialization(this.withMaterialization);
        replicaInfo.setRenew(this.renewCollection);
        replicaInfo.setSuccessTriggers(new ArrayList<String>(this.successTriggers.keySet()));
        replicaInfo.setFailTriggers(new ArrayList<String>(this.failTriggers.keySet()));
        replicaInfo.setValidationTriggers(new ArrayList<String>(this.validationTriggers.keySet()));
        replicaInfo.setTransformTrigger(this.replicationModifyTrigger != null ? this.replicationModifyTrigger.getObjectName().name : null);
        replicaInfo.setTransformTriggerUsingMapper(this.replicationModifyTrigger != null ? this.replicationModifyTrigger.getMapperName() != null : false);
        replicaInfo.setTransformTriggerMappers(this.replicationModifyTrigger != null ? this.replicationModifyTrigger.getMapperNames() : null);
        replicaInfo.setEventScope(this.getEventScope());
        replicaInfo.setSourceEntityName(this.sourceEntityName);
        replicaInfo.setSync(this.isSyncSet ? Boolean.valueOf(this.sync) : null);
        Collection collectionLocal = this.collection;
        if (collectionLocal == null) {
            try {
                collectionLocal = (Collection)this.dataspace.lookupCollection(this.targetCollectionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        replicaInfo.setTargetCollectionType(collectionLocal != null ? collectionLocal.getCollectionType() : null);
        if (collectionLocal != null && collectionLocal instanceof VirtualTableCollection && (server = ((VirtualTableCollection)collectionLocal).getServer()) != null) {
            replicaInfo.setTargetVirtualServerName(server.getObjectName().getNameString());
            replicaInfo.setTargetVirtualServerType(server.getServerType());
        }
        replicaInfo.setLastError(this.lastError);
        replicaInfo.setSourceEnabled(this.sourceEnabled);
        replicaInfo.setMetaSchema(this.metaSchema);
        replicaInfo.setRetryCount(this.retryCount);
        replicaInfo.setLastTimeStartedStopped(this.lastTimeStartedStopped);
        replicaInfo.setLastTimeResumedSuspended(this.lastTimeResumedSuspended);
        replicaInfo.setLastTimeStateChanged(this.lastTimeStateChanged);
        replicaInfo.setUpsert(this.upsert);
        replicaInfo.setIgnoreOnFailDelete(this.ignoreOnFailDelete);
        replicaInfo.setIgnoreOnFailUpdate(this.ignoreOnFailUpdate);
        replicaInfo.setIgnoreOnFailInsert(this.ignoreOnFailInsert);
        replicaInfo.setPrimaryReplicationKey(this.primaryReplicationKey);
        replicaInfo.setPublishTimeWindow(this.publishTimeWindow);
        replicaInfo.setPublishTimeWindowUnit(this.publishTimeWindowUnit);
        replicaInfo.setPublishBatchWindow(this.publishBatchWindow);
        if (withMetrics) {
            replicaInfo.setReplicaMetricsReport(this.getReplicaMetricsReport());
        }
        return replicaInfo;
    }

    private void trace(Trace.Level level, String message, Object ... args) {
        if (Trace.isEnabled(this.getClass(), level)) {
            Trace.log(this, level, "Replica [" + String.valueOf(this.getTargetEntityName()) + "," + this.getState().getStateWithSourceDisabled(this.sourceEnabled) + "," + (this.isSuspended ? "suspended" : "resumed") + "," + this.getReplicationId() + "] : " + message, args);
        }
    }

    public boolean isSourceEnabled() {
        return this.sourceEnabled;
    }

    public boolean isRollbackOnFailure() {
        return this.rollbackOnFailure;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void alterRetryCount(int retryCount) {
        this.retryCount = retryCount;
        this.replicationManager.enqueueMonitorAction(new ReplicationManager.SendReplicaStateChangeAction(this, false));
    }

    public ReplicationDeliveryMetrics.ReplicaMetricsReport getReplicaMetricsReport() {
        return this.metrics.toReplicaMetricsReport();
    }

    public void alterUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    public void alterIgnoreOnFailDelete(boolean ignoreOnFailDelete) {
        this.ignoreOnFailDelete = ignoreOnFailDelete;
    }

    public void alterIgnoreOnFailUpdate(boolean ignoreOnFailUpdate) {
        this.ignoreOnFailUpdate = ignoreOnFailUpdate;
    }

    public void alterIgnoreOnFailInsert(boolean ignoreOnFailInsert) {
        this.ignoreOnFailInsert = ignoreOnFailInsert;
    }

    public void alterPrimaryReplicationKey(List<String> primaryReplicationKey) {
        this.checkPrimaryReplicationKey(primaryReplicationKey);
        this.primaryReplicationKey = primaryReplicationKey;
        if (this.primaryReplicationKey != null && this.primaryReplicationKey.size() == 0) {
            this.primaryReplicationKey = null;
        }
        this.primaryReplicationKeyIndexes = null;
        this.deleteUpdateStatPrimaryKeyIndexes = null;
    }

    private void checkPrimaryReplicationKey(List<String> key) {
        if (this.collection != null && key != null) {
            for (String column : key) {
                int columnIndex = this.collection.getBaseTable().findColumn(column);
                if (columnIndex != -1) continue;
                throw new DataspaceException("Invalid primary replication key specified. Column with name [" + column + "] doesn't exist in target table.");
            }
        }
    }

    private void buildPrimaryReplicationKeyIndexes() {
        if (this.primaryReplicationKey == null) {
            this.primaryReplicationKeyIndexes = null;
            return;
        }
        this.primaryReplicationKeyIndexes = new ArrayList<Integer>();
        for (String column : this.primaryReplicationKey) {
            int columnIndex = this.collection.getBaseTable().findColumn(column);
            if (columnIndex == -1) {
                throw new DataspaceException("Invalid primary replication key specified. Column with name [" + column + "] doesn't exist in target table.");
            }
            this.primaryReplicationKeyIndexes.add(columnIndex);
        }
    }

    public static String printPreparedStatement(Session session, String statement, Object[] parameters) {
        return ReplicationTarget.printPreparedStatement(session, new StringBuilder(), statement, parameters).toString();
    }

    public static StringBuilder printPreparedStatement(Session session, StringBuilder builder, String statement, Object[] parameters) {
        int originalBuilderLength = builder.length();
        try {
            Token<LexerFactory.DummyTokenType> token;
            Lexer<LexerFactory.DummyTokenType> lexer = LexerFactory.createLexer(statement);
            lexer.setSkipComments(false);
            int index = 0;
            int lastPosition = 0;
            while ((token = lexer.readToken()) != null && token.getCommonType() != CommonTokenType.BUFFER_END) {
                if (token.getCommonType() != CommonTokenType.QUESTION) continue;
                builder.append(statement.substring(lastPosition, lexer.getCurrentTokenPosition()));
                lastPosition = lexer.getCurrentPosition();
                if (index < parameters.length) {
                    Object parameter = parameters[index];
                    builder.append(ReplicationTarget.convertParameterToPrintable(session, parameter));
                } else {
                    builder.append("OUT_OF_INDEX_PARAMETER");
                }
                ++index;
            }
            builder.append(statement.substring(lastPosition));
        }
        catch (LexerException exception) {
            builder.setLength(originalBuilderLength);
            builder.append(statement).append("\n");
            builder.append(Arrays.asList(parameters).stream().map(p -> String.valueOf(p)).collect(Collectors.joining(",")));
            Trace.logException(ReplicationTarget.class, exception, true);
        }
        return builder;
    }

    private static String convertParameterToPrintable(Session session, Object parameter) {
        if (parameter == null) {
            return null;
        }
        if ((parameter = OtherTypeWrapper.unwrap(parameter)) instanceof TimeData) {
            parameter = Type.SQL_TIME.convertToString(parameter);
        } else if (parameter instanceof TimestampData) {
            parameter = Type.SQL_TIMESTAMP.convertToString(parameter);
        } else if (parameter instanceof Timestamp) {
            parameter = DataspaceDateTime.getSqlTimestampString((Timestamp)parameter, session != null ? session.getTimeZone() : null);
        } else if (parameter instanceof Time) {
            parameter = DataspaceDateTime.getSqlTimeString(((Time)parameter).getTime(), session != null ? session.getTimeZone() : null);
        } else if (parameter instanceof java.sql.Date) {
            parameter = DataspaceDateTime.getSqlDateString(((java.sql.Date)parameter).getTime(), session != null ? session.getTimeZone() : null);
        } else if (parameter instanceof Date) {
            parameter = DataspaceDateTime.getJavaDateTimeString((Date)parameter, session != null ? session.getTimeZone() : null);
        } else {
            if (parameter instanceof ClobData || parameter instanceof ClobDataID) {
                return "[ CLOB ]";
            }
            if (parameter instanceof BlobData || parameter instanceof BlobDataID) {
                return "[ BLOB ]";
            }
            if (parameter instanceof byte[]) {
                return StringConverter.byteArrayToSQLHexString((byte[])parameter);
            }
            if (parameter.getClass().isArray()) {
                return "[ ARRAY ]";
            }
            if (parameter.getClass().isPrimitive() || TypeFactory.unwrapBoxer(parameter.getClass()).isPrimitive()) {
                return String.valueOf(parameter);
            }
            if (!(parameter instanceof String)) {
                return "[ OBJECT " + parameter.getClass().getSimpleName() + " ]";
            }
        }
        if (parameter instanceof String) {
            parameter = "'" + String.valueOf(parameter) + "'";
        }
        return String.valueOf(parameter);
    }

    public void addValidationTrigger(ReplicationValidateTrigger trigger) {
        this.validationTriggers.put(trigger.getObjectName().name, trigger);
    }

    public ReplicationValidateTrigger getValidationTrigger(String name) {
        return this.validationTriggers.get(name);
    }

    public void removeValidationTrigger(ReplicationValidateTrigger trigger) {
        String name = trigger.getObjectName().name;
        trigger = this.validationTriggers.remove(name);
        if (trigger != null) {
            trigger.terminate();
        }
    }

    public List<String> listValidationTriggerNames() {
        return new ArrayList<String>(this.validationTriggers.keySet());
    }

    public ReplicationDataTransaction getLastReplicationUnit() {
        return this.lastReplicationUnit;
    }

    public void setReplicationModifyTrigger(ReplicationModifyTrigger trigger) {
        this.replicationModifyTrigger = trigger;
    }

    public ReplicationModifyTrigger getReplicationModifyTrigger() {
        return this.replicationModifyTrigger;
    }

    public void removeReplicationModifyTrigger() {
        if (this.replicationModifyTrigger != null) {
            this.needsReattach = "Replication modify trigger has been dropped. Reattach will be done automatically.";
            this.replicationModifyTrigger.terminate();
            this.replicationModifyTrigger = null;
        }
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.REPLICA;
    }

    @Override
    public String getEntityName() {
        return this.getTargetEntityName().getFullName();
    }

    @Override
    public EventScope getEntityScope() {
        return null;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return new HashMap<String, String>();
    }

    public ReplicationSourceInfo getReplicationSourceInfo() {
        return this.replicationSourceInfo;
    }

    public void enqueueReattachAction() {
        this.enqueueMonitorAction(new ReplicationManager.AttachToSourceMonitorAction(this));
    }

    private class SessionWrapperHolder {
        protected Session targetSession = null;
        protected Session targetSessionAcquired = null;
        protected boolean needToRecreateSession = false;
        protected boolean sessionClosed = false;
        protected final ReentrantLock sessionLock = new ReentrantLock();

        private SessionWrapper getSessionWrapper(Session parentSession) {
            this.sessionLock.lock();
            try {
                if (this.sessionClosed) {
                    SessionWrapper sessionWrapper = new SessionWrapper(null, this);
                    return sessionWrapper;
                }
                if (this.needToRecreateSession) {
                    if (this.targetSession != null) {
                        this.targetSession.close();
                        this.targetSession = null;
                    }
                    this.targetSessionAcquired = null;
                    this.needToRecreateSession = false;
                }
                if (this.targetSession == null) {
                    this.targetSession = ReplicationTarget.this.dataspace.createSession();
                    this.targetSession.disableReplication(true);
                }
                this.targetSession.setParentSessionId(parentSession != null && ReplicationTarget.this.sourceEntityName != null && ReplicationTarget.this.targetEntityName != null && Objects.equals(ReplicationTarget.this.sourceEntityName.getNodeName(), ReplicationTarget.this.targetEntityName.getNodeName()) ? parentSession.getId() : -1L);
                this.targetSessionAcquired = this.targetSession;
                this.targetSession = null;
                SessionWrapper sessionWrapper = new SessionWrapper(this.targetSessionAcquired, this);
                return sessionWrapper;
            }
            finally {
                this.sessionLock.unlock();
            }
        }

        private void openSession() {
            this.sessionLock.lock();
            try {
                this.sessionClosed = false;
            }
            finally {
                this.sessionLock.unlock();
            }
        }

        private void closeSession() {
            this.sessionLock.lock();
            try {
                if (this.targetSession != null) {
                    this.targetSession.close();
                    this.targetSession = null;
                }
                this.targetSessionAcquired = null;
                this.sessionClosed = true;
            }
            finally {
                this.sessionLock.unlock();
            }
        }

        private void needToRecreateSession() {
            this.sessionLock.lock();
            try {
                this.needToRecreateSession = true;
            }
            finally {
                this.sessionLock.unlock();
            }
        }
    }

    static class SessionWrapper
    implements AutoCloseable {
        private Session session;
        private SessionWrapperHolder holder;

        public SessionWrapper(Session session, SessionWrapperHolder holder) {
            this.session = session;
            this.holder = holder;
        }

        public Session getSession() {
            if (this.session == null || this.session.isClosed()) {
                throw new DataspaceException("Replication target is closed.");
            }
            return this.session;
        }

        @Override
        public void close() {
            this.holder.sessionLock.lock();
            try {
                if (this.holder.sessionClosed) {
                    this.session.close();
                    this.session = null;
                }
                if (this.session != null) {
                    if (this.session == this.holder.targetSessionAcquired) {
                        this.holder.targetSessionAcquired = null;
                        this.holder.targetSession = this.session;
                    } else {
                        this.session.close();
                    }
                }
            }
            finally {
                this.holder.sessionLock.unlock();
            }
        }
    }

    static class StateMessage
    implements MessagesExpirationCache.Message {
        private final ReplicaState state;
        private final String lastError;

        StateMessage(ReplicaState state, String lastError) {
            this.state = state;
            this.lastError = lastError;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateMessage)) {
                return false;
            }
            StateMessage that = (StateMessage)o;
            return this.state == that.state && Objects.equals(this.lastError, that.lastError);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.lastError});
        }
    }

    public static class ExceptionMessage
    implements MessagesExpirationCache.Message {
        private final String exceptionMessage;

        ExceptionMessage(Throwable exception) {
            this.exceptionMessage = Utils.formatExceptionWithUnrepeatedCauses(exception);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExceptionMessage)) {
                return false;
            }
            ExceptionMessage that = (ExceptionMessage)o;
            return Objects.equals(this.exceptionMessage, that.exceptionMessage);
        }

        public int hashCode() {
            return Objects.hash(this.exceptionMessage);
        }
    }

    static class ReplicationRowGroup {
        private List<Object[]> rows = new ArrayList<Object[]>();
        private Long replicationGroupId;

        public ReplicationRowGroup(Long replicationGroupId, Object[] row) {
            this.replicationGroupId = replicationGroupId;
            this.rows.add(row);
        }

        List<Object[]> getRows() {
            return this.rows;
        }

        void addRow(Object[] row) {
            this.rows.add(row);
        }

        Long getReplicationGroupId() {
            return this.replicationGroupId;
        }
    }
}

