/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.ds.replication.ReplicationMetricsPublisher;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.WindowMetricsQueue;

public class ReplicationSourceMetrics {
    private ReplicationSourceMetricsAggregator aggregatorGlobal = new ReplicationSourceMetricsAggregator();
    private ReplicationMetricsPublisher<ReplicationSourceMetric, ReplicationSourceMetricsReportFacet> publisher;

    public ReplicationSourceMetrics() {
        this.resetAll();
    }

    public synchronized void resetAll() {
        this.resetGlobal();
    }

    public synchronized void resetGlobal() {
        this.aggregatorGlobal.reset();
    }

    public synchronized void setPublishMetricsParameters(String name, long timeWindow, long unitCount, ReplicationMetricsPublisher.ReplicationMetricsPublisherConsumer<ReplicationSourceMetric, ReplicationSourceMetricsReportFacet> consumer) {
        if (timeWindow == 0L && unitCount == 0L) {
            if (this.publisher != null) {
                this.publisher.stop();
                this.publisher = null;
            }
        } else if (this.publisher == null) {
            this.publisher = new ReplicationMetricsPublisher<ReplicationSourceMetric, ReplicationSourceMetricsReportFacet>(name, new ReplicationSourceMetricsAggregator(), consumer);
            this.publisher.setTimeWindow(timeWindow);
            this.publisher.setCountWindow(unitCount);
            this.publisher.start();
        } else {
            if (consumer != null) {
                this.publisher.setConsumer(consumer);
            }
            this.publisher.setTimeWindow(timeWindow);
            this.publisher.setCountWindow(unitCount);
        }
    }

    public synchronized void addMetric(ReplicationSourceMetric metric) {
        this.aggregatorGlobal.addMetric(metric);
        if (this.publisher != null) {
            this.publisher.addMetric(metric);
        }
    }

    public synchronized ReplicationSourceMetricsReport toReplicationSourceMetricsReport() {
        ReplicationSourceMetricsReport report = new ReplicationSourceMetricsReport();
        report.global = this.aggregatorGlobal.toReport();
        return report;
    }

    public static class ReplicationSourceMetricsAggregator
    implements ReplicationMetricsPublisher.MetricsAggregator<ReplicationSourceMetric, ReplicationSourceMetricsReportFacet> {
        private long totalUnitsCount;
        private long totalRollbacksCount;
        private ReplicationSourceMetric total;
        private ReplicationSourceMetricsAggregatorTotal aggregatorTotal = new ReplicationSourceMetricsAggregatorTotal();
        private long minTimestamp = 0L;
        private long maxTimestamp = 0L;
        private long resetTime;

        @Override
        public synchronized void reset() {
            this.resetTime = System.currentTimeMillis();
            this.total = null;
            this.totalRollbacksCount = 0L;
            this.totalUnitsCount = 0L;
            this.minTimestamp = 0L;
            this.maxTimestamp = 0L;
        }

        @Override
        public synchronized void addMetric(ReplicationSourceMetric metric) {
            if (metric == null) {
                ++this.totalRollbacksCount;
                return;
            }
            ++this.totalUnitsCount;
            this.total = this.aggregatorTotal.add(this.total, metric, this.totalUnitsCount);
            if (this.minTimestamp == 0L) {
                this.minTimestamp = metric.getUnitCommitStartTime();
            }
            this.maxTimestamp = metric.getUnitCommitEndTime();
        }

        public synchronized ReplicationSourceMetricsAggregator copy() {
            ReplicationSourceMetricsAggregator copy = new ReplicationSourceMetricsAggregator();
            copy.totalUnitsCount = this.totalUnitsCount;
            copy.totalRollbacksCount = this.totalRollbacksCount;
            copy.total = this.total != null ? this.total.copy() : ReplicationSourceMetric.empty();
            copy.aggregatorTotal = this.aggregatorTotal;
            copy.minTimestamp = this.minTimestamp;
            copy.maxTimestamp = this.maxTimestamp;
            copy.resetTime = this.resetTime;
            return copy;
        }

        @Override
        public synchronized ReplicationSourceMetricsReportFacet toReport() {
            ReplicationSourceMetricsReportFacet global = new ReplicationSourceMetricsReportFacet();
            global.startTime = this.resetTime;
            global.endTime = System.currentTimeMillis();
            global.unitsCount = this.totalUnitsCount;
            global.rollbacksCount = this.totalRollbacksCount;
            global.minTimestamp = this.minTimestamp;
            global.maxTimestamp = this.maxTimestamp;
            global.total = this.total != null ? this.total.copy() : ReplicationSourceMetric.empty();
            global.averageInUnits = global.total.average(this.totalUnitsCount);
            return global;
        }
    }

    public static class ReplicationSourceMetric {
        private long statementsCount;
        private long insertsCount;
        private long updatesCount;
        private long deletesCount;
        private long truncatesCount;
        private long unitCommitStartTime;
        private long unitCommitEndTime;
        private long unitProcessingStartTime;
        private long unitProcessingEndTime;
        private long unitProcessingTargetStartTime;
        private long unitProcessingTargetEndTime;

        public ReplicationSourceMetric() {
        }

        public ReplicationSourceMetric(ReplicationSourceMetric metric) {
            this.statementsCount = metric.statementsCount;
            this.insertsCount = metric.insertsCount;
            this.updatesCount = metric.updatesCount;
            this.deletesCount = metric.deletesCount;
            this.truncatesCount = metric.truncatesCount;
            this.unitCommitStartTime = metric.unitCommitStartTime;
            this.unitCommitEndTime = metric.unitCommitEndTime;
            this.unitProcessingStartTime = metric.unitProcessingStartTime;
            this.unitProcessingEndTime = metric.unitProcessingEndTime;
            this.unitProcessingTargetStartTime = metric.unitProcessingTargetStartTime;
            this.unitProcessingTargetEndTime = metric.unitProcessingTargetEndTime;
        }

        public long getStatementsCount() {
            return this.statementsCount;
        }

        public long getInsertsCount() {
            return this.insertsCount;
        }

        public long getUpdatesCount() {
            return this.updatesCount;
        }

        public long getDeletesCount() {
            return this.deletesCount;
        }

        public long getTruncatesCount() {
            return this.truncatesCount;
        }

        public long getUnitCommitStartTime() {
            return this.unitCommitStartTime;
        }

        public long getUnitCommitEndTime() {
            return this.unitCommitEndTime;
        }

        public long getUnitProcessingStartTime() {
            return this.unitProcessingStartTime;
        }

        public long getUnitProcessingEndTime() {
            return this.unitProcessingEndTime;
        }

        public long getUnitProcessingTargetStartTime() {
            return this.unitProcessingTargetStartTime;
        }

        public long getUnitProcessingTargetEndTime() {
            return this.unitProcessingTargetEndTime;
        }

        public long getUnitCommitTime() {
            return this.unitCommitEndTime - this.unitCommitStartTime;
        }

        public long getUnitProcessingTime() {
            return this.unitProcessingEndTime - this.unitProcessingStartTime;
        }

        public long getUnitProcessingTargetTime() {
            return this.unitProcessingTargetEndTime - this.unitProcessingTargetStartTime;
        }

        public ReplicationSourceMetricAverage average(long count) {
            ReplicationSourceMetricAverage result = new ReplicationSourceMetricAverage(this);
            if (count <= 0L) {
                return result;
            }
            result.statementsCount /= (double)count;
            result.insertsCount /= (double)count;
            result.deletesCount /= (double)count;
            result.updatesCount /= (double)count;
            result.truncatesCount /= (double)count;
            result.unitCommitTime /= (double)count;
            result.unitProcessingTargetTime /= (double)count;
            result.unitProcessingTime /= (double)count;
            return result;
        }

        public ReplicationSourceMetric copy() {
            return new ReplicationSourceMetric(this);
        }

        public static ReplicationSourceMetricBuilder builder() {
            return new ReplicationSourceMetricBuilder();
        }

        public static ReplicationSourceMetric empty() {
            return new ReplicationSourceMetric();
        }

        public static class ReplicationSourceMetricBuilder {
            private ReplicationSourceMetric metric = new ReplicationSourceMetric();

            private ReplicationSourceMetricBuilder() {
            }

            public ReplicationSourceMetricBuilder setInsertsCount(long insertsCount) {
                this.metric.insertsCount = insertsCount;
                return this;
            }

            public ReplicationSourceMetricBuilder setUpdatesCount(long updatesCount) {
                this.metric.updatesCount = updatesCount;
                return this;
            }

            public ReplicationSourceMetricBuilder setDeletesCount(long deletesCount) {
                this.metric.deletesCount = deletesCount;
                return this;
            }

            public ReplicationSourceMetricBuilder setTruncatesCount(long truncatesCount) {
                this.metric.truncatesCount = truncatesCount;
                return this;
            }

            public ReplicationSourceMetricBuilder addInsert() {
                ++this.metric.insertsCount;
                return this;
            }

            public ReplicationSourceMetricBuilder addDelete() {
                ++this.metric.deletesCount;
                return this;
            }

            public ReplicationSourceMetricBuilder addUpdate() {
                ++this.metric.updatesCount;
                return this;
            }

            public ReplicationSourceMetricBuilder addTruncate() {
                ++this.metric.truncatesCount;
                return this;
            }

            public ReplicationSourceMetricBuilder addOperation(ReplicationOperationType operationType) {
                switch (operationType) {
                    case INSERT: {
                        ++this.metric.insertsCount;
                        break;
                    }
                    case DELETE: {
                        ++this.metric.deletesCount;
                        break;
                    }
                    case UPDATE: {
                        ++this.metric.updatesCount;
                        break;
                    }
                    case TRUNCATE: {
                        ++this.metric.truncatesCount;
                        break;
                    }
                }
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitCommitStartTime(long unitCommitStartTime) {
                this.metric.unitCommitStartTime = unitCommitStartTime;
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitCommitEndTime(long unitCommitEndTime) {
                this.metric.unitCommitEndTime = unitCommitEndTime;
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitCommitStartTime() {
                this.setUnitCommitStartTime(System.currentTimeMillis());
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitCommitEndTime() {
                this.setUnitCommitEndTime(System.currentTimeMillis());
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingStartTime() {
                this.setUnitProcessingStartTime(System.currentTimeMillis());
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingEndTime() {
                this.setUnitProcessingEndTime(System.currentTimeMillis());
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingTargetStartTime() {
                this.setUnitProcessingTargetStartTime(System.currentTimeMillis());
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingTargetEndTime() {
                this.setUnitProcessingTargetEndTime(System.currentTimeMillis());
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingStartTime(long unitProcessingStartTime) {
                this.metric.unitProcessingStartTime = unitProcessingStartTime;
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingEndTime(long unitProcessingEndTime) {
                this.metric.unitProcessingEndTime = unitProcessingEndTime;
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingTargetStartTime(long unitProcessingTargetStartTime) {
                this.metric.unitProcessingTargetStartTime = unitProcessingTargetStartTime;
                return this;
            }

            public ReplicationSourceMetricBuilder setUnitProcessingTargetEndTime(long unitProcessingTargetEndTime) {
                this.metric.unitProcessingTargetEndTime = unitProcessingTargetEndTime;
                return this;
            }

            public long getUnitCommitEndTime() {
                return this.metric.unitCommitEndTime;
            }

            public long getUnitProcessingTargetStartTime() {
                return this.metric.unitProcessingTargetStartTime;
            }

            public void addUnitProcessingTime(long duration) {
                this.metric.unitProcessingEndTime += duration;
            }

            public ReplicationSourceMetric build() {
                this.metric.statementsCount = this.metric.insertsCount + this.metric.deletesCount + this.metric.updatesCount + this.metric.truncatesCount;
                return this.metric;
            }
        }
    }

    public static class ReplicationSourceMetricsReport {
        private ReplicationSourceMetricsReportFacet global;

        public ReplicationSourceMetricsReportFacet getGlobal() {
            return this.global;
        }
    }

    public static class ReplicationSourceMetricsReportFacet {
        private long unitsCount;
        private long rollbacksCount;
        private long minTimestamp;
        private long maxTimestamp;
        private ReplicationSourceMetric total;
        private ReplicationSourceMetricAverage averageInUnits;
        private long startTime;
        private long endTime;

        public long getUnitsCount() {
            return this.unitsCount;
        }

        public long getRollbacksCount() {
            return this.rollbacksCount;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getMinTimestamp() {
            return this.minTimestamp;
        }

        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }

        public ReplicationSourceMetricAverage getAverageInUnits() {
            return this.averageInUnits;
        }

        public ReplicationSourceMetric getTotal() {
            return this.total;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }
    }

    public static class ReplicationSourceMetricWindowReport {
        private ReplicationSourceMetricsReportFacet facet;
        private ReplicationMetricsPublisher.PublisherInfo publisherInfo;

        public ReplicationSourceMetricWindowReport(ReplicationSourceMetricsReportFacet facet, ReplicationMetricsPublisher.PublisherInfo publisherInfo) {
            this.facet = facet;
            this.publisherInfo = publisherInfo;
        }

        public ReplicationSourceMetricsReportFacet getFacet() {
            return this.facet;
        }

        public ReplicationMetricsPublisher.PublisherInfo getPublisherInfo() {
            return this.publisherInfo;
        }
    }

    static class ReplicationSourceMetricsAggregatorTotal
    implements WindowMetricsQueue.MetricsAggregator<ReplicationSourceMetric, ReplicationSourceMetric> {
        ReplicationSourceMetricsAggregatorTotal() {
        }

        @Override
        public ReplicationSourceMetric add(ReplicationSourceMetric average, ReplicationSourceMetric metric, long newSize) {
            if (average != null) {
                average.statementsCount += metric.statementsCount;
                average.insertsCount += metric.insertsCount;
                average.updatesCount += metric.updatesCount;
                average.deletesCount += metric.deletesCount;
                average.truncatesCount += metric.truncatesCount;
                average.unitCommitEndTime += metric.unitCommitEndTime - metric.unitCommitStartTime;
                average.unitProcessingEndTime += metric.unitProcessingEndTime - metric.unitProcessingStartTime;
                average.unitProcessingTargetEndTime += metric.unitProcessingTargetEndTime - metric.unitProcessingTargetStartTime;
            } else {
                average = new ReplicationSourceMetric(metric);
                average.unitCommitEndTime -= average.unitCommitStartTime;
                average.unitCommitStartTime = 0L;
                average.unitProcessingEndTime -= average.unitProcessingStartTime;
                average.unitProcessingStartTime = 0L;
                average.unitProcessingTargetEndTime -= average.unitProcessingTargetStartTime;
                average.unitProcessingTargetStartTime = 0L;
            }
            return average;
        }

        @Override
        public ReplicationSourceMetric remove(ReplicationSourceMetric average, ReplicationSourceMetric metric, long newSize) {
            if (newSize == 0L || average == null) {
                return null;
            }
            if (average != null) {
                average.statementsCount -= metric.statementsCount;
                average.insertsCount -= metric.insertsCount;
                average.updatesCount -= metric.updatesCount;
                average.deletesCount -= metric.deletesCount;
                average.truncatesCount -= metric.truncatesCount;
                average.unitCommitEndTime -= metric.unitCommitEndTime - metric.unitCommitStartTime;
                average.unitProcessingEndTime -= metric.unitProcessingEndTime - metric.unitProcessingStartTime;
                average.unitProcessingTargetEndTime -= metric.unitProcessingTargetEndTime - metric.unitProcessingTargetStartTime;
            } else {
                average = new ReplicationSourceMetric(metric);
                average.unitCommitEndTime -= average.unitCommitStartTime;
                average.unitCommitStartTime = 0L;
                average.unitProcessingEndTime -= average.unitProcessingStartTime;
                average.unitProcessingStartTime = 0L;
                average.unitProcessingTargetEndTime -= average.unitProcessingTargetStartTime;
                average.unitProcessingTargetStartTime = 0L;
            }
            return average;
        }
    }

    public static class ReplicationSourceMetricAverage {
        private double statementsCount;
        private double insertsCount;
        private double updatesCount;
        private double deletesCount;
        private double truncatesCount;
        private double unitCommitTime;
        private double unitProcessingTime;
        private double unitProcessingTargetTime;

        public ReplicationSourceMetricAverage() {
        }

        public ReplicationSourceMetricAverage(ReplicationSourceMetric metric) {
            this.statementsCount = metric.statementsCount;
            this.insertsCount = metric.insertsCount;
            this.updatesCount = metric.updatesCount;
            this.deletesCount = metric.deletesCount;
            this.truncatesCount = metric.truncatesCount;
            this.unitCommitTime = metric.unitCommitEndTime - metric.unitCommitStartTime;
            this.unitProcessingTime = metric.unitProcessingEndTime - metric.unitProcessingStartTime;
            this.unitProcessingTargetTime = metric.unitProcessingTargetEndTime - metric.unitProcessingTargetStartTime;
        }

        public double getStatementsCount() {
            return this.statementsCount;
        }

        public double getInsertsCount() {
            return this.insertsCount;
        }

        public double getUpdatesCount() {
            return this.updatesCount;
        }

        public double getDeletesCount() {
            return this.deletesCount;
        }

        public double getTruncatesCount() {
            return this.truncatesCount;
        }

        public double getUnitCommitTime() {
            return this.unitCommitTime;
        }

        public double getUnitProcessingTime() {
            return this.unitProcessingTime;
        }

        public double getUnitProcessingTargetTime() {
            return this.unitProcessingTargetTime;
        }
    }
}

