/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.CountUpDownLatch;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.replication.AbstractReplicationEntity;
import com.streamscape.ds.replication.DurationTimer;
import com.streamscape.ds.replication.MessagesExpirationCache;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationDataBatch;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationDeliveryMetrics;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationErrorCode;
import com.streamscape.ds.replication.ReplicationException;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.replication.ReplicationQueueFileBased;
import com.streamscape.ds.replication.ReplicationRequest;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.replication.ReplicationSourceMetrics;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.table.AppendableFileTableReader;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.advisory.AbstractReplicationAdvisory;
import com.streamscape.sdo.advisory.ReplicaStateChangeAdvisory;
import com.streamscape.sdo.advisory.ReplicaTimeoutAdvisory;
import com.streamscape.sdo.advisory.ReplicationExceptionAdvisory;
import com.streamscape.sdo.advisory.ReplicationFailAdvisory;
import com.streamscape.sdo.advisory.ReplicationSourceMetricAdvisory;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.slex.SizeUnit;
import com.streamscape.tools.log.monitor.Utils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class ReplicationSource
extends AbstractReplicationEntity
implements AppendableFileTableReader.AppendableFileTableReaderReplicationListener,
SourceEventFlowData {
    protected ReplicationEntityName entityName;
    protected ReplicationSourceReference reference;
    protected CountUpDownLatch openedLatch = new CountUpDownLatch();
    protected volatile boolean opened = false;
    protected boolean enabled = true;
    protected boolean hasLobs = false;
    protected ReplicationSourceSettings replicationSourceSettings;
    protected ReplicationQueue.ReplicationQueueSettings replicationQueueSettings;
    protected ReplicationQueue replicationQueue;
    protected final SyncReplicaInfo syncReplicaInfo = new SyncReplicaInfo();
    protected AtomicInteger version = new AtomicInteger();
    protected AtomicLong replicationId = new AtomicLong();
    protected AtomicLong committedReplicationId = new AtomicLong();
    private final ReentrantLock sessionIdLock = new ReentrantLock();
    private final Condition sessionIdLockCondition = this.sessionIdLock.newCondition();
    private long sessionId = -1L;
    private ReplicationDataTransaction replicationDataTransaction = null;
    private ReplicationSourceMetrics.ReplicationSourceMetric.ReplicationSourceMetricBuilder replicationSourceMetricsBuilder = null;
    private ReplicationSourceMetrics replicationSourceMetrics = new ReplicationSourceMetrics();
    protected ReplicationStrategy strategy;
    protected Statement updateSourceReplicas;
    protected final PairedReplicasInfo pairedReplicasInfo = new PairedReplicasInfo();
    private MonitorWorker reportingWorker;
    private final ReentrantReadWriteLock alterLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock alterReadLock = this.alterLock.readLock();
    private final ReentrantReadWriteLock.WriteLock alterWriteLock = this.alterLock.writeLock();
    private MessagesExpirationCache messagesExpirationCache = new MessagesExpirationCache(900000L, 1800000L);

    public ReplicationSource(DataspaceStore store, Collection collection) {
        super(store, collection.getObjectName().schema.name, collection);
        this.collection = collection;
        this.entityName = new ReplicationEntityName(DataspaceStoreManager.getRuntimeContext().getName(), this.dataspace.getType(), this.dataspace.getName(), collection.getObjectName().name);
        this.hasLobs = collection.getBaseTable().hasLobColumn();
        this.openedLatch.setCount(1);
    }

    public void compile(Session session) {
        this.trace(Trace.Level.DEBUG, "Compiling...", new Object[0]);
        this.compileQueue(session, this.replicationSourceSettings, this.replicationQueueSettings);
        this.compileStrategy(session, this.replicationSourceSettings);
        String SQL = "update RDS.SOURCE_REPLICAS set REPLICATION_ID = ? where  SOURCE_DATASPACE_NAME = ? and  SOURCE_NAME = ? and  REPLICA_NODE = ? and  REPLICA_DATASPACE_NAME = ? and REPLICA_NAME = ?";
        this.updateSourceReplicas = session.compileStatement(SQL);
        try {
            this.dataspace.bindProducerForSystem("advisory.replica.StateChange", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.replication.Exception", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.replica.Timeout", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.replication.source.Metrics", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.replication.Fail", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        this.trace(Trace.Level.DEBUG, "Compiled.", new Object[0]);
    }

    private void compileQueue(Session session, ReplicationSourceSettings replicationSourceSettings, ReplicationQueue.ReplicationQueueSettings replicationQueueSettings) {
        if (!replicationSourceSettings.sync.booleanValue()) {
            this.replicationQueue = new ReplicationQueueFileBased(this.dataspace, this.replicationManager, this, replicationQueueSettings);
        }
        if (this.replicationQueue != null) {
            this.replicationQueue.compile(session, null);
            if (this.replicationQueue.getReplicationQueueStorage() != null) {
                this.store.schemaManager.addSchemaObject(this.replicationQueue.getReplicationQueueStorage());
            }
            this.replicationQueue.compileInternalStatements(session);
        }
    }

    private void compileStrategy(Session session, ReplicationSourceSettings replicationSourceSettings) {
        this.strategy = replicationSourceSettings.sync == false ? new AsyncReplicationStrategy() : (replicationSourceSettings.rollbackOnFailure != false ? new RollbackOnFailureReplicationStrategy() : new SyncReplicationStrategy());
        this.strategy.compile(session);
    }

    public void open(Session session) {
        this.trace(Trace.Level.DEBUG, "Opening...", new Object[0]);
        if (this.opened) {
            throw new DataspaceException("Replication source '" + this.getReplicationEntityName().getFullNameNoDataspaceTypeNoNodeName() + "' already opened.");
        }
        this.replicationManager.addSource(this);
        this.initReference();
        Result temp = session.executeDirectStatement("select VERSION, REPLICATION_ID from  RDS.REPLICATION_SOURCES  where  DATASPACE_NAME = '" + this.collection.getObjectName().schema.name + "' and  NAME = '" + this.collection.getObjectName().name + "'");
        if (temp == null || temp.isError() || !temp.isData() || temp.navigator == null) {
            throw new DataspaceException("Unable to add retrieve information about replication source from the registry. " + (temp != null && temp.getException() != null ? Utils.formatException(temp.getException()) : ""));
        }
        if (temp.navigator.next() && temp.navigator.getCurrent(0) instanceof Integer && temp.navigator.getCurrent(1) instanceof Long) {
            int version = (Integer)temp.navigator.getCurrent(0);
            long replicationId = (Long)temp.navigator.getCurrent(1);
            this.setInitVersion(version);
            this.setInitReplicationId(replicationId);
        } else {
            this.setInitVersion(1);
            this.setInitReplicationId(0L);
            temp = session.executeDirectStatement("insert into RDS.REPLICATION_SOURCES  values ('" + this.dataspace.getType() + "','" + this.dataspace.getName() + "','" + this.collection.getObjectName().name + "', " + this.getVersion() + ", " + this.getReplicationId() + ")");
            if (temp == null || temp.isError()) {
                throw new DataspaceException("Unable to add information about new replication source to the registry. " + (temp != null && temp.getException() != null ? Utils.formatException(temp.getException()) : ""));
            }
        }
        if (this.collection instanceof JournalFileTableCollection && this.collection.getBaseTable() instanceof FileTable) {
            FileTable table = (FileTable)this.collection.getBaseTable();
            table.setAppendableReaderListener(this);
        }
        this.openReplicationQueueAndReplicas(session);
        if (this.replicationQueue != null) {
            try {
                Result result = session.executeDirectStatement("select max(ReplicationId) from " + ReplicationQueue.getQueueFullNameNoNodeName(this.getObjectName().schema.name, this.getReplicationEntityName().getSourceOrReplicaName()));
                if (result.isError()) {
                    this.raiseReplicationException(result.getException() != null ? result.getException() : new DataspaceException(result), false);
                } else if (result.navigator.next()) {
                    long maxReplicationId = -1L;
                    if (result.navigator.getCurrent(0) != null) {
                        maxReplicationId = ((Number)result.navigator.getCurrent(0)).longValue();
                        if (maxReplicationId > this.replicationId.get()) {
                            String error = "WARNING: max replicationId(" + maxReplicationId + ") from replication queue > source replicationId(" + this.replicationId.get() + "). Set source replicationId to " + maxReplicationId + ".";
                            this.raiseReplicationException(new Exception(error), false);
                            this.trace(Trace.Level.ERROR, error, new Object[0]);
                            this.replicationId.set(maxReplicationId);
                        } else if (maxReplicationId < this.replicationId.get()) {
                            String error = "WARNING: max replicationId(" + maxReplicationId + ") from replication queue < source replication Id(" + this.replicationId.get() + "). ";
                            this.raiseReplicationException(new Exception(error), false);
                            this.trace(Trace.Level.ERROR, error, new Object[0]);
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.raiseReplicationException(exception, false);
                Trace.logException(this, exception, true);
            }
        }
        DataspaceStore.getContext();
        if (RuntimeContext.isInitialized()) {
            this.replicationManager.enqueueMonitorAction(new ReplicationManager.CheckSourceReplicasAction(this));
        }
        this.startPublisher(this.replicationSourceSettings);
        this.opened = true;
        this.openedLatch.setCount(0);
        this.trace(Trace.Level.INFO, "Opened. Batch size: {}, batch interval: {}, batch error interval: {}.", this.replicationQueueSettings.batchSize, this.replicationQueueSettings.batchInterval, this.replicationQueueSettings.batchIntervalError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openReplicationQueueAndReplicas(Session session) {
        if (this.replicationQueue != null) {
            this.replicationQueue.open(session);
        }
        List<ReplicaInfo> replicas = this.listReplicas(session);
        for (ReplicaInfo replica : replicas) {
            if (replica.getState() == ReplicaState.EVICTED) continue;
            this.pairedReplicasInfo.addReplica(replica);
        }
        if (this.replicationQueue == null) {
            SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
            synchronized (syncReplicaInfo) {
                if (replicas.size() > 0 && this.syncReplicaInfo.getRequestConsumerReference() == null) {
                    this.syncReplicaInfo.setEntityName(replicas.get(0).getReplicaEntityName());
                }
            }
        }
    }

    synchronized void initReference() {
        if (this.reference == null) {
            this.reference = this.replicationManager.addSourceReference(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInsert(Session session, Object[] newData, Long groupId) {
        if (session.isReplicationDisabled()) {
            return;
        }
        this.checkOpened();
        this.lockReplicationIdForSession(session);
        if (this.pairedReplicasInfo.getPairedReplicasCount() == 0) {
            return;
        }
        ReplicationSource replicationSource = this;
        synchronized (replicationSource) {
            newData = this.extractLobs(session, newData, null);
            this.replicationDataTransaction.addData(new ReplicationData(ReplicationOperationType.INSERT, newData, groupId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelete(Session session, Table table, Object[] data, boolean handlePrimaryKey, Long groupId) {
        if (session.isReplicationDisabled()) {
            return;
        }
        this.checkOpened();
        this.lockReplicationIdForSession(session);
        if (this.pairedReplicasInfo.getPairedReplicasCount() == 0) {
            return;
        }
        ReplicationSource replicationSource = this;
        synchronized (replicationSource) {
            if (handlePrimaryKey) {
                data = this.reduceRowToKeys(data, this.pairedReplicasInfo.getPrimaryKey());
            }
            data = this.extractLobs(session, data, this.pairedReplicasInfo.getPrimaryKey());
            this.replicationDataTransaction.addData(new ReplicationData(ReplicationOperationType.DELETE, data, groupId, this.pairedReplicasInfo.getPrimaryKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate(Session session, Table table, Object[] oldData, Object[] newData, boolean handlePrimaryKey, Long groupId) {
        if (session.isReplicationDisabled()) {
            return;
        }
        this.checkOpened();
        this.lockReplicationIdForSession(session);
        if (this.pairedReplicasInfo.getPairedReplicasCount() == 0) {
            return;
        }
        ReplicationSource replicationSource = this;
        synchronized (replicationSource) {
            oldData = this.reduceRowToKeys(oldData, this.pairedReplicasInfo.getPrimaryKey());
            newData = this.extractLobs(session, newData, null);
            oldData = this.extractLobs(session, oldData, this.pairedReplicasInfo.getPrimaryKey());
            this.replicationDataTransaction.addData(new ReplicationData(oldData, newData, this.pairedReplicasInfo.getPrimaryKey()));
        }
    }

    private void checkOpened() {
        try {
            this.openedLatch.await(10000L);
        }
        catch (InterruptedException exception) {
            Thread.interrupted();
        }
        if (!this.opened) {
            throw new DataspaceException("Replication source '" + this.getReplicationEntityName().getFullNameNoDataspaceTypeNoNodeName() + "' is not opened.");
        }
    }

    private Object[] extractLobs(Session session, Object[] rowData, List<Integer> primaryKey) {
        if (this.hasLobs) {
            rowData = Arrays.copyOf(rowData, rowData.length);
            int counter = -1;
            for (int i = 0; i < this.collection.getBaseTable().getColumnTypes().length; ++i) {
                Type colType;
                if (primaryKey != null && primaryKey.size() > 0 && primaryKey.size() != this.collection.getBaseTable().columnCount) {
                    counter = primaryKey.indexOf(i);
                    if (counter == -1) {
                        continue;
                    }
                } else {
                    ++counter;
                }
                if (!(colType = this.collection.getBaseTable().getColumnTypes()[i]).isLobType()) continue;
                try {
                    if (rowData[counter] instanceof BlobData) {
                        rowData[counter] = SqlUtils.extractBlob(session, (BlobDataID)rowData[counter]);
                        continue;
                    }
                    if (!(rowData[counter] instanceof ClobData)) continue;
                    rowData[counter] = SqlUtils.extractClob(session, (ClobData)rowData[counter]);
                    continue;
                }
                catch (SQLException error) {
                    this.trace(Trace.Level.ERROR, "Unable to replicate lob for the column '" + this.collection.getBaseTable().getColumn(counter).getNameString(), new Object[0]);
                    Trace.logException(this, error, true);
                    throw new DataspaceException("Unable to replicate lob for the column '" + this.collection.getBaseTable().getColumn(counter).getNameString() + "'. " + Utils.formatExceptionWithUnrepeatedCauses(error));
                }
            }
        }
        return rowData;
    }

    private Object[] reduceRowToKeys(Object[] rowData, List<Integer> primaryKey) {
        if (primaryKey != null && primaryKey.size() != 0 && primaryKey.size() != rowData.length) {
            Object[] rowDataReduced = new Object[primaryKey.size()];
            int i = 0;
            for (Integer key : primaryKey) {
                rowDataReduced[i++] = rowData[key];
            }
            rowData = rowDataReduced;
        }
        return rowData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTruncate(Session session, Table table) {
        if (session.isReplicationDisabled() || !table.isReplicated()) {
            return;
        }
        this.checkOpened();
        if (table instanceof FileTable && ((FileTable)table).getParent() instanceof JournalFileTableCollection) {
            return;
        }
        this.lockReplicationIdForSession(session);
        if (this.pairedReplicasInfo.getPairedReplicasCount() == 0) {
            return;
        }
        ReplicationSource replicationSource = this;
        synchronized (replicationSource) {
            int newVersion = this.version.incrementAndGet();
            long currentRepId = this.replicationId.get();
            Result result = session.executeDirectStatement("update RDS.REPLICATION_SOURCES  set VERSION = " + newVersion + ", REPLICATION_ID = " + currentRepId + "  where DATASPACE_TYPE = '" + this.dataspace.getType() + "' and DATASPACE_NAME = '" + this.dataspace.getName() + "' and NAME = '" + this.getName() + "'");
            if (result.isError()) {
                this.raiseReplicationException(result.getException() != null ? result.getException() : new DataspaceException(result), true);
                this.dataspace.logError("Unable to update replication source version after truncate. " + (result.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(result.getException()) : ""));
            }
            this.replicationDataTransaction.addData(new ReplicationData(ReplicationOperationType.TRUNCATE));
        }
    }

    private void lockReplicationIdForSession(Session session) {
        block7: {
            this.sessionIdLock.lock();
            try {
                if (this.sessionId == session.getId()) break block7;
                while (!Thread.currentThread().isInterrupted()) {
                    if (this.sessionId == -1L) {
                        this.sessionId = session.getId();
                        this.replicationDataTransaction = new ReplicationDataTransaction(this.replicationId.incrementAndGet());
                        this.replicationSourceMetricsBuilder = ReplicationSourceMetrics.ReplicationSourceMetric.builder();
                        this.replicationSourceMetricsBuilder.setUnitCommitStartTime();
                        break;
                    }
                    try {
                        this.sessionIdLockCondition.await();
                    }
                    catch (InterruptedException exception) {
                        Thread.interrupted();
                    }
                }
            }
            finally {
                this.sessionIdLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unlockReplicationIdForSession(Session session, boolean rollback) {
        this.sessionIdLock.lock();
        try {
            if (this.sessionId == session.getId()) {
                this.sessionId = -1L;
                if (rollback) {
                    this.replicationId.set(this.committedReplicationId.get());
                    this.strategy.rollbackCommit();
                    this.replicationSourceMetrics.addMetric(null);
                } else {
                    this.committedReplicationId.set(this.replicationId.get());
                    DurationTimer timer = new DurationTimer();
                    this.strategy.applyCommitP2();
                    timer.stop();
                    if (this.replicationSourceMetricsBuilder != null && this.replicationSourceMetricsBuilder.getUnitCommitEndTime() > 0L) {
                        this.replicationSourceMetricsBuilder.addUnitProcessingTime(timer.getDuration());
                        this.replicationSourceMetrics.addMetric(this.replicationSourceMetricsBuilder.build());
                    }
                }
                this.replicationDataTransaction = null;
                this.replicationSourceMetricsBuilder = null;
                this.sessionIdLockCondition.signalAll();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sessionIdLock.unlock();
        }
    }

    @Override
    public void onBeforeCommit(Session session) {
        if (this.replicationDataTransaction == null) {
            return;
        }
        this.strategy.applyCommitP1(session, this.replicationDataTransaction, this.entityName);
    }

    @Override
    public void onAfterCommit(Session session) {
        if (this.replicationDataTransaction == null) {
            return;
        }
        if (this.unlockReplicationIdForSession(session, false)) {
            this.strategy.onAfterCommit();
        }
    }

    @Override
    public void onAfterCommitConfirm(Session session) {
        if (this.unlockReplicationIdForSession(session, true)) {
            this.strategy.onAfterCommit();
        }
    }

    public synchronized void onRename(Session session) {
        this.replicationManager.removeSource(this);
        ReplicationEntityName oldName = this.entityName;
        this.entityName = new ReplicationEntityName(DataspaceStoreManager.getRuntimeContext().getName(), this.dataspace.getType(), this.dataspace.getName(), this.collection.getObjectName().name);
        if (!session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
            session.sessionContext.postponedStatements.add(session.compileStatement("delete from RDS.REPLICATION_SOURCES  where DATASPACE_TYPE = '" + this.dataspace.getType() + "' and DATASPACE_NAME = '" + this.dataspace.getName() + "' and NAME = '" + this.collection.getObjectName().name + "'"));
            session.sessionContext.postponedStatements.add(session.compileStatement("update RDS.REPLICATION_SOURCES  set DATASPACE_NAME = '" + this.dataspace.getName() + "', NAME = '" + this.collection.getObjectName().name + "' where DATASPACE_TYPE = '" + this.dataspace.getType() + "' and DATASPACE_NAME = '" + oldName.getDataspaceName() + "' and NAME = '" + oldName.getSourceOrReplicaName() + "'"));
            session.sessionContext.postponedStatements.add(session.compileStatement("delete from  RDS.SOURCE_REPLICAS  where SOURCE_DATASPACE_TYPE = '" + this.dataspace.getType() + "' and SOURCE_DATASPACE_NAME = '" + this.dataspace.getName() + "' and SOURCE_NAME = '" + this.collection.getObjectName().name + "'"));
            session.sessionContext.postponedStatements.add(session.compileStatement("update RDS.SOURCE_REPLICAS  set SOURCE_DATASPACE_NAME = '" + this.dataspace.getName() + "', SOURCE_NAME = '" + this.collection.getObjectName().name + "'  where SOURCE_DATASPACE_TYPE = '" + this.dataspace.getType() + "' and SOURCE_DATASPACE_NAME = '" + oldName.getDataspaceName() + "' and SOURCE_NAME = '" + oldName.getSourceOrReplicaName() + "'"));
        }
        if (this.replicationQueue != null) {
            this.replicationQueue.onRename(session);
        }
        this.replicationManager.addSource(this);
        if (this.dataspace.getState() == ComponentState.STARTED) {
            this.initReference();
        }
    }

    @Override
    public void onJftAppend(Session session, Object[] data, Long groupId) {
        if (session.isReplicationDisabled()) {
            return;
        }
        Object[] newData = new Object[data.length - 3];
        System.arraycopy(data, 3, newData, 0, data.length - 3);
        if (data[2].equals("I") || data[2].equals("U")) {
            this.onInsert(session, newData, groupId);
        } else if (data[2].equals("D") || data[2].equals("X")) {
            this.onDelete(session, this.collection.getBaseTable(), newData, false, groupId);
        }
    }

    @Override
    public void onJftTruncate(Session session) {
        this.onTruncate(session, this.collection.getBaseTable());
    }

    public ReplicationEntityName getReplicationEntityName() {
        return this.entityName;
    }

    public synchronized void enable(Session session) {
        this.trace(Trace.Level.DEBUG, "Enabled.", new Object[0]);
        this.enabled = true;
        this.replicationManager.updateSourceReference(this);
        this.startPublisher(this.replicationSourceSettings);
    }

    public synchronized void disable() {
        this.trace(Trace.Level.DEBUG, "Disabled.", new Object[0]);
        this.enabled = false;
        this.replicationManager.updateSourceReference(this);
        this.stopPublisher();
    }

    public synchronized void close(Session session) {
        this.trace(Trace.Level.DEBUG, "Closing...", new Object[0]);
        this.openedLatch.setCount(1);
        this.opened = false;
        this.stopPublisher();
        if (this.collection instanceof JournalFileTableCollection && this.collection.getBaseTable() instanceof FileTable) {
            FileTable table = (FileTable)this.collection.getBaseTable();
            table.removeAppendableReaderListener();
        }
        if (this.replicationQueue != null) {
            this.replicationQueue.close();
        }
        this.trace(Trace.Level.DEBUG, "Closed.", new Object[0]);
    }

    public synchronized void destroy(Session session) {
        this.trace(Trace.Level.DEBUG, "Destroying...", new Object[0]);
        try {
            this.dataspace.unbindProducerFor("advisory.replica.StateChange", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataspace.unbindProducerFor("advisory.replication.Exception", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataspace.unbindProducerFor("advisory.replica.Timeout", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataspace.unbindProducerFor("advisory.replication.source.Metrics", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataspace.unbindProducerFor("advisory.replication.Fail", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.trace(Trace.Level.DEBUG, "Removing from SOURCE_REPLICAS", new Object[0]);
        Result result = session.executeDirectStatement("delete from RDS.SOURCE_REPLICAS where SOURCE_DATASPACE_NAME = '" + this.getObjectName().schema.name + "' and SOURCE_NAME='" + this.getName() + "'");
        session.clearWarnings();
        if (result.isError() && result.getException() != null) {
            this.trace(Trace.Level.ERROR, "Failed to remove source-replica pairs for source. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(result.getException()), new Object[0]);
        }
        this.trace(Trace.Level.DEBUG, "Removing from REPLICATION_SOURCES", new Object[0]);
        result = session.executeDirectStatement("delete from RDS.REPLICATION_SOURCES  where  DATASPACE_NAME = '" + this.getObjectName().schema.name + "'and NAME = '" + this.getObjectName().name + "'");
        session.clearWarnings();
        if (result == null || result.isError()) {
            this.trace(Trace.Level.ERROR, "Unable to remove information about replication source from the registry. " + (result != null && result.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(result.getException()) : ""), new Object[0]);
        }
        this.destroyReplicationQueue(session);
        this.replicationManager.removeSource(this);
        this.replicationManager = null;
        this.reference = null;
        if (this.collection != null) {
            this.collection.setReplicationSource(null);
        }
        this.trace(Trace.Level.DEBUG, "Destroyed.", new Object[0]);
    }

    private void destroyReplicationQueue(Session session) {
        if (this.replicationQueue != null) {
            this.trace(Trace.Level.DEBUG, "Removing replication queue.", new Object[0]);
            if (this.replicationQueue.getReplicationQueueStorage() != null) {
                this.store.schemaManager.removeSchemaObject(this.replicationQueue.getReplicationQueueStorage().getObjectName());
                if (!session.isProcessingRecoveryLog() && !session.isProcessingLog()) {
                    session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.DROP_OBJECT, "drop table " + NameManager.quoteNameIfNeeded(this.replicationQueue.getReplicationQueueStorage().getObjectName().name) + " if exists", this.replicationQueue.getReplicationQueueStorage().getObjectName());
                }
            }
            this.replicationQueue.destroy();
        }
    }

    public String getSQL() {
        StringBuilder sb;
        block20: {
            block19: {
                sb = new StringBuilder();
                sb.append("CREATE").append(' ');
                sb.append("REPLICATION").append(' ');
                sb.append("SOURCE").append(' ');
                sb.append("AT").append(' ');
                sb.append(this.collection.getObjectName().getSchemaQualifiedStatementName());
                if (this.replicationSourceSettings.sync.booleanValue()) {
                    sb.append(' ').append("SYNC");
                } else {
                    sb.append(' ').append("ASYNC");
                }
                if (this.replicationSourceSettings.rollbackOnFailure.booleanValue()) {
                    sb.append(' ').append("ROLLBACK").append(' ');
                    sb.append("ON").append(' ').append("FAILURE");
                }
                if (!this.replicationSourceSettings.sync.booleanValue()) {
                    if (this.replicationQueueSettings.batchSize != 1000) {
                        sb.append(' ').append("BATCH").append(' ');
                        sb.append("SIZE").append(' ').append(this.replicationQueueSettings.batchSize);
                    }
                    if (this.replicationQueueSettings.batchInterval != 1000L) {
                        sb.append(' ').append("BATCH").append(' ');
                        sb.append("INTERVAL").append(' ').append(this.replicationQueueSettings.batchInterval);
                    }
                    if (this.replicationQueueSettings.batchIntervalError != 20000L) {
                        sb.append(' ').append("BATCH").append(' ').append("ERROR").append(' ');
                        sb.append("INTERVAL").append(' ').append(this.replicationQueueSettings.batchIntervalError);
                    }
                    if (this.replicationSourceSettings.batchTimeout != 60000L) {
                        sb.append(' ').append("BATCH").append(' ');
                        sb.append("TIMEOUT").append(' ').append(this.replicationSourceSettings.batchTimeout);
                    }
                    if (this.replicationQueueSettings.queueMaxSize != 0L) {
                        sb.append(' ').append("QUEUE").append(' ');
                        sb.append("SIZE").append(' ').append(SizeUnit.convertToBestEvent(this.replicationQueueSettings.queueMaxSize, SizeUnit.BYTES).toString());
                    }
                    if (this.replicationQueueSettings.type == ReplicationQueue.QueueType.JOURNAL_FILE) {
                        if (this.replicationQueueSettings.queueFileMaxFileSize != 0x8000000L) {
                            sb.append(' ').append("QUEUE").append(' ');
                            sb.append("BLOCK").append(' ').append("SIZE").append(' ');
                            sb.append(SizeUnit.convertToBestEvent(this.replicationQueueSettings.queueFileMaxFileSize, SizeUnit.BYTES).toString());
                        }
                        if (this.replicationQueueSettings.queueFileWriteBufferSize != 16384L) {
                            sb.append(' ').append("WRITE").append(' ').append("BUFFER").append(' ').append("SIZE").append(' ');
                            sb.append(SizeUnit.convertToBestEvent(this.replicationQueueSettings.queueFileWriteBufferSize, SizeUnit.BYTES).toString());
                        }
                        if (this.replicationQueueSettings.queueFileWriteFlushDelay != 500L) {
                            sb.append(' ').append("WRITE").append(' ').append("FLUSH").append(' ').append("DELAY").append(' ').append(this.replicationQueueSettings.queueFileWriteFlushDelay);
                        }
                        if (this.replicationQueueSettings.transactionPersistenceType != ReplicationQueue.ReplicationQueueSettings.DEFAULT_TRANSACTION_PERSISTENCE_TYPE) {
                            sb.append(' ').append("RU").append(' ').append("PERSIST").append(' ').append(this.replicationQueueSettings.transactionPersistenceType.toString().toLowerCase());
                        }
                    }
                }
                if (this.replicationSourceSettings.publishMetricsTimeWindow != 0L) break block19;
                if (this.replicationSourceSettings.publishMetricsUnitWindow == 0) break block20;
            }
            sb.append(' ').append("PUBLISH").append(' ').append("STATISTICS").append(' ').append("FOR").append(' ');
            if (this.replicationSourceSettings.publishMetricsTimeWindow != 0L) {
                sb.append(' ').append("TIME").append(' ').append("WINDOW").append(' ').append(this.replicationSourceSettings.publishMetricsTimeWindow).append(' ');
                SqlUtils.timeUnitToString(sb, this.replicationSourceSettings.publishMetricsTimeWindowUnit);
            }
            if (this.replicationSourceSettings.publishMetricsUnitWindow != 0) {
                sb.append(' ').append("UNIT").append(' ').append("WINDOW").append(' ').append(this.replicationSourceSettings.publishMetricsUnitWindow);
            }
        }
        return sb.toString();
    }

    public FabricAddress getComponentAddress() {
        return this.dataspace.getFabricAddress();
    }

    public EventScope getEventScope() {
        return this.dataspace.getEventScope();
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ReplicationSourceReference getReference() {
        return this.reference;
    }

    @Override
    public String getName() {
        return this.collection.getObjectName().name;
    }

    public ReplicationQueue getReplicationQueue() {
        return this.replicationQueue;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.collection.getObjectName();
    }

    public ReplicationQueue.ReplicationQueueSettings getReplicationQueueSettings() {
        return this.replicationQueueSettings;
    }

    public void setReplicationQueueSettings(ReplicationQueue.ReplicationQueueSettings replicationQueueSettings) {
        this.replicationQueueSettings = replicationQueueSettings;
    }

    public void setReplicationSourceSettings(ReplicationSourceSettings replicationSourceSettings) {
        this.replicationSourceSettings = replicationSourceSettings;
    }

    public ReplicationSourceSettings getReplicationSourceSettings() {
        return this.replicationSourceSettings;
    }

    public void setInitReplicationId(long replicationId) {
        this.replicationId.set(replicationId);
        this.committedReplicationId.set(replicationId);
    }

    public long getReplicationId() {
        return this.replicationId.get();
    }

    public long getCommittedReplicationId() {
        return this.committedReplicationId.get();
    }

    public void setInitVersion(int version) {
        this.version.set(version);
    }

    public int getVersion() {
        return this.version.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachOrUpdateReplica(ReplicationRequest request) throws ReplicationException {
        if (!this.alterReadLock.tryLock()) {
            throw new ReplicationException(ReplicationErrorCode.ALTER_IS_IN_PROGRESS, "Replication source alter is in progress.");
        }
        try {
            RequestConsumerReference replicaRequestConsumer;
            this.trace(Trace.Level.DEBUG, "Attaching or updating replica {}...", request.getReplicaEntityName());
            if (request.getSourceTableSchemaChangeTimestamp() != -1L && request.getSourceTableSchemaChangeTimestamp() != this.collection.getBaseTable().tableSchemaChangeTimestamp) {
                this.detachReplica(request, false);
                throw new ReplicationException(ReplicationErrorCode.SOURCE_TABLE_SCHEMA_CHANGED, "Source table schema has been changed. Reattach is required.");
            }
            if (this.replicationManager.executeInManagerOrRequestSession(request.getSession(), session -> this.updateSourceReplicasTable((Session)session, request)) == 0) {
                this.detachReplica(request, false);
                throw new ReplicationException(ReplicationErrorCode.SOURCE_AND_REPLICA_NOT_PAIRED, "Source and replica not paired.");
            }
            this.pairedReplicasInfo.addReplica(request);
            ReplicationQueue replicationQueue = this.replicationQueue;
            if (replicationQueue != null) {
                this.replicationManager.enqueueMonitorAction(new ReplicationManager.CleanupReplicationQueue(replicationQueue));
            }
            if ((replicaRequestConsumer = this.replicationManager.lookupReplicaConsumer(request.getReplicaEntityName().getNodeName(), request.getReplicaEntityName().getDataspaceType(), request.getReplicaEntityName().getDataspaceName(), request.getReplicaEntityName().getSourceOrReplicaName())) == null) {
                throw new ReplicationException(ReplicationErrorCode.REPLICA_CONSUMER_NOT_FOUND, "Unable to resolve replica '" + request.getReplicaEntityName().getSourceOrReplicaName() + "' request consumer. ");
            }
            if (replicationQueue != null) {
                replicationQueue.attachOrUpdateReplica(request, replicaRequestConsumer);
            } else {
                SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
                synchronized (syncReplicaInfo) {
                    if (this.syncReplicaInfo.getEntityName() == null || this.syncReplicaInfo.metrics == null) {
                        this.syncReplicaInfo.setMetrics(this.createDeliveryMetrics());
                    }
                    this.syncReplicaInfo.setEntityName(request.getReplicaEntityName());
                    this.syncReplicaInfo.setRequestConsumerReference(replicaRequestConsumer);
                    this.syncReplicaInfo.setReplicaStateAndSuspended(request.getReplicaState(), request.isSuspended());
                    this.syncReplicaInfo.setRetryCount(request.getRetryCount());
                }
            }
            if (this.replicationManager.executeInManagerOrRequestSession(request.getSession(), session -> this.listPairedReplicas((Session)session, request.getReplicaEntityName())).size() == 0) {
                this.detachReplica(request, true);
                throw new ReplicationException(ReplicationErrorCode.SOURCE_AND_REPLICA_NOT_PAIRED, "Source and replica is evicted.");
            }
            this.replicationManager.addSourceReference(this);
        }
        finally {
            this.alterReadLock.unlock();
        }
    }

    public void detachAllReplicas(Session requestSession) {
        this.trace(Trace.Level.DEBUG, "Detaching all replicas", new Object[0]);
        for (ReplicaInfo replica : this.listAttachedReplicas()) {
            this.detachReplica(replica.getReplicaEntityName(), requestSession, false, -1L);
        }
    }

    public void detachAllReplicasFromDataspace(String nodeName, String dataspaceType, String dataspaceName, boolean withRemove, long timestamp) {
        this.trace(Trace.Level.DEBUG, "Detaching all replicas from dataspace {}://{}.{}. Timestamp: {}.", nodeName, dataspaceType, dataspaceName, timestamp);
        for (ReplicaInfo replica : this.listAttachedReplicas()) {
            if (!replica.getReplicaEntityName().getNodeName().equals(nodeName) || dataspaceName != null && (!replica.getReplicaEntityName().getDataspaceType().equals(dataspaceType) || !replica.getReplicaEntityName().getDataspaceName().equals(dataspaceName))) continue;
            this.detachReplica(replica.getReplicaEntityName(), null, false, timestamp);
        }
    }

    public void detachReplicaIfAttached(ReplicationEntityName replicaEntityName, Session requestSession, boolean withRemove, long timestamp) {
        this.trace(Trace.Level.DEBUG, "Detaching replica {} if attached. Timestamp: {}.", replicaEntityName, timestamp);
        for (ReplicaInfo replica : this.listAttachedReplicas()) {
            if (!replica.getReplicaEntityName().equalsNoCollection(replicaEntityName)) continue;
            this.detachReplica(replicaEntityName, requestSession, withRemove, timestamp);
        }
    }

    public void detachReplica(ReplicationRequest request, boolean withRemove) {
        this.detachReplica(request.getReplicaEntityName(), request.getSession(), withRemove, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachReplica(ReplicationEntityName replicaEntityName, Session requestSession, boolean withRemove, long timestamp) {
        if (!this.alterReadLock.tryLock()) {
            throw new ReplicationException(ReplicationErrorCode.ALTER_IS_IN_PROGRESS, "Replication source alter is in progress.");
        }
        try {
            this.trace(Trace.Level.DEBUG, "Detaching replica {} with remove: {}. Timestamp: {}.", replicaEntityName, withRemove, timestamp);
            boolean detached = false;
            if (this.replicationQueue != null) {
                detached = this.replicationQueue.detachReplica(replicaEntityName, timestamp, withRemove);
                this.replicationManager.executeInManagerOrRequestSession(requestSession, session -> this.replicationQueue.deleteAcknowledgedDataFromReplicationQueue((Session)session, null));
            } else {
                SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
                synchronized (syncReplicaInfo) {
                    if (this.syncReplicaInfo.getEntityName() != null && this.syncReplicaInfo.getEntityName().equalsNoCollection(replicaEntityName) && (timestamp == -1L || timestamp > this.syncReplicaInfo.getUpdateTimestamp())) {
                        this.syncReplicaInfo.setRequestConsumerReference(null);
                        this.syncReplicaInfo.setReplicaState(withRemove ? ReplicaState.DROPPED : ReplicaState.INACTIVE);
                        if (withRemove) {
                            this.syncReplicaInfo.setEntityName(null);
                            this.syncReplicaInfo.setMetrics(null);
                        }
                        detached = true;
                    } else if (this.syncReplicaInfo.getEntityName() == null) {
                        detached = true;
                    }
                }
            }
            if (detached) {
                if (withRemove) {
                    this.replicationManager.executeInManagerOrRequestSession(requestSession, session -> this.removeFromSourceReplicasTable((Session)session, replicaEntityName));
                    this.pairedReplicasInfo.removeReplica(replicaEntityName);
                } else {
                    this.replicationManager.executeInManagerOrRequestSession(requestSession, session -> this.detachFromSourceReplicasTable((Session)session, replicaEntityName));
                }
            }
        }
        finally {
            this.alterReadLock.unlock();
        }
    }

    public void evictReplica(ReplicationEntityName replicaEntityName, Session requestSession) {
        if (!this.alterReadLock.tryLock()) {
            throw new ReplicationException(ReplicationErrorCode.ALTER_IS_IN_PROGRESS, "Replication source alter is in progress.");
        }
        try {
            this.trace(Trace.Level.DEBUG, "Evicting replica {}.", replicaEntityName);
            this.replicationManager.executeInManagerOrRequestSession(null, session -> this.removeFromSourceReplicasTable((Session)session, replicaEntityName));
            this.pairedReplicasInfo.removeReplica(replicaEntityName);
            this.detachReplica(replicaEntityName, requestSession, true, -1L);
            if (this.replicationQueue != null) {
                this.replicationQueue.deleteAcknowledgedDataFromReplicationQueue(requestSession, null);
            }
            this.replicationManager.updateSourceReplicasReference(this, requestSession);
        }
        finally {
            this.alterReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplicaInfo> listAttachedReplicas() {
        ArrayList<ReplicaInfo> result = new ArrayList<ReplicaInfo>();
        if (!this.alterReadLock.tryLock()) {
            return result;
        }
        try {
            SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
            synchronized (syncReplicaInfo) {
                if (this.replicationQueue != null) {
                    result.addAll(this.replicationQueue.listAttachedReplicas());
                } else if (this.syncReplicaInfo.entityName != null) {
                    result.add(new ReplicaInfo(this.syncReplicaInfo.getEntityName(), this.syncReplicaInfo.getReplicaState(), this.syncReplicaInfo.isSuspended(), this.syncReplicaInfo.getReplicationId()));
                }
                ArrayList<ReplicaInfo> arrayList = result;
                return arrayList;
            }
        }
        finally {
            this.alterReadLock.unlock();
        }
    }

    public List<ReplicaInfo> listReplicas(Session session) {
        List<ReplicaInfo> allReplicasInfo = this.listPairedReplicas(session);
        List<ReplicaInfo> attachedReplicas = this.listAttachedReplicas();
        ArrayList<ReplicaInfo> result = new ArrayList<ReplicaInfo>();
        for (ReplicaInfo replicaInfo : allReplicasInfo) {
            boolean attached = false;
            for (ReplicaInfo attachedReplica : attachedReplicas) {
                if (!attachedReplica.getReplicaEntityName().equalsNoCollection(replicaInfo.getReplicaEntityName())) continue;
                result.add(attachedReplica);
                attached = true;
                break;
            }
            if (attached) continue;
            if (replicaInfo.getState() != ReplicaState.EVICTED) {
                replicaInfo.setState(null);
            }
            result.add(replicaInfo);
        }
        return result;
    }

    public void checkSourceReplicas(Session session) {
        List<ReplicaInfo> allReplicas = this.listReplicas(session);
        for (ReplicaInfo replicaInfo : allReplicas) {
            long requestTimestamp = System.currentTimeMillis();
            ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.CHECK_REPLICA_EXISTS);
            request.setReplicaEntityName(replicaInfo.getReplicaEntityName());
            if (replicaInfo.getState() != null && replicaInfo.getState() != ReplicaState.EVICTED) {
                request.setReplicaState(replicaInfo.getState());
                request.setSuspended(replicaInfo.isSuspended());
            } else {
                request.setReplicaState(null);
            }
            try {
                ReplicationResponse response = this.replicationManager.sendReplicationManagementRequest(request, replicaInfo.getReplicaEntityName());
                if (!response.isOk() || response.getReplicaInfo() == null) continue;
                if (response.getReplicaInfo().isNotExists()) {
                    this.trace(Trace.Level.DEBUG, "WARNING: Replica {} is not present in target dataspace. Detaching and unpair it from source..", replicaInfo.getReplicaEntityName());
                    this.detachReplica(replicaInfo.getReplicaEntityName(), session, true, requestTimestamp);
                    this.replicationManager.updateSourceReplicasReference(this, session);
                    continue;
                }
                this.pairedReplicasInfo.addReplica(response.getReplicaInfo());
            }
            catch (ReplicationException exception) {
                if (exception.getCode() == ReplicationErrorCode.REPLICATION_MANAGER_NOT_REACHABLE) {
                    this.trace(Trace.Level.DEBUG, "WARNING: Replication manager not reachable. Detaching replica: " + String.valueOf(replicaInfo.getReplicaEntityName()) + ".", new Object[0]);
                    if (Trace.isDebugEnabled(this.getClass())) {
                        Trace.logException(this, exception, true);
                    }
                    this.detachReplica(replicaInfo.getReplicaEntityName(), session, false, requestTimestamp);
                    this.replicationManager.updateSourceReplicasReference(this, session);
                    continue;
                }
                Trace.logException(this, exception, false);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    public void sendSourceUpdatedForPairedReplicas(Session session) {
        this.trace(Trace.Level.DEBUG, "Sending source is updated to attached replicas.", new Object[0]);
        for (ReplicaInfo replicaInfo : this.listPairedReplicas(session)) {
            this.sendSourceUpdatedForReplica(session, replicaInfo.getReplicaEntityName());
        }
    }

    public void sendSourceUpdatedForReplica(Session session, ReplicationEntityName replicaEntityName) {
        this.trace(Trace.Level.DEBUG, "Sending source is updated to replica {}.", replicaEntityName);
        ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.SOURCE_FOR_REPLICA_IS_UPDATED);
        request.setReplicaEntityName(replicaEntityName);
        try {
            this.replicationManager.sendReplicationManagementRequest(request, replicaEntityName, 2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReplicaInfo checkReplicaIsPairedWithSource(ReplicationRequest request) throws ReplicationException {
        try {
            this.trace(Trace.Level.DEBUG, "Checking paired replicas for replica {}.", request.getReplicaEntityName());
            List replicas = this.replicationManager.executeInManagerOrRequestSession(request.getSession(), session -> this.listPairedReplicas((Session)session));
            this.trace(Trace.Level.DEBUG, "Paired replicas: {}.", replicas.stream().map(r -> r.getReplicaEntityName()).collect(Collectors.toList()));
            for (ReplicaInfo replicaInfo : replicas) {
                if (!replicaInfo.getReplicaEntityName().equalsNoCollection(request.getReplicaEntityName())) continue;
                return replicaInfo;
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            throw new ReplicationException(ReplicationErrorCode.INTERNAL_ERROR, "Internal Error: " + exception.getMessage());
        }
        throw new ReplicationException(ReplicationErrorCode.SOURCE_AND_REPLICA_NOT_PAIRED, "Replica is not paired with replication source. Recreate replica to pair again.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplicaToSource(ReplicationRequest request) throws ReplicationException {
        if (!this.alterReadLock.tryLock()) {
            throw new ReplicationException(ReplicationErrorCode.ALTER_IS_IN_PROGRESS, "Replication source alter is in progress.");
        }
        try {
            this.trace(Trace.Level.DEBUG, "Adding replica {} to source.", request.getReplicaEntityName());
            List replicas = this.replicationManager.executeInManagerOrRequestSession(request.getSession(), session -> this.listPairedReplicas((Session)session));
            if (replicas.size() > 0 && this.replicationSourceSettings.sync.booleanValue()) {
                throw new ReplicationException(ReplicationErrorCode.SOURCE_ALREADY_PAIRED, "Synchronous replication source '" + this.getReplicationEntityName().toString() + "' is already paired with replica '" + ((ReplicaInfo)replicas.get(0)).getReplicaEntityName().toString() + "'. Synchronous source can be paired with one replica only.");
            }
            for (ReplicaInfo replicaIndo : replicas) {
                if (!replicaIndo.getReplicaEntityName().equalsNoCollection(request.getReplicaEntityName())) continue;
                throw new ReplicationException(ReplicationErrorCode.SOURCE_ALREADY_PAIRED, "Replication source '" + this.getReplicationEntityName().toString() + "' is already paired with this replica '" + replicaIndo.getReplicaEntityName().toString() + "'. Unlink them first.");
            }
            this.replicationManager.executeInManagerOrRequestSession(request.getSession(), session -> this.insertSourceReplicaRecord((Session)session, request));
            this.pairedReplicasInfo.addReplica(request);
        }
        finally {
            this.alterReadLock.unlock();
        }
    }

    private List<ReplicaInfo> listPairedReplicas(Session session) {
        Result result = session.executeDirectStatement("select REPLICA_NODE, REPLICA_DATASPACE_TYPE, REPLICA_DATASPACE_NAME, REPLICA_NAME, REPLICATION_ID, PRIMARY_KEY, STATE from RDS.SOURCE_REPLICAS where  SOURCE_DATASPACE_TYPE = '" + this.dataspace.getType() + "' and  SOURCE_DATASPACE_NAME = '" + this.dataspace.getName() + "' and SOURCE_NAME = '" + this.getName() + "'");
        if (result.isError()) {
            throw result.getException() != null ? result.getException() : new DataspaceException("Failed to select from SOURCE_REPLICAS table.");
        }
        ArrayList<ReplicaInfo> replicas = new ArrayList<ReplicaInfo>();
        RowSetNavigator navigator = result.getNavigator();
        while (navigator.next()) {
            Object[] current = navigator.getCurrent();
            ReplicaInfo info = new ReplicaInfo(new ReplicationEntityName((String)current[0], (String)current[1], (String)current[2], (String)current[3], null), false);
            info.setReplicationId((Long)current[4]);
            info.setSourceEnabled(this.enabled);
            info.setPrimaryKey(ReplicationSource.intArrayToList((Object[])current[5]));
            try {
                info.setState(ReplicaState.valueOf(((String)current[6]).toUpperCase()));
            }
            catch (Exception exception) {
                info.setState(ReplicaState.INACTIVE);
            }
            replicas.add(info);
        }
        return replicas;
    }

    private List<ReplicaInfo> listPairedReplicas(Session session, ReplicationEntityName replicaEntityName) {
        Result result = session.executeDirectStatement("select REPLICATION_ID, PRIMARY_KEY from RDS.SOURCE_REPLICAS where  SOURCE_DATASPACE_TYPE = '" + this.dataspace.getType() + "' and  SOURCE_DATASPACE_NAME = '" + this.dataspace.getName() + "' and SOURCE_NAME = '" + this.getName() + "' and REPLICA_NODE = '" + replicaEntityName.getNodeName() + "' and  REPLICA_DATASPACE_TYPE = '" + replicaEntityName.getDataspaceType() + "' and  REPLICA_DATASPACE_NAME = '" + replicaEntityName.getDataspaceName() + "' and  REPLICA_NAME = '" + replicaEntityName.getSourceOrReplicaName() + "'");
        if (result.isError()) {
            throw result.getException() != null ? result.getException() : new DataspaceException("Failed to select from SOURCE_REPLICAS table.");
        }
        ArrayList<ReplicaInfo> replicas = new ArrayList<ReplicaInfo>();
        RowSetNavigator navigator = result.getNavigator();
        while (navigator.next()) {
            Object[] current = navigator.getCurrent();
            ReplicaInfo info = new ReplicaInfo(replicaEntityName, false);
            info.setReplicationId((Long)current[0]);
            info.setPrimaryKey(ReplicationSource.intArrayToList((Object[])current[1]));
            replicas.add(info);
        }
        return replicas;
    }

    public static List<Integer> intArrayToList(int[] a) {
        if (a == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int aa : a) {
            list.add(aa);
        }
        return list;
    }

    public static List<Integer> intArrayToList(Object[] a) {
        if (a == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object aa : a) {
            list.add((Integer)aa);
        }
        return list;
    }

    private int detachFromSourceReplicasTable(Session session, ReplicationEntityName replicaEntityName) {
        this.trace(Trace.Level.DEBUG, "Detaching replica {} from source-replicas table.", replicaEntityName);
        Result result = session.executeDirectStatement("update RDS.SOURCE_REPLICAS set STATE = 'INACTIVE', LAST_MODIFIED=now() where  SOURCE_DATASPACE_NAME = '" + this.dataspace.getName() + "' and SOURCE_NAME = '" + this.getName() + "' and REPLICA_NODE = '" + replicaEntityName.getNodeName() + "' and REPLICA_DATASPACE_NAME = '" + replicaEntityName.getDataspaceName() + "' and REPLICA_NAME = '" + replicaEntityName.getSourceOrReplicaName() + "'");
        return result.getUpdateCount();
    }

    private int insertSourceReplicaRecord(Session session, ReplicationRequest request) throws ReplicationException {
        Result result = session.executeDirectStatement("insert into RDS.SOURCE_REPLICAS values('" + this.dataspace.getType() + "', '" + this.dataspace.getName() + "', '" + request.getSourceName() + "','" + request.getReplicaEntityName().getNodeName() + "','" + request.getReplicaEntityName().getDataspaceType().toUpperCase() + "','" + request.getReplicaEntityName().getDataspaceName() + "','" + request.getReplicaEntityName().getSourceOrReplicaName() + "','" + request.getReplicaState().name() + "'," + request.getReplicationId() + ", now()," + (String)(request.getPrimaryKey() != null ? "ARRAY" + String.valueOf(request.getPrimaryKey()) : "null") + ")");
        Object errorMessage = null;
        try {
            if (result.isError()) {
                errorMessage = result.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(result.getException()) : "Insert failed.";
            }
        }
        catch (Exception exception) {
            errorMessage = Utils.formatExceptionWithUnrepeatedCauses(exception);
        }
        if (errorMessage != null) {
            errorMessage = "Failed to pair source '" + this.getReplicationEntityName().toString() + "' and replica '" + request.getReplicaEntityName().toString() + "'. " + (String)errorMessage;
            throw new ReplicationException(ReplicationErrorCode.INTERNAL_ERROR, (String)errorMessage);
        }
        return result.getUpdateCount();
    }

    private int updateSourceReplicasTable(Session session, ReplicationRequest request) {
        Result result = session.executeDirectStatement("update RDS.SOURCE_REPLICAS set STATE = '" + request.getReplicaState().name() + "', LAST_MODIFIED=now(), REPLICATION_ID = " + String.valueOf(request.getReplicationId() != -2L ? Long.valueOf(request.getReplicationId()) : "REPLICATION_ID") + ",  PRIMARY_KEY=" + (String)(request.getPrimaryKey() != null ? "ARRAY" + String.valueOf(request.getPrimaryKey()) : "PRIMARY_KEY") + " where  SOURCE_DATASPACE_NAME = '" + this.dataspace.getName() + "' and SOURCE_NAME = '" + this.getName() + "' and REPLICA_NODE = '" + request.getReplicaEntityName().getNodeName() + "' and REPLICA_DATASPACE_NAME = '" + request.getReplicaEntityName().getDataspaceName() + "' and REPLICA_NAME = '" + request.getReplicaEntityName().getSourceOrReplicaName() + "'");
        if (result.isError()) {
            this.dataspace.logError("ERROR: unable to update replica '" + String.valueOf(request.getReplicaEntityName()) + "' state and replicationId for source '" + this.getName() + "'. " + (result.getException() != null ? Utils.formatException(result.getException()) : ""));
        }
        if (result.getUpdateCount() == 0) {
            this.dataspace.logError("ERROR: unable to update replica '" + String.valueOf(request.getReplicaEntityName()) + "' state and replicationId for source '" + this.getName() + "'.");
        }
        return result.getUpdateCount();
    }

    private int removeFromSourceReplicasTable(Session session, ReplicationEntityName replicaEntityName) {
        this.trace(Trace.Level.DEBUG, "Removing replica {} from source-replicas table.", replicaEntityName);
        Result result = session.executeDirectStatement("delete from RDS.SOURCE_REPLICAS where SOURCE_DATASPACE_NAME = '" + this.dataspace.getName() + "'  and SOURCE_NAME = '" + this.getName() + "' and REPLICA_NODE = '" + replicaEntityName.getNodeName() + "' and REPLICA_DATASPACE_NAME = '" + replicaEntityName.getDataspaceName() + "' and REPLICA_NAME = '" + replicaEntityName.getSourceOrReplicaName() + "'");
        if (result.isError()) {
            this.dataspace.logError("ERROR: unable to remove replica '" + String.valueOf(replicaEntityName) + "' meta data for source '" + this.getName() + "'. " + (result.getException() != null ? Utils.formatException(result.getException()) : ""));
        }
        return result.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSourceReplicasReplicationId(Session session, ReplicationEntityName replicaEntityName, Long replicationId) {
        Statement statement = this.updateSourceReplicas;
        synchronized (statement) {
            int count = 0;
            Result result = null;
            while (count < 10) {
                try {
                    ++count;
                    result = this.updateSourceReplicasReplicationIdInternal(session, replicaEntityName, replicationId, this.updateSourceReplicas);
                    if (result.isError()) continue;
                    break;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            }
            if (result.isError()) {
                this.dataspace.logError("Unable to update source-replicas '" + String.valueOf(replicaEntityName) + "' for source '" + String.valueOf(this.entityName) + "'. " + count + " attempts have been done." + (result.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(result.getException()) : ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result updateSourceReplicasReplicationIdInternal(Session session, ReplicationEntityName replicaEntityName, Long replicationId, Statement statement) {
        Object[] params = new Object[]{replicationId, this.getObjectName().schema.name, this.getName(), replicaEntityName.getNodeName(), replicaEntityName.getDataspaceName(), replicaEntityName.getSourceOrReplicaName()};
        if (!session.isInMidTransaction() && !session.executingReplication && session.getCurrentStatementCounter() == 0 && session.sessionContext.depth == 0) {
            return session.executeCompiledStatement(statement, params);
        }
        session.sessionContext.pushDynamicArgumentsWithRowActionList(params);
        try {
            Result result = statement.execute(session);
            return result;
        }
        finally {
            session.redoAction = false;
            session.sessionContext.popWithWithRowActionList();
        }
    }

    public ReplicationError getReplicationErrors() {
        ReplicationQueue replicationQueue = this.replicationQueue;
        if (replicationQueue != null) {
            return replicationQueue.getReplicationErrors();
        }
        if (this.syncReplicaInfo.replicationError != null) {
            return this.syncReplicaInfo.replicationError.clone();
        }
        return new ReplicationError();
    }

    private void trace(Trace.Level level, String message, Object ... args) {
        if (Trace.isEnabled(this.getClass(), level)) {
            Trace.log(this, level, "Replication source [" + String.valueOf(this.getReplicationEntityName()) + "," + (this.replicationSourceSettings.sync != false ? "sync" : "async") + "," + (this.enabled ? "enabled" : "disabled") + "," + this.getReplicationId() + ":" + this.getCommittedReplicationId() + "] : " + message, args);
        }
    }

    public void raiseTimeoutAdvisory(ReplicationEntityName replicaEntityName, long timeout, ReplicationDataBatch batch) {
        try {
            ReplicaTimeoutAdvisory advisory = new ReplicaTimeoutAdvisory();
            this.fillReplicaAdvisory(advisory, replicaEntityName, batch.getCurrentReplicationId());
            advisory.setTimeout(timeout);
            advisory.setBatchSize(batch.size());
            advisory.setBatchSizeInBytes(batch.getSizeInBytes());
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception exception) {
            this.trace(Trace.Level.ERROR, "Failed to send replica timeout advisory for replica {}.", replicaEntityName.getFullName());
            Trace.logException(this, exception, true);
        }
    }

    public void raiseReplicaStateChangeAdvisory(ReplicationEntityName replicaEntityName, ReplicaState replicaState, boolean isSuspended, long replicationId) {
        try {
            this.trace(Trace.Level.INFO, "Replica state changed: name: {}, state: {}, isSuspended: {}, replicationId: {}", new Object[]{replicaEntityName.getFullNameNoDataspaceType(), replicaState, isSuspended, replicationId});
            ReplicaStateChangeAdvisory advisory = new ReplicaStateChangeAdvisory();
            this.fillReplicaAdvisory(advisory, replicaEntityName, replicationId);
            advisory.setSuspended(isSuspended);
            advisory.setReplicaState(replicaState);
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception exception) {
            this.trace(Trace.Level.ERROR, "Failed to send replica state change advisory for replica {}.", replicaEntityName.getFullName());
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public boolean raiseReplicationException(Throwable exception, boolean withExpiration) {
        this.raiseReplicationException(null, -3L, exception, true);
        return withExpiration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean raiseReplicationException(ReplicationEntityName replicaEntityName, long replicationId, Throwable exception, boolean withExpiration) {
        if (withExpiration) {
            MessagesExpirationCache.MessageInfo messageInfo = this.messagesExpirationCache.addMessage(new ReplicationTarget.ExceptionMessage(exception));
            if (messageInfo == null) return false;
            this.raiseReplicationExceptionAdvisory(replicaEntityName, replicationId, exception, messageInfo);
            return true;
        } else {
            this.raiseReplicationExceptionAdvisory(replicaEntityName, replicationId, exception, null);
        }
        return true;
    }

    private void raiseReplicationExceptionAdvisory(ReplicationEntityName replicaEntityName, long replicationId, Throwable exception, MessagesExpirationCache.MessageInfo messageInfo) {
        try {
            if (replicaEntityName != null) {
                this.trace(Trace.Level.DEBUG, "Replication exception caught for replica {}, replicationId: {}: {}. {}", replicaEntityName.getFullNameNoDataspaceType(), replicationId, Utils.formatExceptionWithUnrepeatedCauses(exception), messageInfo != null ? messageInfo.getRepeatedInfo() : "");
            } else {
                this.trace(Trace.Level.DEBUG, "Replication exception caught: {}. {}", Utils.formatExceptionWithUnrepeatedCauses(exception), messageInfo != null ? messageInfo.getRepeatedInfo() : "");
            }
            ReplicationExceptionAdvisory advisory = new ReplicationExceptionAdvisory();
            advisory.fillFromException(exception, messageInfo);
            this.fillReplicaAdvisory(advisory, replicaEntityName, replicationId);
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception exception1) {
            this.trace(Trace.Level.ERROR, "Failed to send replication exception advisory.", new Object[0]);
            Trace.logException(this, exception1, true);
        }
    }

    private void fillReplicaAdvisory(AbstractReplicationAdvisory advisory, ReplicationEntityName replicaEntityName, long replicationId) {
        advisory.setOriginator("source");
        advisory.setSourceNodeName(this.getReplicationEntityName().getNodeName());
        advisory.setSourceDataspaceType(this.getReplicationEntityName().getDataspaceType());
        advisory.setSourceDataspaceName(this.getReplicationEntityName().getDataspaceName());
        advisory.setSourceName(this.getReplicationEntityName().getSourceOrReplicaName());
        if (replicaEntityName != null) {
            advisory.setReplicaNodeName(replicaEntityName.getNodeName());
            advisory.setReplicaDataspaceType(replicaEntityName.getDataspaceType());
            advisory.setReplicaDataspaceName(replicaEntityName.getDataspaceName());
            advisory.setReplicaName(replicaEntityName.getSourceOrReplicaName());
        }
        advisory.setReplicationId(replicationId);
    }

    public ReplicationDeliveryMetrics createDeliveryMetrics() {
        ReplicationDeliveryMetrics metrics = new ReplicationDeliveryMetrics();
        metrics.addGlobalMinMaxComparator("DELIVERY_TIME", (o1, o2) -> Long.compare(o1.getDeliveryTime(), o2.getDeliveryTime()));
        metrics.addGlobalMinMaxComparator("NETWORK_TIME", (o1, o2) -> Long.compare(o1.getNetworkTime(), o2.getNetworkTime()));
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> getReplicaMetricsReportMap() {
        HashMap<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> map = new HashMap<String, ReplicationDeliveryMetrics.ReplicaMetricsReport>();
        ReplicationQueue replicationQueue = this.replicationQueue;
        if (replicationQueue != null) {
            map.putAll(replicationQueue.getMetricsReportMap());
        } else {
            SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
            synchronized (syncReplicaInfo) {
                if (this.syncReplicaInfo.getEntityName() != null && this.syncReplicaInfo.metrics != null) {
                    map.put(this.syncReplicaInfo.getEntityName().getFullName(), this.syncReplicaInfo.metrics.toReplicaMetricsReport());
                }
            }
        }
        return map;
    }

    public ReplicationSourceMetrics.ReplicationSourceMetricsReport getReplicationSourceMetricsReport() {
        return this.replicationSourceMetrics.toReplicationSourceMetricsReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMetrics() {
        ReplicationQueue replicationQueue = this.replicationQueue;
        if (replicationQueue != null) {
            replicationQueue.resetDeliveryMetrics();
        } else {
            SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
            synchronized (syncReplicaInfo) {
                if (this.syncReplicaInfo.getEntityName() != null && this.syncReplicaInfo.metrics != null) {
                    this.syncReplicaInfo.metrics.resetAll();
                }
            }
        }
        this.replicationSourceMetrics.resetAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void alterReplicationSource(Session session, ReplicationSourceSettings replicationSourceSettingsNew, ReplicationQueue.ReplicationQueueSettings replicationQueueSettingsNew) {
        boolean processingLog;
        block35: {
            replicationSourceSettingsNew.mergeFrom(this.replicationSourceSettings);
            replicationQueueSettingsNew.mergeFrom(this.replicationQueueSettings);
            ReplicationSourceSettings replicationSourceSettingsUpdated = new ReplicationSourceSettings();
            ReplicationQueue.ReplicationQueueSettings replicationQueueSettingsUpdated = new ReplicationQueue.ReplicationQueueSettings();
            this.trace(Trace.Level.INFO, "ALTER: Start.", new Object[0]);
            processingLog = session.isProcessingLog() || session.isProcessingRecoveryLog();
            try {
                if (replicationSourceSettingsNew.sync != this.replicationSourceSettings.sync || replicationSourceSettingsNew.rollbackOnFailure != this.replicationSourceSettings.rollbackOnFailure) {
                    if (this.isEnabled()) {
                        throw new DataspaceException("Replication source should be disabled to alter sync and rollback on failure.");
                    }
                    if (replicationSourceSettingsNew.sync != this.replicationSourceSettings.sync && replicationSourceSettingsNew.sync.booleanValue() && this.listPairedReplicas(session).size() > 1) {
                        throw new DataspaceException("Replication source should be paired with at most 1 replica to alter it to SYNC.");
                    }
                    if (replicationSourceSettingsNew.rollbackOnFailure != this.replicationSourceSettings.rollbackOnFailure && replicationSourceSettingsNew.rollbackOnFailure.booleanValue() && !replicationSourceSettingsNew.sync.booleanValue()) {
                        throw new DataspaceException("Rollback on failure can be set for SYNC replication source only.");
                    }
                    this.lockReplicationIdForSession(session);
                    this.alterWriteLock.lock();
                    try {
                        block33: {
                            if (replicationSourceSettingsNew.sync != this.replicationSourceSettings.sync) {
                                List<ReplicaInfo> attachedReplicas = this.listAttachedReplicas();
                                if (this.replicationQueue != null) {
                                    this.trace(Trace.Level.INFO, "ALTER: Closing replication queue...", new Object[0]);
                                    this.replicationQueue.close();
                                    this.trace(Trace.Level.INFO, "ALTER: Destroying replication queue...", new Object[0]);
                                    this.destroyReplicationQueue(session);
                                    this.replicationQueue = null;
                                } else {
                                    SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
                                    synchronized (syncReplicaInfo) {
                                        this.trace(Trace.Level.INFO, "ALTER: Resetting SYNC replica info...", new Object[0]);
                                        this.syncReplicaInfo.reset();
                                    }
                                }
                                this.trace(Trace.Level.INFO, "ALTER: Resetting strategy...", new Object[0]);
                                this.strategy = null;
                                this.trace(Trace.Level.INFO, "ALTER: Compiling queue and strategy...", new Object[0]);
                                this.compileQueue(session, replicationSourceSettingsNew, replicationQueueSettingsNew);
                                this.compileStrategy(session, replicationSourceSettingsNew);
                                this.trace(Trace.Level.INFO, "ALTER: Opening queue and strategy...", new Object[0]);
                                if (!processingLog) {
                                    this.openReplicationQueueAndReplicas(session);
                                    this.replicationSourceSettings = replicationSourceSettingsNew;
                                    this.replicationQueueSettings = replicationQueueSettingsNew;
                                    if (attachedReplicas.size() > 0) {
                                        ReplicaInfo attachedReplica = attachedReplicas.get(0);
                                        try {
                                            RequestConsumerReference replicaRequestConsumer = this.replicationManager.lookupReplicaConsumer(attachedReplica.getReplicaEntityName().getNodeName(), attachedReplica.getReplicaEntityName().getDataspaceType(), attachedReplica.getReplicaEntityName().getDataspaceName(), attachedReplica.getReplicaEntityName().getSourceOrReplicaName());
                                            if (replicaRequestConsumer == null) {
                                                throw new ReplicationException(ReplicationErrorCode.REPLICA_CONSUMER_NOT_FOUND, "Unable to resolve replica '" + attachedReplica.getReplicaEntityName().getSourceOrReplicaName() + "' request consumer. ");
                                            }
                                            if (this.replicationQueue != null) {
                                                this.replicationQueue.attachReplica(attachedReplica, replicaRequestConsumer);
                                                break block33;
                                            }
                                            SyncReplicaInfo syncReplicaInfo = this.syncReplicaInfo;
                                            synchronized (syncReplicaInfo) {
                                                this.syncReplicaInfo.setMetrics(this.createDeliveryMetrics());
                                                this.syncReplicaInfo.setEntityName(attachedReplica.getReplicaEntityName());
                                                this.syncReplicaInfo.setRequestConsumerReference(replicaRequestConsumer);
                                                this.syncReplicaInfo.setReplicaStateAndSuspended(attachedReplica.getState(), attachedReplica.isSuspended());
                                                this.syncReplicaInfo.setRetryCount(attachedReplica.getRetryCount());
                                            }
                                        }
                                        catch (Exception exception) {
                                            this.trace(Trace.Level.ERROR, "ALTER: Failed to attach replica {}. Will be attached later.", attachedReplica.getReplicaEntityName());
                                            Trace.logException(this, exception, true);
                                        }
                                    }
                                }
                            } else if (replicationSourceSettingsNew.rollbackOnFailure != this.replicationSourceSettings.rollbackOnFailure) {
                                this.strategy = null;
                                this.compileStrategy(session, replicationSourceSettingsNew);
                            }
                        }
                        this.replicationSourceSettings = replicationSourceSettingsNew;
                        this.replicationQueueSettings = replicationQueueSettingsNew;
                    }
                    finally {
                        this.alterWriteLock.unlock();
                        this.unlockReplicationIdForSession(session, true);
                    }
                    if (!processingLog) {
                        List<ReplicaInfo> allReplicas = this.listReplicas(session);
                        for (ReplicaInfo replicaInfo : allReplicas) {
                            ReplicationRequest request = new ReplicationRequest(ReplicationRequest.RequestType.UPDATE_REPLICA_PARAMS);
                            request.setReplicaEntityName(replicaInfo.getReplicaEntityName());
                            request.setAsync(replicationSourceSettingsNew.sync == false);
                            request.setRollbackOnFailure(replicationSourceSettingsNew.rollbackOnFailure);
                            ReplicationResponse response = this.replicationManager.sendReplicationManagementRequest(request, replicaInfo.getReplicaEntityName());
                            if (response.isOk()) continue;
                            this.trace(Trace.Level.ERROR, "ALTER: Failed to send UPDATE_REPLICA_PARAMS request to replica {}.", replicaInfo.getReplicaEntityName());
                        }
                    }
                } else {
                    if (this.replicationQueue != null) {
                        this.replicationQueue.alterReplicationQueue(replicationQueueSettingsNew);
                        replicationQueueSettingsUpdated.mergeFrom(replicationQueueSettingsNew);
                    }
                    if (replicationSourceSettingsNew.publishMetricsTimeWindow != this.replicationSourceSettings.publishMetricsTimeWindow || replicationSourceSettingsNew.publishMetricsTimeWindowUnit != this.replicationSourceSettings.publishMetricsTimeWindowUnit || replicationSourceSettingsNew.publishMetricsUnitWindow != this.replicationSourceSettings.publishMetricsUnitWindow) {
                        this.trace(Trace.Level.INFO, "ALTER: Updating metrics settings...", new Object[0]);
                        this.startPublisher(replicationSourceSettingsNew);
                        replicationSourceSettingsUpdated.publishMetricsTimeWindow = replicationSourceSettingsNew.publishMetricsTimeWindow;
                        replicationSourceSettingsUpdated.publishMetricsTimeWindowUnit = replicationSourceSettingsNew.publishMetricsTimeWindowUnit;
                        replicationSourceSettingsUpdated.publishMetricsUnitWindow = replicationSourceSettingsNew.publishMetricsUnitWindow;
                    }
                }
                if (this.replicationQueueSettings == replicationQueueSettingsNew && this.replicationSourceSettings == replicationSourceSettingsNew) break block35;
                replicationSourceSettingsUpdated.sync = this.replicationQueue == null;
            }
            catch (Throwable throwable) {
                if (this.replicationQueueSettings != replicationQueueSettingsNew || this.replicationSourceSettings != replicationSourceSettingsNew) {
                    replicationSourceSettingsUpdated.sync = this.replicationQueue == null;
                    replicationSourceSettingsUpdated.batchTimeout = replicationSourceSettingsNew.batchTimeout;
                    replicationQueueSettingsUpdated.batchInterval = replicationQueueSettingsNew.batchInterval;
                    replicationQueueSettingsUpdated.batchIntervalError = replicationQueueSettingsNew.batchIntervalError;
                    replicationQueueSettingsUpdated.batchSize = replicationQueueSettingsNew.batchSize;
                    replicationSourceSettingsUpdated.mergeFrom(this.replicationSourceSettings);
                    replicationQueueSettingsUpdated.mergeFrom(this.replicationQueueSettings);
                    this.replicationSourceSettings = replicationSourceSettingsUpdated;
                    this.replicationQueueSettings = replicationQueueSettingsUpdated;
                }
                throw throwable;
            }
            replicationSourceSettingsUpdated.batchTimeout = replicationSourceSettingsNew.batchTimeout;
            replicationQueueSettingsUpdated.batchInterval = replicationQueueSettingsNew.batchInterval;
            replicationQueueSettingsUpdated.batchIntervalError = replicationQueueSettingsNew.batchIntervalError;
            replicationQueueSettingsUpdated.batchSize = replicationQueueSettingsNew.batchSize;
            replicationSourceSettingsUpdated.mergeFrom(this.replicationSourceSettings);
            replicationQueueSettingsUpdated.mergeFrom(this.replicationQueueSettings);
            this.replicationSourceSettings = replicationSourceSettingsUpdated;
            this.replicationQueueSettings = replicationQueueSettingsUpdated;
        }
        if (!processingLog) {
            this.replicationManager.addSourceReference(this);
        }
        this.trace(Trace.Level.INFO, "ALTER: Finish.", new Object[0]);
    }

    private void startPublisher(ReplicationSourceSettings replicationSourceSettings) {
        try {
            this.replicationSourceMetrics.setPublishMetricsParameters(this.getReplicationEntityName().getFullName(), replicationSourceSettings.publishMetricsTimeWindowUnit.toMillis(replicationSourceSettings.publishMetricsTimeWindow), replicationSourceSettings.publishMetricsUnitWindow, (metricsAggregator, info) -> {
                block2: {
                    try {
                        ReplicationSourceMetrics.ReplicationSourceMetricsReportFacet facet = (ReplicationSourceMetrics.ReplicationSourceMetricsReportFacet)metricsAggregator.toReport();
                        facet.setEndTime(info.getEndTime());
                        ReplicationSourceMetrics.ReplicationSourceMetricWindowReport report = new ReplicationSourceMetrics.ReplicationSourceMetricWindowReport(facet, info);
                        ReplicationSourceMetricAdvisory advisory = new ReplicationSourceMetricAdvisory();
                        advisory.setSourceDataspaceType(this.getReplicationEntityName().getDataspaceType());
                        advisory.setSourceDataspaceName(this.getReplicationEntityName().getDataspaceName());
                        advisory.setSourceName(this.getReplicationEntityName().getSourceOrReplicaName());
                        advisory.setReport(report);
                        this.dataspace.raiseSystemAdvisory(advisory);
                    }
                    catch (Exception exception) {
                        if (!this.raiseReplicationException(exception, true)) break block2;
                        this.trace(Trace.Level.ERROR, "Failed to send replication metrics advisory", new Object[0]);
                        Trace.logException(this, exception, true);
                    }
                }
            });
        }
        catch (Exception exception) {
            this.raiseReplicationException(exception, false);
            this.trace(Trace.Level.ERROR, "Failed to start publisher.", new Object[0]);
            Trace.logException(this, exception, true);
        }
    }

    private void stopPublisher() {
        if (this.replicationSourceMetrics != null) {
            this.replicationSourceMetrics.setPublishMetricsParameters(null, 0L, 0L, null);
        }
    }

    @Override
    public String getEntityName() {
        return this.getReplicationEntityName().getFullName();
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.REPLICATION_SOURCE;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return new HashMap<String, String>();
    }

    @Override
    public EventScope getEntityScope() {
        return null;
    }

    class SyncReplicaInfo {
        private ReplicationEntityName entityName = null;
        private RequestConsumerReference requestConsumerReference = null;
        private boolean suspended = false;
        private long updateTimestamp;
        private ReplicaState replicaState;
        private long replicationId;
        private int retryCount;
        private ReplicationError replicationError = new ReplicationError();
        private ReplicationDeliveryMetrics metrics;

        public SyncReplicaInfo() {
            this.replicaState = ReplicaState.INACTIVE;
            this.updateTimestamp = System.currentTimeMillis();
        }

        public void reset() {
            this.entityName = null;
            this.requestConsumerReference = null;
            this.suspended = false;
            this.updateTimestamp = System.currentTimeMillis();
            this.replicationId = 0L;
            this.retryCount = 0;
            this.replicationError = new ReplicationError();
            this.metrics = null;
            this.replicaState = ReplicaState.INACTIVE;
        }

        public ReplicationEntityName getEntityName() {
            return this.entityName;
        }

        public RequestConsumerReference getRequestConsumerReference() {
            return this.requestConsumerReference;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public long getUpdateTimestamp() {
            return this.updateTimestamp;
        }

        public void setSuspended(boolean suspended) {
            this.setReplicaStateAndSuspended(this.replicaState, suspended);
        }

        public void setEntityName(ReplicationEntityName entityName) {
            this.entityName = entityName;
            this.updateTimestamp = System.currentTimeMillis();
        }

        public void setRequestConsumerReference(RequestConsumerReference requestConsumerReference) {
            this.requestConsumerReference = requestConsumerReference;
            this.updateTimestamp = System.currentTimeMillis();
        }

        public void setReplicaState(ReplicaState replicaState) {
            this.setReplicaStateAndSuspended(replicaState, this.suspended);
        }

        public void setReplicaStateAndSuspended(ReplicaState replicaState, boolean suspended) {
            boolean changed = false;
            if (replicaState != this.replicaState || suspended != this.suspended) {
                changed = true;
            }
            this.replicaState = replicaState;
            this.suspended = suspended;
            this.updateTimestamp = System.currentTimeMillis();
            if (changed && this.entityName != null) {
                ReplicationSource.this.raiseReplicaStateChangeAdvisory(this.entityName, replicaState, suspended, this.replicationId);
            }
        }

        public ReplicaState getReplicaState() {
            return this.replicaState;
        }

        public void setReplicationId(long replicationId) {
            this.replicationId = replicationId;
        }

        public long getReplicationId() {
            return this.replicationId;
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public ReplicationDeliveryMetrics getMetrics() {
            return this.metrics;
        }

        public void setMetrics(ReplicationDeliveryMetrics metrics) {
            this.metrics = metrics;
        }
    }

    static class PairedReplicasInfo {
        private Map<String, List<Integer>> replicas = new HashMap<String, List<Integer>>();
        private List<Integer> primaryKey;

        PairedReplicasInfo() {
        }

        synchronized void reset() {
            this.replicas.clear();
            this.primaryKey = null;
        }

        synchronized void addReplica(ReplicaInfo replicaInfo) {
            this.replicas.put(replicaInfo.getReplicaEntityName().getFullName(), replicaInfo.getPrimaryKey());
            this.updatePrimaryKey();
        }

        synchronized void addReplica(ReplicationRequest request) {
            this.replicas.put(request.getReplicaEntityName().getFullName(), request.getPrimaryKey());
            this.updatePrimaryKey();
        }

        synchronized void removeReplica(ReplicaInfo replicaInfo) {
            this.replicas.remove(replicaInfo.getReplicaEntityName().getFullName());
            this.updatePrimaryKey();
        }

        synchronized void removeReplica(ReplicationEntityName replicaEntityName) {
            this.replicas.remove(replicaEntityName.getFullName());
            this.updatePrimaryKey();
        }

        synchronized int getPairedReplicasCount() {
            return this.replicas.size();
        }

        synchronized List<Integer> getPrimaryKey() {
            return this.primaryKey;
        }

        private void updatePrimaryKey() {
            TreeSet<Integer> primaryKeySet = null;
            for (Map.Entry<String, List<Integer>> entry : this.replicas.entrySet()) {
                if (entry.getValue() == null || entry.getValue().size() == 0) {
                    primaryKeySet = null;
                    break;
                }
                if (primaryKeySet == null) {
                    primaryKeySet = new TreeSet<Integer>();
                }
                for (int i : entry.getValue()) {
                    primaryKeySet.add(i);
                }
            }
            this.primaryKey = primaryKeySet == null ? null : new ArrayList<Integer>(primaryKeySet);
        }
    }

    public static class ReplicationSourceSettings {
        static final boolean DEFAULT_SYNC = true;
        static final boolean DEFAULT_ROLLBACK_ON_FAILURE = false;
        static final long DEFAULT_BATCH_TIMEOUT = 60000L;
        static final long DEFAULT_METRICS_TIME_WINDOW = 0L;
        static final TimeUnit DEFAULT_METRICS_TIME_WINDOW_UNIT = null;
        static final int DEFAULT_METRICS_BATCHES_WINDOW = 0;
        public Boolean sync = null;
        public Boolean rollbackOnFailure = null;
        public long batchTimeout = 60000L;
        public long publishMetricsTimeWindow = 0L;
        public TimeUnit publishMetricsTimeWindowUnit = TimeUnit.MILLISECONDS;
        public int publishMetricsUnitWindow = 0;

        public ReplicationSourceSettings() {
            this.sync = null;
            this.rollbackOnFailure = null;
            this.batchTimeout = -1L;
            this.publishMetricsTimeWindow = -1L;
            this.publishMetricsTimeWindowUnit = TimeUnit.MILLISECONDS;
            this.publishMetricsUnitWindow = -1;
        }

        public ReplicationSourceSettings(ReplicationSourceSettings from) {
            this.sync = from.sync;
            this.rollbackOnFailure = from.rollbackOnFailure;
            this.batchTimeout = from.batchTimeout;
            this.publishMetricsTimeWindow = from.publishMetricsTimeWindow;
            this.publishMetricsTimeWindowUnit = from.publishMetricsTimeWindowUnit;
            this.publishMetricsUnitWindow = from.publishMetricsUnitWindow;
        }

        public void initWithDefaults() {
            if (this.sync == null) {
                this.sync = true;
            }
            if (this.rollbackOnFailure == null) {
                this.rollbackOnFailure = false;
            }
            if (this.batchTimeout == -1L) {
                this.batchTimeout = 60000L;
            }
            if (this.publishMetricsTimeWindow == -1L) {
                this.publishMetricsTimeWindow = 0L;
            }
            if (this.publishMetricsTimeWindowUnit == null) {
                this.publishMetricsTimeWindowUnit = DEFAULT_METRICS_TIME_WINDOW_UNIT;
            }
            if (this.publishMetricsUnitWindow == -1) {
                this.publishMetricsUnitWindow = 0;
            }
        }

        public void mergeFrom(ReplicationSourceSettings from) {
            if (this.sync == null) {
                this.sync = from.sync;
            }
            if (this.rollbackOnFailure == null) {
                this.rollbackOnFailure = from.rollbackOnFailure;
            }
            if (this.batchTimeout == -1L) {
                this.batchTimeout = from.batchTimeout;
            }
            if (this.publishMetricsTimeWindow == -1L) {
                this.publishMetricsTimeWindow = from.publishMetricsTimeWindow;
            }
            if (this.publishMetricsTimeWindowUnit == null) {
                this.publishMetricsTimeWindowUnit = from.publishMetricsTimeWindowUnit;
            }
            if (this.publishMetricsUnitWindow == -1) {
                this.publishMetricsUnitWindow = from.publishMetricsUnitWindow;
            }
        }
    }

    class AsyncReplicationStrategy
    extends ReplicationStrategy {
        AsyncReplicationStrategy() {
        }

        @Override
        void doApplyCommitP1(Session session, ReplicationDataTransaction transaction, ReplicationEntityName name) {
            ReplicationSource.this.replicationQueue.enqueue(session, transaction);
        }

        @Override
        void onAfterCommit() {
            super.onAfterCommit();
            ReplicationSource.this.replicationQueue.onAfterCommit();
        }

        @Override
        void applyCommitP2() {
            ReplicationSource.this.replicationQueue.commit();
        }

        @Override
        void rollbackCommit() {
            ReplicationSource.this.replicationQueue.rollback();
        }
    }

    abstract class ReplicationStrategy {
        protected Statement updateReplicationSource;

        ReplicationStrategy() {
        }

        void compile(Session session) {
            String SQL = "update RDS.REPLICATION_SOURCES set REPLICATION_ID = ? where DATASPACE_NAME = ? and NAME = ?";
            this.updateReplicationSource = session.compileStatement(SQL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void applyCommitP1(Session session, ReplicationDataTransaction transaction, ReplicationEntityName name) {
            ReplicationSource.this.trace(Trace.Level.DEBUG, "Replication data transaction replicationId: {}...", transaction.getReplicationId());
            transaction = this.transformGroupsToUpdate(transaction);
            if (transaction.getSize() > 0 && ReplicationSource.this.replicationSourceMetricsBuilder != null) {
                ReplicationSource.this.replicationSourceMetricsBuilder.setUnitCommitEndTime();
                for (ReplicationData data : transaction.getData()) {
                    ReplicationSource.this.replicationSourceMetricsBuilder.addOperation(data.getOperationType());
                }
                ReplicationSource.this.replicationSourceMetricsBuilder.setUnitProcessingStartTime();
            }
            try {
                session.executingReplication = true;
                if (transaction != null && transaction.getSize() > 0) {
                    this.doApplyCommitP1(session, transaction, name);
                }
            }
            finally {
                session.executingReplication = false;
            }
            this.updateReplicationSourceOnCommit(session, transaction);
            if (ReplicationSource.this.replicationSourceMetricsBuilder != null) {
                ReplicationSource.this.replicationSourceMetricsBuilder.setUnitProcessingEndTime();
            }
        }

        private ReplicationDataTransaction transformGroupsToUpdate(ReplicationDataTransaction transaction) {
            if (!transaction.hasGroup()) {
                return transaction;
            }
            ArrayList<ReplicationData> xdata = new ArrayList<ReplicationData>();
            ArrayList<ReplicationData> udata = new ArrayList<ReplicationData>();
            ArrayList<ReplicationData> ungroupedData = new ArrayList<ReplicationData>();
            for (ReplicationData data : transaction.getData()) {
                if (data.getGroupId() != null) {
                    switch (data.getOperationType()) {
                        case DELETE: {
                            xdata.add(data);
                            break;
                        }
                        case INSERT: {
                            udata.add(data);
                        }
                    }
                    continue;
                }
                ungroupedData.add(data);
            }
            if (udata.size() > 0 && udata.size() == xdata.size()) {
                transaction = new ReplicationDataTransaction(transaction.getReplicationId());
                for (int i = 0; i < udata.size(); ++i) {
                    transaction.addData(new ReplicationData(((ReplicationData)xdata.get(i)).getRow(), ((ReplicationData)udata.get(i)).getRow(), ((ReplicationData)xdata.get(i)).getPrimaryKey()));
                }
                if (ungroupedData != null && ungroupedData.size() > 0) {
                    ReplicationSource.this.trace(Trace.Level.ERROR, "Transaction has {} ungrouped data and {} updates.", ungroupedData.size(), udata.size());
                    for (ReplicationData data : ungroupedData) {
                        transaction.addData(data);
                    }
                }
            }
            return transaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateReplicationSourceOnCommit(Session session, ReplicationDataTransaction transaction) {
            ReplicationSource.this.trace(Trace.Level.DEBUG, "Updating replication source table.", new Object[0]);
            int count = 0;
            Result result = null;
            while (count < 20) {
                try {
                    ++count;
                    Object[] params = new Object[]{transaction.getReplicationId(), ReplicationSource.this.collection.getObjectName().schema.name, ReplicationSource.this.collection.getObjectName().name};
                    if (!session.isInMidTransaction() && !session.executingReplication && session.getCurrentStatementCounter() == 0 && session.sessionContext.depth == 0) {
                        result = session.executeCompiledStatement(this.updateReplicationSource, params);
                    } else {
                        session.sessionContext.pushDynamicArgumentsWithRowActionList(params);
                        try {
                            result = this.updateReplicationSource.execute(session);
                        }
                        finally {
                            session.redoAction = false;
                            session.sessionContext.popWithWithRowActionList();
                        }
                    }
                    if (result.isError()) continue;
                    break;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            }
            if (result.isError()) {
                Trace.logException(this, result.getException(), true);
                ReplicationSource.this.trace(Trace.Level.ERROR, "Unable to update REPLICATION_SOURCES table. {} attempts have been done.", count);
            }
        }

        void onAfterCommit() {
        }

        abstract void doApplyCommitP1(Session var1, ReplicationDataTransaction var2, ReplicationEntityName var3);

        void applyCommitP2() {
        }

        void rollbackCommit() {
        }
    }

    class RollbackOnFailureReplicationStrategy
    extends AbstractSyncReplicationStrategy {
        RollbackOnFailureReplicationStrategy() {
        }

        @Override
        protected void onException(Session session, ReplicationDataTransaction transaction, ReplicationEntityName name, ReplicationException exception) {
            try (Session triggerSession = ReplicationSource.this.dataspace.createSession();){
                ReplicationSource.this.onReplicationRollback(triggerSession, transaction, exception);
            }
            throw new DataspaceException("Rollback on Failure case: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    class SyncReplicationStrategy
    extends AbstractSyncReplicationStrategy {
        SyncReplicationStrategy() {
        }

        @Override
        protected void onException(Session session, ReplicationDataTransaction transaction, ReplicationEntityName name, ReplicationException exception) {
            try {
                ReplicationFailAdvisory advisory = new ReplicationFailAdvisory();
                ReplicationSource.this.fillReplicaAdvisory(advisory, name, transaction.getReplicationId());
                advisory.setReplicationUnit(transaction);
                advisory.setException(exception);
                ReplicationSource.this.dataspace.raiseSystemAdvisory(advisory);
            }
            catch (Exception exception1) {
                ReplicationSource.this.trace(Trace.Level.ERROR, "Failed to send replication failed advisory for replica.", new Object[0]);
                Trace.logException(this, exception1, true);
                Trace.logException(this, exception, true);
            }
        }
    }

    public static class ReplicationError {
        private long replicationErrorsSince = 0L;
        private long replicationErrorsCount = 0L;
        private ReplicationException lastReplicationError = null;

        public ReplicationError() {
        }

        private ReplicationError(long replicationErrorsSince, long replicationErrorsCount, ReplicationException lastReplicationError) {
            this.replicationErrorsSince = replicationErrorsSince;
            this.replicationErrorsCount = replicationErrorsCount;
            this.lastReplicationError = lastReplicationError;
        }

        public long getReplicationErrorsSince() {
            return this.replicationErrorsSince;
        }

        public long getReplicationErrorsCount() {
            return this.replicationErrorsCount;
        }

        public ReplicationException getLastReplicationError() {
            return this.lastReplicationError;
        }

        synchronized void resetReplicationErrors() {
            this.replicationErrorsSince = 0L;
            this.replicationErrorsCount = 0L;
            this.lastReplicationError = null;
        }

        synchronized void increaseReplicationErrors(ReplicationException exception) {
            if (this.replicationErrorsSince == 0L) {
                this.replicationErrorsSince = System.currentTimeMillis();
            }
            ++this.replicationErrorsCount;
            this.lastReplicationError = exception;
        }

        protected synchronized ReplicationError clone() {
            return new ReplicationError(this.replicationErrorsSince, this.replicationErrorsCount, this.lastReplicationError);
        }

        public void add(ReplicationError replicationError) {
            if (replicationError == null) {
                return;
            }
            this.replicationErrorsCount += replicationError.replicationErrorsCount;
            if (this.replicationErrorsSince == 0L) {
                this.replicationErrorsSince = replicationError.replicationErrorsSince;
            } else if (replicationError.replicationErrorsSince > 0L) {
                this.replicationErrorsSince = Math.min(replicationError.replicationErrorsSince, this.replicationErrorsSince);
            }
            if (replicationError.lastReplicationError != null) {
                this.lastReplicationError = replicationError.lastReplicationError;
            }
        }
    }

    abstract class AbstractSyncReplicationStrategy
    extends ReplicationStrategy {
        AbstractSyncReplicationStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void doApplyCommitP1(Session session, ReplicationDataTransaction transaction, ReplicationEntityName name) {
            block18: {
                ReplicationDataBatch replicationDataBatch = null;
                ReplicationEntityName synReplicaEntityName = null;
                try {
                    RuntimeException exception;
                    int retryCount;
                    boolean synReplicaSuspended;
                    RequestConsumerReference synReplicaConsumerReference;
                    SyncReplicaInfo syncReplicaInfo = ReplicationSource.this.syncReplicaInfo;
                    synchronized (syncReplicaInfo) {
                        synReplicaEntityName = ReplicationSource.this.syncReplicaInfo.getEntityName();
                        synReplicaConsumerReference = ReplicationSource.this.syncReplicaInfo.getRequestConsumerReference();
                        synReplicaSuspended = ReplicationSource.this.syncReplicaInfo.isSuspended();
                        retryCount = ReplicationSource.this.syncReplicaInfo.retryCount;
                    }
                    if (synReplicaEntityName == null) break block18;
                    if (synReplicaConsumerReference == null) {
                        throw new ReplicationException(ReplicationErrorCode.REPLICA_IS_DETACHED, "Replica is detached.");
                    }
                    if (synReplicaSuspended) {
                        throw new ReplicationException(ReplicationErrorCode.REPLICA_IS_SUSPENDED, "Replica is suspended.");
                    }
                    replicationDataBatch = new ReplicationDataBatch(transaction);
                    replicationDataBatch.setSession(session);
                    replicationDataBatch.setSync(true);
                    replicationDataBatch.setRollbackOnFailure(ReplicationSource.this.replicationSourceSettings.rollbackOnFailure);
                    replicationDataBatch.setCurrentReplicationId(ReplicationSource.this.committedReplicationId.get());
                    int currentRetriesCount = 0;
                    do {
                        ++currentRetriesCount;
                        ReplicationDeliveryMetrics.ReplicationDeliveryMetric.ReplicationDeliveryMetricBuilder metricBuilder = ReplicationDeliveryMetrics.ReplicationDeliveryMetric.builder();
                        metricBuilder.setBatchReadStartTime(System.currentTimeMillis());
                        metricBuilder.setBatchReadEndTime(System.currentTimeMillis());
                        metricBuilder.setStatementsMap(replicationDataBatch.getStatementsMap());
                        metricBuilder.setDeliveryStartTime(System.currentTimeMillis());
                        metricBuilder.setUnitsCount(1L);
                        if (ReplicationSource.this.replicationSourceMetricsBuilder != null) {
                            ReplicationSource.this.replicationSourceMetricsBuilder.setUnitProcessingTargetStartTime();
                        }
                        ReplicationResponse response = ReplicationSource.this.replicationManager.sendReplicationDataWithAck(synReplicaEntityName, synReplicaConsumerReference, replicationDataBatch, ReplicationSource.this.entityName, ReplicationSource.this.replicationSourceSettings.batchTimeout);
                        if (ReplicationSource.this.replicationSourceMetricsBuilder != null) {
                            ReplicationSource.this.replicationSourceMetricsBuilder.setUnitProcessingTargetEndTime();
                        }
                        if (response.getReplicaInfo() != null && response.getReplicaInfo().getState() != null) {
                            ReplicationSource.this.syncReplicaInfo.setReplicaState(response.getReplicaInfo().getState());
                        }
                        metricBuilder.setStatementsMapTime(response.getStatementsMapTime());
                        metricBuilder.setTargetProcessingTime(response.getBatchProcessingTime());
                        metricBuilder.setDeliveryEndTime(System.currentTimeMillis());
                        if (response.isOk()) {
                            if (response.getReplicaInfo() != null && !response.getReplicaInfo().isSuspended()) {
                                ReplicationSource.this.syncReplicaInfo.metrics.addMetric(metricBuilder.build());
                            }
                            ReplicationSource.this.syncReplicaInfo.replicationError.resetReplicationErrors();
                            if (response.getReplicaInfo() != null && response.getReplicaInfo().isSuspended()) {
                                ReplicationSource.this.syncReplicaInfo.setSuspended(true);
                                ReplicationSource.this.updateSourceReplicasReplicationId(session, synReplicaEntityName, response.getReplicationId());
                                throw new ReplicationException(ReplicationErrorCode.REPLICA_IS_SUSPENDED, "Replica is suspended.");
                            }
                            ReplicationSource.this.updateSourceReplicasReplicationId(session, synReplicaEntityName, response.getReplicationId());
                            ReplicationSource.this.syncReplicaInfo.setReplicationId(response.getReplicationId());
                            break block18;
                        }
                        metricBuilder.setFailedUnitsCount(1L);
                        metricBuilder.setFailedStatementsMap(replicationDataBatch.getStatementsMap());
                        if (response.getReplicaInfo() != null && !response.getReplicaInfo().isSuspended()) {
                            ReplicationSource.this.syncReplicaInfo.metrics.addMetric(metricBuilder.build());
                        }
                        ReplicationSource.this.syncReplicaInfo.replicationError.increaseReplicationErrors(new ReplicationException(response.getReplicationErrorCode(), response.getErrorMessage()));
                        exception = response.getException();
                        if (exception != null) continue;
                        exception = new ReplicationException(response.getReplicationErrorCode(), response.getErrorMessage());
                    } while (retryCount >= 0 && currentRetriesCount <= retryCount);
                    throw exception;
                }
                catch (Throwable exception2) {
                    ReplicationException exception2;
                    if (ReplicationSource.this.replicationSourceMetricsBuilder != null && ReplicationSource.this.replicationSourceMetricsBuilder.getUnitProcessingTargetStartTime() == 0L) {
                        ReplicationSource.this.replicationSourceMetricsBuilder.setUnitProcessingTargetStartTime();
                    }
                    if (com.streamscape.sef.utils.Utils.getCauseAssignable(exception2, TimeoutException.class) != null) {
                        ReplicationSource.this.raiseTimeoutAdvisory(synReplicaEntityName, ReplicationSource.this.replicationSourceSettings.batchTimeout, replicationDataBatch);
                    }
                    if (!(exception2 instanceof ReplicationException)) {
                        exception2 = new ReplicationException(ReplicationErrorCode.INTERNAL_ERROR, exception2.getMessage(), exception2);
                    }
                    ReplicationSource.this.syncReplicaInfo.replicationError.increaseReplicationErrors(exception2);
                    this.onException(session, transaction, name, exception2);
                }
            }
        }

        protected abstract void onException(Session var1, ReplicationDataTransaction var2, ReplicationEntityName var3, ReplicationException var4);
    }
}

