/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.jfq.FileQueueFilenameProvider;
import com.streamscape.ds.persist.jfq.FileQueueFilesManager;
import com.streamscape.ds.persist.jfq.FileQueueKeyColumnIndexes;
import com.streamscape.ds.persist.jfq.FileQueueKeyComparator;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationDataBatch;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationDeliveryMetrics;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationErrorCode;
import com.streamscape.ds.replication.ReplicationException;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.replication.ReplicationRequest;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.table.JournalFileQueueTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class ReplicationQueueFileBased
implements ReplicationQueue {
    public static final String REPLICATION_FILES_DIRECTORY = "replication";
    protected NameManager.ObjectName queueName;
    protected ReplicationQueue.ReplicationQueueSettings settings;
    protected ReplicationSource source;
    private FileQueueFilesManager.FileQueueDataWriter dataWriter;
    protected Statement selectMinReplicationIdStat;
    protected JournalFileQueueTable repQueueStorage;
    protected AbstractDataspace dataspace;
    protected ReplicationManager replicationManager;
    protected FabricTimerManager timerManager = FabricTimerManager.getInstance();
    private final ReentrantLock lock = new ReentrantLock();
    protected final Map<ReplicationEntityName, ReplicationProcessor> replicationProcessors = Collections.synchronizedMap(new LinkedHashMap());
    private long lastTimeQueueCleaned = 0L;

    public ReplicationQueueFileBased(AbstractDataspace dataspace, ReplicationManager replicationManager, ReplicationSource source, ReplicationQueue.ReplicationQueueSettings settings) {
        this.dataspace = dataspace;
        this.replicationManager = replicationManager;
        this.source = source;
        this.settings = new ReplicationQueue.ReplicationQueueSettings(settings);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        this.trace(Trace.Level.DEBUG, "Compiling...", new Object[0]);
        NameManager.ObjectName sourceName = this.source.getObjectName();
        String repQueueName = ReplicationQueue.getQueueName(sourceName.schema.name, sourceName.name);
        this.queueName = session.dataspaceStore.nameManager.newObjectName(repQueueName, true, 3);
        this.queueName.schema = SqlInvariants.RDS_SCHEMA_NAME;
        this.repQueueStorage = (JournalFileQueueTable)TableUtil.newTable(session.dataspaceStore, 15, this.queueName);
        TableUtil.addColumn(this.repQueueStorage, "ReplicationId", Type.LONG);
        TableUtil.addColumn(this.repQueueStorage, "Timestamp", Type.SQL_TIMESTAMP);
        TableUtil.addColumn(this.repQueueStorage, "ReplicationData", Type.OTHER);
        NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(this.queueName.name, this.queueName.isNameQuoted, 21);
        this.repQueueStorage.createPrimaryKeyConstraint(internalTableIndexName, new int[]{this.repQueueStorage.getColumnIndex("ReplicationId")}, true);
        this.repQueueStorage.createIndexForColumns(session, new int[]{this.repQueueStorage.getColumnIndex("Timestamp")});
        this.repQueueStorage.setColumnStructures();
        this.repQueueStorage.setMaxFileSizeBytes(this.settings.queueFileMaxFileSize);
        this.repQueueStorage.setWriteFlushTimeout(this.settings.queueFileWriteFlushDelay);
        this.repQueueStorage.setWriteBufferSizeBytes(this.settings.queueFileWriteBufferSize);
        this.repQueueStorage.setTransactionPersistentType(this.settings.transactionPersistenceType);
        this.repQueueStorage.compile(session, parentObject);
        this.dataWriter = this.repQueueStorage.getFilesManager().createDataWriter();
        this.trace(Trace.Level.DEBUG, "Compiled.", new Object[0]);
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = "select min(REPLICATION_ID) from RDS.SOURCE_REPLICAS where SOURCE_DATASPACE_NAME = ? and SOURCE_NAME = ? and REPLICATION_ID >= 0";
        this.selectMinReplicationIdStat = session.compileStatement(SQL);
    }

    @Override
    public void open(Session session) {
    }

    @Override
    public void close() {
        this.trace(Trace.Level.DEBUG, "Closing...", new Object[0]);
        this.replicationProcessors.entrySet().forEach(e -> ((ReplicationProcessor)e.getValue()).stop());
        if (this.repQueueStorage != null) {
            this.repQueueStorage.close();
        }
        this.trace(Trace.Level.DEBUG, "Closed.", new Object[0]);
    }

    @Override
    public void destroy() {
        if (this.repQueueStorage != null) {
            this.repQueueStorage.destroy();
        }
    }

    @Override
    public void onRename(Session session) {
        this.trace(Trace.Level.DEBUG, "Renaming...", new Object[0]);
        this.trace(Trace.Level.DEBUG, "Renamed.", new Object[0]);
    }

    @Override
    public Table getReplicationQueueStorage() {
        return this.repQueueStorage;
    }

    @Override
    public void enqueue(Session session, ReplicationDataTransaction replicationDataTransaction) {
        this.trace(Trace.Level.DEBUG, "Enqueue replication data transaction replicationId {}, size: {}", replicationDataTransaction.getReplicationId(), replicationDataTransaction.getSize());
        Object[] params = new Object[]{replicationDataTransaction.getReplicationId(), session.getCurrentSqlTimestamp(), new OtherTypeWrapper(replicationDataTransaction)};
        try {
            this.dataWriter.startTransaction();
            this.dataWriter.append(params);
            this.dataWriter.persistTransaction();
        }
        catch (IOException exception) {
            throw new ReplicationException(ReplicationErrorCode.INSERT_TO_REPLICATION_QUEUE_FAILED, "Unable to add replication data to replication queue. " + Utils.formatExceptionWithUnrepeatedCauses(exception), exception);
        }
        this.trace(Trace.Level.DEBUG, "Enqueue replication data replicationId {} finished.", replicationDataTransaction.getReplicationId());
    }

    @Override
    public void commit() {
        try {
            this.dataWriter.commit();
        }
        catch (IOException exception) {
            throw new ReplicationException(ReplicationErrorCode.INSERT_TO_REPLICATION_QUEUE_FAILED, "Commit to replication queue failed. " + Utils.formatException(exception), exception);
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.dataWriter != null) {
                this.dataWriter.rollback();
            }
        }
        catch (IOException exception) {
            throw new ReplicationException(ReplicationErrorCode.INSERT_TO_REPLICATION_QUEUE_FAILED, "Rollback to replication queue failed. " + Utils.formatException(exception), exception);
        }
    }

    @Override
    public void onAfterCommit() {
        this.trace(Trace.Level.DEBUG, "On after commit, committed replicationId: {}", this.source.getCommittedReplicationId());
        try {
            this.replicationProcessors.values().forEach(processor -> {
                if (!processor.isSuspended()) {
                    this.lock.lock();
                    try {
                        if (!processor.isSuspended() && (processor.replicationId.get() >= 0L && this.source.getCommittedReplicationId() - processor.replicationId.get() >= (long)this.settings.batchSize || System.currentTimeMillis() - processor.lastProcessedDataTimestamp >= this.settings.batchInterval)) {
                            processor.lockCondition.signal();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            });
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReplicaInfo> listAttachedReplicas() {
        Map<ReplicationEntityName, ReplicationProcessor> map = this.replicationProcessors;
        synchronized (map) {
            ArrayList<ReplicaInfo> result = new ArrayList<ReplicaInfo>();
            for (Map.Entry<ReplicationEntityName, ReplicationProcessor> entry : this.replicationProcessors.entrySet()) {
                result.add(new ReplicaInfo(entry.getKey(), entry.getValue().getReplicaState(), entry.getValue().isSuspended(), entry.getValue().replicationId.get()));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachOrUpdateReplica(ReplicationRequest request, RequestConsumerReference replicaRequestConsumer) {
        this.trace(Trace.Level.DEBUG, "Attaching or updating replica {}...", request.getReplicaEntityName());
        Map<ReplicationEntityName, ReplicationProcessor> map = this.replicationProcessors;
        synchronized (map) {
            ReplicationProcessor processor = this.replicationProcessors.get(request.getReplicaEntityName());
            if (processor != null) {
                this.trace(Trace.Level.DEBUG, "Updating replica {}, suspended: {}, state: {}, replicationId: {}->{}.", new Object[]{request.getReplicaEntityName(), request.isSuspended(), request.getReplicaState(), processor.replicationId.get(), request.getReplicationId()});
                processor.setRetryCount(request.getRetryCount());
                processor.updateTimestamp = System.currentTimeMillis();
                if (request.getReplicationId() != -2L) {
                    processor.replicationId.set(request.getReplicationId());
                }
                processor.replicaRequestConsumerReference = replicaRequestConsumer;
                processor.setReplicaStateAndSuspended(request.getReplicaState(), request.isSuspended());
                processor.start();
            } else if (request.getReplicationId() != -2L) {
                this.trace(Trace.Level.DEBUG, "Adding replica {}, state: {}, replicationId: {}.", new Object[]{request.getReplicaEntityName(), request.getReplicaState(), request.getReplicationId()});
                processor = new ReplicationProcessor(request.getReplicationId(), request.getReplicaEntityName(), replicaRequestConsumer);
                processor.start();
                processor.updateTimestamp = System.currentTimeMillis();
                processor.setReplicaState(request.getReplicaState());
                processor.setRetryCount(request.getRetryCount());
                this.replicationProcessors.put(request.getReplicaEntityName(), processor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachReplica(ReplicaInfo attachedReplica, RequestConsumerReference replicaRequestConsumer) {
        Map<ReplicationEntityName, ReplicationProcessor> map = this.replicationProcessors;
        synchronized (map) {
            ReplicationProcessor processor = this.replicationProcessors.get(attachedReplica.getReplicaEntityName());
            if (processor == null) {
                this.trace(Trace.Level.DEBUG, "Adding replica from replica info {}, state: {}, replicationId: {}.", new Object[]{attachedReplica.getReplicaEntityName(), attachedReplica.getState(), attachedReplica.getReplicationId()});
                processor = new ReplicationProcessor(attachedReplica.getReplicationId(), attachedReplica.getReplicaEntityName(), replicaRequestConsumer);
                processor.updateTimestamp = System.currentTimeMillis();
                processor.setReplicaState(attachedReplica.getState());
                processor.setRetryCount(attachedReplica.getRetryCount());
                processor.setSuspended(attachedReplica.isSuspended());
                processor.start();
                this.replicationProcessors.put(attachedReplica.getReplicaEntityName(), processor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detachReplica(ReplicationEntityName entityName, long timestamp, boolean withRemove) {
        this.trace(Trace.Level.DEBUG, "Detaching replica {}...", entityName);
        boolean result = true;
        Map<ReplicationEntityName, ReplicationProcessor> map = this.replicationProcessors;
        synchronized (map) {
            ReplicationProcessor processor = this.replicationProcessors.get(entityName);
            if (processor != null && timestamp != -1L && timestamp > processor.updateTimestamp) {
                this.trace(Trace.Level.DEBUG, "WARNING: Detaching replica with update timestamp {} < event timestamp {}.", processor.updateTimestamp, timestamp);
            }
            if (processor != null && (timestamp == -1L || timestamp > processor.updateTimestamp)) {
                processor.setReplicaState(withRemove ? ReplicaState.DROPPED : ReplicaState.INACTIVE);
                if (withRemove) {
                    this.replicationProcessors.remove(entityName);
                }
                processor.stop();
                result = true;
            } else if (processor != null) {
                result = false;
            }
            this.replicationManager.enqueueMonitorAction(new ReplicationManager.CleanupReplicationQueue(this));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAcknowledgedDataFromReplicationQueue(Session session, Statement statement) {
        try {
            this.trace(Trace.Level.DEBUG, "Deleting acknowledged replication data...", new Object[0]);
            if (this.selectMinReplicationIdStat != null) {
                Statement statement2 = this.selectMinReplicationIdStat;
                synchronized (statement2) {
                    this.lastTimeQueueCleaned = System.currentTimeMillis();
                    Result result = session.executeCompiledStatement(this.selectMinReplicationIdStat, new Object[]{this.source.getObjectName().schema.name, this.source.getObjectName().name});
                    if (result.isError() && result.getException() != null) {
                        this.dataspace.logError("Unable to select min replication is from source_replicas table. " + Utils.formatException(result.getException()));
                        return 0;
                    }
                    if (result.isData() && result.getNavigator().next() && result.getNavigator().getCurrent()[0] != null) {
                        long replicationId = ((Number)result.getNavigator().getCurrent()[0]).longValue();
                        if (this.repQueueStorage != null && this.repQueueStorage.getFilesManager() != null) {
                            this.repQueueStorage.getFilesManager().cleanUp(new ReplicationQueueReplicationIdComparator(replicationId));
                        }
                    }
                    return 0;
                }
            }
        }
        catch (Exception exception) {
            this.source.raiseReplicationException(exception, true);
            Trace.logException(this, exception, true);
        }
        return 0;
    }

    @Override
    public ReplicationSource.ReplicationError getReplicationErrors() {
        ReplicationSource.ReplicationError replicationError = new ReplicationSource.ReplicationError();
        for (ReplicationProcessor processor : this.replicationProcessors.values()) {
            replicationError.add(processor.replicationError);
        }
        return replicationError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> getMetricsReportMap() {
        HashMap<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> map = new HashMap<String, ReplicationDeliveryMetrics.ReplicaMetricsReport>();
        Map<ReplicationEntityName, ReplicationProcessor> map2 = this.replicationProcessors;
        synchronized (map2) {
            for (Map.Entry<ReplicationEntityName, ReplicationProcessor> processor : this.replicationProcessors.entrySet()) {
                map.put(processor.getKey().getFullName(), processor.getValue().metrics.toReplicaMetricsReport());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetDeliveryMetrics() {
        Map<ReplicationEntityName, ReplicationProcessor> map = this.replicationProcessors;
        synchronized (map) {
            for (Map.Entry<ReplicationEntityName, ReplicationProcessor> processor : this.replicationProcessors.entrySet()) {
                processor.getValue().metrics.resetAll();
            }
        }
    }

    @Override
    public void alterReplicationQueue(ReplicationQueue.ReplicationQueueSettings replicationQueueSettingsNew) {
        if (replicationQueueSettingsNew.queueFileMaxFileSize != this.settings.queueFileMaxFileSize || replicationQueueSettingsNew.queueFileWriteBufferSize != this.settings.queueFileWriteBufferSize || replicationQueueSettingsNew.queueFileWriteFlushDelay != this.settings.queueFileWriteFlushDelay || replicationQueueSettingsNew.transactionPersistenceType != this.settings.transactionPersistenceType) {
            if (replicationQueueSettingsNew.queueFileMaxFileSize != this.settings.queueFileMaxFileSize) {
                this.repQueueStorage.getFilesManager().setMaxFileSizeBytes(replicationQueueSettingsNew.queueFileMaxFileSize);
            }
            if (replicationQueueSettingsNew.queueFileWriteBufferSize != this.settings.queueFileWriteBufferSize) {
                this.repQueueStorage.getFilesManager().setWriteBufferSizeBytes(replicationQueueSettingsNew.queueFileWriteBufferSize);
            }
            if (replicationQueueSettingsNew.queueFileWriteFlushDelay != this.settings.queueFileWriteFlushDelay) {
                this.repQueueStorage.getFilesManager().setFlushTimeout(replicationQueueSettingsNew.queueFileWriteFlushDelay);
            }
            if (replicationQueueSettingsNew.transactionPersistenceType != this.settings.transactionPersistenceType) {
                this.repQueueStorage.getFilesManager().setTransactionPersistentType(replicationQueueSettingsNew.transactionPersistenceType);
            }
        }
        this.settings = replicationQueueSettingsNew;
    }

    @Override
    public long getLastTimeQueueCleaned() {
        return this.lastTimeQueueCleaned;
    }

    private void trace(Trace.Level level, String message, Object ... args) {
        if (Trace.isEnabled(this.getClass(), level)) {
            Trace.log(this, level, "Replication queue [" + String.valueOf(this.source.getReplicationEntityName()) + "] : " + message, args);
        }
    }

    public class ReplicationProcessor
    implements Runnable {
        private final ReplicationEntityName replicaEntityName;
        private RequestConsumerReference replicaRequestConsumerReference;
        private final Condition lockCondition;
        protected FabricThread<?> replicationThread;
        private AtomicLong replicationId;
        private volatile boolean running;
        private volatile boolean isSuspended;
        public volatile long updateTimestamp;
        public ReplicaState replicaState;
        private int retryCount;
        private ReplicationSource.ReplicationError replicationError;
        private ReplicationDeliveryMetrics metrics;
        private long currentRetriesCount;
        private int currentBatchSize;
        private long currentBatchInterval;
        private long lastProcessedDataTimestamp;

        ReplicationProcessor(long replicationId, ReplicationEntityName replicaEntityName, RequestConsumerReference replicaRequestConsumerReference) {
            this.lockCondition = ReplicationQueueFileBased.this.lock.newCondition();
            this.running = true;
            this.isSuspended = false;
            this.replicationError = new ReplicationSource.ReplicationError();
            this.metrics = new ReplicationDeliveryMetrics();
            this.lastProcessedDataTimestamp = 0L;
            this.replicaEntityName = replicaEntityName;
            this.replicaRequestConsumerReference = replicaRequestConsumerReference;
            this.replicationId = replicationId == -1L ? new AtomicLong(ReplicationQueueFileBased.this.source.getCommittedReplicationId()) : new AtomicLong(replicationId);
            this.metrics = ReplicationQueueFileBased.this.source.createDeliveryMetrics();
        }

        public RequestConsumerReference getReplicaRequestConsumerReference() {
            return this.replicaRequestConsumerReference;
        }

        public void setSuspended(boolean isSuspended) {
            this.setReplicaStateAndSuspended(this.replicaState, isSuspended);
        }

        public boolean isSuspended() {
            return this.isSuspended;
        }

        public void setReplicaState(ReplicaState replicaState) {
            this.setReplicaStateAndSuspended(replicaState, this.isSuspended);
        }

        public ReplicaState getReplicaState() {
            return this.replicaState;
        }

        public void setReplicaStateAndSuspended(ReplicaState replicaState, boolean isSuspended) {
            boolean changed = false;
            if (this.replicaState != replicaState || this.isSuspended != isSuspended) {
                changed = true;
            }
            this.replicaState = replicaState;
            this.isSuspended = isSuspended;
            if (changed) {
                ReplicationQueueFileBased.this.source.raiseReplicaStateChangeAdvisory(this.replicaEntityName, replicaState, isSuspended, this.replicationId.get());
            }
        }

        synchronized void start() {
            if (this.replicationThread == null) {
                this.trace(Trace.Level.DEBUG, "Starting replication thread.", new Object[0]);
                this.running = true;
                this.replicationThread = FabricThreadManager.getInstance().createThread("DSYS:ReplicationProcessor:" + ReplicationQueueFileBased.this.source.getName() + "-" + this.replicaEntityName.toString(), "Asynchronously processes replication changes delivering them to one replicas in micro-batches.", this);
                this.replicationThread.start();
                this.trace(Trace.Level.DEBUG, "Replication thread started.", new Object[0]);
            }
        }

        synchronized void stop() {
            if (this.replicationThread != null) {
                this.trace(Trace.Level.DEBUG, "Stopping replication thread.", new Object[0]);
                this.running = false;
                ReplicationQueueFileBased.this.lock.lock();
                try {
                    this.lockCondition.signal();
                }
                finally {
                    ReplicationQueueFileBased.this.lock.unlock();
                }
                this.replicationThread.join(2000L);
                if (this.replicationThread.isRunning()) {
                    this.replicationThread.interrupt();
                    ReplicationQueueFileBased.this.lock.lock();
                    try {
                        this.lockCondition.signal();
                    }
                    finally {
                        ReplicationQueueFileBased.this.lock.unlock();
                    }
                }
                this.replicationThread = null;
                this.trace(Trace.Level.DEBUG, "Replication thread stopped.", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            this.trace(Trace.Level.DEBUG, "Replication thread run.", new Object[0]);
            try {
                threadSession = ReplicationQueueFileBased.this.dataspace.createSession();
                try {
                    dataReader = ReplicationQueueFileBased.this.repQueueStorage.getFilesManager().createDataReader();
                    try {
                        this.currentRetriesCount = 0L;
                        this.currentBatchSize = ReplicationQueueFileBased.this.settings.batchSize;
                        while (this.running && !Thread.currentThread().isInterrupted()) {
                            this.currentBatchInterval = ReplicationQueueFileBased.this.settings.batchInterval;
                            try {
                                currentReplicationId = this.replicationId.get();
                                lastDataTimestamp = System.currentTimeMillis();
                                queueIsEmpty = false;
                                if (!(this.isSuspended || this.replicaState != ReplicaState.ACTIVE && this.replicaState != ReplicaState.OUTSYNC && this.replicaState != ReplicaState.SYNCING || currentReplicationId < 0L || ReplicationQueueFileBased.this.source.getCommittedReplicationId() <= currentReplicationId)) {
                                    this.trace(Trace.Level.DEBUG, "Selecting rows starting at {}...", new Object[]{currentReplicationId});
                                    try {
                                        batch = this.readNextBatch(dataReader, this.currentBatchSize, currentReplicationId);
                                        batch.setSync(false);
                                        if (batch.size() > 0) {
                                            lastDataTimestamp = System.currentTimeMillis();
                                            this.processBatch(threadSession, currentReplicationId, batch);
                                        }
                                        queueIsEmpty = true;
                                    }
                                    catch (InterruptedException exception) {
                                        throw exception;
                                    }
                                    catch (Exception exception) {
                                        this.currentBatchSize = 1;
                                        this.currentBatchInterval = ReplicationQueueFileBased.this.settings.batchIntervalError;
                                        Thread.sleep(1000L);
                                        queueIsEmpty = true;
                                        if (!ReplicationQueueFileBased.this.source.raiseReplicationException(this.replicaEntityName, currentReplicationId, exception, true)) ** GOTO lbl38
                                        Trace.logException(this, exception, true);
                                    }
                                } else {
                                    this.currentRetriesCount = 0L;
                                }
lbl38:
                                // 5 sources

                                ReplicationQueueFileBased.this.lock.lock();
                                try {
                                    if (!this.running || !this.isSuspended && ReplicationQueueFileBased.this.source.getCommittedReplicationId() > this.replicationId.get() + (long)ReplicationQueueFileBased.this.settings.batchSize && !queueIsEmpty || (interval = this.currentBatchInterval - (System.currentTimeMillis() - lastDataTimestamp)) <= 0L) continue;
                                    this.lockCondition.await(interval, TimeUnit.MILLISECONDS);
                                }
                                finally {
                                    ReplicationQueueFileBased.this.lock.unlock();
                                }
                            }
                            catch (InterruptedException error) {
                                this.running = false;
                                this.trace(Trace.Level.DEBUG, "Replication queue thread was interrupted. Stopping replication...", new Object[0]);
                            }
                            catch (Throwable exception) {
                                if (!ReplicationQueueFileBased.this.source.raiseReplicationException(this.replicaEntityName, this.replicationId.get(), exception, true)) continue;
                                this.trace(Trace.Level.ERROR, "Replication queue exception.", new Object[0]);
                                Trace.logException(this, exception, true);
                            }
                        }
                    }
                    finally {
                        if (dataReader != null) {
                            dataReader.close();
                        }
                    }
                }
                finally {
                    if (threadSession != null) {
                        threadSession.close();
                    }
                }
            }
            catch (Exception exception) {
                ReplicationQueueFileBased.this.source.raiseReplicationException(this.replicaEntityName, this.replicationId.get(), exception, false);
                this.trace(Trace.Level.ERROR, "Replication queue initialization exception.", new Object[0]);
                Trace.logException(this, exception, true);
            }
            this.trace(Trace.Level.DEBUG, "Replication thread finished.", new Object[0]);
        }

        private void processBatch(Session session, long currentReplicationId, ReplicationDataBatch batch) throws InterruptedException {
            block37: {
                if (batch.size() == 0) {
                    return;
                }
                this.trace(Trace.Level.DEBUG, "Replicating batch of size {}, starting at {}.", batch.size(), currentReplicationId);
                this.lastProcessedDataTimestamp = System.currentTimeMillis();
                batch.setCurrentReplicationId(currentReplicationId);
                batch.setCommittedReplicationId(ReplicationQueueFileBased.this.source.getCommittedReplicationId());
                long batchTimeout = ReplicationQueueFileBased.this.source.getReplicationSourceSettings().batchTimeout;
                try {
                    ReplicationDeliveryMetrics.ReplicationDeliveryMetric.ReplicationDeliveryMetricBuilder metricBuilder = ReplicationDeliveryMetrics.ReplicationDeliveryMetric.builder();
                    metricBuilder.setUnitsCount(batch.size());
                    metricBuilder.setStatementsMap(batch.getStatementsMap());
                    metricBuilder.setBatchSizeInBytes(batch.getSizeInBytes());
                    metricBuilder.setDeliveryStartTime(System.currentTimeMillis());
                    metricBuilder.setBatchReadStartTime(batch.getBatchReadStartTime());
                    metricBuilder.setBatchReadEndTime(batch.getBatchReadEndTime());
                    ++this.currentRetriesCount;
                    ReplicationResponse response = ReplicationQueueFileBased.this.replicationManager.sendReplicationDataWithAck(this.replicaEntityName, this.replicaRequestConsumerReference, batch, ReplicationQueueFileBased.this.source.getReplicationEntityName(), batchTimeout);
                    if (response != null) {
                        if (response.isOk()) {
                            this.replicationError.resetReplicationErrors();
                        } else {
                            this.replicationError.increaseReplicationErrors(new ReplicationException(response.getReplicationErrorCode(), response.getErrorMessage()));
                        }
                        metricBuilder.setStatementsMapTime(response.getStatementsMapTime());
                        metricBuilder.setTargetProcessingTime(response.getBatchProcessingTime());
                        metricBuilder.setDeliveryEndTime(System.currentTimeMillis());
                        if (!response.isOk()) {
                            metricBuilder.setFailedUnitsCount(1L);
                            int index = response.getProcessedTransactionsCount() - 1;
                            if (index < 0) {
                                index = 0;
                            }
                            metricBuilder.setFailedStatementsMap(batch.getTransactions().get(index).getStatementsMap());
                        }
                        if (response.getProcessedTransactionsCount() != batch.size()) {
                            int unprocessedUnitsCount = batch.size() - response.getProcessedTransactionsCount();
                            if (metricBuilder.getFailedUnitsCount() > 0L) {
                                unprocessedUnitsCount = (int)((long)unprocessedUnitsCount - metricBuilder.getFailedUnitsCount());
                            }
                            if (unprocessedUnitsCount < 0) {
                                unprocessedUnitsCount = 0;
                            }
                            metricBuilder.setUnprocessedUnitsCount(unprocessedUnitsCount);
                            metricBuilder.setUnprocessedStatementsMap(batch.getStatementsMap(unprocessedUnitsCount));
                        }
                        if (response.getReplicaInfo() != null && !response.getReplicaInfo().isSuspended()) {
                            this.metrics.addMetric(metricBuilder.build());
                        }
                        this.trace(Trace.Level.DEBUG, "Update replicationId from {} to {}", this.replicationId.get(), response.getReplicationId());
                        if (response.getReplicationId() > this.replicationId.get()) {
                            this.currentRetriesCount = 0L;
                        }
                        this.replicationId.set(response.getReplicationId());
                        ReplicationQueueFileBased.this.source.updateSourceReplicasReplicationId(session, this.replicaEntityName, response.getReplicationId());
                        if (response.getReplicaInfo() != null) {
                            if (response.getReplicaInfo().getState() != null && response.getReplicaInfo().isSuspended()) {
                                this.setReplicaStateAndSuspended(response.getReplicaInfo().getState(), response.getReplicaInfo().isSuspended());
                            } else if (response.getReplicaInfo().isSuspended()) {
                                this.setSuspended(true);
                            } else if (response.getReplicaInfo().getState() != null) {
                                this.setReplicaState(response.getReplicaInfo().getState());
                            }
                        }
                    } else {
                        this.replicationError.increaseReplicationErrors(new ReplicationException(ReplicationErrorCode.INTERNAL_ERROR, "Null response on replication returned."));
                        this.trace(Trace.Level.DEBUG, "Replication error: {}.", ReplicationQueueFileBased.this.source.getReplicationErrors().getLastReplicationError());
                    }
                }
                catch (ReplicationException exception) {
                    if (Utils.getCauseAssignable(exception, TimeoutException.class) != null) {
                        this.handleBatchTimeoutException(batch, batchTimeout);
                    } else if (ReplicationQueueFileBased.this.source.raiseReplicationException(this.replicaEntityName, currentReplicationId, exception, true)) {
                        Trace.logException(this, exception, true);
                    }
                    if (exception.getCode() != ReplicationErrorCode.REPLICATION_PROCESSING_ON_TARGET_FAILED) {
                        this.currentRetriesCount = 0L;
                    }
                    this.replicationError.increaseReplicationErrors(exception);
                    if (Trace.isDebugEnabled(this.getClass())) {
                        this.trace(Trace.Level.DEBUG, "Replication error: {}.", ReplicationQueueFileBased.this.source.getReplicationErrors().getLastReplicationError());
                        Trace.logException(this, exception, true);
                    }
                }
                catch (Exception exception) {
                    if (Utils.getCauseAssignable(exception, TimeoutException.class) != null) {
                        this.handleBatchTimeoutException(batch, batchTimeout);
                    } else if (ReplicationQueueFileBased.this.source.raiseReplicationException(this.replicaEntityName, currentReplicationId, exception, true)) {
                        Trace.logException(this, exception, true);
                    }
                    this.currentRetriesCount = 0L;
                    this.replicationError.increaseReplicationErrors(new ReplicationException(ReplicationErrorCode.INTERNAL_ERROR, exception.getMessage(), exception));
                    if (!Trace.isDebugEnabled(this.getClass())) break block37;
                    this.trace(Trace.Level.DEBUG, "Replication error: {}.", ReplicationQueueFileBased.this.source.getReplicationErrors().getLastReplicationError());
                    Trace.logException(this, exception, true);
                }
            }
            if (this.replicationError.getLastReplicationError() != null) {
                this.currentBatchSize = 1;
                this.currentBatchInterval = ReplicationQueueFileBased.this.settings.batchIntervalError;
                Thread.sleep(1000L);
            } else {
                this.currentBatchSize = ReplicationQueueFileBased.this.settings.batchSize;
            }
            ReplicationQueueFileBased.this.deleteAcknowledgedDataFromReplicationQueue(session, null);
            this.lastProcessedDataTimestamp = System.currentTimeMillis();
            if (this.retryCount != -1 && this.currentRetriesCount > (long)this.retryCount) {
                this.setSuspended(true);
                try {
                    Result result = session.executeDirectStatement("suspend replica [" + this.replicaEntityName.getFullName() + "]");
                    if (result.isError()) {
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        throw new Exception(result.getMainString());
                    }
                }
                catch (InterruptedException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    ReplicationQueueFileBased.this.source.raiseReplicationException(this.replicaEntityName, currentReplicationId, exception, true);
                    Trace.logError(this, "Failed to suspend replica " + this.replicaEntityName.getFullName());
                    Trace.logException(this, exception, true);
                }
            }
        }

        private void handleBatchTimeoutException(ReplicationDataBatch batch, long batchTimeout) {
            this.trace(Trace.Level.ERROR, "Timeout error on batch of size {}, total statements count {}, batch size in bytes {}. Timeout: {} ms.", batch.size(), batch.getStatementsCount(), batch.getSizeInBytes(), batchTimeout);
            ReplicationQueueFileBased.this.source.raiseTimeoutAdvisory(this.replicaEntityName, batchTimeout, batch);
        }

        private ReplicationDataBatch readNextBatch(FileQueueFilesManager.FileQueueDataReader dataReader, int currentBatchSize, long currentReplicationId) throws IOException {
            Object[][] batchArray;
            ReplicationDataBatch batch = new ReplicationDataBatch();
            batch.setBatchReadStartTime(System.currentTimeMillis());
            dataReader.seekToFirst(new ReplicationQueueReplicationIdComparator(currentReplicationId + 1L), new ReplicationQueueReplicationIdIndexes(), FileQueueFilesManager.SeekType.LESS_EQUALS_OR_NEXT);
            for (Object[] row : batchArray = dataReader.readNextBatch(currentBatchSize)) {
                batch.addTransaction((ReplicationDataTransaction)OtherTypeWrapper.unwrap(row[2]));
            }
            batch.setSizeInBytes(dataReader.getLastReadSizeInBytes());
            batch.setBatchReadEndTime(System.currentTimeMillis());
            return batch;
        }

        private void trace(Trace.Level level, String message, Object ... args) {
            if (Trace.isEnabled(this.getClass(), level)) {
                Trace.log(this, level, "Replication processor [" + String.valueOf(ReplicationQueueFileBased.this.source.getReplicationEntityName()) + "->" + String.valueOf(this.replicaEntityName) + "," + this.replicationId.get() + "] : " + message, args);
            }
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public int getRetryCount() {
            return this.retryCount;
        }
    }

    public static class ReplicationQueueReplicationIdComparator
    implements FileQueueKeyComparator {
        private long replicationId;

        public ReplicationQueueReplicationIdComparator(long replicationId) {
            this.replicationId = replicationId;
        }

        @Override
        public int compareTo(Object[] keys) {
            return Long.compare(this.replicationId, ((Number)keys[0]).longValue());
        }
    }

    public static class ReplicationQueueFilenameProvider
    implements FileQueueFilenameProvider {
        private final String baseFilename;
        private final String filenamePattern;
        private static final String FILE_EXTENSION = "rpl";

        ReplicationQueueFilenameProvider(ReplicationSource replicationSource) {
            this.baseFilename = "rsq_" + FileQueueFilenameProvider.escapeFilename(replicationSource.getReplicationEntityName().getDataspaceName()) + "_" + FileQueueFilenameProvider.escapeFilename(replicationSource.getReplicationEntityName().getSourceOrReplicaName()) + "_";
            this.filenamePattern = Pattern.quote(this.baseFilename) + "(\\d*)\\.rpl";
        }

        @Override
        public String buildBaseFilename() {
            return this.baseFilename;
        }

        @Override
        public String getNextFilename() {
            return this.baseFilename + System.currentTimeMillis() + ".rpl";
        }

        @Override
        public String getFilenamePattern() {
            return this.filenamePattern;
        }
    }

    public static class ReplicationQueueReplicationIdIndexes
    implements FileQueueKeyColumnIndexes {
        @Override
        public int[] getColumnIndexes() {
            return new int[]{0};
        }
    }
}

