/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistent;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationDeliveryMetrics;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationRequest;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.moderator.RequestConsumerReference;
import java.util.List;
import java.util.Map;

public interface ReplicationQueue {
    public static final String QUEUE_PREFIX = "rsq";

    public void compile(Session var1, SchemaObject var2);

    public void compileInternalStatements(Session var1);

    public void open(Session var1);

    public void close();

    public void destroy();

    public void onRename(Session var1);

    public Table getReplicationQueueStorage();

    public void enqueue(Session var1, ReplicationDataTransaction var2);

    public void commit();

    public void rollback();

    public void onAfterCommit();

    public void attachOrUpdateReplica(ReplicationRequest var1, RequestConsumerReference var2);

    public void attachReplica(ReplicaInfo var1, RequestConsumerReference var2);

    public boolean detachReplica(ReplicationEntityName var1, long var2, boolean var4);

    public List<ReplicaInfo> listAttachedReplicas();

    public int deleteAcknowledgedDataFromReplicationQueue(Session var1, Statement var2);

    public long getLastTimeQueueCleaned();

    public ReplicationSource.ReplicationError getReplicationErrors();

    public Map<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> getMetricsReportMap();

    public void resetDeliveryMetrics();

    public void alterReplicationQueue(ReplicationQueueSettings var1);

    public static String getQueueName(String dataspaceName, String sourceName) {
        return "rsq." + dataspaceName + "." + sourceName;
    }

    public static String getQueueName(String dataspaceType, String dataspaceName, String sourceName) {
        return ReplicationQueue.getQueueName((String)(dataspaceType != null ? dataspaceType.toLowerCase() + "." : "") + dataspaceName, sourceName);
    }

    public static String getQueueFullNameNoNodeName(String dataspaceName, String sourceName) {
        return "RDS.[" + ReplicationQueue.getQueueName(dataspaceName, sourceName) + "]";
    }

    public static String getQueueFullName(String nodeName, String dataspaceType, String dataspaceName, String sourceName) {
        return nodeName + "://" + ReplicationQueue.getQueueName(dataspaceType, dataspaceName, sourceName);
    }

    public static String removeDataspaceTypeFromName(String name) {
        int typeLength;
        int startIndex = 0;
        int pos = ((String)name).indexOf("://");
        if (pos > 0) {
            startIndex = pos + "://".length();
        }
        if (((String)name).substring(startIndex).startsWith("RDS.")) {
            startIndex += 4;
        }
        if (((String)name).substring(startIndex).startsWith("[")) {
            ++startIndex;
        }
        if (((String)name).substring(startIndex).startsWith("rsq.")) {
            startIndex += "rsq.".length();
        }
        if ((typeLength = ReplicationQueue.startsWithDataspaceType(((String)name).substring(startIndex))) > 0) {
            name = ((String)name).substring(0, startIndex) + ((String)name).substring(startIndex + typeLength);
        }
        return name;
    }

    public static int startsWithDataspaceType(String name) {
        if ((name = name.toLowerCase()).startsWith((DataspaceType.TSPACE.toString() + ".").toLowerCase()) || name.startsWith((DataspaceType.QSPACE.toString() + ".").toLowerCase()) || name.startsWith((DataspaceType.FSPACE.toString() + ".").toLowerCase())) {
            return (DataspaceType.FSPACE.toString() + ".").length();
        }
        return 0;
    }

    public static class ReplicationQueueSettings {
        public static final int DEFAULT_BATCH_SIZE = 1000;
        public static final int DEFAULT_QUEUE_MAX_SIZE = 0;
        public static final long DEFAULT_BATCH_INTERVAL = 1000L;
        public static final long DEFAULT_BATCH_INTERVAL_ERROR = 20000L;
        public static final int DEFAULT_QUEUE_FILE_MAX_SIZE = 0x8000000;
        public static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;
        public static final long DEFAULT_WRITE_FLUSH_DELAY = 500L;
        public static final FileQueueTransactionFilePersistent.TransactionPersistentType DEFAULT_TRANSACTION_PERSISTENCE_TYPE = FileQueueTransactionFilePersistent.TransactionPersistentType.NONE;
        public QueueType type = QueueType.JOURNAL_FILE;
        public int batchSize = 1000;
        public long batchInterval = 1000L;
        public long batchIntervalError = 20000L;
        public long queueMaxSize = 0L;
        public long queueFileMaxFileSize = 0x8000000L;
        public long queueFileWriteBufferSize = 16384L;
        public long queueFileWriteFlushDelay = 500L;
        public FileQueueTransactionFilePersistent.TransactionPersistentType transactionPersistenceType = DEFAULT_TRANSACTION_PERSISTENCE_TYPE;

        public ReplicationQueueSettings() {
            this.batchSize = -1;
            this.batchInterval = -1L;
            this.batchIntervalError = -1L;
            this.queueMaxSize = -1L;
            this.queueFileMaxFileSize = -1L;
            this.queueFileWriteBufferSize = -1L;
            this.queueFileWriteFlushDelay = -1L;
            this.transactionPersistenceType = null;
        }

        public ReplicationQueueSettings(ReplicationQueueSettings settings) {
            this.type = settings.type;
            this.batchSize = settings.batchSize;
            this.batchInterval = settings.batchInterval;
            this.batchIntervalError = settings.batchIntervalError;
            this.queueMaxSize = settings.queueMaxSize;
            this.queueFileMaxFileSize = settings.queueFileMaxFileSize;
            this.queueFileWriteBufferSize = settings.queueFileWriteBufferSize;
            this.queueFileWriteFlushDelay = settings.queueFileWriteFlushDelay;
            this.transactionPersistenceType = settings.transactionPersistenceType;
        }

        public void initWithDefaults() {
            if (this.type == null) {
                this.type = QueueType.JOURNAL_FILE;
            }
            if (this.batchSize == -1) {
                this.batchSize = 1000;
            }
            if (this.batchInterval == -1L) {
                this.batchInterval = 1000L;
            }
            if (this.batchIntervalError == -1L) {
                this.batchIntervalError = 20000L;
            }
            if (this.queueMaxSize == -1L) {
                this.queueMaxSize = 0L;
            }
            if (this.queueFileMaxFileSize == -1L) {
                this.queueFileMaxFileSize = 0x8000000L;
            }
            if (this.queueFileWriteBufferSize == -1L) {
                this.queueFileWriteBufferSize = 16384L;
            }
            if (this.queueFileWriteFlushDelay == -1L) {
                this.queueFileWriteFlushDelay = 500L;
            }
            if (this.transactionPersistenceType == null) {
                this.transactionPersistenceType = DEFAULT_TRANSACTION_PERSISTENCE_TYPE;
            }
        }

        public void mergeFrom(ReplicationQueueSettings from) {
            if (this.type == null) {
                this.type = from.type;
            }
            if (this.batchSize == -1) {
                this.batchSize = from.batchSize;
            }
            if (this.batchInterval == -1L) {
                this.batchInterval = from.batchInterval;
            }
            if (this.batchIntervalError == -1L) {
                this.batchIntervalError = from.batchIntervalError;
            }
            if (this.queueMaxSize == -1L) {
                this.queueMaxSize = from.queueMaxSize;
            }
            if (this.queueFileMaxFileSize == -1L) {
                this.queueFileMaxFileSize = from.queueFileMaxFileSize;
            }
            if (this.queueFileWriteBufferSize == -1L) {
                this.queueFileWriteBufferSize = from.queueFileWriteBufferSize;
            }
            if (this.queueFileWriteFlushDelay == -1L) {
                this.queueFileWriteFlushDelay = from.queueFileWriteFlushDelay;
            }
            if (this.transactionPersistenceType == null) {
                this.transactionPersistenceType = from.transactionPersistenceType;
            }
        }
    }

    public static enum QueueType {
        DATASPACE,
        JOURNAL_FILE;


        public String ddlName() {
            switch (this.ordinal()) {
                case 0: {
                    return "DATASPACE";
                }
                case 1: {
                    return "JOURNAL FILE";
                }
            }
            return null;
        }
    }
}

