/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.Trace;
import com.streamscape.ds.replication.ReplicationMetricsPublisher;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.sef.FabricException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ReplicationMetricsPublisher<T, TR> {
    private String name;
    private final MetricsAggregator<T, TR> metricsAggregator;
    private volatile ReplicationMetricsPublisherConsumer<T, TR> consumer;
    private long timeWindow;
    private long countWindow;
    private long startTime;
    private long count;
    private PublishingWorker publishingWorker;

    public ReplicationMetricsPublisher(String name, MetricsAggregator<T, TR> metricsAggregator, ReplicationMetricsPublisherConsumer<T, TR> consumer) {
        this.name = name;
        this.metricsAggregator = metricsAggregator;
        this.consumer = consumer;
    }

    public void setConsumer(ReplicationMetricsPublisherConsumer<T, TR> consumer) {
        this.consumer = consumer;
    }

    public synchronized long getTimeWindow() {
        return this.timeWindow;
    }

    public synchronized void setTimeWindow(long timeWindow) {
        this.timeWindow = timeWindow;
        if (this.publishingWorker != null) {
            try {
                this.publishingWorker.setTimeout(this.timeWindow > 0L ? this.timeWindow : 10000L);
            }
            catch (FabricException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public synchronized long getCountWindow() {
        return this.countWindow;
    }

    public synchronized void setCountWindow(long countWindow) {
        this.countWindow = countWindow;
    }

    public synchronized void addMetric(T metric) {
        this.metricsAggregator.addMetric(metric);
        ++this.count;
        if (this.countWindow != 0L && this.count >= this.countWindow && this.publishingWorker != null) {
            this.publishingWorker.add(this.metricsAggregator.copy(), new PublisherInfo(this.timeWindow, this.countWindow, this.startTime, System.currentTimeMillis(), this.count));
            this.reset();
        }
    }

    public synchronized void reset() {
        this.metricsAggregator.reset();
        this.startTime = System.currentTimeMillis();
        this.count = 0L;
    }

    public void stop() {
        if (this.publishingWorker != null) {
            this.publishingWorker.stop();
            this.publishingWorker.join(1000L);
            this.publishingWorker = null;
        }
    }

    public synchronized void start() {
        if (this.publishingWorker != null) {
            return;
        }
        try {
            this.publishingWorker = new PublishingWorker(this.timeWindow);
        }
        catch (FabricException exception) {
            Trace.logException(this, exception, true);
        }
        this.publishingWorker.start();
    }

    public static interface MetricsAggregator<T, TR> {
        public void addMetric(T var1);

        public void reset();

        public MetricsAggregator<T, TR> copy();

        public TR toReport();
    }

    public static interface ReplicationMetricsPublisherConsumer<T, TR> {
        public void publish(MetricsAggregator<T, TR> var1, PublisherInfo var2);
    }

    class PublishingWorker
    extends MonitorWorker {
        private Queue<com.streamscape.ds.replication.ReplicationMetricsPublisher$PublishingWorker.PublishingWrapper<T>> queue;

        public PublishingWorker(long timeout) throws FabricException {
            super("DSYS:ReplicationMetricsPublisher", "Publish metrics for '" + ReplicationMetricsPublisher.this.name + "'.", timeout > 0L ? timeout : 100000L);
            this.queue = new ConcurrentLinkedQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(MetricsAggregator<T, TR> metric, PublisherInfo publisherInfo) {
            PublishingWorker publishingWorker = this;
            synchronized (publishingWorker) {
                this.queue.add((com.streamscape.ds.replication.ReplicationMetricsPublisher$PublishingWorker.PublishingWrapper)new PublishingWrapper(this, metric, publisherInfo));
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            if (this.queue.size() > 0) {
                while (this.queue.size() > 0) {
                    PublishingWrapper wrapper = (PublishingWrapper)this.queue.poll();
                    ReplicationMetricsPublisher.this.consumer.publish(wrapper.metricsAggregator, wrapper.info);
                }
            } else if (ReplicationMetricsPublisher.this.timeWindow > 0L) {
                PublisherInfo info;
                MetricsAggregator copy;
                ReplicationMetricsPublisher replicationMetricsPublisher = ReplicationMetricsPublisher.this;
                synchronized (replicationMetricsPublisher) {
                    copy = ReplicationMetricsPublisher.this.metricsAggregator.copy();
                    info = new PublisherInfo(ReplicationMetricsPublisher.this.timeWindow, ReplicationMetricsPublisher.this.countWindow, ReplicationMetricsPublisher.this.startTime, System.currentTimeMillis(), ReplicationMetricsPublisher.this.count);
                    ReplicationMetricsPublisher.this.reset();
                }
                ReplicationMetricsPublisher.this.consumer.publish(copy, info);
            }
        }

        class PublishingWrapper<T> {
            private final MetricsAggregator<T, TR> metricsAggregator;
            private final PublisherInfo info;

            public PublishingWrapper(PublishingWorker this$1, MetricsAggregator<T, TR> metricsAggregator, PublisherInfo info) {
                this.metricsAggregator = metricsAggregator;
                this.info = info;
            }
        }
    }

    public static class PublisherInfo {
        private long timeWindow;
        private long countWindow;
        private long startTime;
        private long endTime;
        private long count;

        public PublisherInfo(long timeWindow, long countWindow, long startTime, long endTime, long count) {
            this.timeWindow = timeWindow;
            this.countWindow = countWindow;
            this.startTime = startTime;
            this.endTime = endTime;
            this.count = count;
        }

        public long getTimeWindow() {
            return this.timeWindow;
        }

        public long getCountWindow() {
            return this.countWindow;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getCount() {
            return this.count;
        }
    }
}

