/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationDataBatch;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationErrorCode;
import com.streamscape.ds.replication.ReplicationException;
import com.streamscape.ds.replication.ReplicationMetaSchema;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.replication.ReplicationRequest;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationSourceInfo;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.replication.SimpleColumnDescriptor;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractReplicationManager;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.tools.log.monitor.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class ReplicationManager
extends AbstractReplicationManager {
    protected TargetsSourceMonitor targetsThreadMonitor;

    public ReplicationManager(AbstractDataspace dataspace) {
        super(dataspace);
    }

    @Override
    public void open(Session session) {
        super.open(session);
        this.targetsThreadMonitor = new TargetsSourceMonitor();
        this.targetsThreadMonitor.start();
    }

    @Override
    public void close(Session session) {
        super.close(session);
        if (this.targetsThreadMonitor != null) {
            this.targetsThreadMonitor.stop();
            this.targetsThreadMonitor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
        ReplicationResponse response = new ReplicationResponse();
        try {
            OpaqueEvent replicationEvent = (OpaqueEvent)event;
            ReplicationRequest request = (ReplicationRequest)replicationEvent.getData();
            if (request.getReplicaEntityName() != null && request.getOperation() != ReplicationRequest.RequestType.GET_SOURCE_DEFINITION) {
                request.setReplicaEntityName(new ReplicationEntityName(request.getReplicaEntityName().getNodeName(), request.getReplicaEntityName().getDataspaceType(), request.getReplicaEntityName().getDataspaceName(), request.getReplicaEntityName().getSourceOrReplicaName(), null));
            }
            switch (request.getOperation()) {
                case GET_SOURCE_DEFINITION: {
                    this.trace(Trace.Level.DEBUG, "Getting source definition for {}.", request.getSourceName());
                    ReplicationSource source = this.getReplicationSource(request.getSourceName());
                    ReplicationSourceInfo replicationSourceInfo = new ReplicationSourceInfo();
                    response.setReplicationSourceInfo(replicationSourceInfo);
                    response.setSourceTableSchemaChangeTimestamp(source.getCollection().getBaseTable().tableSchemaChangeTimestamp);
                    replicationSourceInfo.setSourceCollectionType(source.getCollection().getCollectionType());
                    this.trace(Trace.Level.DEBUG, "Getting column list...", new Object[0]);
                    if (request.getReplicaEntityName() != null) {
                        ArrayList<SimpleColumnDescriptor> columns = new ArrayList<SimpleColumnDescriptor>();
                        HashSet hiddenColumns = new HashSet();
                        if (source.getCollection() instanceof JournalFileTableCollection) {
                            JournalFileTableCollection.listSpecificJftColumns().forEach(p -> hiddenColumns.add((String)p.first));
                            replicationSourceInfo.setSql("N/A");
                        } else {
                            replicationSourceInfo.setSql(source.getCollection().getSQLForReplication("[" + request.getReplicaEntityName().getCollectionName() + "]"));
                        }
                        Iterator iter = source.getCollection().getBaseTable().columnList.values().iterator();
                        while (iter.hasNext()) {
                            ColumnSchema column = (ColumnSchema)iter.next();
                            if (hiddenColumns.contains(column.getNameString())) continue;
                            columns.add(new SimpleColumnDescriptor(column.getNameString(), column.getDataType()));
                        }
                        replicationSourceInfo.setColumnList(columns);
                        replicationSourceInfo.setPrimaryKey(source.getCollection().getBaseTable().getPrimaryKey());
                    }
                    response.setReplicationId(source.getCommittedReplicationId());
                    this.trace(Trace.Level.DEBUG, "Setting source information...", new Object[0]);
                    replicationSourceInfo.setEnabled(source.isEnabled());
                    replicationSourceInfo.setRollbackOnFailure(source.getReplicationSourceSettings().rollbackOnFailure);
                    replicationSourceInfo.setSync(source.getReplicationSourceSettings().sync);
                    replicationSourceInfo.setVersion(source.getVersion());
                    replicationSourceInfo.setReplicationId(source.getReplicationId());
                    replicationSourceInfo.setCommittedReplicationId(source.getCommittedReplicationId());
                    replicationSourceInfo.setReplicationSourceSettings(new ReplicationSource.ReplicationSourceSettings(source.getReplicationSourceSettings()));
                    replicationSourceInfo.setReplicationQueueSettings(new ReplicationQueue.ReplicationQueueSettings(source.getReplicationQueueSettings()));
                    replicationSourceInfo.setListReplicas(this.executeInManagerOrRequestSession(request.getSession(), session -> source.listReplicas((Session)session)));
                    replicationSourceInfo.setEventScope(source.getEventScope());
                    replicationSourceInfo.setRollbackTriggerNames(source.listRollbackTriggerNames());
                    replicationSourceInfo.setReplicationErrors(source.getReplicationErrors());
                    if (request.isWithMetrics()) {
                        replicationSourceInfo.setReplicaMetricsReportMap(source.getReplicaMetricsReportMap());
                        replicationSourceInfo.setReplicationSourceMetricsReport(source.getReplicationSourceMetricsReport());
                    }
                    this.trace(Trace.Level.DEBUG, "Source definition ready.", new Object[0]);
                    break;
                }
                case CHECK_REPLICA_IS_PAIRED_WITH_SOURCE: {
                    ReplicationSource replicationSource = this.getReplicationSource(request.getSourceName());
                    ReplicaInfo replicaInfo = replicationSource.checkReplicaIsPairedWithSource(request);
                    ReplicationSourceInfo replicationSourceInfo = new ReplicationSourceInfo();
                    response.setReplicationSourceInfo(replicationSourceInfo);
                    response.setReplicaInfo(replicaInfo);
                    response.setSourceTableSchemaChangeTimestamp(replicationSource.getCollection().getBaseTable().tableSchemaChangeTimestamp);
                    replicationSourceInfo.setEnabled(replicationSource.isEnabled());
                    break;
                }
                case GET_SOURCE_REPLICATION_ID: {
                    ReplicationSource replicationSource = this.getReplicationSource(request.getSourceName());
                    response.setReplicationId(replicationSource.getCommittedReplicationId());
                    break;
                }
                case ADD_REPLICA_TO_SOURCE: {
                    this.getReplicationSource(request.getSourceName()).addReplicaToSource(request);
                    this.updateSourceReplicasReference(request);
                    break;
                }
                case REPLICA_STATE_CHANGED: {
                    this.getReplicationSource(request.getSourceName()).attachOrUpdateReplica(request);
                    this.updateSourceReplicasReference(request);
                    break;
                }
                case REPLICA_DETACHED: {
                    this.getReplicationSource(request.getSourceName()).detachReplica(request, false);
                    this.updateSourceReplicasReference(request);
                    break;
                }
                case REPLICA_REMOVED: {
                    this.getReplicationSource(request.getSourceName()).detachReplica(request, true);
                    this.updateSourceReplicasReference(request);
                    break;
                }
                case SOURCE_FOR_REPLICA_IS_UPDATED: {
                    ReplicationTarget target = (ReplicationTarget)this.managerSession.dataspaceStore.schemaManager.findSchemaObject(request.getReplicaEntityName().getSourceOrReplicaName(), this.dataspace.getName(), 29);
                    if (target == null) break;
                    this.enqueueMonitorAction(new CheckReplicaIsPairedWithSourceAction(target));
                    break;
                }
                case UPDATE_REPLICA_PARAMS: {
                    ReplicationTarget target = (ReplicationTarget)this.managerSession.dataspaceStore.schemaManager.findSchemaObject(request.getReplicaEntityName().getSourceOrReplicaName(), this.dataspace.getName(), 29);
                    if (target == null) break;
                    target.updateSyncAndRollbackOnFailure(!request.isAsync(), request.isRollbackOnFailure());
                    break;
                }
                case GET_REPLICA_INFO: {
                    ReplicationTarget target = (ReplicationTarget)this.managerSession.dataspaceStore.schemaManager.findSchemaObject(request.getReplicaEntityName().getSourceOrReplicaName(), this.dataspace.getName(), 29);
                    if (target != null) {
                        response.setReplicaInfo(target.getReplicaInfo(request.isWithMetrics()));
                        break;
                    }
                    response.setReplicaInfo(new ReplicaInfo(request.getReplicaEntityName(), true));
                    break;
                }
                case CHECK_REPLICA_EXISTS: {
                    if (DataspaceStore.getContext().getRunLevel() != 4) {
                        response = new ReplicationResponse(false);
                        response.setErrorMessage("Dataspace not yet initialized.");
                        break;
                    }
                    ReplicationTarget target = (ReplicationTarget)this.managerSession.dataspaceStore.schemaManager.findSchemaObject(request.getReplicaEntityName().getSourceOrReplicaName(), this.dataspace.getName(), 29);
                    if (target != null) {
                        if (request.getReplicaState() == ReplicaState.INACTIVE) {
                            this.enqueueMonitorAction(new SendReplicaStateChangeAction(target));
                            break;
                        }
                        if (request.getReplicaState() == null || request.isSuspended() != target.isSuspended()) {
                            this.enqueueMonitorAction(new SendReplicaStateChangeAction(target));
                            break;
                        }
                        if (request.getReplicaState() != null && (target.getState() == ReplicaState.INACTIVE || target.getState() == ReplicaState.FAILURE || target.getState() == ReplicaState.STOPPED || target.getState() == ReplicaState.EVICTED)) {
                            this.enqueueMonitorAction(new SendReplicaDetachedAction(target));
                        }
                        break;
                    }
                    response.setReplicaInfo(new ReplicaInfo(request.getReplicaEntityName(), true));
                    break;
                }
                case SQL_REQUEST: {
                    this.trace(Trace.Level.DEBUG, "Processing request {}, sql: {}", new Object[]{request.getOperation(), request.getSql()});
                    try (Session tempSession = this.dataspace.createSession();){
                        Result result;
                        if (request.getRequestTimeout() >= 0L) {
                            tempSession.setRequestTimeout(request.getRequestTimeout());
                        }
                        if ((result = tempSession.executeDirectStatement(request.getSql())).isError()) {
                            response.setException(result.getException());
                        }
                        if (result.isData()) {
                            response.setRowSet(new RowSetFactoryForDSResult().createRowSets(tempSession, result).get(0));
                        }
                        break;
                    }
                }
                case MATERIALIZE_REQUEST: {
                    ReplicationSource source = this.getReplicationSource(request.getSourceName());
                    if (source.getCollection().getCollectionType() == CollectionType.JOURNAL_FILE_QUEUE || source.getCollection().getCollectionType() == CollectionType.JOURNAL_FILE_TABLE) {
                        throw new DataspaceException("Materialization Option Not Supported with External Data Sources.");
                    }
                    try (Session tempSession = this.dataspace.createSession();){
                        NameManager.ObjectName collectionName = source.getCollection().getBaseTable().getObjectName();
                        tempSession.dataspaceStore.txManager.lockCollectionForWrite(tempSession, collectionName);
                        try {
                            ReplicationRequest newReq = new ReplicationRequest(ReplicationRequest.RequestType.START_MATERIALIZATION);
                            newReq.setSourceName(source.getReplicationEntityName().getCollectionName());
                            newReq.setReplicaEntityName(request.getReplicaEntityName());
                            newReq.setFetchSize(request.getFetchSize());
                            newReq.setRequestTimeout(request.getRequestTimeout() - request.getRequestTimeout() / 10L);
                            newReq.setAppend(request.isAppend());
                            try {
                                ReplicationResponse startMaterializationResponse = this.dataspace.getReplicationManager().sendReplicationManagementRequest(newReq, request.getReplicaEntityName(), request.getRequestTimeout() - request.getRequestTimeout() / 10L);
                                if (!startMaterializationResponse.isOk()) {
                                    response = startMaterializationResponse;
                                }
                                break;
                            }
                            catch (Exception error) {
                                Trace.logError(this, "Unable to send start materialize request to the target. " + error.getMessage());
                                throw error;
                            }
                        }
                        finally {
                            tempSession.dataspaceStore.txManager.unlockCollectionForWrite(tempSession, collectionName);
                        }
                    }
                }
                case START_MATERIALIZATION: {
                    Session materializationSession = this.dataspace.createSession();
                    try {
                        materializationSession.setRequestTimeout(request.getRequestTimeout());
                        ReplicationTarget target = (ReplicationTarget)materializationSession.dataspaceStore.schemaManager.findSchemaObject(request.getReplicaEntityName().getSourceOrReplicaName(), this.dataspace.getName(), 29);
                        if (target == null) {
                            throw new DataspaceException("Target replica '" + request.getReplicaEntityName().getSourceOrReplicaName() + "' doesn't exist.");
                        }
                        target.doMaterialize(materializationSession, request.getFetchSize(), request.getRequestTimeout(), request.isAppend());
                        if (materializationSession == null) break;
                        materializationSession.close();
                        break;
                    }
                    catch (Throwable throwable) {
                        if (materializationSession != null) {
                            try {
                                materializationSession.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (ReplicationException exception) {
            this.trace(Trace.Level.DEBUG, "Processing failed, code: {}, message: {}", new Object[]{exception.getCode(), Utils.formatExceptionWithUnrepeatedCauses(exception)});
            response.setErrorStateAndMessage(exception.getCode(), exception.getMessage());
        }
        catch (Exception exception) {
            this.trace(Trace.Level.DEBUG, "Processing failed, message: {}", Utils.formatExceptionWithUnrepeatedCauses(exception));
            throw new FabricRequestException(exception);
        }
        try {
            OpaqueEvent responseEvent = (OpaqueEvent)OpaqueDatagramFactory.getInstance().newEventInstance("OpaqueEvent");
            responseEvent.setData(response);
            return responseEvent;
        }
        catch (Exception error) {
            throw new FabricRequestException("Internal Error: " + error.getMessage());
        }
    }

    protected ReplicationSource getReplicationSource(String sourceName) {
        Collection collection = (Collection)this.dataspace.lookupCollection(sourceName);
        if (collection == null) {
            throw new ReplicationException(ReplicationErrorCode.SOURCE_COLLECTION_NOT_FOUND, "Collection '" + sourceName + "' doesn't exist.");
        }
        ReplicationSource replicationSource = collection.getReplicationSource();
        if (replicationSource == null) {
            throw new ReplicationException(ReplicationErrorCode.SOURCE_NOT_FOUND, "Replication source on collection '" + sourceName + "' doesn't exist.");
        }
        if (!replicationSource.opened) {
            throw new ReplicationException(ReplicationErrorCode.SOURCE_NOT_OPENED, "Replication source is not opened yet.");
        }
        return replicationSource;
    }

    @Override
    protected ReplicationResponse sendReplicationDataWithAck(ReplicationEntityName replicaEntityName, RequestConsumerReference consumer, ReplicationDataBatch batch, ReplicationEntityName from, long batchTimeout) {
        return super.sendReplicationDataWithAck(replicaEntityName, consumer, batch, from, batchTimeout);
    }

    public ReplicationResponse sendReplicationManagementRequest(ReplicationRequest request, ReplicationEntityName to) {
        return this.sendReplicationManagementRequest(request, to, 10000L);
    }

    @Override
    public ReplicationResponse sendReplicationManagementRequest(ReplicationRequest request, ReplicationEntityName to, long timeout) {
        return super.sendReplicationManagementRequest(request, to, timeout);
    }

    public static ReplicationResponse sendReplicationManagementRequestGlobal(ReplicationRequest request, ReplicationEntityName to) throws ReplicationException {
        return ReplicationManager.sendReplicationManagementRequestGlobal(request, to, 10000L);
    }

    public static ReplicationResponse sendReplicationManagementRequestGlobal(ReplicationRequest request, ReplicationEntityName to, long timeout) throws ReplicationException {
        return AbstractReplicationManager.sendReplicationManagementRequestGlobal(request, to, timeout);
    }

    @Override
    protected void registerTarget(ReplicationTarget replicationTarget) {
        super.registerTarget(replicationTarget);
    }

    @Override
    protected void addTarget(ReplicationTarget target) {
        super.addTarget(target);
    }

    @Override
    protected ReplicationTargetReference addTargetReference(ReplicationTarget replicationTarget) {
        return super.addTargetReference(replicationTarget);
    }

    @Override
    protected void removeTarget(ReplicationTarget replicationTarget) {
        super.removeTarget(replicationTarget);
    }

    @Override
    protected void updateTargetState(ReplicationTarget replicationTarget, ReplicaState state, boolean isSuspended, Boolean sync, ReplicationMetaSchema metaSchema) {
        super.updateTargetState(replicationTarget, state, isSuspended, sync, metaSchema);
    }

    @Override
    protected void addSource(ReplicationSource source) {
        super.addSource(source);
    }

    @Override
    protected ReplicationSourceReference addSourceReference(ReplicationSource source) {
        return super.addSourceReference(source);
    }

    @Override
    protected void removeSource(ReplicationSource source) {
        super.removeSource(source);
    }

    @Override
    protected void updateSourceReference(ReplicationSource source) {
        super.updateSourceReference(source);
    }

    protected void updateSourceReplicasReference(ReplicationSource source, Session requestSession) {
        try {
            super.updateSourceReplicas(source, this.executeInManagerOrRequestSession(requestSession, session -> source.listReplicas((Session)session)));
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to update source replica in reference. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    protected void updateSourceReplicasReference(ReplicationRequest request) {
        try {
            this.updateSourceReplicasReference(this.getReplicationSource(request.getSourceName()), request.getSession());
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to update source replica in reference. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    @Override
    protected void unregisterTarget(ReplicationTarget replicationTarget) {
        super.unregisterTarget(replicationTarget);
    }

    @Override
    protected RequestConsumerReference lookupReplicaConsumer(String nodeName, String dataspaceType, String dataspaceName, String replicaName) {
        return super.lookupReplicaConsumer(nodeName, dataspaceType, dataspaceName, replicaName);
    }

    protected void enqueueMonitorAction(TargetsSourceMonitorAction action) {
        TargetsSourceMonitor monitor = this.targetsThreadMonitor;
        if (monitor != null) {
            monitor.enqueue(action);
        }
    }

    private class TargetsSourceMonitor
    implements Runnable {
        private FabricThread thread;
        private volatile boolean running;
        private final long CHECK_INTERVAL = 30000L;
        private final BlockingQueue<TargetsSourceMonitorAction> queue = new LinkedBlockingQueue<TargetsSourceMonitorAction>();

        void start() {
            this.thread = FabricThreadManager.getInstance().createThread("DSYS:ReplicationManager:TargetsSourceMonitor$" + ReplicationManager.this.dataspace.getObjectName().getSchemaQualifiedStatementName(), "Monitors replication sources and replicas in dataspace " + ReplicationManager.this.dataspace.getObjectName().getSchemaQualifiedStatementName() + ".", this);
            this.running = true;
            this.thread.start();
        }

        void stop() {
            if (this.thread != null) {
                this.running = false;
                this.thread.interrupt();
                this.thread = null;
            }
        }

        public void enqueue(TargetsSourceMonitorAction action) {
            this.queue.add(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long timeoutRemaining = -1L;
            Session session = ReplicationManager.this.dataspace.createSession();
            while (this.running && !Thread.currentThread().isInterrupted()) {
                TargetsSourceMonitorAction action;
                long startTime;
                block10: {
                    if (timeoutRemaining < 0L) {
                        timeoutRemaining = 30000L;
                    }
                    startTime = System.currentTimeMillis();
                    action = null;
                    try {
                        if (timeoutRemaining <= 0L) break block10;
                        action = this.queue.poll(timeoutRemaining, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException exception) {
                        this.running = false;
                        break;
                    }
                }
                if (action == null) {
                    action = new TargetsSourceMonitorRepeatedAction();
                    timeoutRemaining = -1L;
                }
                try {
                    action.execute(session);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
                finally {
                    session.commit(true);
                }
                if (timeoutRemaining <= 0L || (timeoutRemaining -= System.currentTimeMillis() - startTime) > 0L) continue;
                timeoutRemaining = 0L;
            }
            session.close();
        }

        private class TargetsSourceMonitorRepeatedAction
        implements TargetsSourceMonitorAction {
            private TargetsSourceMonitorRepeatedAction() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Session session) {
                for (ReplicationTarget target : ReplicationManager.this.targets) {
                    try {
                        target.attachToSourceMonitor(session);
                    }
                    finally {
                        session.commit(true);
                    }
                }
                for (ReplicationSource source : ReplicationManager.this.sources) {
                    try {
                        source.checkSourceReplicas(session);
                    }
                    finally {
                        session.commit(true);
                    }
                    ReplicationQueue replicationQueue = source.getReplicationQueue();
                    if (replicationQueue == null || System.currentTimeMillis() - replicationQueue.getLastTimeQueueCleaned() <= 30000L) continue;
                    try {
                        replicationQueue.deleteAcknowledgedDataFromReplicationQueue(session, null);
                    }
                    finally {
                        session.commit(true);
                    }
                }
            }
        }
    }

    static class CheckReplicaIsPairedWithSourceAction
    implements TargetsSourceMonitorAction {
        private ReplicationTarget target;

        public CheckReplicaIsPairedWithSourceAction(ReplicationTarget target) {
            this.target = target;
        }

        @Override
        public void execute(Session session) {
            this.target.checkReplicaIsPairedWithSourceMonitor(session);
        }
    }

    public static interface TargetsSourceMonitorAction {
        public void execute(Session var1);
    }

    public static class SendReplicaStateChangeAction
    implements TargetsSourceMonitorAction {
        private ReplicationTarget target;
        private boolean withReplicationId;

        public SendReplicaStateChangeAction(ReplicationTarget target) {
            this(target, true);
        }

        public SendReplicaStateChangeAction(ReplicationTarget target, boolean withReplicationId) {
            this.target = target;
            this.withReplicationId = withReplicationId;
        }

        @Override
        public void execute(Session session) {
            this.target.sendReplicaStateChangedRequestMonitor(session, this.withReplicationId);
        }
    }

    static class SendReplicaDetachedAction
    implements TargetsSourceMonitorAction {
        private ReplicationTarget target;

        public SendReplicaDetachedAction(ReplicationTarget target) {
            this.target = target;
        }

        @Override
        public void execute(Session session) {
            this.target.sendReplicaDetachedMonitor(session);
        }
    }

    public static class CleanupReplicationQueue
    implements TargetsSourceMonitorAction {
        private ReplicationQueue queue;

        public CleanupReplicationQueue(ReplicationQueue queue) {
            this.queue = queue;
        }

        @Override
        public void execute(Session session) {
            this.queue.deleteAcknowledgedDataFromReplicationQueue(session, null);
        }
    }

    public static class CheckSourceReplicasAction
    implements TargetsSourceMonitorAction {
        private ReplicationSource source;

        public CheckSourceReplicasAction(ReplicationSource source) {
            this.source = source;
        }

        @Override
        public void execute(Session session) {
            this.source.checkSourceReplicas(session);
        }
    }

    public static class AttachToSourceMonitorAction
    implements TargetsSourceMonitorAction {
        private ReplicationTarget target;

        public AttachToSourceMonitorAction(ReplicationTarget target) {
            this.target = target;
        }

        @Override
        public void execute(Session session) {
            this.target.attachToSourceMonitor(session);
        }
    }

    public static class SendSourceUpdatedForPairedReplicasAction
    implements TargetsSourceMonitorAction {
        private ReplicationSource source;

        public SendSourceUpdatedForPairedReplicasAction(ReplicationSource source) {
            this.source = source;
        }

        @Override
        public void execute(Session session) {
            this.source.sendSourceUpdatedForPairedReplicas(session);
        }
    }
}

