/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.persist.jfq.FileQueueTransactionFilePersistent;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationDeliveryMetrics;
import com.streamscape.ds.replication.ReplicationMetaSchema;
import com.streamscape.sef.enums.EventScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReplicationFlow {
    private String nodeName;
    private String dataspaceType;
    private String dataspaceName;
    private String replicationSourceName;
    private CollectionType sourceCollectionType;
    private boolean enabled;
    private EventScope eventScope;
    private boolean rollbackOnFailure;
    private boolean sync;
    private int version;
    private long replicationId;
    private long committedReplicationId;
    private ReplicationQueue queue;
    private long replicationErrorsSince = 0L;
    private long replicationErrorsCount = 0L;
    private String lastReplicationError = null;
    private List<String> rollbackTriggers = new ArrayList<String>();
    private List<Replica> replicas = new ArrayList<Replica>();
    private long publishMetricsTimeWindow;
    private TimeUnit publishMetricsTimeWindowUnit;
    private int publishMetricsUnitWindow;
    private ReplicationFlowMetrics metrics;

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getDataspaceType() {
        return this.dataspaceType;
    }

    public void setDataspaceType(String dataspaceType) {
        this.dataspaceType = dataspaceType;
    }

    public String getDataspaceName() {
        return this.dataspaceName;
    }

    public void setDataspaceName(String dataspaceName) {
        this.dataspaceName = dataspaceName;
    }

    public String getReplicationSourceName() {
        return this.replicationSourceName;
    }

    public void setReplicationSourceName(String replicationSourceName) {
        this.replicationSourceName = replicationSourceName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    public boolean isRollbackOnFailure() {
        return this.rollbackOnFailure;
    }

    public void setRollbackOnFailure(boolean rollbackOnFailure) {
        this.rollbackOnFailure = rollbackOnFailure;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(long replicationId) {
        this.replicationId = replicationId;
    }

    public long getCommittedReplicationId() {
        return this.committedReplicationId;
    }

    public void setCommittedReplicationId(long committedReplicationId) {
        this.committedReplicationId = committedReplicationId;
    }

    public ReplicationQueue getQueue() {
        return this.queue;
    }

    public void setQueue(ReplicationQueue queue) {
        this.queue = queue;
    }

    public long getReplicationErrorsSince() {
        return this.replicationErrorsSince;
    }

    public void setReplicationErrorsSince(long replicationErrorsSince) {
        this.replicationErrorsSince = replicationErrorsSince;
    }

    public long getReplicationErrorsCount() {
        return this.replicationErrorsCount;
    }

    public void setReplicationErrorsCount(long replicationErrorsCount) {
        this.replicationErrorsCount = replicationErrorsCount;
    }

    public String getLastReplicationError() {
        return this.lastReplicationError;
    }

    public void setLastReplicationError(String lastReplicationError) {
        this.lastReplicationError = lastReplicationError;
    }

    public List<String> getRollbackTriggers() {
        return this.rollbackTriggers;
    }

    public void setRollbackTriggers(List<String> rollbackTriggers) {
        this.rollbackTriggers = rollbackTriggers;
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public void setReplicas(List<Replica> replicas) {
        this.replicas = replicas;
    }

    public void addReplica(Replica replica) {
        if (this.replicas == null) {
            this.replicas = new ArrayList<Replica>();
        }
        this.replicas.add(replica);
    }

    public void setPublishMetricsTimeWindow(long publishMetricsTimeWindow) {
        this.publishMetricsTimeWindow = publishMetricsTimeWindow;
    }

    public long getPublishMetricsTimeWindow() {
        return this.publishMetricsTimeWindow;
    }

    public void setPublishMetricsTimeWindowUnit(TimeUnit publishMetricsTimeWindowUnit) {
        this.publishMetricsTimeWindowUnit = publishMetricsTimeWindowUnit;
    }

    public TimeUnit getPublishMetricsTimeWindowUnit() {
        return this.publishMetricsTimeWindowUnit;
    }

    public void setPublishMetricsUnitWindow(int publishMetricsUnitWindow) {
        this.publishMetricsUnitWindow = publishMetricsUnitWindow;
    }

    public int getPublishMetricsUnitWindow() {
        return this.publishMetricsUnitWindow;
    }

    public ReplicationFlowMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(ReplicationFlowMetrics metrics) {
        this.metrics = metrics;
    }

    public void setSourceCollectionType(CollectionType sourceCollectionType) {
        this.sourceCollectionType = sourceCollectionType;
    }

    public CollectionType getSourceCollectionType() {
        return this.sourceCollectionType;
    }

    public static class ReplicationQueue {
        private int batchSize;
        private long batchInterval;
        private long batchIntervalError;
        private long queueMaxSize;
        private long queueFileMaxFileSize;
        private long queueFileWriteBufferSize;
        private long queueFileWriteFlushDelay;
        private FileQueueTransactionFilePersistent.TransactionPersistentType transactionPersistenceType;

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public long getBatchInterval() {
            return this.batchInterval;
        }

        public void setBatchInterval(long batchInterval) {
            this.batchInterval = batchInterval;
        }

        public long getBatchIntervalError() {
            return this.batchIntervalError;
        }

        public void setBatchIntervalError(long batchIntervalError) {
            this.batchIntervalError = batchIntervalError;
        }

        public long getQueueMaxSize() {
            return this.queueMaxSize;
        }

        public void setQueueMaxSize(long queueMaxSize) {
            this.queueMaxSize = queueMaxSize;
        }

        public long getQueueFileMaxFileSize() {
            return this.queueFileMaxFileSize;
        }

        public void setQueueFileMaxFileSize(long queueFileMaxFileSize) {
            this.queueFileMaxFileSize = queueFileMaxFileSize;
        }

        public long getQueueFileWriteBufferSize() {
            return this.queueFileWriteBufferSize;
        }

        public void setQueueFileWriteBufferSize(long queueFileWriteBufferSize) {
            this.queueFileWriteBufferSize = queueFileWriteBufferSize;
        }

        public long getQueueFileWriteFlushDelay() {
            return this.queueFileWriteFlushDelay;
        }

        public void setQueueFileWriteFlushDelay(long queueFileWriteFlushDelay) {
            this.queueFileWriteFlushDelay = queueFileWriteFlushDelay;
        }

        public FileQueueTransactionFilePersistent.TransactionPersistentType getTransactionPersistenceType() {
            return this.transactionPersistenceType;
        }

        public void setTransactionPersistenceType(FileQueueTransactionFilePersistent.TransactionPersistentType transactionPersistenceType) {
            this.transactionPersistenceType = transactionPersistenceType;
        }
    }

    public static class ReplicationFlowMetrics {
        private Map<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> replicaMetricReports;

        public Map<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> getReplicaMetricReports() {
            return this.replicaMetricReports;
        }

        public void setReplicaMetricReports(Map<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> replicaMetricReports) {
            this.replicaMetricReports = replicaMetricReports;
        }

        public void addReplicaMetricReport(String name, ReplicationDeliveryMetrics.ReplicaMetricsReport replicaMetricReport) {
            if (this.replicaMetricReports == null) {
                this.replicaMetricReports = new HashMap<String, ReplicationDeliveryMetrics.ReplicaMetricsReport>();
            }
            this.replicaMetricReports.put(name, replicaMetricReport);
        }
    }

    public static class Replica {
        private String nodeName;
        private String dataspaceType;
        private String dataspaceName;
        private String replicaName;
        private String replicaCollectionName;
        private Boolean renew;
        private Boolean withMaterialization;
        private ReplicaState replicaState;
        private boolean attached;
        private boolean notExists;
        private Boolean suspended;
        private boolean unreachable = false;
        private ReplicationMetaSchema metaSchema;
        private Long replicaReplicationId;
        private List<String> successTriggers = new ArrayList<String>();
        private List<String> failTriggers = new ArrayList<String>();
        private List<String> validationTriggers;
        private String transformTrigger;
        private boolean transformTriggerUsingMapper;
        private List<String> transformTriggerMappers;
        private int retryCount;
        private CollectionType targetCollectionType;
        private String targetVirtualServerName;
        private String targetVirtualServerType;
        private long lastTimeResumedSuspended;
        private long lastTimeStateChanged;
        private long lastTimeStartedStopped;
        private String lastError;
        private boolean upsert;
        private boolean ignoreOnFailDelete;
        private boolean ignoreOnFailUpdate;
        private boolean ignoreOnFailInsert;
        private List<String> primaryReplicationKey;

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getDataspaceType() {
            return this.dataspaceType;
        }

        public void setDataspaceType(String dataspaceType) {
            this.dataspaceType = dataspaceType;
        }

        public String getDataspaceName() {
            return this.dataspaceName;
        }

        public void setDataspaceName(String dataspaceName) {
            this.dataspaceName = dataspaceName;
        }

        public String getReplicaName() {
            return this.replicaName;
        }

        public void setReplicaName(String replicaName) {
            this.replicaName = replicaName;
        }

        public String getReplicaCollectionName() {
            return this.replicaCollectionName;
        }

        public void setReplicaCollectionName(String replicaCollectionName) {
            this.replicaCollectionName = replicaCollectionName;
        }

        public boolean isRenew() {
            return this.renew;
        }

        public void setRenew(boolean renew) {
            this.renew = renew;
        }

        public boolean isWithMaterialization() {
            return this.withMaterialization;
        }

        public void setWithMaterialization(boolean withMaterialization) {
            this.withMaterialization = withMaterialization;
        }

        public boolean isAttached() {
            return this.attached;
        }

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public boolean isNotExists() {
            return this.notExists;
        }

        public void setNotExists(boolean notExists) {
            this.notExists = notExists;
        }

        public ReplicaState getReplicaState() {
            return this.replicaState;
        }

        public void setReplicaState(ReplicaState replicaState) {
            this.replicaState = replicaState;
        }

        public Boolean isSuspended() {
            return this.suspended;
        }

        public void setSuspended(Boolean suspended) {
            this.suspended = suspended;
        }

        public long getReplicaReplicationId() {
            return this.replicaReplicationId;
        }

        public void setReplicaReplicationId(long replicaReplicationId) {
            this.replicaReplicationId = replicaReplicationId;
        }

        public List<String> getSuccessTriggers() {
            return this.successTriggers;
        }

        public void setSuccessTriggers(List<String> successTriggers) {
            this.successTriggers = successTriggers;
        }

        public List<String> getFailTriggers() {
            return this.failTriggers;
        }

        public void setFailTriggers(List<String> failTriggers) {
            this.failTriggers = failTriggers;
        }

        public boolean isUnreachable() {
            return this.unreachable;
        }

        public void setUnreachable(boolean unreachable) {
            this.unreachable = unreachable;
        }

        public ReplicationMetaSchema getMetaSchema() {
            return this.metaSchema;
        }

        public void setMetaSchema(ReplicationMetaSchema metaSchema) {
            this.metaSchema = metaSchema;
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public void setTargetCollectionType(CollectionType targetCollectionType) {
            this.targetCollectionType = targetCollectionType;
        }

        public CollectionType getTargetCollectionType() {
            return this.targetCollectionType;
        }

        public void setTargetVirtualServerName(String targetVirtualServerName) {
            this.targetVirtualServerName = targetVirtualServerName;
        }

        public String getTargetVirtualServerName() {
            return this.targetVirtualServerName;
        }

        public void setTargetVirtualServerType(String targetVirtualServerType) {
            this.targetVirtualServerType = targetVirtualServerType;
        }

        public String getTargetVirtualServerType() {
            return this.targetVirtualServerType;
        }

        public void setLastTimeResumedSuspended(long lastTimeResumedSuspended) {
            this.lastTimeResumedSuspended = lastTimeResumedSuspended;
        }

        public long getLastTimeResumedSuspended() {
            return this.lastTimeResumedSuspended;
        }

        public void setLastTimeStateChanged(long lastTimeStateChanged) {
            this.lastTimeStateChanged = lastTimeStateChanged;
        }

        public long getLastTimeStateChanged() {
            return this.lastTimeStateChanged;
        }

        public void setLastTimeStartedStopped(long lastTimeStartedStopped) {
            this.lastTimeStartedStopped = lastTimeStartedStopped;
        }

        public long getLastTimeStartedStopped() {
            return this.lastTimeStartedStopped;
        }

        public void setLastError(String lastError) {
            this.lastError = lastError;
        }

        public String getLastError() {
            return this.lastError;
        }

        public void setUpsert(boolean upsert) {
            this.upsert = upsert;
        }

        public boolean isUpsert() {
            return this.upsert;
        }

        public void setIgnoreOnFailDelete(boolean ignoreOnFailDelete) {
            this.ignoreOnFailDelete = ignoreOnFailDelete;
        }

        public boolean isIgnoreOnFailDelete() {
            return this.ignoreOnFailDelete;
        }

        public void setIgnoreOnFailUpdate(boolean ignoreOnFailUpdate) {
            this.ignoreOnFailUpdate = ignoreOnFailUpdate;
        }

        public boolean isIgnoreOnFailUpdate() {
            return this.ignoreOnFailUpdate;
        }

        public void setIgnoreOnFailInsert(boolean ignoreOnFailInsert) {
            this.ignoreOnFailInsert = ignoreOnFailInsert;
        }

        public boolean isIgnoreOnFailInsert() {
            return this.ignoreOnFailInsert;
        }

        public void setValidationTriggers(List<String> validationTriggers) {
            this.validationTriggers = validationTriggers;
        }

        public List<String> getValidationTriggers() {
            return this.validationTriggers;
        }

        public String getTransformTrigger() {
            return this.transformTrigger;
        }

        public void setTransformTrigger(String transformTrigger) {
            this.transformTrigger = transformTrigger;
        }

        public boolean isTransformTriggerUsingMapper() {
            return this.transformTriggerUsingMapper;
        }

        public void setTransformTriggerUsingMapper(boolean transformTriggerUsingMapper) {
            this.transformTriggerUsingMapper = transformTriggerUsingMapper;
        }

        public List<String> getTransformTriggerMappers() {
            return this.transformTriggerMappers;
        }

        public void setTransformTriggerMappers(List<String> transformTriggerMappers) {
            this.transformTriggerMappers = transformTriggerMappers;
        }

        public void setPrimaryReplicationKey(List<String> primaryReplicationKey) {
            this.primaryReplicationKey = primaryReplicationKey;
        }

        public List<String> getPrimaryReplicationKey() {
            return this.primaryReplicationKey;
        }
    }
}

