/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.enums.EventScope;
import java.util.Objects;

public class ReplicationEntityName {
    private String nodeName = null;
    private String dataspaceType = null;
    private String dataspaceName = null;
    private String sourceOrReplicaName = null;
    private String collectionName = null;

    public ReplicationEntityName(Session session, String fullName, EventScope scope) {
        Pair<String, Integer> colonDelimiter;
        if (fullName == null || fullName.length() <= 0) {
            throw new DataspaceException("Invalid replication entity name.");
        }
        this.nodeName = DataspaceStoreManager.getRuntimeContext().getName();
        Pair<String, Integer> nodeNameDelimiter = this.findNextPart(fullName, 0, "://");
        boolean nodeNameSpecified = false;
        if (nodeNameDelimiter != null) {
            if (scope == null || scope == EventScope.GLOBAL || this.nodeName.equals(nodeNameDelimiter.first)) {
                this.nodeName = (String)nodeNameDelimiter.first;
                fullName = fullName.substring((Integer)nodeNameDelimiter.second + "://".length());
                nodeNameSpecified = true;
            } else {
                throw new DataspaceException("Event scope violation. Node name can't be specified for the target inside of the dataspace with non-global scope.");
            }
        }
        if ((colonDelimiter = this.findNextPart(fullName, 0, ":")) != null) {
            Pair<String, Integer> dataspaceTypeNameDelimiter = this.findNextPart((String)colonDelimiter.first, 0, ".");
            if (dataspaceTypeNameDelimiter != null) {
                this.dataspaceType = ((String)dataspaceTypeNameDelimiter.first).toUpperCase();
                try {
                    DataspaceType.valueOf(this.dataspaceType);
                    this.dataspaceName = NameManager.unquoteString(fullName.substring((Integer)dataspaceTypeNameDelimiter.second + 1, (Integer)colonDelimiter.second));
                }
                catch (Exception exception) {
                    this.dataspaceType = null;
                }
            }
            if (this.dataspaceType == null) {
                if (this.nodeName.equals(DataspaceStoreManager.getRuntimeContext().getName())) {
                    this.dataspaceName = NameManager.unquoteString((String)colonDelimiter.first);
                    DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(this.dataspaceName);
                    if (schema == null) {
                        throw new DataspaceException("Invalid name specified or schema with name '" + this.dataspaceName + "' not found.");
                    }
                    this.dataspaceType = schema.getType().toUpperCase();
                } else {
                    throw new DataspaceException("Dataspace type should be specified for the entities in other nodes. FQN format: <NodeName>://<DataspaceType>.<DataspaceName>:<EntityName>.");
                }
            }
            fullName = fullName.substring((Integer)colonDelimiter.second + 1);
        } else {
            if (nodeNameSpecified) {
                throw new DataspaceException("Invalid FQN. Dataspace type and dataspace name are missing. FQN format: <NodeName>://<DataspaceType>.<DataspaceName>:<EntityName>.");
            }
            DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
            this.dataspaceType = schema.getType().toUpperCase();
            this.dataspaceName = schema.getName();
        }
        this.sourceOrReplicaName = NameManager.unquoteString(fullName);
    }

    public ReplicationEntityName(String nodeName, String dataspaceType, String dataspaceName, String sourceOrReplicaName) {
        this(nodeName, dataspaceType, dataspaceName, sourceOrReplicaName, null);
    }

    public ReplicationEntityName(String nodeName, String dataspaceType, String dataspaceName, String sourceOrReplicaName, String collectionName) {
        this.nodeName = nodeName;
        this.dataspaceType = dataspaceType != null ? dataspaceType.toUpperCase() : null;
        this.dataspaceName = dataspaceName;
        this.sourceOrReplicaName = sourceOrReplicaName;
        this.collectionName = collectionName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getDataspaceType() {
        return this.dataspaceType;
    }

    public String getDataspaceName() {
        return this.dataspaceName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getSourceOrReplicaName() {
        return this.sourceOrReplicaName;
    }

    public String toString() {
        return this.getFullName();
    }

    public String getFullName() {
        return this.nodeName + "://" + (String)(this.dataspaceType != null ? this.dataspaceType.toLowerCase() + "." : "") + this.getFullNameNoDataspaceTypeNoNodeName();
    }

    public String getFullNameNoDataspaceType() {
        return this.nodeName + "://" + this.getFullNameNoDataspaceTypeNoNodeName();
    }

    public String getFullNameNoDataspaceTypeNoNodeName() {
        return ReplicationEntityName.quoteReplicationNameIfNeeded(this.dataspaceName) + ":" + ReplicationEntityName.quoteReplicationNameIfNeeded(this.sourceOrReplicaName);
    }

    public boolean isLocalNode() {
        return DataspaceStoreManager.getRuntimeContext().getName().equals(this.nodeName);
    }

    public static String quoteReplicationNameIfNeeded(String name) {
        if (name != null && !name.startsWith("[") && name.contains(":")) {
            name = NameManager.quoteName(name);
        }
        return name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        ReplicationEntityName temp = (ReplicationEntityName)obj;
        if (!Objects.equals(this.nodeName, temp.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.sourceOrReplicaName, temp.sourceOrReplicaName)) {
            return false;
        }
        return Objects.equals(this.collectionName, temp.collectionName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.dataspaceName, this.sourceOrReplicaName, this.collectionName);
    }

    public boolean equalsNoCollection(ReplicationEntityName replica) {
        return Objects.equals(this.getNodeName(), replica.getNodeName()) && Objects.equals(this.getDataspaceName(), replica.getDataspaceName()) && Objects.equals(this.getSourceOrReplicaName(), replica.getSourceOrReplicaName());
    }

    private Pair<String, Integer> findNextPart(String s, int position, String delimiter) {
        int startPosition = position;
        while (position < s.length()) {
            int delimiterPosition = s.indexOf(delimiter, position);
            if (delimiterPosition == -1) {
                return null;
            }
            if ((position = s.indexOf(91, position)) != -1 && position < delimiterPosition) {
                int count = 0;
                while (position < s.length()) {
                    if (s.charAt(position) == '[') {
                        ++count;
                    } else if (s.charAt(position) == ']' && --count == 0) break;
                    ++position;
                }
                if (position != s.length()) continue;
                throw new DataspaceException("Invalid name '" + s + "', no close bracket.");
            }
            return new Pair<String, Integer>(s.substring(startPosition, delimiterPosition), delimiterPosition);
        }
        return null;
    }
}

