/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.ds.replication.ReplicationMetricsPublisher;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.WindowMetricsQueue;
import com.streamscape.lib.utils.Pair;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ReplicationDeliveryMetrics {
    private ReplicationDeliveryMetricsAggregator aggregatorGlobal = new ReplicationDeliveryMetricsAggregator();
    private ReplicationMetricsPublisher<ReplicationDeliveryMetric, ReplicaMetricsReportFacet> publisher;

    public ReplicationDeliveryMetrics() {
        this.resetAll();
    }

    public synchronized void resetAll() {
        this.resetGlobal();
        if (this.publisher != null) {
            this.publisher.reset();
        }
    }

    public synchronized void resetGlobal() {
        this.aggregatorGlobal.reset();
    }

    public synchronized void addGlobalMinMaxComparator(String name, Comparator<ReplicationDeliveryMetric> comparator) {
        this.aggregatorGlobal.addMinMaxValueComparator(name, comparator);
    }

    public synchronized void setPublishMetricsParameters(String name, long timeWindow, long unitCount, ReplicationMetricsPublisher.ReplicationMetricsPublisherConsumer<ReplicationDeliveryMetric, ReplicaMetricsReportFacet> consumer) {
        if (timeWindow == 0L && unitCount == 0L) {
            if (this.publisher != null) {
                this.publisher.stop();
                this.publisher = null;
            }
        } else if (this.publisher == null) {
            ReplicationDeliveryMetricsAggregator aggregator = new ReplicationDeliveryMetricsAggregator();
            aggregator.minMaxValues = this.aggregatorGlobal.copyMinMaxValuesEmpty();
            this.publisher = new ReplicationMetricsPublisher<ReplicationDeliveryMetric, ReplicaMetricsReportFacet>(name, aggregator, consumer);
            this.publisher.setTimeWindow(timeWindow);
            this.publisher.setCountWindow(unitCount);
            this.publisher.start();
        } else {
            if (consumer != null) {
                this.publisher.setConsumer(consumer);
            }
            this.publisher.setTimeWindow(timeWindow);
            this.publisher.setCountWindow(unitCount);
        }
    }

    public synchronized void addMetric(ReplicationDeliveryMetric metric) {
        this.aggregatorGlobal.addMetric(metric);
        if (this.publisher != null) {
            this.publisher.addMetric(metric);
        }
    }

    public synchronized long getGlobalMinTimestamp() {
        return this.aggregatorGlobal.getMinTimestamp();
    }

    public synchronized long getGlobalMaxTimestamp() {
        return this.aggregatorGlobal.getMaxTimestamp();
    }

    public synchronized ReplicationDeliveryMetric getGlobalTotal() {
        if (this.aggregatorGlobal.getTotal() == null) {
            return null;
        }
        return new ReplicationDeliveryMetric(this.aggregatorGlobal.getTotal());
    }

    public long getGlobalTotalCount() {
        return this.aggregatorGlobal.getTotalCount();
    }

    public long getGlobalResetTime() {
        return this.aggregatorGlobal.getResetTime();
    }

    public synchronized Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric> getGlobalMinMaxMetric(String name) {
        return this.aggregatorGlobal.getMinMaxMetric(name);
    }

    public synchronized ReplicaMetricsReport toReplicaMetricsReport() {
        ReplicaMetricsReport report = new ReplicaMetricsReport();
        report.global = this.aggregatorGlobal.toReport();
        return report;
    }

    public static class ReplicationDeliveryMetricsAggregator
    implements ReplicationMetricsPublisher.MetricsAggregator<ReplicationDeliveryMetric, ReplicaMetricsReportFacet> {
        private long minTimestamp = 0L;
        private long maxTimestamp = 0L;
        private Map<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>> minMaxValues = new HashMap<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>>();
        private long resetTime;
        private ReplicationDeliveryMetric total;
        private long totalCount = 0L;
        private ReplicationDeliveryMetricsAggregatorTotal aggregatorTotal = new ReplicationDeliveryMetricsAggregatorTotal();

        @Override
        public synchronized void addMetric(ReplicationDeliveryMetric metric) {
            for (Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> pair : this.minMaxValues.values()) {
                if (((Pair)pair.second).first == null || ((Comparator)pair.first).compare((ReplicationDeliveryMetric)((Pair)pair.second).first, metric) > 0) {
                    ((Pair)pair.second).first = metric;
                }
                if (((Pair)pair.second).second != null && ((Comparator)pair.first).compare((ReplicationDeliveryMetric)((Pair)pair.second).second, metric) >= 0) continue;
                ((Pair)pair.second).second = metric;
            }
            ++this.totalCount;
            this.total = this.aggregatorTotal.add(this.total, metric, this.totalCount);
            if (this.minTimestamp == 0L) {
                this.minTimestamp = metric.getBatchReadStartTime() > 0L ? metric.getBatchReadStartTime() : metric.getDeliveryStartTime();
            }
            this.maxTimestamp = metric.getBatchReadStartTime() > 0L ? metric.getBatchReadStartTime() : metric.getDeliveryStartTime();
        }

        @Override
        public synchronized void reset() {
            for (Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> pair : this.minMaxValues.values()) {
                if (pair.second == null) continue;
                ((Pair)pair.second).first = null;
                ((Pair)pair.second).second = null;
            }
            this.resetTime = System.currentTimeMillis();
            this.total = null;
            this.totalCount = 0L;
            this.minTimestamp = 0L;
            this.maxTimestamp = 0L;
        }

        public synchronized ReplicationDeliveryMetricsAggregator copy() {
            ReplicationDeliveryMetricsAggregator copy = new ReplicationDeliveryMetricsAggregator();
            copy.minTimestamp = this.minTimestamp;
            copy.maxTimestamp = this.maxTimestamp;
            copy.minMaxValues = this.copyMinMaxValues();
            copy.resetTime = this.resetTime;
            copy.total = this.total != null ? this.total.copy() : null;
            copy.totalCount = this.totalCount;
            copy.aggregatorTotal = this.aggregatorTotal;
            return copy;
        }

        public synchronized Map<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>> copyMinMaxValues() {
            HashMap<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>> copy = new HashMap<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>>();
            for (Map.Entry<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>> entry : this.minMaxValues.entrySet()) {
                copy.put(entry.getKey(), new Pair<Comparator, Pair>((Comparator)entry.getValue().first, entry.getValue().second != null ? new Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>((ReplicationDeliveryMetric)((Pair)entry.getValue().second).first, (ReplicationDeliveryMetric)((Pair)entry.getValue().second).second) : null));
            }
            return copy;
        }

        public synchronized Map<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>> copyMinMaxValuesEmpty() {
            Map<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>> copy = this.copyMinMaxValues();
            for (Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> pair : copy.values()) {
                if (pair.second == null) continue;
                ((Pair)pair.second).first = null;
                ((Pair)pair.second).second = null;
            }
            return copy;
        }

        @Override
        public synchronized ReplicaMetricsReportFacet toReport() {
            ReplicaMetricsReportFacet global = new ReplicaMetricsReportFacet();
            global.startTime = this.resetTime;
            global.endTime = System.currentTimeMillis();
            global.count = this.totalCount;
            global.minTimestamp = this.minTimestamp;
            global.maxTimestamp = this.maxTimestamp;
            global.total = this.total != null ? this.total.copy() : ReplicationDeliveryMetric.empty();
            global.averageInBatches = global.total.averageInBatches(this.totalCount);
            global.averageInUnits = global.total.averageInUnits(this.totalCount);
            global.minMax = new HashMap<String, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>(this.getMinMaxMetricMap());
            return global;
        }

        public synchronized Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric> getMinMaxMetric(String name) {
            Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> pair = this.minMaxValues.get(name);
            if (pair != null) {
                return (Pair)pair.second;
            }
            return null;
        }

        public synchronized Map<String, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> getMinMaxMetricMap() {
            HashMap<String, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> map = new HashMap<String, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>();
            for (Map.Entry<String, Pair<Comparator<ReplicationDeliveryMetric>, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>>> entry : this.minMaxValues.entrySet()) {
                map.put(entry.getKey(), (Pair)entry.getValue().second);
            }
            return map;
        }

        public synchronized void addMinMaxValueComparator(String name, Comparator<ReplicationDeliveryMetric> comparator) {
            Pair<Object, Object> pair = new Pair<Object, Object>(null, null);
            this.minMaxValues.put(name, new Pair<Comparator<ReplicationDeliveryMetric>, Pair<Object, Object>>(comparator, pair));
        }

        public synchronized long getMinTimestamp() {
            return this.minTimestamp;
        }

        public synchronized long getMaxTimestamp() {
            return this.maxTimestamp;
        }

        public synchronized ReplicationDeliveryMetric getTotal() {
            if (this.total == null) {
                return null;
            }
            return new ReplicationDeliveryMetric(this.total);
        }

        public synchronized long getTotalCount() {
            return this.totalCount;
        }

        public synchronized long getResetTime() {
            return this.resetTime;
        }
    }

    public static class ReplicationDeliveryMetric {
        private long unitsCount;
        private long statementsCount;
        private long[] statementsMap;
        private long[] statementsMapTime;
        private long[] discardedStatementsMap;
        private long discardedStatementsCount;
        private long[] ignoredStatementsMap;
        private long ignoredStatementsCount;
        private long batchSizeInBytes;
        private long batchReadStartTime;
        private long batchReadEndTime;
        private long deliveryStartTime;
        private long deliveryEndTime;
        private long targetProcessingTime;
        private long unprocessedUnitsCount;
        private long unprocessedStatementsCount;
        private long[] unprocessedStatementsMap;
        private long failedUnitsCount;
        private long failedStatementsCount;
        private long[] failedStatementsMap;

        public ReplicationDeliveryMetric(ReplicationDeliveryMetric metric) {
            this.unitsCount = metric.unitsCount;
            this.statementsCount = metric.statementsCount;
            this.statementsMap = Arrays.copyOf(metric.statementsMap, metric.statementsMap.length);
            this.statementsMapTime = Arrays.copyOf(metric.statementsMapTime, metric.statementsMapTime.length);
            this.discardedStatementsMap = Arrays.copyOf(metric.discardedStatementsMap, metric.discardedStatementsMap.length);
            this.discardedStatementsCount = metric.discardedStatementsCount;
            this.ignoredStatementsMap = Arrays.copyOf(metric.ignoredStatementsMap, metric.ignoredStatementsMap.length);
            this.ignoredStatementsCount = metric.ignoredStatementsCount;
            this.batchSizeInBytes = metric.batchSizeInBytes;
            this.batchReadStartTime = metric.batchReadStartTime;
            this.batchReadEndTime = metric.batchReadEndTime;
            this.deliveryStartTime = metric.deliveryStartTime;
            this.deliveryEndTime = metric.deliveryEndTime;
            this.targetProcessingTime = metric.targetProcessingTime;
            this.unprocessedUnitsCount = metric.unprocessedUnitsCount;
            this.unprocessedStatementsCount = metric.unprocessedStatementsCount;
            this.unprocessedStatementsMap = metric.unprocessedStatementsMap != null ? Arrays.copyOf(metric.unprocessedStatementsMap, metric.unprocessedStatementsMap.length) : null;
            this.failedUnitsCount = metric.failedUnitsCount;
            this.failedStatementsCount = metric.failedStatementsCount;
            this.failedStatementsMap = metric.failedStatementsMap != null ? Arrays.copyOf(metric.failedStatementsMap, metric.failedStatementsMap.length) : null;
        }

        private ReplicationDeliveryMetric() {
        }

        public static ReplicationDeliveryMetric empty() {
            ReplicationDeliveryMetric metric = new ReplicationDeliveryMetric();
            metric.unitsCount = 0L;
            metric.statementsCount = 0L;
            metric.statementsMap = new long[ReplicationOperationType.values().length];
            metric.statementsMapTime = new long[ReplicationOperationType.values().length];
            metric.discardedStatementsMap = new long[ReplicationOperationType.values().length];
            metric.discardedStatementsCount = 0L;
            metric.ignoredStatementsMap = new long[ReplicationOperationType.values().length];
            metric.ignoredStatementsCount = 0L;
            metric.batchSizeInBytes = 0L;
            metric.batchReadStartTime = 0L;
            metric.batchReadEndTime = 0L;
            metric.deliveryStartTime = 0L;
            metric.deliveryEndTime = 0L;
            metric.targetProcessingTime = 0L;
            metric.unprocessedUnitsCount = 0L;
            metric.unprocessedStatementsCount = 0L;
            metric.unprocessedStatementsMap = null;
            metric.failedUnitsCount = 0L;
            metric.failedStatementsCount = 0L;
            metric.failedStatementsMap = null;
            return metric;
        }

        public ReplicationDeliveryMetric copy() {
            return new ReplicationDeliveryMetric(this);
        }

        public ReplicationDeliveryMetricAverage averageInBatches(long count) {
            int i;
            ReplicationDeliveryMetricAverage result = new ReplicationDeliveryMetricAverage(this);
            if (count <= 0L) {
                return result;
            }
            if (result.statementsCount > 0.0) {
                for (i = 0; i < result.statementsMapTime.length; ++i) {
                    double c = result.statementsMap[i];
                    if (c > 0.0) {
                        int n = i;
                        result.statementsMapTime[n] = result.statementsMapTime[n] / c;
                        continue;
                    }
                    result.statementsMapTime[i] = 0.0;
                }
            }
            i = 0;
            while (i < result.statementsMap.length) {
                int n = i++;
                result.statementsMap[n] = result.statementsMap[n] / (double)count;
            }
            if (result.unprocessedStatementsMap != null) {
                i = 0;
                while (i < result.unprocessedStatementsMap.length) {
                    int n = i++;
                    result.unprocessedStatementsMap[n] = result.unprocessedStatementsMap[n] / (double)count;
                }
            }
            result.unitsCount /= (double)count;
            result.statementsCount /= (double)count;
            result.batchSizeInBytes /= (double)count;
            result.batchReadEndTime /= (double)count;
            result.deliveryEndTime /= (double)count;
            result.targetProcessingTime /= (double)count;
            return result;
        }

        public ReplicationDeliveryMetricAverage averageInUnits(long count) {
            int i;
            ReplicationDeliveryMetricAverage result = new ReplicationDeliveryMetricAverage(this);
            if (count <= 0L) {
                return result;
            }
            if (result.statementsCount > 0.0) {
                for (i = 0; i < result.statementsMapTime.length; ++i) {
                    double c = result.statementsMap[i];
                    if (c > 0.0) {
                        int n = i;
                        result.statementsMapTime[n] = result.statementsMapTime[n] / c;
                        continue;
                    }
                    result.statementsMapTime[i] = 0.0;
                }
            }
            if (result.unitsCount > 0.0) {
                i = 0;
                while (i < result.statementsMap.length) {
                    int n = i++;
                    result.statementsMap[n] = result.statementsMap[n] / result.unitsCount;
                }
                if (result.unprocessedStatementsMap != null) {
                    i = 0;
                    while (i < result.unprocessedStatementsMap.length) {
                        int n = i++;
                        result.unprocessedStatementsMap[n] = result.unprocessedStatementsMap[n] / result.unitsCount;
                    }
                }
            }
            if (result.unitsCount > 0.0) {
                result.statementsCount /= result.unitsCount;
                result.deliveryEndTime /= result.unitsCount;
                result.targetProcessingTime /= result.unitsCount;
            } else {
                result.statementsCount = 0.0;
                result.deliveryEndTime = 0.0;
                result.targetProcessingTime = 0.0;
            }
            result.batchSizeInBytes /= (double)count;
            result.batchReadEndTime /= (double)count;
            result.unitsCount /= (double)count;
            return result;
        }

        public long getUnitsCount() {
            return this.unitsCount;
        }

        public long getStatementsCount() {
            return this.statementsCount;
        }

        public long[] getStatementsMap() {
            return this.statementsMap;
        }

        public long[] getStatementsMapTime() {
            return this.statementsMapTime;
        }

        public long[] getDiscardedStatementsMap() {
            return this.discardedStatementsMap;
        }

        public long getDiscardedStatementsCount() {
            return this.discardedStatementsCount;
        }

        public long[] getIgnoredStatementsMap() {
            return this.ignoredStatementsMap;
        }

        public long getIgnoredStatementsCount() {
            return this.ignoredStatementsCount;
        }

        public long getBatchSizeInBytes() {
            return this.batchSizeInBytes;
        }

        public long getDeliveryStartTime() {
            return this.deliveryStartTime;
        }

        public long getDeliveryEndTime() {
            return this.deliveryEndTime;
        }

        public long getTargetProcessingTime() {
            return this.targetProcessingTime;
        }

        public long getDeliveryTime() {
            return this.deliveryEndTime - this.deliveryStartTime;
        }

        public long getNetworkTime() {
            return this.deliveryEndTime - this.deliveryStartTime - this.targetProcessingTime;
        }

        public long getBatchReadTime() {
            return this.batchReadEndTime - this.batchReadStartTime;
        }

        public long getBatchReadStartTime() {
            return this.batchReadStartTime;
        }

        public long getBatchReadEndTime() {
            return this.batchReadEndTime;
        }

        public long getUnprocessedUnitsCount() {
            return this.unprocessedUnitsCount;
        }

        public long getUnprocessedStatementsCount() {
            return this.unprocessedStatementsCount;
        }

        public long[] getUnprocessedStatementsMap() {
            return this.unprocessedStatementsMap;
        }

        public long getFailedUnitsCount() {
            return this.failedUnitsCount;
        }

        public long getFailedStatementsCount() {
            return this.failedStatementsCount;
        }

        public long[] getFailedStatementsMap() {
            return this.failedStatementsMap;
        }

        public static ReplicationDeliveryMetricBuilder builder() {
            return new ReplicationDeliveryMetricBuilder();
        }

        public static class ReplicationDeliveryMetricBuilder {
            private ReplicationDeliveryMetric metric = new ReplicationDeliveryMetric();
            private long[] statementsTimeTemp;
            private long[] discardedStatementsMapTemp;
            private long[] ignoredStatementsMapTemp;

            private ReplicationDeliveryMetricBuilder() {
            }

            public ReplicationDeliveryMetricBuilder setUnitsCount(long unitsCount) {
                this.metric.unitsCount = unitsCount;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setBatchSizeInBytes(long batchSizeInBytes) {
                this.metric.batchSizeInBytes = batchSizeInBytes;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setBatchReadStartTime(long batchReadStartTime) {
                this.metric.batchReadStartTime = batchReadStartTime;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setBatchReadEndTime(long batchReadEndTime) {
                this.metric.batchReadEndTime = batchReadEndTime;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setDeliveryStartTime(long deliveryStartTime) {
                this.metric.deliveryStartTime = deliveryStartTime;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setDeliveryEndTime(long deliveryEndTime) {
                this.metric.deliveryEndTime = deliveryEndTime;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setTargetProcessingTime(long targetProcessingTime) {
                this.metric.targetProcessingTime = targetProcessingTime;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setStatementsMap(long[] statementsMap) {
                this.metric.statementsMap = statementsMap;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setStatementsMapTime(long[] statementsMapTime) {
                this.metric.statementsMapTime = statementsMapTime;
                return this;
            }

            public void addStatementTime(ReplicationOperationType type, long time) {
                if (this.metric.statementsMapTime == null) {
                    this.metric.statementsMapTime = new long[ReplicationOperationType.values().length];
                }
                int n = type.ordinal();
                this.metric.statementsMapTime[n] = this.metric.statementsMapTime[n] + time;
            }

            public ReplicationDeliveryMetricBuilder setUnprocessedUnitsCount(long unprocessedUnitsCount) {
                this.metric.unprocessedUnitsCount = unprocessedUnitsCount;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setUnprocessedStatementsMap(long[] unprocessedStatementsMap) {
                this.metric.unprocessedStatementsMap = unprocessedStatementsMap;
                return this;
            }

            public ReplicationDeliveryMetricBuilder setFailedUnitsCount(long failedUnitsCount) {
                this.metric.failedUnitsCount = failedUnitsCount;
                return this;
            }

            public long getFailedUnitsCount() {
                return this.metric.failedUnitsCount;
            }

            public ReplicationDeliveryMetricBuilder setFailedStatementsMap(long[] failedStatementsMap) {
                this.metric.failedStatementsMap = failedStatementsMap;
                return this;
            }

            public ReplicationDeliveryMetric build() {
                if (this.metric.statementsMap == null) {
                    this.metric.statementsMap = new long[ReplicationOperationType.values().length];
                }
                if (this.metric.statementsMapTime == null) {
                    this.metric.statementsMapTime = new long[ReplicationOperationType.values().length];
                }
                if (this.metric.discardedStatementsMap == null) {
                    this.metric.discardedStatementsMap = new long[ReplicationOperationType.values().length];
                }
                if (this.metric.ignoredStatementsMap == null) {
                    this.metric.ignoredStatementsMap = new long[ReplicationOperationType.values().length];
                }
                block3: for (ReplicationOperationType type : ReplicationOperationType.values()) {
                    switch (type) {
                        case INSERT: 
                        case DELETE: 
                        case UPDATE: 
                        case TRUNCATE: 
                        case SQL: 
                        case OTHER: {
                            this.metric.statementsCount += this.metric.statementsMap[type.ordinal()];
                            this.metric.discardedStatementsCount += this.metric.discardedStatementsMap[type.ordinal()];
                            this.metric.ignoredStatementsCount += this.metric.ignoredStatementsMap[type.ordinal()];
                            if (this.metric.unprocessedStatementsMap != null) {
                                this.metric.unprocessedStatementsCount += this.metric.unprocessedStatementsMap[type.ordinal()];
                            }
                            if (this.metric.failedStatementsMap == null) continue block3;
                            this.metric.failedStatementsCount += this.metric.failedStatementsMap[type.ordinal()];
                            continue block3;
                        }
                    }
                }
                this.subtractUnprocessedUnitsAndStatements();
                return this.metric;
            }

            private void subtractUnprocessedUnitsAndStatements() {
                int i;
                if (this.metric.unprocessedStatementsCount > 0L) {
                    this.metric.statementsCount -= this.metric.unprocessedStatementsCount;
                    this.metric.unitsCount -= this.metric.unprocessedUnitsCount;
                    if (this.metric.unprocessedStatementsMap != null) {
                        for (i = 0; i < this.metric.unprocessedStatementsMap.length; ++i) {
                            int n = i;
                            this.metric.statementsMap[n] = this.metric.statementsMap[n] - this.metric.unprocessedStatementsMap[i];
                        }
                    }
                }
                if (this.metric.failedStatementsCount > 0L) {
                    this.metric.statementsCount -= this.metric.failedStatementsCount;
                    this.metric.unitsCount -= this.metric.failedUnitsCount;
                    if (this.metric.failedStatementsMap != null) {
                        for (i = 0; i < this.metric.failedStatementsMap.length; ++i) {
                            int n = i;
                            this.metric.statementsMap[n] = this.metric.statementsMap[n] - this.metric.failedStatementsMap[i];
                        }
                    }
                }
            }

            public void addStatementTimeTemp(ReplicationOperationType operationType, long duration) {
                if (this.statementsTimeTemp == null) {
                    this.statementsTimeTemp = new long[ReplicationOperationType.values().length];
                }
                int n = operationType.ordinal();
                this.statementsTimeTemp[n] = this.statementsTimeTemp[n] + duration;
            }

            public void commitStatementsTimeTemp() {
                if (this.statementsTimeTemp == null) {
                    return;
                }
                for (ReplicationOperationType operationType : ReplicationOperationType.values()) {
                    this.addStatementTime(operationType, this.statementsTimeTemp[operationType.ordinal()]);
                }
                this.statementsTimeTemp = null;
            }

            public void resetStatementsTimeTemp() {
                this.statementsTimeTemp = null;
            }

            public ReplicationDeliveryMetricBuilder incrementDiscardedStatementTemp(ReplicationOperationType operationType) {
                if (this.discardedStatementsMapTemp == null) {
                    this.discardedStatementsMapTemp = new long[ReplicationOperationType.values().length];
                }
                int n = operationType.ordinal();
                this.discardedStatementsMapTemp[n] = this.discardedStatementsMapTemp[n] + 1L;
                return this;
            }

            public ReplicationDeliveryMetricBuilder incrementIgnoredStatementTemp(ReplicationOperationType operationType) {
                if (this.ignoredStatementsMapTemp == null) {
                    this.ignoredStatementsMapTemp = new long[ReplicationOperationType.values().length];
                }
                int n = operationType.ordinal();
                this.ignoredStatementsMapTemp[n] = this.ignoredStatementsMapTemp[n] + 1L;
                return this;
            }

            public void commitDiscardedIgnoredStatementTemp() {
                if (this.discardedStatementsMapTemp != null) {
                    if (this.metric.discardedStatementsMap == null) {
                        this.metric.discardedStatementsMap = new long[ReplicationOperationType.values().length];
                    }
                    for (ReplicationOperationType operationType : ReplicationOperationType.values()) {
                        int n = operationType.ordinal();
                        this.metric.discardedStatementsMap[n] = this.metric.discardedStatementsMap[n] + this.discardedStatementsMapTemp[operationType.ordinal()];
                    }
                    this.discardedStatementsMapTemp = null;
                }
                if (this.ignoredStatementsMapTemp != null) {
                    if (this.metric.ignoredStatementsMap == null) {
                        this.metric.ignoredStatementsMap = new long[ReplicationOperationType.values().length];
                    }
                    for (ReplicationOperationType operationType : ReplicationOperationType.values()) {
                        int n = operationType.ordinal();
                        this.metric.ignoredStatementsMap[n] = this.metric.ignoredStatementsMap[n] + this.ignoredStatementsMapTemp[operationType.ordinal()];
                    }
                    this.ignoredStatementsMapTemp = null;
                }
            }

            public void resetDiscardedIgnoredStatementsMapTemp() {
                this.discardedStatementsMapTemp = null;
                this.ignoredStatementsMapTemp = null;
            }
        }

        public static class StatementMapBuilder {
            private final long[] statementsMap = new long[ReplicationOperationType.values().length];

            public StatementMapBuilder insert(long count) {
                this.statementsMap[ReplicationOperationType.INSERT.ordinal()] = count;
                return this;
            }

            public StatementMapBuilder delete(long count) {
                this.statementsMap[ReplicationOperationType.DELETE.ordinal()] = count;
                return this;
            }

            public StatementMapBuilder update(long count) {
                this.statementsMap[ReplicationOperationType.UPDATE.ordinal()] = count;
                return this;
            }

            public StatementMapBuilder truncate(long count) {
                this.statementsMap[ReplicationOperationType.TRUNCATE.ordinal()] = count;
                return this;
            }

            public StatementMapBuilder transaction(long count) {
                this.statementsMap[ReplicationOperationType.TRANSACTION.ordinal()] = count;
                return this;
            }

            public StatementMapBuilder batch(long count) {
                this.statementsMap[ReplicationOperationType.BATCH.ordinal()] = count;
                return this;
            }

            public StatementMapBuilder sql(long count) {
                this.statementsMap[ReplicationOperationType.SQL.ordinal()] = count;
                return this;
            }

            public StatementMapBuilder other(long count) {
                this.statementsMap[ReplicationOperationType.OTHER.ordinal()] = count;
                return this;
            }

            public long[] build() {
                return this.statementsMap;
            }
        }
    }

    public static class ReplicaMetricsReport {
        private ReplicaMetricsReportFacet global;

        public ReplicaMetricsReportFacet getGlobal() {
            return this.global;
        }
    }

    public static class ReplicaMetricsReportFacet {
        private long count;
        private long minTimestamp;
        private long maxTimestamp;
        private ReplicationDeliveryMetric total;
        private ReplicationDeliveryMetricAverage averageInBatches;
        public ReplicationDeliveryMetricAverage averageInUnits;
        private Map<String, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> minMax;
        private long startTime;
        private long endTime;

        public long getCount() {
            return this.count;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getMinTimestamp() {
            return this.minTimestamp;
        }

        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }

        public ReplicationDeliveryMetricAverage getAverageInBatches() {
            return this.averageInBatches;
        }

        public ReplicationDeliveryMetricAverage getAverageInUnits() {
            return this.averageInUnits;
        }

        public ReplicationDeliveryMetric getTotal() {
            return this.total;
        }

        public Map<String, Pair<ReplicationDeliveryMetric, ReplicationDeliveryMetric>> getMinMax() {
            return this.minMax;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }
    }

    public static class ReplicaMetricsWindowReport {
        private ReplicaMetricsReportFacet facet;
        private ReplicationMetricsPublisher.PublisherInfo publisherInfo;

        public ReplicaMetricsWindowReport(ReplicaMetricsReportFacet facet, ReplicationMetricsPublisher.PublisherInfo publisherInfo) {
            this.facet = facet;
            this.publisherInfo = publisherInfo;
        }

        public ReplicaMetricsReportFacet getFacet() {
            return this.facet;
        }

        public ReplicationMetricsPublisher.PublisherInfo getPublisherInfo() {
            return this.publisherInfo;
        }
    }

    static class ReplicationDeliveryMetricsAggregatorTotal
    implements WindowMetricsQueue.MetricsAggregator<ReplicationDeliveryMetric, ReplicationDeliveryMetric> {
        ReplicationDeliveryMetricsAggregatorTotal() {
        }

        @Override
        public ReplicationDeliveryMetric add(ReplicationDeliveryMetric average, ReplicationDeliveryMetric metric, long newSize) {
            if (average != null) {
                int i;
                average.unitsCount += metric.unitsCount;
                average.batchSizeInBytes += metric.batchSizeInBytes;
                average.statementsCount += metric.statementsCount;
                for (i = 0; i < average.statementsMap.length; ++i) {
                    int n = i;
                    average.statementsMap[n] = average.statementsMap[n] + metric.statementsMap[i];
                }
                for (i = 0; i < average.statementsMapTime.length; ++i) {
                    int n = i;
                    average.statementsMapTime[n] = average.statementsMapTime[n] + metric.statementsMapTime[i];
                }
                for (i = 0; i < average.discardedStatementsMap.length; ++i) {
                    int n = i;
                    average.discardedStatementsMap[n] = average.discardedStatementsMap[n] + metric.discardedStatementsMap[i];
                }
                average.discardedStatementsCount += metric.discardedStatementsCount;
                for (i = 0; i < average.ignoredStatementsMap.length; ++i) {
                    int n = i;
                    average.ignoredStatementsMap[n] = average.ignoredStatementsMap[n] + metric.ignoredStatementsMap[i];
                }
                average.ignoredStatementsCount += metric.ignoredStatementsCount;
                average.targetProcessingTime += metric.targetProcessingTime;
                average.deliveryEndTime += metric.deliveryEndTime - metric.deliveryStartTime;
                average.batchReadEndTime += metric.batchReadEndTime - metric.batchReadStartTime;
                average.unprocessedUnitsCount += metric.unprocessedUnitsCount;
                average.unprocessedStatementsCount += metric.unprocessedStatementsCount;
                if (metric.unprocessedStatementsMap != null) {
                    if (average.unprocessedStatementsMap == null) {
                        average.unprocessedStatementsMap = new long[metric.unprocessedStatementsMap.length];
                    }
                    for (i = 0; i < average.unprocessedStatementsMap.length; ++i) {
                        int n = i;
                        average.unprocessedStatementsMap[n] = average.unprocessedStatementsMap[n] + metric.unprocessedStatementsMap[i];
                    }
                }
                average.failedUnitsCount += metric.failedUnitsCount;
                average.failedStatementsCount += metric.failedStatementsCount;
                if (metric.failedStatementsMap != null) {
                    if (average.failedStatementsMap == null) {
                        average.failedStatementsMap = new long[metric.failedStatementsMap.length];
                    }
                    for (i = 0; i < average.failedStatementsMap.length; ++i) {
                        int n = i;
                        average.failedStatementsMap[n] = average.failedStatementsMap[n] + metric.failedStatementsMap[i];
                    }
                }
            } else {
                average = new ReplicationDeliveryMetric(metric);
                average.deliveryEndTime -= average.deliveryStartTime;
                average.deliveryStartTime = 0L;
                average.batchReadEndTime -= average.batchReadStartTime;
                average.batchReadStartTime = 0L;
            }
            return average;
        }

        @Override
        public ReplicationDeliveryMetric remove(ReplicationDeliveryMetric average, ReplicationDeliveryMetric metric, long newSize) {
            if (newSize == 0L || average == null) {
                return null;
            }
            if (average != null) {
                int i;
                average.unitsCount -= metric.unitsCount;
                average.batchSizeInBytes -= metric.batchSizeInBytes;
                average.statementsCount -= metric.statementsCount;
                for (i = 0; i < average.statementsMap.length; ++i) {
                    int n = i;
                    average.statementsMap[n] = average.statementsMap[n] - metric.statementsMap[i];
                }
                for (i = 0; i < average.statementsMapTime.length; ++i) {
                    int n = i;
                    average.statementsMapTime[n] = average.statementsMapTime[n] - metric.statementsMapTime[i];
                }
                for (i = 0; i < average.discardedStatementsMap.length; ++i) {
                    int n = i;
                    average.discardedStatementsMap[n] = average.discardedStatementsMap[n] - metric.discardedStatementsMap[i];
                }
                average.discardedStatementsCount -= metric.discardedStatementsCount;
                for (i = 0; i < average.ignoredStatementsMap.length; ++i) {
                    int n = i;
                    average.ignoredStatementsMap[n] = average.ignoredStatementsMap[n] - metric.ignoredStatementsMap[i];
                }
                average.ignoredStatementsCount -= metric.ignoredStatementsCount;
                average.targetProcessingTime -= metric.targetProcessingTime;
                average.deliveryEndTime -= metric.deliveryEndTime - metric.deliveryStartTime;
                average.batchReadEndTime -= metric.batchReadEndTime - metric.batchReadStartTime;
                average.unprocessedUnitsCount -= metric.unprocessedUnitsCount;
                average.unprocessedStatementsCount -= metric.unprocessedStatementsCount;
                if (metric.unprocessedStatementsMap != null) {
                    if (average.unprocessedStatementsMap == null) {
                        average.unprocessedStatementsMap = new long[metric.unprocessedStatementsMap.length];
                    }
                    for (i = 0; i < average.unprocessedStatementsMap.length; ++i) {
                        int n = i;
                        average.unprocessedStatementsMap[n] = average.unprocessedStatementsMap[n] - metric.unprocessedStatementsMap[i];
                    }
                }
                average.failedUnitsCount -= metric.failedUnitsCount;
                average.failedStatementsCount -= metric.failedStatementsCount;
                if (metric.failedStatementsMap != null) {
                    if (average.failedStatementsMap == null) {
                        average.failedStatementsMap = new long[metric.failedStatementsMap.length];
                    }
                    for (i = 0; i < average.failedStatementsMap.length; ++i) {
                        int n = i;
                        average.failedStatementsMap[n] = average.failedStatementsMap[n] - metric.failedStatementsMap[i];
                    }
                }
            } else {
                average = new ReplicationDeliveryMetric(metric);
                average.deliveryEndTime -= average.deliveryStartTime;
                average.deliveryStartTime = 0L;
                average.batchReadEndTime -= average.batchReadStartTime;
                average.batchReadStartTime = 0L;
            }
            return average;
        }
    }

    public static class ReplicationDeliveryMetricAverage {
        private double unitsCount;
        private double statementsCount;
        private double[] statementsMap;
        private double[] statementsMapTime;
        private double[] discardedStatementsMap;
        private double discardedStatementsCount;
        private double[] ignoredStatementsMap;
        private double ignoredStatementsCount;
        private double batchSizeInBytes;
        private double batchReadStartTime;
        private double batchReadEndTime;
        private double deliveryStartTime;
        private double deliveryEndTime;
        private double targetProcessingTime;
        private double unprocessedUnitsCount;
        private double unprocessedStatementsCount;
        private double[] unprocessedStatementsMap;
        private double failedUnitsCount;
        private double failedStatementsCount;
        private double[] failedStatementsMap;

        public ReplicationDeliveryMetricAverage(ReplicationDeliveryMetric metric) {
            int i;
            this.unitsCount = metric.unitsCount;
            this.statementsCount = metric.statementsCount;
            this.discardedStatementsCount = metric.discardedStatementsCount;
            this.batchSizeInBytes = metric.batchSizeInBytes;
            this.batchReadStartTime = metric.batchReadStartTime;
            this.batchReadEndTime = metric.batchReadEndTime;
            this.deliveryStartTime = metric.deliveryStartTime;
            this.deliveryEndTime = metric.deliveryEndTime;
            this.targetProcessingTime = metric.targetProcessingTime;
            this.unprocessedUnitsCount = metric.unprocessedUnitsCount;
            this.unprocessedStatementsCount = metric.unprocessedStatementsCount;
            this.failedUnitsCount = metric.failedUnitsCount;
            this.failedStatementsCount = metric.failedStatementsCount;
            this.statementsMap = new double[metric.statementsMap.length];
            for (i = 0; i < this.statementsMap.length; ++i) {
                this.statementsMap[i] = metric.statementsMap[i];
            }
            this.statementsMapTime = new double[metric.statementsMapTime.length];
            for (i = 0; i < this.statementsMapTime.length; ++i) {
                this.statementsMapTime[i] = metric.statementsMapTime[i];
            }
            this.discardedStatementsMap = new double[metric.discardedStatementsMap.length];
            for (i = 0; i < this.discardedStatementsMap.length; ++i) {
                this.discardedStatementsMap[i] = metric.discardedStatementsMap[i];
            }
            this.ignoredStatementsMap = new double[metric.ignoredStatementsMap.length];
            for (i = 0; i < this.ignoredStatementsMap.length; ++i) {
                this.ignoredStatementsMap[i] = metric.ignoredStatementsMap[i];
            }
            if (metric.unprocessedStatementsMap != null) {
                this.unprocessedStatementsMap = new double[metric.unprocessedStatementsMap.length];
                for (i = 0; i < this.unprocessedStatementsMap.length; ++i) {
                    this.unprocessedStatementsMap[i] = metric.unprocessedStatementsMap[i];
                }
            }
            if (metric.failedStatementsMap != null) {
                this.failedStatementsMap = new double[metric.failedStatementsMap.length];
                for (i = 0; i < this.failedStatementsMap.length; ++i) {
                    this.failedStatementsMap[i] = metric.failedStatementsMap[i];
                }
            }
        }

        public double getUnitsCount() {
            return this.unitsCount;
        }

        public double getStatementsCount() {
            return this.statementsCount;
        }

        public double[] getStatementsMap() {
            return this.statementsMap;
        }

        public double[] getStatementsMapTime() {
            return this.statementsMapTime;
        }

        public double[] getDiscardedStatementsMap() {
            return this.discardedStatementsMap;
        }

        public double getDiscardedStatementsCount() {
            return this.discardedStatementsCount;
        }

        public double[] getIgnoredStatementsMap() {
            return this.ignoredStatementsMap;
        }

        public double getIgnoredStatementsCount() {
            return this.ignoredStatementsCount;
        }

        public double getBatchSizeInBytes() {
            return this.batchSizeInBytes;
        }

        public double getBatchReadStartTime() {
            return this.batchReadStartTime;
        }

        public double getBatchReadEndTime() {
            return this.batchReadEndTime;
        }

        public double getDeliveryStartTime() {
            return this.deliveryStartTime;
        }

        public double getDeliveryEndTime() {
            return this.deliveryEndTime;
        }

        public double getTargetProcessingTime() {
            return this.targetProcessingTime;
        }

        public double getUnprocessedUnitsCount() {
            return this.unprocessedUnitsCount;
        }

        public double getUnprocessedStatementsCount() {
            return this.unprocessedStatementsCount;
        }

        public double[] getUnprocessedStatementsMap() {
            return this.unprocessedStatementsMap;
        }

        public double getDeliveryTime() {
            return this.deliveryEndTime - this.deliveryStartTime;
        }

        public double getNetworkTime() {
            return this.deliveryEndTime - this.deliveryStartTime - this.targetProcessingTime;
        }

        public double getBatchReadTime() {
            return this.batchReadEndTime - this.batchReadStartTime;
        }

        public double getFailedUnitsCount() {
            return this.failedUnitsCount;
        }
    }
}

