/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationDataBase;
import com.streamscape.ds.replication.ReplicationOperationType;
import java.util.ArrayList;
import java.util.List;

public class ReplicationDataTransaction
extends ReplicationDataBase {
    private List<ReplicationData> data;
    private long replicationId = 0L;

    public ReplicationDataTransaction(long replicationId) {
        super(ReplicationOperationType.TRANSACTION);
        this.replicationId = replicationId;
        this.data = new ArrayList<ReplicationData>();
    }

    public ReplicationDataTransaction(long replicationId, ReplicationData data) {
        this(replicationId);
        this.data.add(data);
    }

    public List<ReplicationData> getData() {
        return this.data;
    }

    public void setData(List<ReplicationData> data) {
        this.data = data;
    }

    public void addData(ReplicationData data) {
        this.data.add(data);
    }

    public long getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(long replicationId) {
        this.replicationId = replicationId;
    }

    public int getSize() {
        return this.data == null ? 0 : this.data.size();
    }

    public long[] getStatementsMap() {
        long[] map = new long[ReplicationOperationType.values().length];
        this.data.stream().forEach(d -> {
            int n = d.getOperationType().ordinal();
            map[n] = map[n] + 1L;
        });
        return map;
    }

    public boolean hasGroup() {
        return this.data != null && this.data.stream().filter(d -> d.getGroupId() != null).findAny().orElse(null) != null;
    }
}

