/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.ds.replication.ReplicationDataBase;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.List;

public class ReplicationDataBatch
extends ReplicationDataBase {
    private List<ReplicationDataTransaction> transactions;
    private long committedReplicationId;
    private long currentReplicationId;
    private boolean sync;
    private boolean rollbackOnFailure;
    private long sizeInBytes = 0L;
    private long batchReadStartTime = 0L;
    private long batchReadEndTime = 0L;
    private transient Session session;

    public ReplicationDataBatch() {
        super(ReplicationOperationType.BATCH);
    }

    public ReplicationDataBatch(ReplicationDataTransaction transaction) {
        super(ReplicationOperationType.BATCH);
        this.transactions = new ArrayList<ReplicationDataTransaction>(1);
        this.transactions.add(transaction);
    }

    public List<ReplicationDataTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<ReplicationDataTransaction> transactions) {
        this.transactions = transactions;
    }

    public void addTransaction(ReplicationDataTransaction transaction) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<ReplicationDataTransaction>();
        }
        this.transactions.add(transaction);
    }

    public int size() {
        return this.transactions != null ? this.transactions.size() : 0;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setCommittedReplicationId(long committedReplicationId) {
        this.committedReplicationId = committedReplicationId;
    }

    public long getCommittedReplicationId() {
        return this.committedReplicationId;
    }

    public void setCurrentReplicationId(long currentReplicationId) {
        this.currentReplicationId = currentReplicationId;
    }

    public long getCurrentReplicationId() {
        return this.currentReplicationId;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isRollbackOnFailure() {
        return this.rollbackOnFailure;
    }

    public void setRollbackOnFailure(boolean rollbackOnFailure) {
        this.rollbackOnFailure = rollbackOnFailure;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public long getBatchReadStartTime() {
        return this.batchReadStartTime;
    }

    public void setBatchReadStartTime(long batchReadStartTime) {
        this.batchReadStartTime = batchReadStartTime;
    }

    public long getBatchReadEndTime() {
        return this.batchReadEndTime;
    }

    public void setBatchReadEndTime(long batchReadEndTime) {
        this.batchReadEndTime = batchReadEndTime;
    }

    public int getStatementsCount() {
        return this.getTransactions().stream().mapToInt(t -> t.getSize()).sum();
    }

    public long[] getStatementsMap() {
        return this.getStatementsMap(this.size());
    }

    public long[] getStatementsMap(int last) {
        long[] map = new long[ReplicationOperationType.values().length];
        for (int i = this.transactions.size() - last; i < this.transactions.size(); ++i) {
            ReplicationDataTransaction t = this.transactions.get(i);
            long[] tmap = t.getStatementsMap();
            for (int j = 0; j < map.length; ++j) {
                int n = j;
                map[n] = map[n] + tmap[j];
            }
            int n = ReplicationOperationType.TRANSACTION.ordinal();
            map[n] = map[n] + 1L;
        }
        int n = ReplicationOperationType.BATCH.ordinal();
        map[n] = map[n] + 1L;
        return map;
    }
}

