/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.ds.replication.ReplicationDataBase;
import com.streamscape.ds.replication.ReplicationOperationType;
import java.util.List;

public class ReplicationData
extends ReplicationDataBase {
    private Object[] row;
    private Long groupId;
    private String sql;
    private List<Integer> primaryKey;

    public ReplicationData(ReplicationOperationType operationType) {
        super(operationType);
    }

    public ReplicationData(ReplicationOperationType operationType, Object[] row, Long groupId) {
        this(operationType, row, groupId, null);
    }

    public ReplicationData(ReplicationOperationType operationType, Object[] row, Long groupId, List<Integer> primaryKey) {
        this(operationType);
        this.row = row;
        this.groupId = groupId;
        this.primaryKey = primaryKey;
    }

    public ReplicationData(Object[] oldRow, Object[] newRow, List<Integer> primaryKey) {
        this(ReplicationOperationType.UPDATE, oldRow, newRow, null, primaryKey);
    }

    public ReplicationData(ReplicationOperationType operationType, Object[] oldRow, Object[] newRow, Long groupId, List<Integer> primaryKey) {
        this(operationType);
        switch (operationType) {
            case INSERT: {
                this.row = newRow;
                break;
            }
            case DELETE: {
                this.row = oldRow;
                break;
            }
            case UPDATE: {
                this.row = new Object[]{oldRow, newRow};
            }
        }
        this.groupId = groupId;
        this.primaryKey = primaryKey;
    }

    public Object[] getRow() {
        return this.row;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public List<Integer> getPrimaryKey() {
        return this.primaryKey;
    }
}

