/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MessagesExpirationCache {
    private long expirationTimeout;
    private long expirationCleanupTimeout;
    private long lastCleanupTime = 0L;
    private Map<Message, MessageInfo> messages = new HashMap<Message, MessageInfo>();

    public MessagesExpirationCache(long expirationTimeout, long expirationCleanupTimeout) {
        this.expirationTimeout = expirationTimeout;
        this.expirationCleanupTimeout = expirationCleanupTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageInfo addMessage(Message message) {
        MessageInfo info;
        block14: {
            info = this.messages.get(message);
            if (info == null) {
                this.messages.put(message, new MessageInfo(this));
                MessageInfo messageInfo = new MessageInfo(this);
                return messageInfo;
            }
            if (System.currentTimeMillis() - info.timestamp > this.expirationCleanupTimeout) {
                try {
                    ++info.count;
                    MessageInfo messageInfo = new MessageInfo(this, info);
                    return messageInfo;
                }
                finally {
                    this.messages.put(message, new MessageInfo(this));
                }
            }
            if (System.currentTimeMillis() - info.timestamp <= this.expirationTimeout) break block14;
            try {
                ++info.count;
                MessageInfo messageInfo = new MessageInfo(this, info);
                return messageInfo;
            }
            finally {
                this.messages.put(message, new MessageInfo(this));
            }
        }
        ++info.count;
        MessageInfo messageInfo = null;
        return messageInfo;
        finally {
            this.cleanup();
        }
    }

    public synchronized void cleanup() {
        if (System.currentTimeMillis() - this.lastCleanupTime <= this.expirationCleanupTimeout) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Message, MessageInfo>> iterator = this.messages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Message, MessageInfo> entry = iterator.next();
            if (now - entry.getValue().timestamp <= this.expirationTimeout) continue;
            iterator.remove();
        }
        this.lastCleanupTime = System.currentTimeMillis();
    }

    public class MessageInfo {
        private long timestamp;
        private long count;

        public MessageInfo(MessagesExpirationCache this$0) {
            this.timestamp = System.currentTimeMillis();
            this.count = 0L;
        }

        public MessageInfo(MessagesExpirationCache this$0, MessageInfo from) {
            this.timestamp = from.timestamp;
            this.count = from.count;
        }

        public String getRepeatedInfo() {
            if (this.count > 0L) {
                return "Repeated " + this.count + " times in last " + (System.currentTimeMillis() - this.timestamp) / 1000L + " seconds.";
            }
            return "";
        }
    }

    public static interface Message {
    }
}

