/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DurationTimer {
    private long startTime = 0L;
    private long stopTime = 0L;

    public DurationTimer() {
        this.start();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.stopTime = 0L;
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
    }

    public long getDuration() {
        return this.getDuration(TimeUnit.MILLISECONDS);
    }

    public long getDuration(TimeUnit unit) {
        long t = this.stopTime;
        if (t == 0L) {
            t = System.currentTimeMillis();
        }
        return unit.convert(t - this.startTime, TimeUnit.MILLISECONDS);
    }

    public String getDurationString() {
        return Duration.ofMillis(this.getDuration()).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public long getStartTime() {
        return this.startTime;
    }
}

