/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.replication;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.ReplicationEventTrigger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractReplicationEntity {
    protected DataspaceStore store;
    protected AbstractDataspace dataspace;
    protected Collection collection;
    protected ReplicationManager replicationManager;
    protected Map<String, ReplicationEventTrigger> successTriggers = new LinkedHashMap<String, ReplicationEventTrigger>();
    protected Map<String, ReplicationEventTrigger> rollbackTriggers = new LinkedHashMap<String, ReplicationEventTrigger>();
    protected Map<String, ReplicationEventTrigger> failTriggers = new LinkedHashMap<String, ReplicationEventTrigger>();

    public AbstractReplicationEntity(DataspaceStore store, String schemaName) {
        this.store = store;
        this.dataspace = (AbstractDataspace)store.schemaManager.findSchema(schemaName);
        this.replicationManager = this.dataspace.getReplicationManager();
    }

    public abstract String getName();

    public AbstractReplicationEntity(DataspaceStore store, String schemaName, Collection collection) {
        this(store, schemaName);
        this.collection = collection;
    }

    public void onReplicationSuccess(Session session, ReplicationDataTransaction transaction) {
        this.successTriggers.entrySet().forEach(e -> ((ReplicationEventTrigger)e.getValue()).execute(session, transaction, null));
    }

    public void onReplicationFail(Session session, ReplicationDataTransaction transaction, Throwable exception) {
        this.failTriggers.entrySet().forEach(e -> ((ReplicationEventTrigger)e.getValue()).execute(session, transaction, exception));
    }

    public void onReplicationFail(Session session, ReplicationData replicationData, Throwable exception) {
        this.failTriggers.entrySet().forEach(e -> ((ReplicationEventTrigger)e.getValue()).execute(session, replicationData, exception));
    }

    public void onReplicationRollback(Session session, ReplicationDataTransaction transaction, Throwable exception) {
        this.rollbackTriggers.entrySet().forEach(e -> ((ReplicationEventTrigger)e.getValue()).execute(session, transaction, exception));
    }

    public void addTrigger(ReplicationEventTrigger trigger) {
        switch (trigger.getReplicationTriggerType()) {
            case SUCCESS: {
                this.successTriggers.put(trigger.getObjectName().name, trigger);
                break;
            }
            case FAIL: {
                this.failTriggers.put(trigger.getObjectName().name, trigger);
                break;
            }
            case ROLLBACK: {
                this.rollbackTriggers.put(trigger.getObjectName().name, trigger);
            }
        }
    }

    public ReplicationEventTrigger getTrigger(String name) {
        ReplicationEventTrigger trigger = this.successTriggers.get(name);
        if (trigger == null) {
            trigger = this.failTriggers.get(name);
        }
        if (trigger == null) {
            trigger = this.rollbackTriggers.get(name);
        }
        return trigger;
    }

    public void removeTrigger(ReplicationEventTrigger trigger) {
        String name = trigger.getObjectName().name;
        trigger = this.successTriggers.remove(name);
        if (trigger != null) {
            trigger.terminate();
        }
        if ((trigger = this.failTriggers.remove(name)) != null) {
            trigger.terminate();
        }
        if ((trigger = this.rollbackTriggers.remove(name)) != null) {
            trigger.terminate();
        }
    }

    public List<String> listSuccessTriggerNames() {
        return new ArrayList<String>(this.successTriggers.keySet());
    }

    public List<String> listFailTriggerNames() {
        return new ArrayList<String>(this.successTriggers.keySet());
    }

    public List<String> listRollbackTriggerNames() {
        return new ArrayList<String>(this.rollbackTriggers.keySet());
    }

    public Collection getCollection() {
        return this.collection;
    }

    public abstract NameManager.ObjectName getObjectName();

    public AbstractDataspace getDataspace() {
        return this.dataspace;
    }

    public void enqueueMonitorAction(ReplicationManager.TargetsSourceMonitorAction action) {
        this.replicationManager.enqueueMonitorAction(action);
    }

    public abstract boolean raiseReplicationException(Throwable var1, boolean var2);
}

