/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.range;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.IntKeyIntValueHashMap;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.MultiValueHashMap;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.session.Session;

public class RangeVariableResolver {
    Session session;
    public RangeVariable[] rangeVariables;
    Expression conditions;
    OrderedHashSet rangeVarSet = new OrderedHashSet();
    ParserDQL.CompileContext compileContext;
    SortAndSlice sortAndSlice = SortAndSlice.noSort;
    HsqlArrayList[] tempJoinExpressions;
    HsqlArrayList[] joinExpressions;
    HsqlArrayList[] whereExpressions;
    HsqlArrayList queryExpressions = new HsqlArrayList();
    Expression[] inExpressions;
    boolean[] inInJoin;
    int inExpressionCount = 0;
    boolean expandInExpression = true;
    boolean hasOuterJoin = false;
    int firstLeftJoinIndex;
    int firstRightJoinIndex;
    OrderedIntHashSet colIndexSetEqual = new OrderedIntHashSet();
    IntKeyIntValueHashMap colIndexSetOther = new IntKeyIntValueHashMap();
    OrderedHashSet tempSet = new OrderedHashSet();
    MultiValueHashMap tempMap = new MultiValueHashMap();

    public RangeVariableResolver(QuerySpecification select) {
        this.rangeVariables = select.rangeVariables;
        this.conditions = select.queryCondition;
        this.compileContext = select.compileContext;
        this.sortAndSlice = select.sortAndSlice;
        this.initialise();
    }

    public RangeVariableResolver(RangeVariable[] rangeVariables, Expression conditions, ParserDQL.CompileContext compileContext) {
        this.rangeVariables = rangeVariables;
        this.conditions = conditions;
        this.compileContext = compileContext;
        this.initialise();
    }

    private void initialise() {
        int i;
        this.firstLeftJoinIndex = this.rangeVariables.length;
        this.firstRightJoinIndex = this.rangeVariables.length;
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            if (range.isLeftJoin) {
                if (this.firstLeftJoinIndex == this.rangeVariables.length) {
                    this.firstLeftJoinIndex = i;
                }
                this.hasOuterJoin = true;
            }
            if (!range.isRightJoin) continue;
            if (this.firstRightJoinIndex == this.rangeVariables.length) {
                this.firstRightJoinIndex = i;
            }
            this.hasOuterJoin = true;
        }
        this.inExpressions = new Expression[this.rangeVariables.length];
        this.inInJoin = new boolean[this.rangeVariables.length];
        this.tempJoinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.tempJoinExpressions[i] = new HsqlArrayList();
        }
        this.joinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.joinExpressions[i] = new HsqlArrayList();
        }
        this.whereExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.whereExpressions[i] = new HsqlArrayList();
        }
    }

    public void processConditions(Session session) {
        int i;
        this.session = session;
        RangeVariableResolver.decomposeAndConditions(session, this.conditions, this.queryExpressions);
        for (i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].joinCondition == null) continue;
            RangeVariableResolver.decomposeAndConditions(session, this.rangeVariables[i].joinCondition, this.tempJoinExpressions[i]);
        }
        this.conditions = null;
        if (!this.sortAndSlice.usingIndex || this.sortAndSlice.primaryTableIndex == null) {
            for (i = 0; i < this.rangeVariables.length; ++i) {
                this.rangeVarSet.add(this.rangeVariables[i]);
            }
            this.reorder();
            this.rangeVarSet.clear();
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVarSet.add(this.rangeVariables[i]);
        }
        this.assignToLists();
        this.expandConditions();
        this.assignToRangeVariables();
    }

    void reorder() {
        int i;
        if (this.rangeVariables.length == 1 || this.firstLeftJoinIndex == 1 || this.firstRightJoinIndex != this.rangeVariables.length) {
            return;
        }
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            if (this.rangeVariables[i2].rangeTable.isSchemaBaseTable()) continue;
            return;
        }
        HsqlArrayList joins = new HsqlArrayList();
        HsqlArrayList starts = new HsqlArrayList();
        HsqlArrayList others = new HsqlArrayList();
        for (i = 0; i < this.firstLeftJoinIndex; ++i) {
            HsqlArrayList tempJoins = this.tempJoinExpressions[i];
            for (int j = 0; j < tempJoins.size(); ++j) {
                Expression e = (Expression)tempJoins.get(j);
                if (e.isColumnEqual) {
                    joins.add(e);
                    continue;
                }
                if (e.isSingleColumnCondition) {
                    starts.add(e);
                    continue;
                }
                others.add(e);
            }
        }
        for (i = 0; i < this.queryExpressions.size(); ++i) {
            Expression e = (Expression)this.queryExpressions.get(i);
            RangeVariable[] ranges = e.getJoinRangeVariables(this.rangeVariables);
            int count = ArrayUtil.countCommonElements(this.rangeVariables, this.firstLeftJoinIndex, ranges);
            if (count != ranges.length) continue;
            if (e.isColumnEqual) {
                joins.add(e);
                continue;
            }
            if (e.isSingleColumnCondition) {
                starts.add(e);
                continue;
            }
            others.add(e);
        }
        if (starts.size() == 0) {
            return;
        }
        Expression start = null;
        int position = 0;
        RangeVariable range = null;
        double cost = this.rangeVariables[0].rangeTable.getRowStore(this.session).elementCount();
        if (cost < 16.0) {
            cost = 16.0;
        }
        if (this.rangeVariables[0].rangeTable.getTableType() == 6) {
            cost *= 8.0;
        }
        for (int i3 = 0; i3 < starts.size(); ++i3) {
            Expression e = (Expression)starts.get(i3);
            range = e.getJoinRangeVariables(this.rangeVariables)[0];
            double currentCost = e.costFactor(this.session, range, 41);
            if (range == this.rangeVariables[0]) {
                start = null;
                break;
            }
            if (!(currentCost < cost)) continue;
            start = e;
        }
        if (start == null) {
            return;
        }
        position = ArrayUtil.find(this.rangeVariables, range);
        if (position <= 0) {
            return;
        }
        RangeVariable[] newRanges = new RangeVariable[this.rangeVariables.length];
        ArrayUtil.copyArray(this.rangeVariables, newRanges, this.rangeVariables.length);
        newRanges[position] = newRanges[0];
        newRanges[0] = range;
        for (position = 1; position < this.firstLeftJoinIndex; ++position) {
            boolean found = false;
            for (int i4 = 0; i4 < joins.size(); ++i4) {
                int newPosition;
                Expression e = (Expression)joins.get(i4);
                if (e == null || (newPosition = this.getJoinedRangePosition(e, position, newRanges)) < position) continue;
                range = newRanges[position];
                newRanges[position] = newRanges[newPosition];
                newRanges[newPosition] = range;
                joins.set(i4, null);
                found = true;
                break;
            }
            if (!found) break;
        }
        if (position != this.firstLeftJoinIndex) {
            return;
        }
        ArrayUtil.copyArray(newRanges, this.rangeVariables, this.rangeVariables.length);
        joins.clear();
        for (int i5 = 0; i5 < this.firstLeftJoinIndex; ++i5) {
            HsqlArrayList tempJoins = this.tempJoinExpressions[i5];
            joins.addAll(tempJoins);
            tempJoins.clear();
        }
        this.tempJoinExpressions[this.firstLeftJoinIndex - 1].addAll(joins);
    }

    int getJoinedRangePosition(Expression e, int position, RangeVariable[] currentRanges) {
        int found = -1;
        RangeVariable[] ranges = e.getJoinRangeVariables(currentRanges);
        for (int i = 0; i < ranges.length; ++i) {
            for (int j = 0; j < currentRanges.length; ++j) {
                if (ranges[i] != currentRanges[j] || j < position) continue;
                if (found > 0) {
                    return -1;
                }
                found = j;
            }
        }
        return found;
    }

    public static Expression decomposeAndConditions(Session session, Expression e, HsqlArrayList conditions) {
        if (e == null) {
            return Expression.EXPR_TRUE;
        }
        Expression arg1 = e.getLeftNode();
        Expression arg2 = e.getRightNode();
        int type = e.getType();
        if (type == 49) {
            arg1 = RangeVariableResolver.decomposeAndConditions(session, arg1, conditions);
            arg2 = RangeVariableResolver.decomposeAndConditions(session, arg2, conditions);
            if (arg1 == Expression.EXPR_TRUE) {
                return arg2;
            }
            if (arg2 == Expression.EXPR_TRUE) {
                return arg1;
            }
            e.setLeftNode(arg1);
            e.setRightNode(arg2);
            return e;
        }
        if (type == 41 && arg1.getType() == 25 && arg2.getType() == 25) {
            for (int i = 0; i < arg1.nodes.length; ++i) {
                ExpressionLogical part = new ExpressionLogical(arg1.nodes[i], arg2.nodes[i]);
                ((Expression)part).resolveTypes(session, null);
                conditions.add(part);
            }
            return Expression.EXPR_TRUE;
        }
        if (e != Expression.EXPR_TRUE) {
            conditions.add(e);
        }
        return Expression.EXPR_TRUE;
    }

    static Expression decomposeOrConditions(Expression e, HsqlArrayList conditions) {
        if (e == null) {
            return Expression.EXPR_FALSE;
        }
        Expression arg1 = e.getLeftNode();
        Expression arg2 = e.getRightNode();
        int type = e.getType();
        if (type == 50) {
            arg1 = RangeVariableResolver.decomposeOrConditions(arg1, conditions);
            arg2 = RangeVariableResolver.decomposeOrConditions(arg2, conditions);
            if (arg1 == Expression.EXPR_FALSE) {
                return arg2;
            }
            if (arg2 == Expression.EXPR_FALSE) {
                return arg1;
            }
            e = new ExpressionLogical(50, arg1, arg2);
            return e;
        }
        if (e != Expression.EXPR_FALSE) {
            conditions.add(e);
        }
        return Expression.EXPR_FALSE;
    }

    void assignToLists() {
        int i;
        int lastBoundary = 0;
        int lastOuterIndex = -1;
        int lastRightIndex = -1;
        for (i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].isLeftJoin) {
                lastOuterIndex = i;
            }
            if (this.rangeVariables[i].isRightJoin) {
                lastOuterIndex = i;
                lastRightIndex = i;
            }
            if (this.rangeVariables[i].isBoundary) {
                lastBoundary = i;
            }
            if (lastOuterIndex == i) {
                this.joinExpressions[i].addAll(this.tempJoinExpressions[i]);
                continue;
            }
            int start = lastOuterIndex + 1;
            if (lastBoundary > start) {
                start = lastBoundary;
            }
            for (int j = 0; j < this.tempJoinExpressions[i].size(); ++j) {
                this.assignToJoinLists((Expression)this.tempJoinExpressions[i].get(j), this.joinExpressions, start);
            }
        }
        for (i = 0; i < this.queryExpressions.size(); ++i) {
            this.assignToJoinLists((Expression)this.queryExpressions.get(i), this.whereExpressions, lastRightIndex);
        }
    }

    void assignToJoinLists(Expression e, HsqlArrayList[] expressionLists, int first) {
        this.tempSet.clear();
        e.collectRangeVariables(this.rangeVariables, this.tempSet);
        int index = this.rangeVarSet.getLargestIndex(this.tempSet);
        if (index == -1) {
            index = 0;
        }
        if (index < first) {
            index = first;
        }
        if (e instanceof ExpressionLogical && ((ExpressionLogical)e).isTerminal) {
            index = expressionLists.length - 1;
        }
        expressionLists[index].add(e);
    }

    void expandConditions() {
        if (this.hasOuterJoin) {
            return;
        }
        this.expandConditions(this.joinExpressions, true);
        this.expandConditions(this.whereExpressions, false);
    }

    void expandConditions(HsqlArrayList[] array, boolean isJoin) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            HsqlArrayList list = array[i];
            this.tempMap.clear();
            this.tempSet.clear();
            boolean hasChain = false;
            for (int j = 0; j < list.size(); ++j) {
                Expression e = (Expression)list.get(j);
                if (!e.isColumnEqual || e.getLeftNode().getRangeVariable() == e.getRightNode().getRangeVariable()) continue;
                if (e.getLeftNode().getRangeVariable() == this.rangeVariables[i]) {
                    this.tempMap.put(e.getLeftNode().getColumn(), e.getRightNode());
                    if (this.tempSet.add(e.getLeftNode().getColumn())) continue;
                    hasChain = true;
                    continue;
                }
                if (e.getRightNode().getRangeVariable() != this.rangeVariables[i]) continue;
                this.tempMap.put(e.getRightNode().getColumn(), e.getLeftNode());
                if (this.tempSet.add(e.getRightNode().getColumn())) continue;
                hasChain = true;
            }
            if (!hasChain) continue;
            Iterator keyIt = this.tempMap.keySet().iterator();
            while (keyIt.hasNext()) {
                Object key = keyIt.next();
                Iterator it = this.tempMap.get(key);
                this.tempSet.clear();
                while (it.hasNext()) {
                    this.tempSet.add(it.next());
                }
                while (this.tempSet.size() > 1) {
                    Expression e1 = (Expression)this.tempSet.remove(this.tempSet.size() - 1);
                    for (int j = 0; j < this.tempSet.size(); ++j) {
                        Expression e2 = (Expression)this.tempSet.get(j);
                        this.closeJoinChain(array, e1, e2);
                    }
                }
            }
        }
    }

    void closeJoinChain(HsqlArrayList[] array, Expression e1, Expression e2) {
        int idx2;
        int index;
        int idx1 = this.rangeVarSet.getIndex(e1.getRangeVariable());
        int n = index = idx1 > (idx2 = this.rangeVarSet.getIndex(e2.getRangeVariable())) ? idx1 : idx2;
        if (idx1 == -1 || idx2 == -1) {
            return;
        }
        ExpressionLogical e = new ExpressionLogical(e1, e2);
        for (int i = 0; i < array[index].size(); ++i) {
            if (!e.equals(array[index].get(i))) continue;
            return;
        }
        array[index].add(e);
    }

    void assignToRangeVariables() {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable.RangeVariableConditions conditions;
            boolean hasIndex = false;
            if (i < this.firstLeftJoinIndex && this.firstRightJoinIndex == this.rangeVariables.length) {
                conditions = this.rangeVariables[i].joinConditions[0];
                this.joinExpressions[i].addAll(this.whereExpressions[i]);
                this.assignToRangeVariable(this.rangeVariables[i], conditions, i, this.joinExpressions[i]);
                this.assignToRangeVariable(conditions, this.joinExpressions[i]);
                continue;
            }
            conditions = this.rangeVariables[i].joinConditions[0];
            this.assignToRangeVariable(this.rangeVariables[i], conditions, i, this.joinExpressions[i]);
            conditions = this.rangeVariables[i].joinConditions[0];
            if (conditions.hasIndex()) {
                hasIndex = true;
            }
            this.assignToRangeVariable(conditions, this.joinExpressions[i]);
            conditions = this.rangeVariables[i].whereConditions[0];
            for (int j = i + 1; j < this.rangeVariables.length; ++j) {
                if (!this.rangeVariables[j].isRightJoin) continue;
                this.assignToRangeVariable(this.rangeVariables[j].whereConditions[0], this.whereExpressions[i]);
            }
            if (!hasIndex) {
                this.assignToRangeVariable(this.rangeVariables[i], conditions, i, this.whereExpressions[i]);
            }
            this.assignToRangeVariable(conditions, this.whereExpressions[i]);
        }
        if (this.expandInExpression && this.inExpressionCount != 0) {
            this.setInConditionsAsTables();
        }
    }

    void assignToRangeVariable(RangeVariable.RangeVariableConditions conditions, HsqlArrayList exprList) {
        int size = exprList.size();
        for (int j = 0; j < size; ++j) {
            Expression e = (Expression)exprList.get(j);
            conditions.addCondition(e);
        }
    }

    Expression getIndexableColumn(HsqlArrayList exprList, int start) {
        int size = exprList.size();
        for (int j = start; j < size; ++j) {
            int colIndex;
            RangeVariable range;
            Expression e = (Expression)exprList.get(j);
            if (e.getType() != 41 || e.exprSubType == 51 || e.exprSubType == 52) continue;
            this.tempSet.clear();
            e.collectRangeVariables(this.rangeVariables, this.tempSet);
            if (this.tempSet.size() != 1 || (e = e.getIndexableExpression(range = (RangeVariable)this.tempSet.get(0))) == null || (e = e.getLeftNode()).getType() != 2 || range.rangeTable.indexTypeForColumn(this.session, colIndex = e.getColumnIndex()) == 0) continue;
            return e;
        }
        return null;
    }

    void assignToRangeVariable(RangeVariable rangeVar, RangeVariable.RangeVariableConditions conditions, int rangeVarIndex, HsqlArrayList exprList) {
        if (exprList.isEmpty()) {
            return;
        }
        this.setIndexConditions(conditions, exprList, rangeVarIndex, true);
    }

    private void setIndexConditions(RangeVariable.RangeVariableConditions conditions, HsqlArrayList exprList, int rangeVarIndex, boolean includeOr) {
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int size = exprList.size();
        block8: for (int j = 0; j < size; ++j) {
            Expression e = (Expression)exprList.get(j);
            if (e == null || !e.isIndexable(conditions.rangeVar)) continue;
            int type = e.getType();
            switch (type) {
                case 50: {
                    continue block8;
                }
                case 2: {
                    continue block8;
                }
                case 41: {
                    if (e.exprSubType == 52 || e.exprSubType == 51 || e.getLeftNode().getRangeVariable() != conditions.rangeVar) continue block8;
                    int colIndex = e.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(colIndex);
                    continue block8;
                }
                case 47: {
                    if (e.getLeftNode().getRangeVariable() != conditions.rangeVar || conditions.rangeVar.isLeftJoin) continue block8;
                    int colIndex = e.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(colIndex);
                    continue block8;
                }
                case 48: {
                    if (e.getLeftNode().getLeftNode().getRangeVariable() != conditions.rangeVar || conditions.rangeVar.isLeftJoin) continue block8;
                    int colIndex = e.getLeftNode().getLeftNode().getColumnIndex();
                    int count = this.colIndexSetOther.get(colIndex, 0);
                    this.colIndexSetOther.put(colIndex, count + 1);
                    continue block8;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (e.getLeftNode().getRangeVariable() != conditions.rangeVar) continue block8;
                    int colIndex = e.getLeftNode().getColumnIndex();
                    int count = this.colIndexSetOther.get(colIndex, 0);
                    this.colIndexSetOther.put(colIndex, count + 1);
                    continue block8;
                }
                default: {
                    Error.runtimeError(201, "RangeVariableResolver");
                }
            }
        }
        this.setEqualityConditions(conditions, exprList, rangeVarIndex);
        boolean hasIndex = conditions.hasIndex();
        if (!hasIndex) {
            this.setNonEqualityConditions(conditions, exprList, rangeVarIndex);
        }
        hasIndex = rangeVarIndex == 0 && this.sortAndSlice.usingIndex ? true : conditions.hasIndex();
        boolean isOR = false;
        if (!hasIndex && includeOr) {
            int size2 = exprList.size();
            for (int j = 0; j < size2; ++j) {
                Expression e = (Expression)exprList.get(j);
                if (e == null) continue;
                if (e.getType() == 50) {
                    hasIndex = ((ExpressionLogical)e).isIndexable(conditions.rangeVar);
                    if (hasIndex) {
                        hasIndex = this.setOrConditions(conditions, (ExpressionLogical)e, rangeVarIndex);
                    }
                    if (!hasIndex) continue;
                    exprList.set(j, null);
                    isOR = true;
                    break;
                }
                if (e.getType() != 41 || e.exprSubType != 52 || rangeVarIndex >= this.firstLeftJoinIndex || this.firstRightJoinIndex != this.rangeVariables.length || e.getRightNode().isCorrelated()) continue;
                OrderedIntHashSet set = new OrderedIntHashSet();
                ((ExpressionLogical)e).addLeftColumnsForAllAny(conditions.rangeVar, set);
                Index index = conditions.rangeVar.rangeTable.getIndexForColumns(this.session, set, false);
                if (index == null || this.inExpressions[rangeVarIndex] != null) continue;
                this.inExpressions[rangeVarIndex] = e;
                this.inInJoin[rangeVarIndex] = conditions.isJoin;
                ++this.inExpressionCount;
                exprList.set(j, null);
                break;
            }
        }
        int size3 = exprList.size();
        for (int i = 0; i < size3; ++i) {
            Expression e = (Expression)exprList.get(i);
            if (e == null) continue;
            if (isOR) {
                for (int j = 0; j < conditions.rangeVar.joinConditions.length; ++j) {
                    if (conditions.isJoin) {
                        conditions.rangeVar.joinConditions[j].nonIndexCondition = ExpressionLogical.andExpressions(e, conditions.rangeVar.joinConditions[j].nonIndexCondition);
                        continue;
                    }
                    conditions.rangeVar.whereConditions[j].nonIndexCondition = ExpressionLogical.andExpressions(e, conditions.rangeVar.whereConditions[j].nonIndexCondition);
                }
                continue;
            }
            conditions.addCondition(e);
        }
    }

    private boolean setOrConditions(RangeVariable.RangeVariableConditions conditions, ExpressionLogical orExpression, int rangeVarIndex) {
        HsqlArrayList orExprList = new HsqlArrayList();
        RangeVariableResolver.decomposeOrConditions(orExpression, orExprList);
        Object[] conditionsArray = new RangeVariable.RangeVariableConditions[orExprList.size()];
        for (int i = 0; i < orExprList.size(); ++i) {
            HsqlArrayList exprList = new HsqlArrayList();
            Expression e = (Expression)orExprList.get(i);
            RangeVariableResolver.decomposeAndConditions(this.session, e, exprList);
            RangeVariable.RangeVariableConditions c = new RangeVariable.RangeVariableConditions(conditions);
            this.setIndexConditions(c, exprList, rangeVarIndex, false);
            conditionsArray[i] = c;
            if (c.hasIndex()) continue;
            return false;
        }
        Expression exclude = null;
        for (int i = 0; i < conditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions c = conditionsArray[i];
            conditionsArray[i].excludeConditions = exclude;
            if (i == conditionsArray.length - 1) break;
            Expression e = null;
            if (c.indexCond != null) {
                for (int k = 0; k < c.indexedColumnCount; ++k) {
                    e = ExpressionLogical.andExpressions(e, c.indexCond[k]);
                }
            }
            e = ExpressionLogical.andExpressions(e, c.indexEndCondition);
            e = ExpressionLogical.andExpressions(e, c.nonIndexCondition);
            exclude = ExpressionLogical.orExpressions(e, exclude);
        }
        if (exclude != null) {
            // empty if block
        }
        if (conditions.isJoin) {
            conditions.rangeVar.joinConditions = conditionsArray;
            conditionsArray = new RangeVariable.RangeVariableConditions[orExprList.size()];
            ArrayUtil.fillArray(conditionsArray, conditions.rangeVar.whereConditions[0]);
            conditions.rangeVar.whereConditions = conditionsArray;
        } else {
            conditions.rangeVar.whereConditions = conditionsArray;
            conditionsArray = new RangeVariable.RangeVariableConditions[orExprList.size()];
            ArrayUtil.fillArray(conditionsArray, conditions.rangeVar.joinConditions[0]);
            conditions.rangeVar.joinConditions = conditionsArray;
        }
        return true;
    }

    private void setEqualityConditions(RangeVariable.RangeVariableConditions conditions, HsqlArrayList exprList, int rangeVarIndex) {
        Index idx = null;
        if (rangeVarIndex == 0 && this.sortAndSlice.usingIndex && (idx = this.sortAndSlice.primaryTableIndex) != null) {
            conditions.rangeIndex = idx;
        }
        if (idx == null) {
            idx = conditions.rangeVar.rangeTable.getIndexForColumns(this.session, this.colIndexSetEqual, false);
        }
        if (idx == null) {
            return;
        }
        int[] cols = idx.getColumns();
        int colCount = cols.length;
        Expression[] firstRowExpressions = new Expression[cols.length];
        for (int j = 0; j < exprList.size(); ++j) {
            int offset;
            int type;
            Expression e = (Expression)exprList.get(j);
            if (e == null || (type = e.getType()) != 41 && type != 47 || e.getLeftNode().getRangeVariable() != conditions.rangeVar || !e.isIndexable(conditions.rangeVar) || (offset = ArrayUtil.find(cols, e.getLeftNode().getColumnIndex())) == -1 || firstRowExpressions[offset] != null) continue;
            firstRowExpressions[offset] = e;
            exprList.set(j, null);
        }
        boolean hasNull = false;
        for (int i = 0; i < firstRowExpressions.length; ++i) {
            Expression e = firstRowExpressions[i];
            if (e == null) {
                if (colCount == cols.length) {
                    colCount = i;
                }
                hasNull = true;
                continue;
            }
            if (!hasNull) continue;
            conditions.addCondition(e);
            firstRowExpressions[i] = null;
        }
        if (colCount > 0) {
            conditions.addIndexCondition(firstRowExpressions, idx, colCount);
        }
    }

    private void setNonEqualityConditions(RangeVariable.RangeVariableConditions conditions, HsqlArrayList exprList, int rangeVarIndex) {
        if (this.colIndexSetOther.isEmpty()) {
            return;
        }
        int currentCount = 0;
        int currentIndex = 0;
        Iterator it = this.colIndexSetOther.keySet().iterator();
        while (it.hasNext()) {
            int colIndex = it.nextInt();
            int colCount = this.colIndexSetOther.get(colIndex);
            if (colCount <= currentCount) continue;
            currentIndex = colIndex;
        }
        Index idx = null;
        if (rangeVarIndex == 0 && this.sortAndSlice.usingIndex) {
            idx = this.sortAndSlice.primaryTableIndex;
        }
        if (idx == null) {
            idx = conditions.rangeVar.rangeTable.getIndexForColumn(this.session, currentIndex);
        }
        if (idx == null) {
            int colIndex;
            it = this.colIndexSetOther.keySet().iterator();
            while (it.hasNext() && ((colIndex = it.nextInt()) == currentIndex || (idx = conditions.rangeVar.rangeTable.getIndexForColumn(this.session, colIndex)) == null)) {
            }
        }
        if (idx == null) {
            return;
        }
        int[] cols = idx.getColumns();
        for (int j = 0; j < exprList.size(); ++j) {
            Expression e = (Expression)exprList.get(j);
            if (e == null) continue;
            boolean isIndexed = false;
            switch (e.getType()) {
                case 48: {
                    if (e.getLeftNode().getType() != 47 || cols[0] != e.getLeftNode().getLeftNode().getColumnIndex()) break;
                    isIndexed = true;
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (cols[0] != e.getLeftNode().getColumnIndex() || e.getRightNode() == null || e.getRightNode().isCorrelated()) break;
                    isIndexed = true;
                }
            }
            if (!isIndexed) continue;
            Expression[] firstRowExpressions = new Expression[idx.getColumnCount()];
            firstRowExpressions[0] = e;
            conditions.addIndexCondition(firstRowExpressions, idx, 1);
            exprList.set(j, null);
            break;
        }
    }

    void setInConditionsAsTables() {
        for (int i = this.rangeVariables.length - 1; i >= 0; --i) {
            RangeVariable rangeVar = this.rangeVariables[i];
            ExpressionLogical in = (ExpressionLogical)this.inExpressions[i];
            if (in == null) continue;
            OrderedIntHashSet set = new OrderedIntHashSet();
            in.addLeftColumnsForAllAny(rangeVar, set);
            Index index = rangeVar.rangeTable.getIndexForColumns(this.session, set, false);
            int indexedColCount = 0;
            for (int j = 0; j < index.getColumnCount() && set.contains(index.getColumns()[j]); ++j) {
                ++indexedColCount;
            }
            RangeVariable newRangeVar = new RangeVariable(in.getRightNode().getTable(), null, null, null, this.compileContext);
            newRangeVar.isGenerated = true;
            RangeVariable[] newList = new RangeVariable[this.rangeVariables.length + 1];
            ArrayUtil.copyAdjustArray(this.rangeVariables, newList, newRangeVar, i, 1);
            this.rangeVariables = newList;
            Expression[] exprList = new Expression[index.getColumnCount()];
            for (int j = 0; j < indexedColCount; ++j) {
                int leftIndex = index.getColumns()[j];
                int rightIndex = set.getIndex(leftIndex);
                ExpressionLogical e = new ExpressionLogical(rangeVar, leftIndex, newRangeVar, rightIndex);
                exprList[j] = e;
            }
            boolean isOuter = this.rangeVariables[i].isLeftJoin || this.rangeVariables[i].isRightJoin;
            RangeVariable.RangeVariableConditions conditions = !this.inInJoin[i] && isOuter ? rangeVar.whereConditions[0] : rangeVar.joinConditions[0];
            conditions.addIndexCondition(exprList, index, indexedColCount);
            int j = 0;
            while (j < set.size()) {
                int leftIndex = set.get(j);
                int rightIndex = j++;
                ExpressionLogical e = new ExpressionLogical(rangeVar, leftIndex, newRangeVar, rightIndex);
                conditions.addCondition(e);
            }
        }
    }
}

