/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.range;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class RangeVariableJoined
extends RangeVariable {
    RangeVariable[] rangeArray;

    public RangeVariableJoined(Table table, NameManager.SimpleName alias, OrderedHashSet columnList, NameManager.SimpleName[] columnNameList, ParserDQL.CompileContext compileContext) {
        super(table, alias, columnList, columnNameList, compileContext);
        QuerySpecification qs = (QuerySpecification)this.rangeTable.getQueryExpression();
        this.rangeArray = qs.rangeVariables;
    }

    @Override
    public void setRangeTableVariables() {
        super.setRangeTableVariables();
    }

    @Override
    public RangeVariable duplicate() {
        RangeVariable r = null;
        try {
            r = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        r.resetConditions();
        return r;
    }

    @Override
    public void setJoinType(boolean isLeft, boolean isRight) {
        super.setJoinType(isLeft, isRight);
    }

    @Override
    public void addNamedJoinColumns(OrderedHashSet columns) {
        super.addNamedJoinColumns(columns);
    }

    @Override
    public void addColumn(int columnIndex) {
        super.addColumn(columnIndex);
    }

    @Override
    public void addAllColumns() {
        super.addAllColumns();
    }

    @Override
    public void addNamedJoinColumnExpression(String name, Expression e) {
        super.addNamedJoinColumnExpression(name, e);
    }

    @Override
    public ExpressionColumn getColumnExpression(String name) {
        return super.getColumnExpression(name);
    }

    @Override
    public Table getTable() {
        return super.getTable();
    }

    @Override
    public boolean hasSingleIndexCondition() {
        return super.hasSingleIndexCondition();
    }

    @Override
    public boolean setDistinctColumnsOnIndex(int[] colMap) {
        return super.setDistinctColumnsOnIndex(colMap);
    }

    @Override
    public Index getSortIndex() {
        return super.getSortIndex();
    }

    @Override
    public boolean setSortIndex(Index index, boolean reversed) {
        return super.setSortIndex(index, reversed);
    }

    @Override
    public boolean reverseOrder() {
        return super.reverseOrder();
    }

    @Override
    public OrderedHashSet getColumnNames() {
        return super.getColumnNames();
    }

    @Override
    public OrderedHashSet getUniqueColumnNameSet() {
        return super.getUniqueColumnNameSet();
    }

    @Override
    public int findColumn(ExpressionColumn e) {
        if (this.tableAlias != null) {
            return super.findColumn(e);
        }
        int count = 0;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            int colIndex = this.rangeArray[i].findColumn(e);
            if (colIndex > -1) {
                return count + colIndex;
            }
            count += this.rangeArray[i].rangeTable.getColumnCount();
        }
        return -1;
    }

    @Override
    public int findColumn(String columnName) {
        return super.findColumn(columnName);
    }

    @Override
    ColumnSchema getColumn(String columnName) {
        return super.getColumn(columnName);
    }

    @Override
    public ColumnSchema getColumn(int i) {
        return super.getColumn(i);
    }

    @Override
    public NameManager.SimpleName getColumnAlias(int i) {
        return super.getColumnAlias(i);
    }

    @Override
    public boolean hasColumnAlias() {
        return super.hasColumnAlias();
    }

    @Override
    public NameManager.SimpleName getTableAlias() {
        return super.getTableAlias();
    }

    @Override
    public boolean resolvesTableName(ExpressionColumn e) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(e);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean resolvesTableName(String name) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(name);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean resolvesSchemaName(String name) {
        return super.resolvesSchemaName(name);
    }

    @Override
    public void addTableColumns(HsqlArrayList exprList) {
        super.addTableColumns(exprList);
    }

    @Override
    public int addTableColumns(HsqlArrayList exprList, int position, HashSet exclude) {
        return super.addTableColumns(exprList, position, exclude);
    }

    @Override
    public void addTableColumns(Expression expression, HashSet exclude) {
        super.addTableColumns(expression, exclude);
    }

    @Override
    public void setForCheckConstraint() {
        super.setForCheckConstraint();
    }

    @Override
    public Expression getJoinCondition() {
        return super.getJoinCondition();
    }

    @Override
    public void addJoinCondition(Expression e) {
        super.addJoinCondition(e);
    }

    @Override
    public void resetConditions() {
        super.resetConditions();
    }

    @Override
    public OrderedHashSet getSubqueries() {
        return super.getSubqueries();
    }

    @Override
    public void replaceColumnReference(RangeVariable range, Expression[] list) {
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        super.replaceRangeVariables(ranges, newRanges);
    }

    @Override
    public void resolveRangeTable(Session session, RangeVariable[] rangeVariables, int rangeCount, RangeVariable[] outerRanges) {
        super.resolveRangeTable(session, rangeVariables, rangeCount, RangeVariable.emptyArray);
    }

    @Override
    public boolean isFullScan() {
        return !this.joinConditions[0].hasIndexCondition();
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String joinType = "INNER";
        if (this.isLeftJoin) {
            joinType = "LEFT OUTER";
            if (this.isRightJoin) {
                joinType = "FULL";
            }
        } else if (this.isRightJoin) {
            joinType = "RIGHT OUTER";
        }
        result.put("joinType", joinType);
        result.put("tableName", this.rangeTable.getObjectName().name);
        if (this.tableAlias != null) {
            result.put("tableAlias", this.tableAlias.name);
        }
        result.put("access", this.isFullScan() ? "FULL SCAN" : "INDEX PRED");
        ArrayList joinConditionsExplained = new ArrayList();
        for (int i = 0; i < this.joinConditions.length; ++i) {
            RangeVariable.RangeVariableConditions conditions = this.joinConditions[i];
            LinkedHashMap<String, Map<String, Object>> joinConditionExplained = new LinkedHashMap<String, Map<String, Object>>();
            if (i > 0) {
                joinConditionExplained.put("orCondition", conditions.describeJson(session));
                continue;
            }
            joinConditionExplained.put("condition", conditions.describeJson(session));
        }
        result.put("joinConditions", joinConditionsExplained);
        return result;
    }

    @Override
    public String describe(Session session, int blanks) {
        RangeVariable.RangeVariableConditions[] conditionsArray = this.joinConditions;
        String b = ValuePool.spaceString.substring(0, blanks);
        StringBuffer sb = new StringBuffer();
        String temp = "INNER";
        if (this.isLeftJoin) {
            temp = "LEFT OUTER";
            if (this.isRightJoin) {
                temp = "FULL";
            }
        } else if (this.isRightJoin) {
            temp = "RIGHT OUTER";
        }
        sb.append(b).append("join type=").append(temp).append("\n");
        sb.append(b).append("table=").append(this.rangeTable.getObjectName().name).append("\n");
        if (this.tableAlias != null) {
            sb.append(b).append("alias=").append(this.tableAlias.name).append("\n");
        }
        boolean fullScan = !conditionsArray[0].hasIndexCondition();
        sb.append(b).append("access=").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < conditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions conditions = this.joinConditions[i];
            if (i > 0) {
                sb.append(b).append("OR condition = [");
            } else {
                sb.append(b).append("condition = [");
            }
            sb.append(conditions.describe(session, blanks + 2));
            sb.append(b).append("]\n");
        }
        return sb.toString();
    }

    @Override
    public RangeVariable.RangeIteratorMain getIterator(Session session) {
        return super.getIterator(session);
    }
}

