/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.range;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.ExplainComplexity;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.ExpressionTable;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.RowSnapshot;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class RangeVariable
implements Cloneable {
    public static final RangeVariable[] emptyArray = new RangeVariable[0];
    public static final int TABLE_RANGE = 1;
    public static final int TRANSITION_RANGE = 2;
    public static final int PARAMETER_RANGE = 3;
    public static final int VARIABLE_RANGE = 4;
    public static final int TRANSIENT_VARIABLE_RANGE = 5;
    public Table rangeTable;
    public final NameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private NameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    public OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    private Object[] emptyData;
    public boolean[] columnsInGroupBy;
    public boolean hasKeyedColumnInGroupBy;
    public boolean[] usedColumns;
    boolean[] updatedColumns;
    public RangeVariableConditions[] joinConditions;
    RangeVariableConditions[] whereConditions;
    int subRangeCount;
    Expression joinCondition;
    public boolean isLeftJoin;
    public boolean isRightJoin;
    public boolean isBoundary;
    public boolean isFacetJoin;
    public int level;
    int indexDistinctCount;
    public int rangePositionInJoin;
    public int rangePosition;
    public int parsePosition;
    HashMappedList variables;
    public int rangeType;
    boolean isGenerated;
    private RplScript parentRplBlock = null;

    public RangeVariable(HashMappedList variables, NameManager.SimpleName rangeName, boolean isVariable, int rangeType) {
        this.variables = variables;
        this.rangeType = rangeType;
        this.rangeTable = null;
        this.tableAlias = rangeName;
        this.emptyData = null;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public RangeVariable(Table table, NameManager.SimpleName alias, OrderedHashSet columnList, NameManager.SimpleName[] columnNameList, ParserDQL.CompileContext compileContext) {
        SubQuery subQuery;
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = alias;
        this.columnAliases = columnList;
        this.columnAliasNames = columnNameList;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        if (compileContext != null) {
            compileContext.registerRangeVariable(this);
        }
        if ((subQuery = this.rangeTable.getSubQuery()) == null || subQuery.isResolved()) {
            this.setRangeTableVariables();
        }
    }

    public RangeVariable(Table table, int position) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = position;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public void resetViewRageTableAsSubquery() {
        this.rangeTable = ((View)this.rangeTable).getSubqueryTable();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public void setRangeTableVariables() {
        if (this.columnAliasNames != null && this.rangeTable.getColumnCount() != this.columnAliasNames.length) {
            throw Error.error(5593);
        }
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public RangeVariable duplicate() {
        RangeVariable r = null;
        try {
            r = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        r.resetConditions();
        return r;
    }

    public void setJoinType(boolean isLeft, boolean isRight) {
        this.isLeftJoin = isLeft;
        this.isRightJoin = isRight;
        if (this.isRightJoin) {
            this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        }
    }

    public void setFacetJoinType() {
        this.isFacetJoin = true;
    }

    public void addNamedJoinColumns(OrderedHashSet columns) {
        this.namedJoinColumns = columns;
    }

    public void addColumn(int columnIndex) {
        this.usedColumns[columnIndex] = true;
    }

    public void addAllColumns() {
    }

    public void addNamedJoinColumnExpression(String name, Expression e) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(name, e);
    }

    public ExpressionColumn getColumnExpression(String name) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(name);
    }

    public Table getTable() {
        return this.rangeTable;
    }

    public boolean hasAnyIndexCondition() {
        int i;
        for (i = 0; i < this.joinConditions.length; ++i) {
            if (this.joinConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        for (i = 0; i < this.whereConditions.length; ++i) {
            if (this.whereConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSingleIndexCondition() {
        return this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount > 0;
    }

    public boolean setDistinctColumnsOnIndex(int[] colMap) {
        if (this.joinConditions.length != 1) {
            return false;
        }
        int[] indexColMap = this.joinConditions[0].rangeIndex.getColumns();
        if (colMap.length != ArrayUtil.countTrueElements(this.usedColumns)) {
            return false;
        }
        if (colMap.length == 1 && colMap[0] == indexColMap[0]) {
            this.indexDistinctCount = 1;
            return true;
        }
        return false;
    }

    public Index getSortIndex() {
        if (this.joinConditions.length == 1) {
            return this.joinConditions[0].rangeIndex;
        }
        return null;
    }

    public boolean setSortIndex(Index index, boolean reversed) {
        if (this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount == 0) {
            this.joinConditions[0].rangeIndex = index;
            this.joinConditions[0].reversed = reversed;
            return true;
        }
        return false;
    }

    public boolean reverseOrder() {
        this.joinConditions[0].reverseIndexCondition();
        return true;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.columnAliases != null) {
            set.addAll(this.columnAliases);
            return set;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String name = this.rangeTable.getColumn((int)i).getObjectName().name;
            boolean added = set.add(name);
            if (added) continue;
            throw Error.error(5578, name);
        }
        return set;
    }

    public int findColumn(ExpressionColumn e) {
        if (!this.resolvesTableName(e)) {
            return -1;
        }
        return this.findColumn(e.columnName);
    }

    public int findColumn(String columnName) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(columnName)) {
            return -1;
        }
        if (this.variables != null) {
            return this.variables.getIndex(columnName);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(columnName);
        }
        return this.rangeTable.findColumn(columnName);
    }

    ColumnSchema getColumn(String columnName) {
        int index = this.findColumn(columnName);
        return index < 0 ? null : this.rangeTable.getColumn(index);
    }

    public ColumnSchema getColumn(int i) {
        if (this.variables == null) {
            return this.rangeTable.getColumn(i);
        }
        return (ColumnSchema)this.variables.get(i);
    }

    public NameManager.SimpleName getColumnAlias(int i) {
        if (this.columnAliases != null) {
            return this.columnAliasNames[i];
        }
        if (this.rangeTable != null) {
            return this.rangeTable.getColumn(i).getObjectName();
        }
        if (this.variables != null) {
            return ((ColumnSchema)this.variables.get(i)).getObjectName();
        }
        return null;
    }

    public boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    public NameManager.SimpleName getTableAlias() {
        return this.tableAlias == null ? (this.rangeTable != null ? this.rangeTable.getObjectName() : null) : this.tableAlias;
    }

    public boolean resolvesTableName(ExpressionColumn e) {
        if (e.tableName == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return e.tableName.equals(this.tableAlias.name);
            }
            return false;
        }
        return e.schema == null ? (this.tableAlias == null ? e.tableName.equals(this.rangeTable.getObjectName().name) : e.tableName.equals(this.tableAlias.name)) : this.tableAlias == null && e.tableName.equals(this.rangeTable.getObjectName().name) && e.schema.equals(this.rangeTable.getSchemaName().name);
    }

    public boolean resolvesTableName(String name) {
        if (name == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return name.equals(this.tableAlias.name);
            }
            return false;
        }
        return this.tableAlias == null ? name.equals(this.rangeTable.getObjectName().name) : name.equals(this.tableAlias.name);
    }

    public boolean resolvesSchemaName(String name) {
        if (name == null) {
            return true;
        }
        if (this.variables != null) {
            return false;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return name.equals(this.rangeTable.getSchemaName().name);
    }

    public void addTableColumns(HsqlArrayList exprList) {
        if (this.namedJoinColumns != null) {
            int count = exprList.size();
            int position = 0;
            for (int i = 0; i < count; ++i) {
                Expression e = (Expression)exprList.get(i);
                String columnName = e.getColumnName();
                if (!this.namedJoinColumns.contains(columnName)) continue;
                if (position != i) {
                    exprList.remove(i);
                    exprList.add(position, e);
                }
                e = this.getColumnExpression(columnName);
                exprList.set(position, e);
                ++position;
            }
        }
        this.addTableColumns(exprList, exprList.size(), this.namedJoinColumns);
    }

    public int addTableColumns(HsqlArrayList exprList, int position, HashSet exclude) {
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getObjectName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, i);
            exprList.add(position++, e);
        }
        return position;
    }

    public void addTableColumns(Expression expression, HashSet exclude) {
        HsqlArrayList list = new HsqlArrayList();
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getObjectName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, i);
            list.add(e);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        expression.nodes = nodes;
    }

    public void setForCheckConstraint() {
        this.joinConditions[0].rangeIndex = null;
        this.rangePosition = 0;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void addJoinCondition(Expression e) {
        this.joinCondition = ExpressionLogical.andExpressions(this.joinCondition, e);
    }

    public void setJoinCondition(Expression e) {
        this.joinCondition = e;
    }

    public void resetConditions() {
        Index index = this.joinConditions[0].rangeIndex;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = index;
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public OrderedHashSet getSubqueries() {
        OrderedHashSet set = null;
        if (this.joinCondition != null) {
            set = this.joinCondition.collectAllSubqueries(set);
        }
        if (this.rangeTable instanceof TableDerived) {
            QueryExpression baseQueryExpression = ((TableDerived)this.rangeTable).getQueryExpression();
            if (set == null) {
                set = new OrderedHashSet();
            }
            if (((TableDerived)this.rangeTable).view != null) {
                set.addAll(((TableDerived)this.rangeTable).view.getSubqueries());
            } else if (baseQueryExpression == null) {
                if (this.rangeTable.getSubQuery().dataExpression != null && this.rangeTable.getSubQuery().dataExpression instanceof ExpressionTable) {
                    ExpressionTable expTable = (ExpressionTable)this.rangeTable.getSubQuery().dataExpression;
                    OrderedHashSet temp = expTable.getSubqueries();
                    set = OrderedHashSet.addAll(set, temp);
                }
                set = OrderedHashSet.add(set, this.rangeTable.getSubQuery());
            } else {
                OrderedHashSet temp = baseQueryExpression.getSubqueries();
                set = OrderedHashSet.addAll(set, temp);
                set = OrderedHashSet.add(set, this.rangeTable.getSubQuery());
            }
        }
        return set;
    }

    public void replaceColumnReference(RangeVariable range, Expression[] list) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceColumnReferences(range, list);
        }
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceRangeVariables(ranges, newRanges);
        }
    }

    public void resolveRangeTable(Session session, RangeVariable[] rangeVariables, int rangeCount, RangeVariable[] outerRanges) {
        Table table = this.rangeTable;
        SubQuery subQuery = table.getSubQuery();
        if (subQuery != null && !subQuery.isResolved()) {
            if (subQuery.dataExpression != null) {
                HsqlList unresolved = subQuery.dataExpression.resolveColumnReferences(session, emptyArray, null);
                if (unresolved != null) {
                    unresolved = subQuery.dataExpression.resolveColumnReferences(session, rangeVariables, rangeCount, null, true);
                }
                if (unresolved != null) {
                    unresolved = subQuery.dataExpression.resolveColumnReferences(session, outerRanges, null);
                }
                if (!(unresolved == null || outerRanges == null || outerRanges.length <= 0 || table instanceof TableDerived && outerRanges == session.sessionContext.sessionVariablesRange)) {
                    throw Error.error(5501, ((Expression)unresolved.get(0)).getSQL());
                }
                subQuery.dataExpression.resolveTypes(session, null);
                this.setRangeTableVariables();
                if (unresolved != null && subQuery.dataExpression instanceof ExpressionTable) {
                    subQuery.dataExpression.unresolvedExpressions = unresolved;
                }
            }
            if (subQuery.queryExpression != null) {
                subQuery.queryExpression.resolveReferences(session, outerRanges);
                HsqlList list = subQuery.queryExpression.getUnresolvedExpressions();
                HsqlList unresolved = Expression.resolveColumnSet(session, rangeVariables, rangeCount, list, null);
                if (unresolved != null) {
                    throw Error.error(5501, ((Expression)unresolved.get(0)).getSQL());
                }
                subQuery.queryExpression.resolveTypes(session);
                subQuery.prepareTable(session);
                subQuery.setCorrelated();
                this.setRangeTableVariables();
            }
        }
    }

    public boolean isFullScan() {
        RangeVariableConditions[] conditions = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            conditions = this.whereConditions;
        }
        return !conditions[0].hasIndexCondition();
    }

    public Map<String, Object> describeJson(Session session) {
        boolean isFullScan;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String joinType = "INNER";
        if (this.isLeftJoin) {
            joinType = "LEFT OUTER";
            if (this.isRightJoin) {
                joinType = "FULL";
            }
        } else if (this.isRightJoin) {
            joinType = "RIGHT OUTER";
        }
        result.put("joinType", joinType);
        result.put("tableName", this.rangeTable.getObjectName().name);
        if (this.tableAlias != null) {
            result.put("tableAlias", this.tableAlias.name);
        }
        RangeVariableConditions[] conditions = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            conditions = this.whereConditions;
        }
        if (conditions == this.whereConditions && this.joinConditions[0].nonIndexCondition != null) {
            result.put("joinCondition", this.joinConditions[0].nonIndexCondition.describeJson(session));
        }
        result.put("access", (isFullScan = this.isFullScan()) ? "FULL SCAN" : "INDEX PRED");
        ExplainComplexity explainComplexity = new ExplainComplexity(new RangeVariable[]{this}, session.dataspaceStore);
        explainComplexity.init();
        result.put("sampleCount", this.rangeTable.getSampleCount());
        result.put("complexity", explainComplexity.getComplexity());
        result.put("iterationsCount", (long)explainComplexity.getIterationsCount());
        result.put("durationMs", explainComplexity.getEstimatedDurationMs());
        result.put("duration", explainComplexity.getEstimatedDurationString());
        ArrayList conditionsExplained = new ArrayList();
        for (int i = 0; i < conditions.length; ++i) {
            LinkedHashMap<String, Map<String, Object>> conditionExplained = new LinkedHashMap<String, Map<String, Object>>();
            String conditionType = null;
            conditionType = i > 0 ? "orCondition" : (conditions == this.whereConditions ? "whereCondition" : "joinCondition");
            conditionExplained.put(conditionType, conditions[i].describeJson(session));
            conditionsExplained.add(conditionExplained);
        }
        if (conditions == this.joinConditions && this.whereConditions[0].nonIndexCondition != null) {
            LinkedHashMap<String, Map<String, Object>> conditionExplained = new LinkedHashMap<String, Map<String, Object>>();
            conditionExplained.put("whereCondition", this.whereConditions[0].nonIndexCondition.describeJson(session));
        }
        result.put("conditions", conditionsExplained);
        return result;
    }

    public String describe(Session session, int blanks) {
        String b = ValuePool.spaceString.substring(0, blanks);
        StringBuffer sb = new StringBuffer();
        String temp = "INNER";
        if (this.isLeftJoin) {
            temp = "LEFT OUTER";
            if (this.isRightJoin) {
                temp = "FULL";
            }
        } else if (this.isRightJoin) {
            temp = "RIGHT OUTER";
        }
        sb.append(b).append("join type=").append(temp).append("\n");
        sb.append(b).append("table=").append(this.rangeTable.getObjectName().name).append("\n");
        if (this.tableAlias != null) {
            sb.append(b).append("alias=").append(this.tableAlias.name).append("\n");
        }
        RangeVariableConditions[] conditions = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            conditions = this.whereConditions;
        }
        sb.append(b);
        if (conditions == this.whereConditions && this.joinConditions[0].nonIndexCondition != null) {
            sb.append("join condition = [");
            sb.append(this.joinConditions[0].nonIndexCondition.describe(session, blanks));
            sb.append(b).append("]\n");
            sb.append(b);
        }
        boolean isFullScan = this.isFullScan();
        sb.append("access=").append(isFullScan ? "FULL SCAN" : "INDEX PRED").append("\n");
        ExplainComplexity explainComplexity = new ExplainComplexity(new RangeVariable[]{this}, session.dataspaceStore);
        explainComplexity.init();
        sb.append("sample count=").append(this.rangeTable.getSampleCount()).append("\n");
        sb.append("complexity=").append(explainComplexity.getComplexity()).append("\n");
        sb.append("iterations count=").append((long)explainComplexity.getIterationsCount()).append("\n");
        sb.append("durationMs=").append(explainComplexity.getEstimatedDurationMs()).append("\n");
        sb.append("duration=").append(explainComplexity.getEstimatedDurationString()).append("\n");
        for (int i = 0; i < conditions.length; ++i) {
            if (i > 0) {
                sb.append(b).append("OR condition = [");
            } else {
                sb.append(b);
                if (conditions == this.whereConditions) {
                    sb.append("where condition = [");
                } else {
                    sb.append("join condition = [");
                }
            }
            sb.append(conditions[i].describe(session, blanks + 2));
            sb.append(b).append("]\n");
        }
        if (conditions == this.joinConditions) {
            sb.append(b);
            if (this.whereConditions[0].nonIndexCondition != null) {
                sb.append("where condition = [");
                sb.append(this.whereConditions[0].nonIndexCondition.describe(session, blanks));
                sb.append(b).append("]\n");
                sb.append(b);
            }
        }
        return sb.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain it = this.isRightJoin ? new RangeIteratorRight(session, this, null) : new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(it);
        return it;
    }

    public static RangeIterator getIterator(Session session, RangeVariable[] rangeVars) {
        if (rangeVars.length == 1) {
            return rangeVars[0].getIterator(session);
        }
        RangeIteratorMain[] iterators = new RangeIteratorMain[rangeVars.length];
        for (int i = 0; i < rangeVars.length; ++i) {
            iterators[i] = rangeVars[i].getIterator(session);
        }
        return new RangeIteratorJoined(iterators);
    }

    public void setParentRplBloc(RplScript block) {
        this.parentRplBlock = block;
    }

    public RplScript getParentRplBlock() {
        return this.parentRplBlock;
    }

    public HashMappedList getVariables() {
        return this.variables;
    }

    public static class RangeVariableConditions {
        final RangeVariable rangeVar;
        Expression[] indexCond;
        Expression[] indexEndCond;
        int[] opTypes;
        int[] opTypesEnd;
        Expression indexEndCondition;
        int indexedColumnCount;
        Index rangeIndex;
        final boolean isJoin;
        Expression excludeConditions;
        public Expression nonIndexCondition;
        Expression terminalCondition;
        int opType;
        int opTypeEnd;
        boolean isFalse;
        boolean reversed;
        boolean hasIndex;

        RangeVariableConditions(RangeVariable rangeVar, boolean isJoin) {
            this.rangeVar = rangeVar;
            this.isJoin = isJoin;
        }

        RangeVariableConditions(RangeVariableConditions base) {
            this.rangeVar = base.rangeVar;
            this.isJoin = base.isJoin;
            this.nonIndexCondition = base.nonIndexCondition;
        }

        public boolean hasIndexCondition() {
            return this.indexedColumnCount > 0;
        }

        boolean hasIndex() {
            return this.hasIndex;
        }

        void addCondition(Expression e) {
            if (e == null) {
                return;
            }
            if (e instanceof ExpressionLogical && ((ExpressionLogical)e).isTerminal) {
                this.terminalCondition = e;
            }
            this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, e);
            if (Expression.EXPR_FALSE.equals(this.nonIndexCondition)) {
                this.isFalse = true;
            }
            if (this.rangeIndex == null || this.rangeIndex.getColumnCount() == 0) {
                return;
            }
            if (this.indexedColumnCount == 0) {
                return;
            }
            if (e.getIndexableExpression(this.rangeVar) == null) {
                return;
            }
            int colIndex = e.getLeftNode().getColumnIndex();
            int[] indexCols = this.rangeIndex.getColumns();
            switch (e.getType()) {
                case 42: 
                case 43: {
                    if (this.opType == 48) {
                        if (indexCols[this.indexedColumnCount - 1] != colIndex) break;
                        this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, this.indexCond[this.indexedColumnCount - 1]);
                        this.indexCond[this.indexedColumnCount - 1] = e;
                        this.opType = e.opType;
                        this.opTypes[this.indexedColumnCount - 1] = e.opType;
                        if (e.exprSubType != 53 || this.indexedColumnCount != 1) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = ExpressionLogical.andExpressions(this.indexEndCond[this.indexedColumnCount - 1], e.nodes[2]);
                        break;
                    }
                    this.addToIndexConditions(e);
                    break;
                }
                case 44: 
                case 45: {
                    if (this.opType == 43 || this.opType == 42 || this.opType == 48) {
                        if (this.opTypeEnd != 74 || indexCols[this.indexedColumnCount - 1] != colIndex) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = e;
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                        this.opTypeEnd = e.opType;
                        this.opTypesEnd[this.indexedColumnCount - 1] = e.opType;
                        break;
                    }
                    this.addToIndexEndConditions(e);
                    break;
                }
            }
        }

        boolean addToIndexConditions(Expression e) {
            if ((this.opType == 41 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == e.getLeftNode().getColumnIndex()) {
                this.indexCond[this.indexedColumnCount] = e;
                this.opType = e.opType;
                this.opTypes[this.indexedColumnCount] = e.opType;
                this.opTypeEnd = 74;
                this.opTypesEnd[this.indexedColumnCount] = 74;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        private boolean addToIndexEndConditions(Expression e) {
            if ((this.opType == 41 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == e.getLeftNode().getColumnIndex()) {
                Expression condition = e.getLeftNode();
                condition = new ExpressionLogical(47, condition);
                this.indexCond[this.indexedColumnCount] = condition = new ExpressionLogical(48, condition);
                this.indexEndCond[this.indexedColumnCount] = e;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                this.opType = 48;
                this.opTypes[this.indexedColumnCount] = 48;
                this.opTypeEnd = e.opType;
                this.opTypesEnd[this.indexedColumnCount] = e.opType;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        void addIndexCondition(Expression[] exprList, Index index, int colCount) {
            int indexColCount = index.getColumnCount();
            this.rangeIndex = index;
            this.indexCond = new Expression[indexColCount];
            this.indexEndCond = new Expression[indexColCount];
            this.opTypes = new int[indexColCount];
            this.opTypesEnd = new int[indexColCount];
            this.opType = exprList[0].opType;
            this.opTypes[0] = exprList[0].opType;
            switch (this.opType) {
                case 48: {
                    this.indexCond = exprList;
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 42: 
                case 43: {
                    this.indexCond = exprList;
                    if (exprList[0].exprSubType == 53) {
                        this.indexEndCond[0] = this.indexEndCondition = exprList[0].nodes[2];
                    }
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 44: 
                case 45: {
                    Expression e = exprList[0].getLeftNode();
                    e = new ExpressionLogical(47, e);
                    this.indexCond[0] = e = new ExpressionLogical(48, e);
                    this.indexEndCond[0] = this.indexEndCondition = exprList[0];
                    this.opTypeEnd = this.opType;
                    this.opTypesEnd[0] = this.opType;
                    this.opType = 48;
                    this.opTypes[0] = 48;
                    break;
                }
                case 41: 
                case 47: {
                    this.indexCond = exprList;
                    for (int i = 0; i < colCount; ++i) {
                        Expression e;
                        this.indexEndCond[i] = e = exprList[i];
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                        this.opType = e.opType;
                        this.opTypes[0] = e.opType;
                    }
                    this.opTypeEnd = this.opType;
                    break;
                }
                default: {
                    Error.runtimeError(201, "RangeVariable");
                }
            }
            this.indexedColumnCount = colCount;
            this.hasIndex = true;
        }

        void reverseIndexCondition() {
            if (this.opType == 41 || this.opType == 47) {
                return;
            }
            this.indexEndCondition = null;
            for (int i = 0; i < this.indexedColumnCount; ++i) {
                Expression e = this.indexCond[i];
                this.indexCond[i] = this.indexEndCond[i];
                this.indexEndCond[i] = e;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
            }
            this.opType = this.opTypeEnd;
            this.reversed = true;
        }

        String describe(Session session, int blanks) {
            StringBuffer sb = new StringBuffer();
            String b = ValuePool.spaceString.substring(0, blanks);
            sb.append("index=").append(this.rangeIndex.getObjectName().name).append("\n");
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    sb.append(b).append("start conditions=[");
                    for (int j = 0; j < this.indexedColumnCount; ++j) {
                        if (this.indexCond == null || this.indexCond[j] == null) continue;
                        sb.append(this.indexCond[j].describe(session, blanks));
                    }
                    sb.append("]\n");
                }
                if (this.indexEndCondition != null) {
                    String temp = this.indexEndCondition.describe(session, blanks);
                    sb.append(b).append("end condition=[").append(temp).append("]\n");
                }
            }
            if (this.nonIndexCondition != null) {
                String temp = this.nonIndexCondition.describe(session, blanks);
                sb.append(b).append("other condition=[").append(temp).append("]\n");
            }
            return sb.toString();
        }

        Map<String, Object> describeJson(Session session) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("indexName", this.rangeIndex.getObjectName().name);
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    ArrayList<Map<String, Object>> startConditions = new ArrayList<Map<String, Object>>();
                    for (int j = 0; j < this.indexedColumnCount; ++j) {
                        if (this.indexCond == null || this.indexCond[j] == null) continue;
                        startConditions.add(this.indexCond[j].describeJson(session));
                    }
                    result.put("startConditions", startConditions);
                }
                if (this.indexEndCondition != null) {
                    result.put("indexEndCondition", this.indexEndCondition.describeJson(session));
                }
            }
            if (this.nonIndexCondition != null) {
                result.put("otherCondition", this.nonIndexCondition.describeJson(session));
            }
            return result;
        }
    }

    public static class RangeIteratorRight
    extends RangeIteratorMain {
        boolean isOnRightOuterRows;

        private RangeIteratorRight(Session session, RangeVariable rangeVar, RangeIteratorMain main) {
            super(session, rangeVar);
            this.isFullIterator = true;
        }

        public void setOnOuterRows() {
            this.conditions = this.rangeVar.whereConditions;
            this.isOnRightOuterRows = true;
            this.hasLeftOuterRow = false;
            this.condIndex = 0;
            this.initialiseIterator();
        }

        @Override
        public boolean next() {
            if (this.isOnRightOuterRows) {
                if (this.it == null) {
                    return false;
                }
                return this.findNextRight();
            }
            return super.next();
        }

        protected boolean findNextRight() {
            boolean result;
            block2: {
                result = false;
                do {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block2;
                    this.currentData = this.currentRow instanceof RowSnapshot && ((RowSnapshot)this.currentRow).isLazy() ? (this.rangeVar != null ? this.rangeVar.emptyData : null) : this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) break block2;
                } while (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session) || !this.lookupAndTest());
                result = true;
            }
            if (result) {
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            return result;
        }

        private boolean lookupAndTest() {
            boolean result;
            boolean bl = result = !this.lookup.contains(this.currentRow.getPos());
            if (result) {
                this.currentData = this.currentRow instanceof RowSnapshot && ((RowSnapshot)this.currentRow).isLazy() ? (this.rangeVar != null ? this.rangeVar.emptyData : null) : this.currentRow.getData();
                if (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                    result = false;
                }
            }
            return result;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasLeftOuterRow;
        boolean isFullIterator;
        public RangeVariableConditions[] conditions;
        RangeVariableConditions[] whereConditions;
        public RangeVariableConditions[] joinConditions;
        int condIndex = 0;
        OrderedIntHashSet lookup;
        Object[] currentJoinData = null;

        RangeIteratorMain() {
        }

        private RangeIteratorMain(Session session, RangeVariable rangeVar) {
            this.rangePosition = rangeVar.rangePosition;
            this.store = rangeVar.rangeTable.getRowStore(session);
            this.session = session;
            this.rangeVar = rangeVar;
            this.currentData = rangeVar.emptyData;
            this.isBeforeFirst = true;
            this.whereConditions = rangeVar.whereConditions;
            this.joinConditions = rangeVar.joinConditions;
            if (rangeVar.isRightJoin) {
                this.lookup = new OrderedIntHashSet();
            }
            this.conditions = rangeVar.joinConditions;
            if (rangeVar.whereConditions[0].hasIndexCondition()) {
                this.conditions = rangeVar.whereConditions;
            }
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            Session.checkIfThreadIsInterrupted();
            while (this.condIndex < this.conditions.length) {
                boolean result;
                if (this.isBeforeFirst) {
                    this.isBeforeFirst = false;
                    this.initialiseIterator();
                }
                if (result = this.findNext()) {
                    return true;
                }
                this.reset();
                ++this.condIndex;
            }
            this.condIndex = 0;
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentData = this.rangeVar.emptyData;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            if (this.condIndex == 0) {
                this.hasLeftOuterRow = this.rangeVar.isLeftJoin;
            }
            if (this.conditions[this.condIndex].isFalse) {
                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                return;
            }
            SubQuery subQuery = this.rangeVar.rangeTable.getSubQuery();
            if (subQuery != null && subQuery.isCorrelated()) {
                subQuery.materialiseCorrelated(this.session);
            }
            if (this.conditions[this.condIndex].indexCond == null) {
                this.it = this.conditions[this.condIndex].reversed ? this.conditions[this.condIndex].rangeIndex.lastRow(this.session, this.store) : this.conditions[this.condIndex].rangeIndex.firstRow(this.session, this.store);
            } else {
                this.getFirstRow();
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            if (this.currentJoinData == null || this.currentJoinData.length < this.conditions[this.condIndex].indexedColumnCount) {
                this.currentJoinData = new Object[this.conditions[this.condIndex].indexedColumnCount];
            }
            for (int i = 0; i < this.conditions[this.condIndex].indexedColumnCount; ++i) {
                Object value;
                block11: {
                    int exprType;
                    int range;
                    block12: {
                        int opType;
                        range = 0;
                        int n = opType = i == this.conditions[this.condIndex].indexedColumnCount - 1 ? this.conditions[this.condIndex].opType : this.conditions[this.condIndex].indexCond[i].getType();
                        if (opType == 47 || opType == 48 || opType == 74) {
                            this.currentJoinData[i] = null;
                            continue;
                        }
                        Type valueType = this.conditions[this.condIndex].indexCond[i].getRightNode().getDataType();
                        value = this.conditions[this.condIndex].indexCond[i].getRightNode().getValue(this.session);
                        Type targetType = this.conditions[this.condIndex].indexCond[i].getLeftNode().getDataType();
                        if (targetType != valueType && (range = targetType.compareToTypeRange(value)) == 0 && targetType.typeComparisonGroup != valueType.typeComparisonGroup) {
                            value = targetType.convertToType(this.session, value, valueType);
                        }
                        if (i != 0) break block11;
                        exprType = this.conditions[this.condIndex].indexCond[0].getType();
                        if (range >= 0) break block12;
                        switch (exprType) {
                            case 42: 
                            case 43: {
                                value = null;
                                break block11;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                    if (range > 0) {
                        switch (exprType) {
                            case 48: {
                                value = null;
                                break;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                }
                this.currentJoinData[i] = value;
            }
            this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, this.currentJoinData, this.conditions[this.condIndex].indexedColumnCount, this.rangeVar.indexDistinctCount, this.conditions[this.condIndex].opType, this.conditions[this.condIndex].reversed, null);
        }

        protected boolean findNext() {
            boolean result;
            block5: {
                result = false;
                while (true) {
                    Session.checkIfThreadIsInterrupted();
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block5;
                    this.currentData = this.currentRow instanceof RowSnapshot && ((RowSnapshot)this.currentRow).isLazy() ? (this.rangeVar != null ? this.rangeVar.emptyData : null) : this.currentRow.getData();
                    if (this.conditions[this.condIndex].terminalCondition != null && !this.conditions[this.condIndex].terminalCondition.testCondition(this.session)) break block5;
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) {
                        if (!this.conditions[this.condIndex].isJoin) {
                            this.hasLeftOuterRow = false;
                        }
                        break block5;
                    }
                    if (this.joinConditions[this.condIndex].nonIndexCondition != null && !this.joinConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) continue;
                    if (this.whereConditions[this.condIndex].nonIndexCondition != null && !this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                        this.hasLeftOuterRow = false;
                        this.addFoundRow();
                        continue;
                    }
                    Expression e = this.conditions[this.condIndex].excludeConditions;
                    if (e == null || !e.testCondition(this.session)) break;
                }
                this.addFoundRow();
                this.hasLeftOuterRow = false;
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            if (this.hasLeftOuterRow && this.condIndex == this.conditions.length - 1) {
                result = this.whereConditions[this.condIndex].nonIndexCondition == null || this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session);
                this.hasLeftOuterRow = false;
            }
            return result;
        }

        protected void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                this.lookup.add(this.currentRow.getPos());
            }
        }
    }

    public static class RangeIteratorJoined
    extends RangeIteratorBase {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;

        public RangeIteratorJoined(RangeIteratorMain[] rangeIterators) {
            this.rangeIterators = rangeIterators;
            this.isBeforeFirst = true;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.currentIndex >= 0) {
                RangeIteratorMain it = this.rangeIterators[this.currentIndex];
                if (it.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    this.currentRow = this.rangeIterators[this.currentIndex].currentRow;
                    this.currentData = this.currentRow instanceof RowSnapshot && ((RowSnapshot)this.currentRow).isLazy() ? (this.rangeVar != null ? this.rangeVar.emptyData : null) : this.currentRow.getData();
                    return true;
                }
                it.reset();
                --this.currentIndex;
            }
            this.currentData = this.rangeIterators[this.rangeIterators.length - 1].rangeVar.emptyData;
            this.currentRow = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public int getRangePosition() {
            return 0;
        }
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        public RowIterator it;
        public PersistentStore store;
        public Object[] currentData;
        protected Row currentRow;
        protected boolean isBeforeFirst;
        public RangeVariable rangeVar;

        protected RangeIteratorBase() {
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            Session.checkIfThreadIsInterrupted();
            this.currentRow = this.it.getNextRow();
            if (this.currentRow == null) {
                return false;
            }
            this.currentData = !(this.currentRow instanceof RowSnapshot) || !((RowSnapshot)this.currentRow).isLazy() ? this.currentRow.getData() : (this.rangeVar != null ? this.rangeVar.emptyData : null);
            return true;
        }

        @Override
        public Row getCurrentRow() {
            return this.currentRow;
        }

        @Override
        public Object[] getCurrent() {
            if (this.rangeVar != null && this.currentData == this.rangeVar.emptyData && this.currentRow instanceof RowSnapshot && ((RowSnapshot)this.currentRow).isLazy()) {
                this.currentData = this.currentRow.getData();
            }
            return this.currentData;
        }

        @Override
        public Object getCurrent(int i) {
            if (this.rangeVar != null && this.currentData == this.rangeVar.emptyData && this.currentRow instanceof RowSnapshot && ((RowSnapshot)this.currentRow).isLazy()) {
                return ((RowSnapshot)this.currentRow).getData(i);
            }
            return this.currentData == null ? null : this.currentData[i];
        }

        @Override
        public void setCurrent(Object[] data) {
            this.currentData = data;
        }

        @Override
        public long getRowId() {
            return this.currentRow == null ? 0L : ((long)this.rangeVar.rangeTable.getId() << 32) + (long)this.currentRow.getPos();
        }

        @Override
        public Object getRowidObject() {
            return this.currentRow == null ? null : ValuePool.getLong(this.getRowId());
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }

        @Override
        public Row getNextRow() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean hasNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public Object[] getNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
        }
    }
}

