/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.snapshot;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.jfq.IndexJFQ;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.persist.snapshot.RowSnapshot;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.columns.BooleanColumn;
import com.streamscape.ds.stable.columns.CategoryColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.DateColumn;
import com.streamscape.ds.stable.columns.DateTimeColumn;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.DoubleColumn;
import com.streamscape.ds.stable.columns.FloatColumn;
import com.streamscape.ds.stable.columns.IntColumn;
import com.streamscape.ds.stable.columns.LongColumn;
import com.streamscape.ds.stable.columns.ShortColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.columns.TimeColumn;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RowStoreSnapshot
implements PersistentStore {
    private final PersistentStoreCollection persistentStoreCollection;
    private final SnapshotDataspaceTable table;
    private Index[] indexList = Index.emptyArray;
    private long timestamp;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public RowStoreSnapshot(PersistentStoreCollection persistentStoreCollection, SnapshotDataspaceTable table) {
        this.persistentStoreCollection = persistentStoreCollection;
        this.table = table;
        persistentStoreCollection.setStore(table, this);
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void indexRow(Session session, Row row) {
        this.writeLock();
        try {
            this.appendRowDataNoLock(session, row.getData());
            row.setPos(this.table.getSTable().rowCountWithDeleted());
        }
        finally {
            this.writeUnlock();
        }
    }

    public void indexRowData(Session session, Object[] data) {
        this.writeLock();
        try {
            this.appendRowDataNoLock(session, data);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        return new RowSnapshot(this, this.table, (Object[])object, false, -1);
    }

    @Override
    public void removeAll() {
        this.writeLock();
        try {
            this.table.checkDataReadOnly();
            this.table.getSTable().clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    private String convertValueToStringOrNull(Object value) {
        return value != null ? String.valueOf(value) : null;
    }

    private void checkValueNotNull(Object value, int index) {
        if (value == null) {
            ColumnSchema columnSchema = this.table.getColumn(index);
            throw new DataspaceException("Null value is not allowed for column '" + columnSchema.getNameString() + "' of type '" + columnSchema.getDataType().getNameString() + "'.");
        }
    }

    @Override
    public void moveData(Session session, PersistentStore oldStore, int colindex, int adjust) {
        SnapshotDataspaceTable oldTable = (SnapshotDataspaceTable)oldStore.getTable();
        this.table.setsTable(oldTable.getSTable());
        if (colindex >= 0) {
            if (adjust >= 0) {
                ColumnSchema newColumnSchema = this.table.getColumn(colindex);
                Column newColumn = this.table.jdbcColumnToJColumn(newColumnSchema);
                int size = this.table.getSTable().rowCountWithDeleted();
                newColumn = newColumn.emptyCopy(size);
                Object defaultValue = null;
                if (newColumnSchema.getDefaultExpression() != null) {
                    defaultValue = newColumnSchema.getDefaultExpression().getValue(session);
                }
                this.fillColumnWithValue(newColumn, newColumnSchema, defaultValue, size);
                this.table.getSTable().addColumn(colindex, newColumn);
            } else {
                this.table.getSTable().removeColumn(colindex);
            }
        }
    }

    @Override
    public void delete(Session session, Row row) {
        Trace.logDebug(this, "delete");
    }

    @Override
    public void remove(int i) {
        Trace.logDebug(this, "remove");
    }

    @Override
    public void release(int i) {
        Trace.logDebug(this, "release");
    }

    @Override
    public void setMemory(boolean mode) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(int key) {
        return null;
    }

    @Override
    public CachedObject get(int key, boolean keep) {
        return null;
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        return null;
    }

    @Override
    public int getStorageSize(int key) {
        return 0;
    }

    @Override
    public void add(CachedObject object) {
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        return null;
    }

    @Override
    public CachedObject getNewInstance(int size) {
        return null;
    }

    @Override
    public void removePersistence(int i) {
    }

    @Override
    public void commitPersistence(CachedObject object) {
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
    }

    @Override
    public void commitRowWith2PCLogOnly(Session session, Row row, int type, int txModel) {
    }

    @Override
    public void commitRowWith2PCNoLog(Session session, Row row, int type, int txModel) {
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
    }

    @Override
    public void indexRows(Session session) {
    }

    @Override
    public RowIterator rowIterator() {
        return null;
    }

    @Override
    public DataFileCache getCache() {
        return null;
    }

    @Override
    public void setCache(DataFileCache cache) {
    }

    @Override
    public void release() {
    }

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index key) {
        return null;
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
    }

    @Override
    public void setAccessor(Index key, int accessor) {
    }

    @Override
    public long elementCount() {
        return this.elementCount(null);
    }

    @Override
    public long elementCount(Session session) {
        return ((IndexSnapshot)this.table.getIndexList()[0]).getNodeCount(session, this);
    }

    @Override
    public long elementCountGetOnly() {
        return this.elementCount(null);
    }

    @Override
    public int elementCountUnique(Index index) {
        return ((IndexJFQ)index).getNodeCount(null, this);
    }

    @Override
    public void setElementCount(Index key, long size, long uniqueSize) {
    }

    @Override
    public void resetAccessorKeys(Index[] keys) {
        this.indexList = Arrays.copyOf(keys, keys.length);
    }

    @Override
    public Index[] getAccessorKeys() {
        return this.indexList;
    }

    @Override
    public void reindex(Session session, Index index) {
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] readRow(int rowIndex) {
        this.readLock();
        try {
            SnapshotTable sTable = this.table.getSTable();
            Object[] next = new Object[sTable.columnCount()];
            for (int i = 0; i < sTable.columnCount(); ++i) {
                next[i] = RowStoreSnapshot.getColumnValue(sTable.column(i), rowIndex);
            }
            Object[] objectArray = next;
            return objectArray;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readRowColumn(int rowIndex, int columnIndex) {
        this.readLock();
        try {
            Object object = RowStoreSnapshot.getColumnValue(this.table.getSTable().column(columnIndex), rowIndex);
            return object;
        }
        finally {
            this.readUnlock();
        }
    }

    public void setRowValuesNoLock(int rowIndex, int[] columnIndexesMap, Object[] values) {
        int processedIndex = -1;
        Object[] oldRow = this.readRow(rowIndex);
        try {
            for (int i = 0; i < columnIndexesMap.length; ++i) {
                ++processedIndex;
                this.setValueToColumn(columnIndexesMap[i], rowIndex, values[i]);
            }
        }
        catch (Exception exception) {
            for (int i = processedIndex; i >= 0; --i) {
                this.setValueToColumn(columnIndexesMap[i], rowIndex, oldRow[columnIndexesMap[i]]);
            }
            throw exception;
        }
    }

    public void setValueToColumn(int columnIndex, int rowIndex, Object value) {
        Column column = this.table.getSTable().column(columnIndex);
        switch (column.type()) {
            case BOOLEAN: {
                if (!(value instanceof Boolean)) break;
                ((BooleanColumn)column).set(rowIndex, (Boolean)value);
                return;
            }
            case CATEGORY: {
                if (!(value instanceof String)) break;
                ((CategoryColumn)column).set(rowIndex, (String)value);
                return;
            }
            case STRING: {
                if (!(value instanceof String)) break;
                ((StringColumn)column).set(rowIndex, (String)value);
                return;
            }
            case FLOAT: {
                if (!(value instanceof Number)) break;
                ((FloatColumn)column).set(rowIndex, ((Number)value).floatValue());
                return;
            }
            case DOUBLE: {
                if (!(value instanceof Number)) break;
                ((DoubleColumn)column).set(rowIndex, ((Number)value).doubleValue());
                return;
            }
            case SHORT: {
                if (!(value instanceof Number)) break;
                ((ShortColumn)column).set(rowIndex, ((Number)value).shortValue());
                return;
            }
            case INTEGER: {
                if (!(value instanceof Number)) break;
                ((IntColumn)column).set(rowIndex, ((Number)value).intValue());
                return;
            }
            case LONG: {
                if (!(value instanceof Number)) break;
                ((LongColumn)column).set(rowIndex, ((Number)value).longValue());
                return;
            }
            case DECIMAL: {
                column.setObject(rowIndex, value);
                return;
            }
            case LOCAL_DATE: {
                DateColumn dateColumn = (DateColumn)column;
                if (value instanceof Date) {
                    dateColumn.set(rowIndex, (Date)value);
                    return;
                }
                if (value instanceof LocalDate) {
                    dateColumn.set(rowIndex, (LocalDate)value);
                    return;
                }
                if (!(value instanceof TimestampData)) break;
                dateColumn.set(rowIndex, ((TimestampData)value).getMilliseconds());
                return;
            }
            case LOCAL_TIME: {
                TimeColumn timeColumn = (TimeColumn)column;
                if (value instanceof Time) {
                    timeColumn.set(rowIndex, (Time)value);
                    return;
                }
                if (value instanceof LocalTime) {
                    timeColumn.set(rowIndex, (LocalTime)value);
                    return;
                }
                if (!(value instanceof TimeData)) break;
                timeColumn.set(rowIndex, ((TimeData)value).getSeconds() * 1000);
                return;
            }
            case LOCAL_DATE_TIME: {
                DateTimeColumn dateTimeColumn = (DateTimeColumn)column;
                if (value instanceof Timestamp) {
                    dateTimeColumn.set(rowIndex, (Timestamp)value);
                    return;
                }
                if (value instanceof LocalDateTime) {
                    dateTimeColumn.set(rowIndex, (LocalDateTime)value);
                    return;
                }
                if (!(value instanceof TimestampData)) break;
                dateTimeColumn.set(rowIndex, ((TimestampData)value).getMilliseconds());
                return;
            }
        }
        try {
            column.setObject(rowIndex, this.convertValueToStringOrNull(value));
        }
        catch (Exception exception) {
            ColumnSchema columnSchema = this.table.getColumn(columnIndex);
            throw new DataspaceException("Failed to assign value '" + String.valueOf(value) + "' to column '" + columnSchema.getNameString() + "' of type '" + columnSchema.getDataType().getNameString() + "'.", exception);
        }
    }

    public void appendRowDataNoLock(Session session, Object[] data) {
        SnapshotTable sTable = this.table.getSTable();
        if (sTable.columnCount() != data.length) {
            throw new DataspaceException("Column count mismatch. Expected " + sTable.columnCount() + " but passed " + data.length);
        }
        sTable.appendRow(() -> {
            for (int i = 0; i < data.length; ++i) {
                this.appendValueToColumnNoLock(i, data[i]);
            }
        });
    }

    public void appendValueToColumnNoLock(int columnIndex, Object value) {
        Column column = this.table.getSTable().column(columnIndex);
        switch (column.type()) {
            case BOOLEAN: {
                if (!(value instanceof Boolean)) break;
                ((BooleanColumn)column).append((Boolean)value);
                return;
            }
            case CATEGORY: {
                if (!(value instanceof String)) break;
                ((CategoryColumn)column).append((String)value);
                return;
            }
            case STRING: {
                if (!(value instanceof String)) break;
                ((StringColumn)column).append((String)value);
                return;
            }
            case FLOAT: {
                if (!(value instanceof Number)) break;
                ((FloatColumn)column).append(((Number)value).floatValue());
                return;
            }
            case DOUBLE: {
                if (!(value instanceof Number)) break;
                ((DoubleColumn)column).append(((Number)value).doubleValue());
                return;
            }
            case SHORT: {
                if (!(value instanceof Number)) break;
                ((ShortColumn)column).append(((Number)value).shortValue());
                return;
            }
            case INTEGER: {
                if (!(value instanceof Number)) break;
                ((IntColumn)column).append(((Number)value).intValue());
                return;
            }
            case LONG: {
                if (!(value instanceof Number)) break;
                ((LongColumn)column).append(((Number)value).longValue());
                return;
            }
            case DECIMAL: {
                column.appendObject(value);
                return;
            }
            case LOCAL_DATE: {
                DateColumn dateColumn = (DateColumn)column;
                if (value instanceof Date) {
                    dateColumn.append((Date)value);
                    return;
                }
                if (value instanceof LocalDate) {
                    dateColumn.append((LocalDate)value);
                    return;
                }
                if (!(value instanceof TimestampData)) break;
                dateColumn.append(((TimestampData)value).getMilliseconds());
                return;
            }
            case LOCAL_TIME: {
                TimeColumn timeColumn = (TimeColumn)column;
                if (value instanceof Time) {
                    timeColumn.append((Time)value);
                    return;
                }
                if (value instanceof LocalTime) {
                    timeColumn.append((LocalTime)value);
                    return;
                }
                if (!(value instanceof TimeData)) break;
                timeColumn.append(((TimeData)value).getSeconds() * 1000);
                return;
            }
            case LOCAL_DATE_TIME: {
                DateTimeColumn dateTimeColumn = (DateTimeColumn)column;
                if (value instanceof Timestamp) {
                    dateTimeColumn.append((Timestamp)value);
                    return;
                }
                if (value instanceof LocalDateTime) {
                    dateTimeColumn.append((LocalDateTime)value);
                    return;
                }
                if (!(value instanceof TimestampData)) break;
                dateTimeColumn.append(((TimestampData)value).getMilliseconds());
                return;
            }
        }
        try {
            column.appendObject(this.convertValueToStringOrNull(value));
        }
        catch (Exception exception) {
            ColumnSchema columnSchema = this.table.getColumn(columnIndex);
            throw new DataspaceException("Failed to assign value '" + String.valueOf(value) + "' to column '" + columnSchema.getNameString() + "' of type '" + columnSchema.getDataType().getNameString() + "'.", exception);
        }
    }

    public int assignColumnWithValueNoLock(int columnIndex, Object value) {
        Column column = this.table.getSTable().column(columnIndex);
        switch (column.type()) {
            case BOOLEAN: {
                if (!(value instanceof Boolean)) break;
                ((BooleanColumn)column).assignWithValue((Boolean)value);
                return column.size();
            }
            case CATEGORY: {
                if (!(value instanceof String)) break;
                ((CategoryColumn)column).assignWithValue((String)value);
                return column.size();
            }
            case STRING: {
                if (!(value instanceof String)) break;
                ((StringColumn)column).assignWithValue((String)value);
                return column.size();
            }
            case FLOAT: {
                if (!(value instanceof Number)) break;
                ((FloatColumn)column).assignWithValue(((Number)value).floatValue());
                return column.size();
            }
            case DOUBLE: {
                if (!(value instanceof Number)) break;
                ((DoubleColumn)column).assignWithValue(((Number)value).doubleValue());
                return column.size();
            }
            case SHORT: {
                if (!(value instanceof Number)) break;
                ((ShortColumn)column).assignWithValue(((Number)value).shortValue());
                return column.size();
            }
            case INTEGER: {
                if (!(value instanceof Number)) break;
                ((IntColumn)column).assignWithValue(((Number)value).intValue());
                return column.size();
            }
            case LONG: {
                column.assignWithValue(value);
                return column.size();
            }
            case LOCAL_DATE: {
                DateColumn dateColumn = (DateColumn)column;
                if (value instanceof Date) {
                    dateColumn.assignWithValue((Date)value);
                    return column.size();
                }
                if (value instanceof LocalDate) {
                    dateColumn.assignWithValue((LocalDate)value);
                    return column.size();
                }
                if (!(value instanceof TimestampData)) break;
                dateColumn.assignWithValue(((TimestampData)value).getMilliseconds());
                return column.size();
            }
            case LOCAL_TIME: {
                TimeColumn timeColumn = (TimeColumn)column;
                if (value instanceof Time) {
                    timeColumn.assignWithValue((Time)value);
                    return column.size();
                }
                if (value instanceof LocalTime) {
                    timeColumn.assignWithValue((LocalTime)value);
                    return column.size();
                }
                if (!(value instanceof TimeData)) break;
                timeColumn.assignWithValue(((TimeData)value).getSeconds() * 1000);
                return column.size();
            }
            case LOCAL_DATE_TIME: {
                DateTimeColumn dateTimeColumn = (DateTimeColumn)column;
                if (value instanceof Timestamp) {
                    dateTimeColumn.assignWithValue((Timestamp)value);
                    return column.size();
                }
                if (value instanceof LocalDateTime) {
                    dateTimeColumn.assignWithValue((LocalDateTime)value);
                    return column.size();
                }
                if (!(value instanceof TimestampData)) break;
                dateTimeColumn.assignWithValue(((TimestampData)value).getMilliseconds());
                return column.size();
            }
        }
        try {
            column.assignWithValue(this.convertValueToStringOrNull(value));
            return column.size();
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed fill column '" + column.name() + "' of type '" + column.type().toString() + "' with value '" + String.valueOf(value) + "'.", exception);
        }
    }

    private void fillColumnWithValue(Column column, ColumnSchema columnSchema, Object value, int size) {
        switch (column.type()) {
            case BOOLEAN: {
                if (!(value instanceof Boolean)) break;
                ((BooleanColumn)column).fillWithValue((Boolean)value, size);
                return;
            }
            case CATEGORY: {
                if (!(value instanceof String)) break;
                ((CategoryColumn)column).fillWithValue((String)value, size);
                return;
            }
            case STRING: {
                if (!(value instanceof String)) break;
                ((StringColumn)column).fillWithValue((String)value, size);
                return;
            }
            case FLOAT: {
                if (!(value instanceof Number)) break;
                ((FloatColumn)column).fillWithValue(((Number)value).floatValue(), size);
                return;
            }
            case DOUBLE: {
                if (!(value instanceof Number)) break;
                ((DoubleColumn)column).fillWithValue(((Number)value).doubleValue(), size);
                return;
            }
            case SHORT: {
                if (!(value instanceof Number)) break;
                ((ShortColumn)column).fillWithValue(((Number)value).shortValue(), size);
                return;
            }
            case INTEGER: {
                if (!(value instanceof Number)) break;
                ((IntColumn)column).fillWithValue(((Number)value).intValue(), size);
                return;
            }
            case LONG: {
                if (!(value instanceof Number)) break;
                ((LongColumn)column).fillWithValue(((Number)value).longValue(), size);
                return;
            }
            case DECIMAL: {
                column.fillWithValue(value, size);
                return;
            }
            case LOCAL_DATE: {
                DateColumn dateColumn = (DateColumn)column;
                if (value instanceof Date) {
                    dateColumn.fillWithValue((Date)value, size);
                    return;
                }
                if (value instanceof LocalDate) {
                    dateColumn.fillWithValue((LocalDate)value, size);
                    return;
                }
                if (!(value instanceof TimestampData)) break;
                dateColumn.fillWithValue(((TimestampData)value).getMilliseconds(), size);
                return;
            }
            case LOCAL_TIME: {
                TimeColumn timeColumn = (TimeColumn)column;
                if (value instanceof Time) {
                    timeColumn.fillWithValue((Time)value, size);
                    return;
                }
                if (value instanceof LocalTime) {
                    timeColumn.fillWithValue((LocalTime)value, size);
                    return;
                }
                if (!(value instanceof TimeData)) break;
                timeColumn.fillWithValue(((TimeData)value).getSeconds() * 1000, size);
                return;
            }
            case LOCAL_DATE_TIME: {
                DateTimeColumn dateTimeColumn = (DateTimeColumn)column;
                if (value instanceof Timestamp) {
                    dateTimeColumn.fillWithValue((Timestamp)value, size);
                    return;
                }
                if (value instanceof LocalDateTime) {
                    dateTimeColumn.fillWithValue((LocalDateTime)value, size);
                    return;
                }
                if (!(value instanceof TimestampData)) break;
                dateTimeColumn.fillWithValue(((TimestampData)value).getMilliseconds(), size);
                return;
            }
        }
        try {
            column.fillWithValue(this.convertValueToStringOrNull(value), size);
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed fill column column '" + columnSchema.getNameString() + "' of type '" + columnSchema.getDataType().getNameString() + "' with value '" + String.valueOf(value) + "'.", exception);
        }
    }

    private static Object getColumnValue(Column column, int index) {
        if (column.isMissing(index)) {
            return null;
        }
        switch (column.type()) {
            case BOOLEAN: {
                return ((BooleanColumn)column).get(index);
            }
            case CATEGORY: {
                return ((CategoryColumn)column).get(index);
            }
            case STRING: {
                return ((StringColumn)column).get(index);
            }
            case FLOAT: {
                return Float.valueOf(((FloatColumn)column).get(index));
            }
            case DOUBLE: {
                return ((DoubleColumn)column).get(index);
            }
            case SHORT: {
                return ((ShortColumn)column).get(index);
            }
            case INTEGER: {
                return ((IntColumn)column).get(index);
            }
            case LONG: {
                return ((LongColumn)column).get(index);
            }
            case DECIMAL: {
                return ((DecimalColumn)column).get(index);
            }
            case LOCAL_DATE: {
                long millis = ((DateColumn)column).getLong(index);
                return new TimestampData(millis, (int)(millis % 1000L) * 1000000, 0);
            }
            case LOCAL_TIME: {
                long milliseconds = ((TimeColumn)column).getLong(index);
                if (milliseconds < 0L) {
                    return null;
                }
                return new TimeData((int)milliseconds / 1000, 0);
            }
            case LOCAL_DATE_TIME: {
                long milliseconds = ((DateTimeColumn)column).getLong(index);
                if (milliseconds < 0L) {
                    return null;
                }
                return new TimestampData(milliseconds, (int)(milliseconds % 1000L) * 1000000, 0);
            }
        }
        return null;
    }

    public void deleteRowNoLock(int index) {
        this.table.getSTable().deleteRow(index);
    }
}

