/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.snapshot;

import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.RowStoreSnapshot;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;

public class RowSnapshot
extends Row {
    private final RowStoreSnapshot rowStore;
    private final boolean lazy;
    private final int rowIndex;

    public RowSnapshot(RowStoreSnapshot rowStore, SnapshotDataspaceTable table, Object[] data, boolean lazy, int rowIndex) {
        super(table, data);
        this.rowStore = rowStore;
        this.lazy = lazy;
        this.rowIndex = rowIndex;
        this.position = rowIndex;
    }

    @Override
    public Object[] getData() {
        if (this.lazy && this.rowData == null) {
            this.rowData = this.rowStore.readRow(this.rowIndex);
        }
        return this.rowData;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public Object getData(int i) {
        if (!this.lazy || this.lazy && this.rowData != null && this.rowData[i] != null) {
            return this.rowData[i];
        }
        return this.rowStore.readRowColumn(this.rowIndex, i);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }
}

