/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.snapshot;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.RowSnapshot;
import com.streamscape.ds.persist.snapshot.RowStoreSnapshot;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.types.Type;
import java.util.List;
import java.util.stream.Collectors;

public class IndexSnapshot
implements Index {
    private final NameManager.ObjectName name;
    private final long persistenceId;
    private final int[] defaultColMap;
    private final boolean isSimpleOrder;
    private SnapshotDataspaceTable table;
    private final int[] columns;
    private final boolean[] descending;
    private final boolean[] nullsLast;
    private final Type[] colTypes;
    private final boolean isPK;
    private final boolean isUnique;
    private final boolean isConstraint;
    private final boolean forward;
    private int position;
    private Object[] nullData;
    private SIndexType sIndexType;

    public IndexSnapshot(NameManager.ObjectName name, long persistenceId, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward, SIndexType sIndexType) {
        this.name = name;
        this.persistenceId = persistenceId;
        this.table = (SnapshotDataspaceTable)table;
        this.columns = columns;
        this.descending = descending == null ? new boolean[columns.length] : descending;
        this.nullsLast = nullsLast;
        this.colTypes = colTypes;
        this.isPK = pk;
        this.isUnique = unique;
        this.isConstraint = constraint;
        this.forward = forward;
        this.isSimpleOrder = true;
        this.defaultColMap = new int[columns.length];
        ArrayUtil.fillSequence(this.defaultColMap);
        this.nullData = new Object[columns.length];
        this.sIndexType = sIndexType;
        if (this.sIndexType == null) {
            this.sIndexType = SIndexType.AVL;
        }
        this.initSIndex();
    }

    public void initSIndex() {
        if (this.columns == null) {
            return;
        }
        String indexName = this.getObjectName().getNameString();
        SnapshotTable sTable = this.table.getSTable();
        if (sTable == null) {
            return;
        }
        SIndex sIndex = sTable.getSIndex(indexName);
        if (sIndex == null && this.isPK) {
            sIndex = sTable.getPrimaryKey();
        }
        if (sIndex != null) {
            boolean same = true;
            List sIndexColumns = sIndex.getColumns().stream().map(c -> c.getIndex()).collect(Collectors.toList());
            if (sIndexColumns.size() != this.columns.length) {
                same = false;
            }
            if (sIndex.getType() != this.sIndexType) {
                same = false;
            }
            if (same) {
                for (int i = 0; i < sIndexColumns.size(); ++i) {
                    if ((Integer)sIndexColumns.get(i) == this.columns[i]) continue;
                    same = false;
                }
            }
            if (!same) {
                sTable.removeSIndex(sIndex.getName());
            } else {
                return;
            }
        }
        if (this.columns.length == 0) {
            return;
        }
        sTable.createSIndex(indexName, this.sIndexType, this.isPK, this.isUnique, this.columns);
    }

    public SIndex getSIndex() {
        if (this.columns == null || this.columns.length == 0) {
            return null;
        }
        return this.table.getSTable().getSIndex(this.getObjectName().getNameString());
    }

    @Override
    public RowIterator emptyIterator() {
        return new EmptyRowIteratorSnapshot();
    }

    @Override
    public int size(Session session, PersistentStore store) {
        return (int)store.elementCount(session);
    }

    @Override
    public int sizeUnique(PersistentStore store) {
        return store.elementCountUnique(this);
    }

    @Override
    public boolean isEmpty(PersistentStore store) {
        store.readLock();
        try {
            boolean bl = this.table.getSTable().isEmpty();
            return bl;
        }
        finally {
            store.readUnlock();
        }
    }

    @Override
    public void checkIndex(PersistentStore store) {
    }

    @Override
    public void insert(Session session, PersistentStore store, Row row) {
        throw new DataspaceException("Insert into snap table is not allowed.");
    }

    @Override
    public void delete(Session session, PersistentStore store, Row row) {
        throw new DataspaceException("Delete from snap table is not allowed.");
    }

    @Override
    public boolean existsParent(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        SIndex.RowIndex rowIndex = this.findRowIndex(session, store, rowdata, rowColMap, rowColMap.length, 41, false);
        return rowIndex != null;
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int matchCount, int distinctCount, int compareType, boolean reversed, boolean[] map) {
        if (compareType == 74) {
            return this.lastRow(session, store);
        }
        SIndex.RowIndex rowIndex = this.findRowIndex(session, store, rowdata, this.defaultColMap, matchCount, compareType, reversed);
        if (rowIndex == null) {
            return this.emptyIterator();
        }
        return new RowIteratorSnapshot(session, store, this, rowIndex, distinctCount, false, reversed);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata) {
        SIndex.RowIndex rowIndex = this.findRowIndex(session, store, rowdata, this.columns, this.columns.length, 41, false);
        if (rowIndex == null) {
            return this.emptyIterator();
        }
        return new RowIteratorSnapshot(session, store, this, rowIndex, 0, false, false);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        SIndex.RowIndex rowIndex = this.findRowIndex(session, store, rowdata, rowColMap, rowColMap.length, 41, false);
        if (rowIndex == null) {
            return this.emptyIterator();
        }
        return new RowIteratorSnapshot(session, store, this, rowIndex, 0, false, false);
    }

    @Override
    public RowIterator findFirstRowNotNull(Session session, PersistentStore store) {
        SIndex.RowIndex rowIndex = this.findRowIndex(session, store, this.nullData, this.defaultColMap, 1, 48, false);
        if (rowIndex == null) {
            return this.emptyIterator();
        }
        return new RowIteratorSnapshot(session, store, this, rowIndex, 0, false, false);
    }

    @Override
    public RowIterator firstRow(PersistentStore store) {
        return this.firstRow(null, store);
    }

    @Override
    public RowIterator firstRow(Session session, PersistentStore store) {
        SIndex.RowIndex rowIndex = this.getFirstLastRowIndex(true);
        if (rowIndex == null) {
            return this.emptyIterator();
        }
        return new RowIteratorSnapshot(session, store, this, rowIndex, 0, false, false);
    }

    @Override
    public RowIterator lastRow(Session session, PersistentStore store) {
        SIndex.RowIndex rowIndex = this.getFirstLastRowIndex(false);
        if (rowIndex == null) {
            return this.emptyIterator();
        }
        return new RowIteratorSnapshot(session, store, this, rowIndex, 0, false, true);
    }

    public int getNodeCount(Session session, PersistentStore store) {
        return this.table.getSTable().rowCount();
    }

    private SIndex.RowIndex getFirstLastRowIndex(boolean first) {
        if (this.table.getSTable().rowCount() == 0) {
            return null;
        }
        if (this.columns == null || this.columns.length == 0) {
            return this.table.getSTable().getRowIndex(first).next();
        }
        SIndex sIndex = this.getSIndexOrThrowException();
        SIndex.RowIndexNode rowIndexNode = sIndex.getRowIndexNode();
        if (rowIndexNode == null || rowIndexNode.isEmpty()) {
            return null;
        }
        return rowIndexNode.getRowIndex(first ? rowIndexNode.first() : rowIndexNode.last()).next();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public long getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public int getVisibleColumns() {
        return this.columns.length;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public int[] getColumns() {
        return this.columns;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    @Override
    public boolean[] getColumnDesc() {
        return this.descending;
    }

    @Override
    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    @Override
    public int getIndexOrderValue() {
        if (this.isPK) {
            return 0;
        }
        return this.columns == null || this.columns.length == 0 ? 2 : 4;
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    @Override
    public void setTable(TableBase table) {
        this.table = (SnapshotDataspaceTable)table;
    }

    @Override
    public void setClustered(boolean clustered) {
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap) {
        int fieldcount = rowColMap.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[this.columns[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRow(Session session, Object[] a, Object[] b) {
        for (int j = 0; j < this.columns.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, a[this.columns[j]], b[this.columns[j]]);
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.columns[j]] == null || b[this.columns[j]] == null;
            if (this.descending[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        return 0;
    }

    int compareObject(Session session, Object[] a, Object[] b, int[] rowColMap, int position) {
        return this.colTypes[position].compare(session, a[this.columns[position]], b[rowColMap[position]]);
    }

    @Override
    public int getObjectType() {
        return 21;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().statementName);
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQL(this.getObjectName().statementName, schemaName);
    }

    @Override
    public String getSQL(String name) {
        return this.getSQL(name, this.table.getObjectName().schema.getStatementName());
    }

    public String getSQL(String name, String schemaName) {
        StringBuilder builder = new StringBuilder(64);
        builder.append("CREATE").append(' ');
        if (this.isUnique()) {
            builder.append("UNIQUE").append(' ');
        }
        builder.append("INDEX").append(' ');
        builder.append(name);
        builder.append(' ').append("ON").append(' ');
        builder.append(this.table.getObjectName().getSchemaQualifiedStatementName(schemaName));
        int[] col = this.getColumns();
        int len = this.getVisibleColumns();
        builder.append(this.table.getColumnListSQL(col, len));
        if (this.getSIndexType() == SIndexType.READ_ONLY) {
            builder.append(" ").append("READONLY");
        } else {
            builder.append(" ").append("AVL");
        }
        return builder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public SnapshotDataspaceTable getTable() {
        return this.table;
    }

    public SIndexType getSIndexType() {
        return this.sIndexType;
    }

    private SIndex getSIndexOrThrowException() {
        SIndex sIndex = this.getSIndex();
        if (sIndex == null) {
            throw new DataspaceException("SIndex '" + this.getObjectName().getNameString() + "' isn't found.");
        }
        if (!sIndex.isValid()) {
            throw new DataspaceException("SIndex '" + this.getObjectName().getNameString() + "' isn't valid.");
        }
        if (!sIndex.isBuilt()) {
            throw new DataspaceException("SIndex '" + this.getObjectName().getNameString() + "' isn't build.");
        }
        return sIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SIndex.RowIndex findRowIndex(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap, int fieldCount, int compareType, boolean reversed) {
        store.readLock();
        try {
            SIndex.RowIndex rowIndex;
            if (this.columns == null || this.columns.length == 0) {
                SIndex.RowIndex rowIndex2 = this.table.getSTable().getRowIndex(true).next();
                return rowIndex2;
            }
            SIndex sIndex = this.getSIndexOrThrowException();
            SIndex.RowIndexNode rowIndexNode = sIndex.getRowIndexNode();
            if (rowIndexNode == null || rowIndexNode.isEmpty()) {
                SIndex.RowIndex rowIndex3 = null;
                return rowIndex3;
            }
            if (fieldCount == 0) {
                SIndex.RowIndex rowIndex4 = rowIndexNode.getRowIndex(rowIndexNode.first()).next();
                return rowIndex4;
            }
            if (compareType != 41 && compareType != 47) {
                --fieldCount;
            }
            int result = -1;
            int x = rowIndexNode.root();
            int n = -1;
            while (x != -1) {
                Object[] currentRow = ((RowStoreSnapshot)store).readRow(rowIndexNode.value(x));
                int i = 0;
                if (fieldCount > 0) {
                    i = this.compareRowNonUnique(session, currentRow, rowdata, rowColMap, fieldCount);
                }
                if (i == 0) {
                    switch (compareType) {
                        case 41: 
                        case 47: {
                            result = x;
                            n = rowIndexNode.left(x);
                            break;
                        }
                        case 43: 
                        case 48: {
                            i = this.compareObject(session, currentRow, rowdata, rowColMap, fieldCount);
                            if (i <= 0) {
                                n = rowIndexNode.right(x);
                                break;
                            }
                            result = x;
                            n = rowIndexNode.left(x);
                            break;
                        }
                        case 42: {
                            i = this.compareObject(session, currentRow, rowdata, rowColMap, fieldCount);
                            if (i < 0) {
                                n = rowIndexNode.right(x);
                                break;
                            }
                            result = x;
                            n = rowIndexNode.left(x);
                            break;
                        }
                        case 44: {
                            i = this.compareObject(session, currentRow, rowdata, rowColMap, fieldCount);
                            if (i < 0) {
                                result = x;
                                n = rowIndexNode.right(x);
                                break;
                            }
                            n = rowIndexNode.left(x);
                            break;
                        }
                        case 45: {
                            i = this.compareObject(session, currentRow, rowdata, rowColMap, fieldCount);
                            if (i <= 0) {
                                result = x;
                                n = rowIndexNode.right(x);
                                break;
                            }
                            n = rowIndexNode.left(x);
                            break;
                        }
                        default: {
                            Error.runtimeError(201, "Index");
                            break;
                        }
                    }
                } else if (i < 0) {
                    n = rowIndexNode.right(x);
                } else if (i > 0) {
                    n = rowIndexNode.left(x);
                }
                if (n == -1) break;
                x = n;
            }
            if (result == -1) {
                rowIndex = null;
                return rowIndex;
            }
            rowIndex = rowIndexNode.getRowIndex(result).next();
            return rowIndex;
        }
        finally {
            store.readUnlock();
        }
    }

    SIndex.RowIndex next(Session session, RowStoreSnapshot store, SIndex.RowIndex rowIndex, int distinctCount) {
        if (rowIndex == null || rowIndex.currentIndex() == -1) {
            return rowIndex;
        }
        if (distinctCount == 0) {
            return rowIndex.next();
        }
        Object[] rowData = store.readRow(rowIndex.currentIndex());
        return this.findRowIndex(session, store, rowData, this.columns, distinctCount, 43, false);
    }

    SIndex.RowIndex last(Session session, RowStoreSnapshot store, SIndex.RowIndex rowIndex, int distinctCount) {
        if (rowIndex == null || rowIndex.currentIndex() == -1) {
            return rowIndex;
        }
        if (distinctCount == 0) {
            return rowIndex.previous();
        }
        Object[] rowData = store.readRow(rowIndex.currentIndex());
        return this.findRowIndex(session, store, rowData, this.columns, distinctCount, 44, false);
    }

    @Override
    public boolean isBuilt() {
        if (this.columns == null || this.columns.length == 0) {
            return true;
        }
        SIndex sIndex = this.getSIndex();
        return sIndex != null && sIndex.isBuilt();
    }

    @Override
    public boolean isValid() {
        if (this.columns == null || this.columns.length == 0) {
            return true;
        }
        SIndex sIndex = this.getSIndex();
        return sIndex != null && sIndex.isValid();
    }

    static class EmptyRowIteratorSnapshot
    implements RowIterator {
        @Override
        public Row getNextRow() {
            return null;
        }

        @Override
        public Object[] getNext() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void remove() {
            throw new DataspaceException("Remove is not allowed on snapshot table.");
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        @Override
        public void release() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }
    }

    public static class RowIteratorSnapshot
    implements RowIterator {
        private Session session;
        private RowStoreSnapshot store;
        private final IndexSnapshot index;
        private SIndex.RowIndex rowIndex;
        private final int distinctCount;
        private final boolean single;
        private final boolean reversed;
        private final SnapshotTable sTable;
        private Row nextrow = null;
        private boolean skip = false;
        private boolean lazy = true;

        public RowIteratorSnapshot(Session session, PersistentStore store, IndexSnapshot index, SIndex.RowIndex rowIndex, int distinctCount, boolean single, boolean reversed) {
            this.session = session;
            this.store = (RowStoreSnapshot)store;
            this.index = index;
            this.rowIndex = rowIndex;
            this.distinctCount = distinctCount;
            this.single = single;
            this.reversed = reversed;
            this.sTable = index.table.getSTable();
            this.lazy = index.table.isReadOnly();
            this.nextrow = this.readRow(rowIndex.currentIndex());
        }

        private Row readRow(int rowIndex) {
            Object[] next = null;
            if (!this.lazy) {
                next = this.store.readRow(rowIndex);
            }
            return new RowSnapshot(this.store, this.index.table, next, this.lazy, rowIndex);
        }

        @Override
        public boolean hasNext() {
            return this.nextrow != null;
        }

        @Override
        public Row getNextRow() {
            if (this.rowIndex == null || this.rowIndex.currentIndex() == -1) {
                this.release();
                return null;
            }
            Row lastrow = this.nextrow;
            if (this.single) {
                this.nextrow = null;
                this.rowIndex = null;
            } else {
                this.store.readLock();
                try {
                    this.rowIndex = this.reversed ? this.index.last(this.session, this.store, this.rowIndex, this.distinctCount) : this.index.next(this.session, this.store, this.rowIndex, this.distinctCount);
                    if (this.rowIndex != null && this.rowIndex.currentIndex() != -1) {
                        this.nextrow = this.readRow(this.rowIndex.currentIndex());
                    }
                }
                finally {
                    this.store.readUnlock();
                }
            }
            return lastrow;
        }

        @Override
        public Object[] getNext() {
            Row row = this.getNextRow();
            return row == null ? null : row.getData();
        }

        @Override
        public void remove() {
            throw new DataspaceException("Remove is not allowed on JFQ.");
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        @Override
        public void release() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }
    }
}

