/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.row;

import com.streamscape.ds.io.rowio.RowInputBinary;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.RowAVLDisk;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.Type;
import java.io.IOException;

public class RowDiskDataChange
extends RowAVLDisk {
    public static final int COL_POS_ROW_NUM = 0;
    public static final int COL_POS_ROW_ID = 1;
    public static final int COL_POS_TABLE_ID = 2;
    public static final int COL_POS_SCHEMA_NAME = 3;
    public static final int COL_POS_TABLE_NAME = 4;
    public static final int COL_POS_IS_UPDATE = 5;
    static final Type[] arrayType = new Type[]{new ArrayType(Type.SQL_INTEGER, Integer.MAX_VALUE)};
    final Table targetTable;
    Object[] updateData;
    int[] updateColMap;

    public RowDiskDataChange(TableBase t, Object[] data, PersistentStore store, Table targetTable) {
        super(t, data, store);
        this.targetTable = targetTable;
    }

    public RowDiskDataChange(Session session, TableBase t, RowInputInterface in) throws IOException {
        super(t, in);
        this.targetTable = t.database.schemaManager.getTable(session, (String)this.rowData[4], (String)this.rowData[3]);
        if (((Boolean)this.rowData[5]).booleanValue()) {
            this.updateData = in.readData(this.targetTable.colTypes);
            RowInputBinary bin = (RowInputBinary)in;
            this.updateColMap = (int[])(bin.readNull() ? null : bin.readIntArray());
        } else {
            this.updateData = null;
            this.updateColMap = null;
        }
    }

    @Override
    public void write(RowOutputInterface out) {
        try {
            this.writeNodes(out);
            if (this.hasDataChanged) {
                out.writeData(this, this.table.colTypes);
                if (this.updateData != null) {
                    Type[] targetTypes = this.targetTable.colTypes;
                    out.writeData(targetTypes.length, targetTypes, this.updateData, null, null);
                    RowOutputBinary bout = (RowOutputBinary)out;
                    if (this.updateColMap == null) {
                        bout.writeNull(Type.SQL_ARRAY_ALL_TYPES);
                    } else {
                        bout.writeArray(this.updateColMap);
                    }
                }
                out.writeEnd();
                this.hasDataChanged = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object[] getUpdateData() {
        return this.updateData;
    }

    public int[] getUpdateColumnMap() {
        return this.updateColMap;
    }

    public void setUpdateData(Object[] data) {
        this.updateData = data;
    }

    public void setUpdateColumnMap(int[] colMap) {
        this.updateColMap = colMap;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        RowOutputBinary bout = (RowOutputBinary)out;
        int size = out.getSize(this);
        if (this.updateData != null) {
            size += bout.getSize(this.updateData, this.targetTable.getColumnCount(), this.targetTable.getColumnTypes());
            if (this.updateColMap != null) {
                size += bout.getSize(this.updateColMap);
            }
        }
        return size;
    }
}

