/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist.row;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowActionBase;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;

public class RowAction
extends RowActionBase {
    public final TableBase table;
    public final PersistentStore store;
    public Row memoryRow;
    int rowId;
    public boolean isMemory;
    RowAction updatedAction;
    private boolean triggered = false;

    public static RowAction addInsertAction(Session session, TableBase table, Row row) {
        RowAction action;
        row.rowAction = action = new RowAction(session, table, 1, row, null);
        return action;
    }

    public static RowAction addDeleteAction(Session session, TableBase table, Row row, int[] colMap, boolean forUpdate) {
        RowAction action = row.rowAction;
        if (action == null) {
            action = new RowAction(session, table, 2, row, colMap);
            action.forUpdate = forUpdate;
            row.rowAction = action;
        } else {
            action = action.addDeleteAction(session, colMap, forUpdate);
        }
        return action;
    }

    public static boolean addRefAction(Session session, Row row, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            row.rowAction = action = new RowAction(session, row.getTable(), 5, row, colMap);
            return true;
        }
        return action.addRefAction(session, colMap);
    }

    public RowAction(Session session, TableBase table, byte type, Row row, int[] colMap) {
        this.session = session;
        this.type = type;
        this.actionTimestamp = session.actionTimestamp;
        this.table = table;
        this.store = table.getRowStore(session);
        this.isMemory = row.isMemory();
        this.memoryRow = row;
        this.rowId = row.getPos();
        this.changeColumnMap = colMap;
    }

    private RowAction(RowAction other) {
        this.session = other.session;
        this.type = other.type;
        this.actionTimestamp = other.actionTimestamp;
        this.table = other.table;
        this.store = other.store;
        this.isMemory = other.isMemory;
        this.memoryRow = other.memoryRow;
        this.rowId = other.rowId;
        this.changeColumnMap = other.changeColumnMap;
    }

    public synchronized int getType() {
        return this.type;
    }

    synchronized RowAction addDeleteAction(Session session, int[] colMap, boolean forUpdate) {
        if (this.type == 0) {
            this.setAsAction(session, (byte)2);
            this.forUpdate = forUpdate;
            this.changeColumnMap = colMap;
        } else {
            RowActionBase action = this;
            while (true) {
                if (action.rolledback) {
                    if (action.next == null) break;
                    action = action.next;
                    continue;
                }
                switch (action.type) {
                    case 1: {
                        if (action.commitTimestamp != 0L || session == action.session) break;
                        throw Error.runtimeError(201, "RowAction");
                    }
                    case 2: 
                    case 3: {
                        if (session == action.session) break;
                        if (action.commitTimestamp == 0L) {
                            if (!session.tempSet.isEmpty()) {
                                session.tempSet.clear();
                            }
                            session.tempSet.add(action);
                        }
                        return null;
                    }
                    case 5: {
                        if (session == action.session || action.commitTimestamp != 0L || colMap != null && !ArrayUtil.haveCommonElement(colMap, action.changeColumnMap)) break;
                        if (!session.tempSet.isEmpty()) {
                            session.tempSet.clear();
                        }
                        session.tempSet.add(action);
                        return null;
                    }
                }
                if (action.next == null) break;
                action = action.next;
            }
            RowActionBase newAction = new RowActionBase(session, 2);
            newAction.forUpdate = forUpdate;
            newAction.changeColumnMap = colMap;
            action.next = newAction;
        }
        return this;
    }

    synchronized boolean addRefAction(Session session, int[] colMap) {
        if (this.type == 0) {
            this.setAsAction(session, (byte)5);
            this.changeColumnMap = colMap;
            return true;
        }
        RowActionBase action = this;
        while (true) {
            if (session == action.session) {
                if (action.type == 5 && action.changeColumnMap == colMap && action.commitTimestamp == 0L) {
                    return false;
                }
                if (action.type == 1 && action.commitTimestamp == 0L) {
                    return false;
                }
            } else if (action.type == 2 && action.commitTimestamp == 0L && (action.changeColumnMap == null || ArrayUtil.haveCommonElement(colMap, action.changeColumnMap))) {
                if (!session.tempSet.isEmpty()) {
                    session.tempSet.clear();
                }
                session.tempSet.add(action);
                return false;
            }
            if (action.next == null) break;
            action = action.next;
        }
        RowActionBase newAction = new RowActionBase(session, 5);
        newAction.changeColumnMap = colMap;
        action.next = newAction;
        return true;
    }

    public boolean checkDeleteActions() {
        return false;
    }

    public synchronized RowAction duplicate(Row newRow) {
        RowAction action = new RowAction(this.session, this.table, this.type, newRow, this.changeColumnMap);
        return action;
    }

    synchronized void setAsAction(Session session, byte type) {
        this.session = session;
        this.type = type;
        this.actionTimestamp = session.actionTimestamp;
        this.changeColumnMap = null;
    }

    @Override
    synchronized void setAsAction(RowActionBase action) {
        super.setAsAction(action);
    }

    public void setAsNoOp() {
        this.session = null;
        this.actionTimestamp = 0L;
        this.commitTimestamp = 0L;
        this.rolledback = false;
        this.deleteComplete = false;
        this.changeColumnMap = null;
        this.prepared = false;
        this.preparedTimestamp = 0L;
        this.type = 0;
        this.next = null;
        this.triggered = false;
        this.forUpdate = false;
    }

    private void setAsDeleteFinal(long timestamp) {
        this.actionTimestamp = 0L;
        this.commitTimestamp = timestamp;
        this.rolledback = false;
        this.deleteComplete = false;
        this.prepared = false;
        this.preparedTimestamp = 0L;
        this.changeColumnMap = null;
        this.type = (byte)3;
        this.next = null;
    }

    public synchronized void prepareCommit(Session session) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.commitTimestamp != 0L || action.preparedTimestamp != 0L) continue;
            action.prepared = true;
            action.preparedTimestamp = session.actionTimestamp;
        } while ((action = action.next) != null);
    }

    public synchronized int commit(Session session) {
        RowActionBase action = this;
        int actiontype = 0;
        do {
            if (action.session != session || action.commitTimestamp != 0L) continue;
            action.commitTimestamp = session.actionTimestamp;
            action.prepared = false;
            action.preparedTimestamp = 0L;
            if (action.type == 1) {
                actiontype = action.type;
                continue;
            }
            if (action.type != 2) continue;
            actiontype = actiontype == 1 ? 4 : (int)action.type;
        } while ((action = action.next) != null);
        return actiontype;
    }

    public synchronized int resetCommit(Session session) {
        RowActionBase action = this;
        int actiontype = 0;
        do {
            if (action.session != session || action.commitTimestamp <= 0L && action.preparedTimestamp <= 0L) continue;
            action.commitTimestamp = 0L;
            action.preparedTimestamp = 0L;
            action.prepared = false;
            if (action.type == 1) {
                actiontype = action.type;
                continue;
            }
            if (action.type != 2) continue;
            actiontype = actiontype == 1 ? 4 : (int)action.type;
        } while ((action = action.next) != null);
        return actiontype;
    }

    public boolean isDeleted() {
        RowActionBase action = this;
        do {
            if (action.commitTimestamp == 0L || action.type != 2 && action.type != 3) continue;
            return true;
        } while ((action = action.next) != null);
        return false;
    }

    public synchronized int getCommitTypeOn(long timestamp) {
        RowActionBase action = this;
        int actionType = 0;
        do {
            if ((action.prepared || action.commitTimestamp != timestamp) && (!action.prepared || action.preparedTimestamp != timestamp)) continue;
            if (action.type == 1) {
                actionType = action.type;
                continue;
            }
            if (action.type != 2) continue;
            actionType = actionType == 1 ? 4 : (int)action.type;
        } while ((action = action.next) != null);
        return actionType;
    }

    public synchronized RowActionBase getCommitActionOn(long timestamp) {
        RowActionBase action = this;
        int actionType = 0;
        do {
            if ((action.prepared || action.commitTimestamp != timestamp) && (!action.prepared || action.preparedTimestamp != timestamp)) continue;
            if (action.type == 1) {
                actionType = action.type;
            } else if (action.type == 2) {
                actionType = actionType == 1 ? 4 : (int)action.type;
            }
            return action;
        } while ((action = action.next) != null);
        return null;
    }

    public synchronized boolean canCommit(Session session, OrderedHashSet set) {
        long timestamp = session.transactionTimestamp;
        long commitTimestamp = 0L;
        boolean readCommitted = session.getIsolation() == 2;
        boolean hasDelete = false;
        RowActionBase action = this;
        if (readCommitted) {
            do {
                if (action.session != session || action.type != 2 || action.commitTimestamp != 0L) continue;
                timestamp = action.actionTimestamp;
            } while ((action = action.next) != null);
            action = this;
        }
        do {
            if (action.session == session) {
                if (action.type == 2) {
                    hasDelete = true;
                }
            } else {
                if (action.rolledback || action.type != 2) {
                    action = action.next;
                    continue;
                }
                if (action.prepared) {
                    return false;
                }
                if (action.commitTimestamp == 0L) {
                    set.add(action);
                } else if (action.commitTimestamp > commitTimestamp) {
                    commitTimestamp = action.commitTimestamp;
                }
            }
            action = action.next;
        } while (action != null);
        if (!hasDelete) {
            return true;
        }
        return commitTimestamp < timestamp;
    }

    synchronized void complete(Session session) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.actionTimestamp != 0L) continue;
            action.actionTimestamp = session.actionTimestamp;
        } while ((action = action.next) != null);
    }

    synchronized boolean complete(Session session, OrderedHashSet set) {
        boolean readCommitted = session.getIsolation() == 2;
        boolean result = true;
        RowActionBase action = this;
        do {
            if (action.rolledback || action.type == 0) {
                action = action.next;
                continue;
            }
            if (action.session != session) {
                if (action.prepared) {
                    set.add(action.session);
                    return false;
                }
                if (readCommitted) {
                    if (action.commitTimestamp > session.actionTimestamp) {
                        set.add(session);
                        result = false;
                    } else if (action.commitTimestamp == 0L) {
                        set.add(action.session);
                        result = false;
                    }
                } else if (action.commitTimestamp > session.transactionTimestamp) {
                    return false;
                }
            }
            action = action.next;
        } while (action != null);
        return result;
    }

    synchronized int getActionType(long timestamp) {
        int actionType = 0;
        RowActionBase action = this;
        do {
            if (action.actionTimestamp != timestamp) continue;
            if (action.type == 2) {
                if (actionType == 1) {
                    actionType = 4;
                    continue;
                }
                actionType = action.type;
                continue;
            }
            if (action.type != 1) continue;
            actionType = action.type;
        } while ((action = action.next) != null);
        return actionType;
    }

    public synchronized int getPos() {
        return this.rowId;
    }

    public synchronized void setPos(int pos) {
        this.rowId = pos;
    }

    private int getRollbackType(Session session) {
        int actionType = 0;
        RowActionBase action = this;
        do {
            if (action.session != session || !action.rolledback) continue;
            if (action.type == 2) {
                if (actionType == 1) {
                    actionType = 4;
                    continue;
                }
                actionType = action.type;
                continue;
            }
            if (action.type != 1) continue;
            actionType = action.type;
        } while ((action = action.next) != null);
        return actionType;
    }

    public synchronized void rollback(Session session, long timestamp) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.commitTimestamp != 0L || action.actionTimestamp < timestamp) continue;
            action.commitTimestamp = session.actionTimestamp;
            action.rolledback = true;
            action.prepared = false;
            action.preparedTimestamp = 0L;
        } while ((action = action.next) != null);
    }

    public synchronized int mergeRollback(Session session, long timestamp, Row row) {
        RowActionBase action = this;
        RowAction head = null;
        RowAction tail = null;
        int rollbackAction = this.getRollbackType(session);
        do {
            if (action.session == session && action.rolledback) {
                if (tail == null) continue;
                tail.next = null;
                continue;
            }
            if (head == null) {
                head = tail = action;
                continue;
            }
            tail.next = action;
            tail = action;
        } while ((action = action.next) != null);
        if (head == null) {
            switch (rollbackAction) {
                case 1: 
                case 4: {
                    this.setAsDeleteFinal(timestamp);
                    break;
                }
                default: {
                    this.setAsNoOp();
                    break;
                }
            }
        } else if (head != this) {
            this.setAsAction(head);
        }
        return rollbackAction;
    }

    public synchronized void mergeToTimestamp(long timestamp) {
        RowActionBase action = this;
        RowAction head = null;
        RowAction tail = null;
        int commitType = this.getCommitTypeOn(timestamp);
        if (this.type == 3 || this.type == 0) {
            return;
        }
        if (commitType == 2 || commitType == 4) {
            this.setAsDeleteFinal(timestamp);
            return;
        }
        do {
            boolean expired = false;
            if (action.commitTimestamp != 0L) {
                if (action.commitTimestamp <= timestamp) {
                    expired = true;
                } else if (action.type == 5) {
                    expired = true;
                }
            }
            if (expired) {
                if (tail == null) continue;
                tail.next = null;
                continue;
            }
            if (head == null) {
                head = tail = action;
                continue;
            }
            tail.next = action;
            tail = action;
        } while ((action = action.next) != null);
        if (head == null) {
            switch (commitType) {
                case 2: 
                case 4: {
                    this.setAsDeleteFinal(timestamp);
                    break;
                }
                default: {
                    this.setAsNoOp();
                    break;
                }
            }
        } else if (head != this) {
            this.setAsAction(head);
        }
        this.mergeExpiredRefActions();
    }

    public synchronized boolean canRead(Session session, int mode) {
        long threshold;
        int actionType = 0;
        if (this.type == 3) {
            return false;
        }
        if (this.type == 0) {
            return true;
        }
        RowActionBase action = this;
        if (session == null) {
            threshold = Long.MAX_VALUE;
        } else {
            switch (session.getIsolation()) {
                case 1: {
                    threshold = Long.MAX_VALUE;
                    break;
                }
                case 2: {
                    threshold = session.actionTimestamp;
                    break;
                }
                default: {
                    threshold = session.transactionTimestamp;
                }
            }
        }
        do {
            if (action.type == 5) {
                action = action.next;
                continue;
            }
            if (action.rolledback) {
                if (action.type == 1) {
                    actionType = 2;
                }
                action = action.next;
                continue;
            }
            if (session == action.session) {
                if (action.type == 2) {
                    actionType = action.type;
                } else if (action.type == 1) {
                    actionType = action.type;
                }
                action = action.next;
                continue;
            }
            if (action.commitTimestamp == 0L) {
                if (action.type == 0) {
                    throw Error.runtimeError(201, "RowAction");
                }
                if (action.type == 1) {
                    if (mode == 0) {
                        actionType = 2;
                        break;
                    }
                    if (mode == 1) {
                        actionType = 1;
                        session.tempSet.clear();
                        session.tempSet.add(action);
                        break;
                    }
                    if (mode != 2) break;
                    actionType = 2;
                    break;
                }
                if (action.type == 2 && mode != 1 && mode == 2) {
                    actionType = 2;
                }
                action = action.next;
                continue;
            }
            if (action.commitTimestamp != 0L) {
                if (action.commitTimestamp < threshold) {
                    if (action.type == 2) {
                        actionType = 2;
                    } else if (action.type == 1) {
                        actionType = 1;
                    }
                } else if (action.type == 1) {
                    if (mode == 0) {
                        actionType = 2;
                    } else if (mode == 1) {
                        actionType = 1;
                        session.tempSet.clear();
                        session.tempSet.add(action);
                    } else if (mode == 2) {
                        actionType = 2;
                    }
                }
            } else if (action.preparedTimestamp != 0L) {
                if (action.preparedTimestamp < threshold) {
                    if (action.type == 2) {
                        actionType = 2;
                    } else if (action.type == 1) {
                        actionType = 1;
                    }
                } else if (action.type == 1) {
                    if (mode == 0) {
                        actionType = 2;
                    } else if (mode == 1) {
                        actionType = 1;
                        session.tempSet.clear();
                        session.tempSet.add(action);
                    } else if (mode == 2) {
                        actionType = 2;
                    }
                }
            }
            action = action.next;
        } while (action != null);
        return actionType == 0 || actionType == 1;
    }

    public boolean hasCurrentRefAction() {
        RowActionBase action = this;
        do {
            if (action.type != 5 || action.commitTimestamp != 0L) continue;
            return true;
        } while ((action = action.next) != null);
        return false;
    }

    private RowAction mergeExpiredRefActions() {
        if (this.updatedAction != null) {
            this.updatedAction = this.updatedAction.mergeExpiredRefActions();
        }
        if (this.hasCurrentRefAction()) {
            return this;
        }
        return this.updatedAction;
    }

    public synchronized String describe(Session session) {
        StringBuilder sb = new StringBuilder();
        RowActionBase action = this;
        do {
            if (action == this) {
                sb.append(this.rowId).append(' ');
            }
            sb.append(action.session.getId()).append(' ');
            sb.append(action.type).append(' ').append(action.actionTimestamp);
            sb.append(' ').append(action.commitTimestamp);
            if (action.commitTimestamp != 0L) {
                if (action.rolledback) {
                    sb.append('r');
                } else {
                    sb.append('c');
                }
            }
            sb.append(" - ");
        } while ((action = action.next) != null);
        return sb.toString();
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }
}

